/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.registry.gossip.Election;
import ibis.ipl.registry.gossip.Registry;
import ibis.util.TypedProperties;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectionSet
implements Iterable<Election> {
    private static final Logger logger = LoggerFactory.getLogger(ElectionSet.class);
    private final TypedProperties properties;
    private final Registry registry;
    private final HashMap<String, Election> elections;

    public ElectionSet(TypedProperties properties, Registry registry) {
        this.properties = properties;
        this.registry = registry;
        this.elections = new HashMap();
    }

    public synchronized void writeGossipData(DataOutputStream out) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("writing " + this.elections.size() + " elections");
        }
        out.writeInt(this.elections.size());
        for (Election election : this.elections.values()) {
            election.writeTo(out);
        }
    }

    public void readGossipData(DataInputStream in) throws IOException {
        int nrOfElections = in.readInt();
        if (nrOfElections < 0) {
            throw new IOException("negative election list value");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("reading " + nrOfElections + " elections");
        }
        for (int i = 0; i < nrOfElections; ++i) {
            Election election = new Election(in);
            String name = election.getName();
            if (this.elections.containsKey(name)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("merging " + election + " with existing election" + this.elections.get(name));
                }
                this.elections.get(name).merge(election);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("received new election in gossip: " + election);
            }
            this.elections.put(name, election);
        }
    }

    public synchronized IbisIdentifier[] getElectionResult(String electionName, long timeoutMillis) {
        if (logger.isDebugEnabled()) {
            logger.debug("trying to get election result for: " + electionName + ", waiting " + timeoutMillis);
        }
        if (timeoutMillis > 0L) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Election election = this.elections.get(electionName);
        if (logger.isDebugEnabled()) {
            logger.debug("result for " + electionName + " is " + election);
        }
        if (election == null) {
            return null;
        }
        return election.getCandidates();
    }

    public IbisIdentifier[] getElectionResult(String electionName) {
        return this.getElectionResult(electionName, this.properties.getIntProperty("ibis.registry.gossip.election.timeout") * 1000);
    }

    public synchronized IbisIdentifier[] elect(String electionName, long timeoutMillis) {
        Election election;
        if (logger.isDebugEnabled()) {
            logger.debug("electing result for: " + electionName + ", waiting " + timeoutMillis);
        }
        if ((election = this.elections.get(electionName)) == null) {
            election = new Election(electionName);
            this.elections.put(electionName, election);
        }
        if (election.nrOfCandidates() == 0) {
            election.addCandidate(this.registry.getIbisIdentifier());
        }
        if (timeoutMillis > 0L) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if ((election = this.elections.get(electionName)) == null) {
            election = new Election(electionName);
            this.elections.put(electionName, election);
        }
        if (election.nrOfCandidates() == 0) {
            election.addCandidate(this.registry.getIbisIdentifier());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("result for " + electionName + " is " + election);
        }
        return election.getCandidates();
    }

    public IbisIdentifier[] elect(String electionName) {
        return this.elect(electionName, this.properties.getIntProperty("ibis.registry.gossip.election.timeout") * 1000);
    }

    @Override
    public Iterator<Election> iterator() {
        return this.elections.values().iterator();
    }
}

