/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.gossip;

import ibis.ipl.registry.gossip.ARRGCacheEntry;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ARRGCache {
    private static final Logger logger = LoggerFactory.getLogger(ARRGCache.class);
    private final int cacheSize;
    private final Random random;
    private final ArrayList<ARRGCacheEntry> cache;

    public ARRGCache(int cacheSize) {
        this.cacheSize = cacheSize;
        this.cache = new ArrayList();
        this.random = new Random();
    }

    public synchronized ARRGCacheEntry[] getRandomEntries(int n, boolean includeArrgOnly) {
        ArrayList<ARRGCacheEntry> result = new ArrayList<ARRGCacheEntry>();
        BitSet selected = new BitSet();
        while (selected.cardinality() < n && selected.cardinality() < this.cache.size()) {
            int next = this.random.nextInt(this.cache.size());
            selected.set(next);
            ARRGCacheEntry entry = this.cache.get(next);
            if (!includeArrgOnly && entry.isArrgOnly()) continue;
            result.add(entry);
        }
        return result.toArray(new ARRGCacheEntry[0]);
    }

    public synchronized ARRGCacheEntry getRandomEntry(boolean includeArrgOnly) {
        ARRGCacheEntry[] result = this.getRandomEntries(1, includeArrgOnly);
        if (result.length < 1) {
            return null;
        }
        return result[0];
    }

    public synchronized void add(ARRGCacheEntry ... entries) {
        for (ARRGCacheEntry entry : entries) {
            if (entry == null) continue;
            this.cache.add(entry);
        }
        for (int i = 0; i < this.cache.size(); ++i) {
            for (int j = i + 1; j < this.cache.size(); ++j) {
                if (!this.cache.get(i).sameAddressAs(this.cache.get(j))) continue;
                this.cache.remove(j);
                --j;
            }
        }
        while (this.cache.size() > this.cacheSize) {
            this.cache.remove(this.random.nextInt(this.cache.size()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cache value now: " + this.cache.size());
        }
    }

    public synchronized ARRGCacheEntry[] getEntries(boolean includeArrgOnly) {
        if (includeArrgOnly) {
            return this.cache.toArray(new ARRGCacheEntry[0]);
        }
        ArrayList<ARRGCacheEntry> result = new ArrayList<ARRGCacheEntry>();
        for (ARRGCacheEntry entry : this.cache) {
            if (entry.isArrgOnly()) continue;
            result.add(entry);
        }
        return result.toArray(new ARRGCacheEntry[0]);
    }
}

