/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.central.server;

import ibis.ipl.registry.central.Member;
import ibis.ipl.registry.central.server.Pool;
import ibis.util.ThreadPool;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IterativeEventPusher
implements Runnable {
    private static final int THREADS = 25;
    private static final Logger logger = LoggerFactory.getLogger(IterativeEventPusher.class);
    private final Pool pool;
    private final long timeout;
    private final boolean eventTriggersPush;
    private final boolean useTree;

    IterativeEventPusher(Pool pool, long timeout, boolean eventTriggersPush, boolean useTree) {
        this.pool = pool;
        this.timeout = timeout;
        this.eventTriggersPush = eventTriggersPush;
        this.useTree = useTree;
        ThreadPool.createNew((Runnable)this, (String)"event pusher scheduler thread");
    }

    @Override
    public void run() {
        while (!this.pool.hasEnded()) {
            Member[] children;
            int eventTime = this.pool.getEventTime();
            if (this.useTree) {
                children = this.pool.getChildren();
                if (logger.isDebugEnabled()) {
                    String message = "broadcasting to " + children.length + " children:";
                    for (Member member : children) {
                        message = message + "\n" + member;
                    }
                    logger.debug(message);
                }
            } else {
                children = this.pool.getMembers();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("updating " + children.length + " nodes in pool (pool size = " + this.pool.getSize() + ") to event-time " + eventTime + " using tree: " + this.useTree);
            }
            WorkQ workQ = new WorkQ(children);
            int threads = Math.min(25, children.length);
            for (int i = 0; i < threads; ++i) {
                new EventPusherThread(workQ);
            }
            workQ.waitUntilDone();
            if (logger.isDebugEnabled()) {
                logger.debug("DONE updating nodes in pool to event-time " + eventTime);
            }
            this.pool.purgeHistory();
            if (this.eventTriggersPush) {
                this.pool.waitForEventTime(eventTime + 1, this.timeout);
                continue;
            }
            this.pool.waitForEventTime(Integer.MAX_VALUE, this.timeout);
        }
    }

    private class EventPusherThread
    implements Runnable {
        WorkQ workQ;

        EventPusherThread(WorkQ workQ) {
            this.workQ = workQ;
            ThreadPool.createNew((Runnable)this, (String)"event pusher thread");
        }

        @Override
        public void run() {
            Member work;
            while ((work = this.workQ.next()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("pushing to " + work);
                }
                IterativeEventPusher.this.pool.push(work, false, IterativeEventPusher.this.useTree);
                this.workQ.doneJob();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("done pushing to " + work);
            }
            return;
        }
    }

    private class WorkQ {
        private List<Member> q = new LinkedList<Member>();
        private int count;

        WorkQ(Member[] work) {
            this.q.addAll(Arrays.asList(work));
            this.count = this.q.size();
        }

        synchronized Member next() {
            if (this.q.isEmpty()) {
                return null;
            }
            return this.q.remove(0);
        }

        synchronized void doneJob() {
            --this.count;
            if (this.count <= 0) {
                this.notifyAll();
            }
        }

        synchronized void waitUntilDone() {
            while (this.count > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

