/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.util;

import de.javawi.jstun.util.UtilityException;

public class Utility {
    public static final byte IntegerToOneByte(int value) throws UtilityException {
        if ((double)value > Math.pow(2.0, 15.0) || value < 0) {
            throw new UtilityException("Integer value " + value + " is larger than 2^15");
        }
        return (byte)(value & 0xFF);
    }

    public static final byte[] IntegerToTwoBytes(int value) throws UtilityException {
        byte[] result = new byte[2];
        if ((double)value > Math.pow(2.0, 31.0) || value < 0) {
            throw new UtilityException("Integer value " + value + " is larger than 2^31");
        }
        result[0] = (byte)(value >>> 8 & 0xFF);
        result[1] = (byte)(value & 0xFF);
        return result;
    }

    public static final byte[] IntegerToFourBytes(int value) throws UtilityException {
        byte[] result = new byte[4];
        if ((double)value > Math.pow(2.0, 63.0) || value < 0) {
            throw new UtilityException("Integer value " + value + " is larger than 2^63");
        }
        result[0] = (byte)(value >>> 24 & 0xFF);
        result[1] = (byte)(value >>> 16 & 0xFF);
        result[2] = (byte)(value >>> 8 & 0xFF);
        result[3] = (byte)(value & 0xFF);
        return result;
    }

    public static final int OneByteToInteger(byte value) throws UtilityException {
        return value & 0xFF;
    }

    public static final int TwoBytesToInteger(byte[] value) throws UtilityException {
        if (value.length < 2) {
            throw new UtilityException("Byte array too short!");
        }
        int temp0 = value[0] & 0xFF;
        int temp1 = value[1] & 0xFF;
        return (temp0 << 8) + temp1;
    }

    public static final long FourBytesToLong(byte[] value) throws UtilityException {
        if (value.length < 4) {
            throw new UtilityException("Byte array too short!");
        }
        int temp0 = value[0] & 0xFF;
        int temp1 = value[1] & 0xFF;
        int temp2 = value[2] & 0xFF;
        int temp3 = value[3] & 0xFF;
        return ((long)temp0 << 24) + (long)(temp1 << 16) + (long)(temp2 << 8) + (long)temp3;
    }
}

