/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test;

import de.javawi.jstun.attribute.ChangeRequest;
import de.javawi.jstun.attribute.ChangedAddress;
import de.javawi.jstun.attribute.ErrorCode;
import de.javawi.jstun.attribute.MappedAddress;
import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.attribute.MessageAttributeInterface;
import de.javawi.jstun.attribute.MessageAttributeParsingException;
import de.javawi.jstun.header.MessageHeader;
import de.javawi.jstun.header.MessageHeaderInterface;
import de.javawi.jstun.header.MessageHeaderParsingException;
import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.util.UtilityException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.logging.Logger;

public class DiscoveryTest {
    private static Logger logger = Logger.getLogger("de.javawi.stun.test.DiscoveryTest");
    InetAddress iaddress;
    String stunServer;
    int port;
    int timeoutInitValue = 300;
    MappedAddress ma = null;
    ChangedAddress ca = null;
    boolean nodeNatted = true;
    DatagramSocket socketTest1 = null;
    DiscoveryInfo di = null;

    public DiscoveryTest(InetAddress iaddress, String stunServer, int port) {
        this.iaddress = iaddress;
        this.stunServer = stunServer;
        this.port = port;
    }

    public DiscoveryInfo test() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        this.ma = null;
        this.ca = null;
        this.nodeNatted = true;
        this.socketTest1 = null;
        this.di = new DiscoveryInfo(this.iaddress);
        if (this.test1() && this.test2() && this.test1Redo()) {
            this.test3();
        }
        this.socketTest1.close();
        return this.di;
    }

    private boolean test1() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageHeaderParsingException {
        int timeSinceFirstTransmission = 0;
        int timeout = this.timeoutInitValue;
        while (true) {
            try {
                this.socketTest1 = new DatagramSocket(new InetSocketAddress(this.iaddress, 0));
                this.socketTest1.setReuseAddress(true);
                this.socketTest1.connect(InetAddress.getByName(this.stunServer), this.port);
                this.socketTest1.setSoTimeout(timeout);
                MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                sendMH.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                sendMH.addMessageAttribute(changeRequest);
                byte[] data = sendMH.getBytes();
                DatagramPacket send = new DatagramPacket(data, data.length);
                this.socketTest1.send(send);
                logger.finer("Test 1: Binding Request sent.");
                MessageHeader receiveMH = new MessageHeader();
                while (!receiveMH.equalTransactionID(sendMH)) {
                    DatagramPacket receive = new DatagramPacket(new byte[200], 200);
                    this.socketTest1.receive(receive);
                    receiveMH = MessageHeader.parseHeader(receive.getData());
                }
                this.ma = (MappedAddress)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.MappedAddress);
                this.ca = (ChangedAddress)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ChangedAddress);
                ErrorCode ec = (ErrorCode)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (ec != null) {
                    this.di.setError(ec.getResponseCode(), ec.getReason());
                    logger.config("Message header contains errorcode message attribute.");
                    return false;
                }
                if (this.ma == null || this.ca == null) {
                    this.di.setError(700, "The server is sending incomplete response (Mapped Address and Changed Address message attributes are missing). The client should not retry.");
                    logger.config("Response does not contain a mapped address or changed address message attribute.");
                    return false;
                }
                this.di.setPublicIP(this.ma.getAddress().getInetAddress());
                if (this.ma.getPort() == this.socketTest1.getLocalPort() && this.ma.getAddress().getInetAddress().equals(this.socketTest1.getLocalAddress())) {
                    logger.fine("Node is not natted.");
                    this.nodeNatted = false;
                } else {
                    logger.fine("Node is natted.");
                }
                return true;
            }
            catch (SocketTimeoutException ste) {
                if (timeSinceFirstTransmission < 7900) {
                    logger.finer("Test 1: Socket timeout while receiving the response.");
                    int timeoutAddValue = (timeSinceFirstTransmission += timeout) * 2;
                    if (timeoutAddValue > 1600) {
                        timeoutAddValue = 1600;
                    }
                    timeout = timeoutAddValue;
                    continue;
                }
                logger.finer("Test 1: Socket timeout while receiving the response. Maximum retry limit exceed. Give up.");
                this.di.setBlockedUDP();
                logger.fine("Node is not capable of udp communication.");
                return false;
            }
            break;
        }
    }

    private boolean test2() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        int timeSinceFirstTransmission = 0;
        int timeout = this.timeoutInitValue;
        while (true) {
            try {
                DatagramSocket sendSocket = new DatagramSocket(new InetSocketAddress(this.iaddress, 0));
                sendSocket.connect(InetAddress.getByName(this.stunServer), this.port);
                sendSocket.setSoTimeout(timeout);
                MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                sendMH.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                changeRequest.setChangeIP();
                changeRequest.setChangePort();
                sendMH.addMessageAttribute(changeRequest);
                byte[] data = sendMH.getBytes();
                DatagramPacket send = new DatagramPacket(data, data.length);
                sendSocket.send(send);
                logger.finer("Test 2: Binding Request sent.");
                int localPort = sendSocket.getLocalPort();
                InetAddress localAddress = sendSocket.getLocalAddress();
                sendSocket.close();
                DatagramSocket receiveSocket = new DatagramSocket(localPort, localAddress);
                receiveSocket.connect(this.ca.getAddress().getInetAddress(), this.ca.getPort());
                receiveSocket.setSoTimeout(timeout);
                MessageHeader receiveMH = new MessageHeader();
                while (!receiveMH.equalTransactionID(sendMH)) {
                    DatagramPacket receive = new DatagramPacket(new byte[200], 200);
                    receiveSocket.receive(receive);
                    receiveMH = MessageHeader.parseHeader(receive.getData());
                }
                ErrorCode ec = (ErrorCode)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (ec != null) {
                    this.di.setError(ec.getResponseCode(), ec.getReason());
                    logger.config("Message header contains errorcode message attribute.");
                    return false;
                }
                if (!this.nodeNatted) {
                    this.di.setOpenAccess();
                    logger.fine("Node has open access to the internet (or, at least the node is a full-cone NAT without translation).");
                } else {
                    this.di.setFullCone();
                    logger.fine("Node is behind a full-cone NAT.");
                }
                return false;
            }
            catch (SocketTimeoutException ste) {
                if (timeSinceFirstTransmission < 7900) {
                    logger.finer("Test 2: Socket timeout while receiving the response.");
                    int timeoutAddValue = (timeSinceFirstTransmission += timeout) * 2;
                    if (timeoutAddValue > 1600) {
                        timeoutAddValue = 1600;
                    }
                    timeout = timeoutAddValue;
                    continue;
                }
                logger.finer("Test 2: Socket timeout while receiving the response. Maximum retry limit exceed. Give up.");
                if (!this.nodeNatted) {
                    this.di.setSymmetricUDPFirewall();
                    logger.fine("Node is behind a symmetric udp firewall.");
                    return false;
                }
                return true;
            }
            break;
        }
    }

    private boolean test1Redo() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageHeaderParsingException {
        int timeSinceFirstTransmission = 0;
        int timeout = this.timeoutInitValue;
        while (true) {
            try {
                this.socketTest1.connect(this.ca.getAddress().getInetAddress(), this.ca.getPort());
                this.socketTest1.setSoTimeout(timeout);
                MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                sendMH.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                sendMH.addMessageAttribute(changeRequest);
                byte[] data = sendMH.getBytes();
                DatagramPacket send = new DatagramPacket(data, data.length);
                this.socketTest1.send(send);
                logger.finer("Test 1 redo with changed address: Binding Request sent.");
                MessageHeader receiveMH = new MessageHeader();
                while (!receiveMH.equalTransactionID(sendMH)) {
                    DatagramPacket receive = new DatagramPacket(new byte[200], 200);
                    this.socketTest1.receive(receive);
                    receiveMH = MessageHeader.parseHeader(receive.getData());
                }
                MappedAddress ma2 = (MappedAddress)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.MappedAddress);
                ErrorCode ec = (ErrorCode)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (ec != null) {
                    this.di.setError(ec.getResponseCode(), ec.getReason());
                    logger.config("Message header contains errorcode message attribute.");
                    return false;
                }
                if (ma2 == null) {
                    this.di.setError(700, "The server is sending incomplete response (Mapped Address message attribute is missing). The client should not retry.");
                    logger.config("Response does not contain a mapped address message attribute.");
                    return false;
                }
                if (this.ma.getPort() != ma2.getPort() || !this.ma.getAddress().getInetAddress().equals(ma2.getAddress().getInetAddress())) {
                    this.di.setSymmetricCone();
                    logger.fine("Node is behind a symmetric NAT.");
                    return false;
                }
                return true;
            }
            catch (SocketTimeoutException ste2) {
                if (timeSinceFirstTransmission < 7900) {
                    logger.config("Test 1 redo with changed address: Socket timeout while receiving the response.");
                    int timeoutAddValue = (timeSinceFirstTransmission += timeout) * 2;
                    if (timeoutAddValue > 1600) {
                        timeoutAddValue = 1600;
                    }
                    timeout = timeoutAddValue;
                    continue;
                }
                logger.config("Test 1 redo with changed address: Socket timeout while receiving the response.  Maximum retry limit exceed. Give up.");
                return false;
            }
            break;
        }
    }

    private void test3() throws UtilityException, SocketException, UnknownHostException, IOException, MessageAttributeParsingException, MessageAttributeException, MessageHeaderParsingException {
        int timeSinceFirstTransmission = 0;
        int timeout = this.timeoutInitValue;
        while (true) {
            try {
                DatagramSocket sendSocket = new DatagramSocket(new InetSocketAddress(this.iaddress, 0));
                sendSocket.connect(InetAddress.getByName(this.stunServer), this.port);
                sendSocket.setSoTimeout(timeout);
                MessageHeader sendMH = new MessageHeader(MessageHeaderInterface.MessageHeaderType.BindingRequest);
                sendMH.generateTransactionID();
                ChangeRequest changeRequest = new ChangeRequest();
                changeRequest.setChangePort();
                sendMH.addMessageAttribute(changeRequest);
                byte[] data = sendMH.getBytes();
                DatagramPacket send = new DatagramPacket(data, data.length);
                sendSocket.send(send);
                logger.finer("Test 3: Binding Request sent.");
                int localPort = sendSocket.getLocalPort();
                InetAddress localAddress = sendSocket.getLocalAddress();
                sendSocket.close();
                DatagramSocket receiveSocket = new DatagramSocket(localPort, localAddress);
                receiveSocket.connect(InetAddress.getByName(this.stunServer), this.ca.getPort());
                receiveSocket.setSoTimeout(timeout);
                MessageHeader receiveMH = new MessageHeader();
                while (!receiveMH.equalTransactionID(sendMH)) {
                    DatagramPacket receive = new DatagramPacket(new byte[200], 200);
                    receiveSocket.receive(receive);
                    receiveMH = MessageHeader.parseHeader(receive.getData());
                }
                ErrorCode ec = (ErrorCode)receiveMH.getMessageAttribute(MessageAttributeInterface.MessageAttributeType.ErrorCode);
                if (ec != null) {
                    this.di.setError(ec.getResponseCode(), ec.getReason());
                    logger.config("Message header contains errorcode message attribute.");
                    return;
                }
                if (!this.nodeNatted) continue;
                this.di.setRestrictedCone();
                logger.fine("Node is behind a restricted NAT.");
                continue;
            }
            catch (SocketTimeoutException ste) {
                if (timeSinceFirstTransmission < 7900) {
                    logger.finer("Test 3: Socket timeout while receiving the response.");
                    int timeoutAddValue = (timeSinceFirstTransmission += timeout) * 2;
                    if (timeoutAddValue > 1600) {
                        timeoutAddValue = 1600;
                    }
                    timeout = timeoutAddValue;
                    continue;
                }
                logger.finer("Test 3: Socket timeout while receiving the response. Maximum retry limit exceed. Give up.");
                this.di.setPortRestrictedCone();
                logger.fine("Node is behind a port restricted NAT.");
                return;
            }
            break;
        }
    }
}

