/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;

public class WebSocketFrame
implements Frame {
    public static final int MAX_CONTROL_PAYLOAD = 125;
    private boolean fin = true;
    private boolean rsv1 = false;
    private boolean rsv2 = false;
    private boolean rsv3 = false;
    protected byte opcode = (byte)-1;
    private boolean masked = false;
    private byte[] mask;
    private ByteBuffer data;
    private int payloadLength = 0;
    private int payloadStart = -1;
    private Frame.Type type;
    private boolean continuation = false;
    private int continuationIndex = 0;

    public static WebSocketFrame binary() {
        return new WebSocketFrame(2);
    }

    public static WebSocketFrame binary(byte[] buf) {
        return new WebSocketFrame(2).setPayload(buf);
    }

    public static WebSocketFrame ping() {
        return new WebSocketFrame(9);
    }

    public static WebSocketFrame pong() {
        return new WebSocketFrame(10);
    }

    public static WebSocketFrame text() {
        return new WebSocketFrame(1);
    }

    public static WebSocketFrame text(String msg) {
        return new WebSocketFrame(1).setPayload(msg);
    }

    public WebSocketFrame() {
        this(-1);
    }

    public WebSocketFrame(byte opcode) {
        this.reset();
        this.setOpCode(opcode);
    }

    public WebSocketFrame(Frame frame) {
        if (frame instanceof WebSocketFrame) {
            WebSocketFrame wsf = (WebSocketFrame)frame;
            this.copy(wsf, wsf.data);
        } else {
            this.fin = frame.isFin();
            this.rsv1 = frame.isRsv1();
            this.rsv2 = frame.isRsv2();
            this.rsv3 = frame.isRsv3();
            this.opcode = frame.getType().getOpCode();
            this.type = frame.getType();
            this.masked = frame.isMasked();
            this.mask = null;
            byte[] maskCopy = frame.getMask();
            if (maskCopy != null) {
                this.mask = new byte[maskCopy.length];
                System.arraycopy(maskCopy, 0, this.mask, 0, this.mask.length);
            }
            this.setPayload(frame.getPayload());
        }
    }

    public WebSocketFrame(WebSocketFrame copy) {
        this.copy(copy, copy.data);
    }

    public WebSocketFrame(WebSocketFrame copy, ByteBuffer altPayload) {
        this.copy(copy, altPayload);
    }

    public void assertValid() {
        if (OpCode.isControlFrame(this.opcode)) {
            if (this.getPayloadLength() > 125) {
                throw new ProtocolException("Desired payload length [" + this.getPayloadLength() + "] exceeds maximum control payload length [" + 125 + "]");
            }
            if (!this.fin) {
                throw new ProtocolException("Cannot have FIN==false on Control frames");
            }
            if (this.rsv1) {
                throw new ProtocolException("Cannot have RSV1==true on Control frames");
            }
            if (this.rsv2) {
                throw new ProtocolException("Cannot have RSV2==true on Control frames");
            }
            if (this.rsv3) {
                throw new ProtocolException("Cannot have RSV3==true on Control frames");
            }
            if (this.isContinuation()) {
                throw new ProtocolException("Control frames cannot be Continuations");
            }
        }
    }

    private final void copy(WebSocketFrame copy, ByteBuffer payload) {
        this.fin = copy.fin;
        this.rsv1 = copy.rsv1;
        this.rsv2 = copy.rsv2;
        this.rsv3 = copy.rsv3;
        this.opcode = copy.opcode;
        this.type = copy.type;
        this.masked = copy.masked;
        this.mask = null;
        if (copy.mask != null) {
            this.mask = new byte[copy.mask.length];
            System.arraycopy(copy.mask, 0, this.mask, 0, this.mask.length);
        }
        this.continuationIndex = copy.continuationIndex;
        this.continuation = copy.continuation;
        this.setPayload(payload);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebSocketFrame other = (WebSocketFrame)obj;
        if (this.continuation != other.continuation) {
            return false;
        }
        if (this.continuationIndex != other.continuationIndex) {
            return false;
        }
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.fin != other.fin) {
            return false;
        }
        if (!Arrays.equals(this.mask, other.mask)) {
            return false;
        }
        if (this.masked != other.masked) {
            return false;
        }
        if (this.opcode != other.opcode) {
            return false;
        }
        if (this.rsv1 != other.rsv1) {
            return false;
        }
        if (this.rsv2 != other.rsv2) {
            return false;
        }
        return this.rsv3 == other.rsv3;
    }

    public int getContinuationIndex() {
        return this.continuationIndex;
    }

    @Override
    public byte[] getMask() {
        if (!this.masked) {
            throw new IllegalStateException("Frame is not masked");
        }
        return this.mask;
    }

    @Override
    public final byte getOpCode() {
        return this.opcode;
    }

    @Override
    public ByteBuffer getPayload() {
        if (this.data != null) {
            return this.data;
        }
        return null;
    }

    public String getPayloadAsUTF8() {
        if (this.data == null) {
            return null;
        }
        return BufferUtil.toUTF8String(this.data);
    }

    @Override
    public int getPayloadLength() {
        if (this.data == null) {
            return 0;
        }
        return this.payloadLength;
    }

    @Override
    public int getPayloadStart() {
        if (this.data == null) {
            return -1;
        }
        return this.payloadStart;
    }

    @Override
    public Frame.Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.continuation ? 1231 : 1237);
        result = 31 * result + this.continuationIndex;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.fin ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.mask);
        result = 31 * result + (this.masked ? 1231 : 1237);
        result = 31 * result + this.opcode;
        result = 31 * result + (this.rsv1 ? 1231 : 1237);
        result = 31 * result + (this.rsv2 ? 1231 : 1237);
        result = 31 * result + (this.rsv3 ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean hasPayload() {
        return this.data != null && this.payloadLength > 0;
    }

    @Override
    public boolean isContinuation() {
        return this.continuation;
    }

    public boolean isControlFrame() {
        return OpCode.isControlFrame(this.opcode);
    }

    public boolean isDataFrame() {
        return OpCode.isDataFrame(this.opcode);
    }

    @Override
    public boolean isFin() {
        return this.fin;
    }

    @Override
    public boolean isLast() {
        return this.fin;
    }

    public boolean isLastFrame() {
        return this.fin;
    }

    @Override
    public boolean isMasked() {
        return this.masked;
    }

    @Override
    public boolean isRsv1() {
        return this.rsv1;
    }

    @Override
    public boolean isRsv2() {
        return this.rsv2;
    }

    @Override
    public boolean isRsv3() {
        return this.rsv3;
    }

    public int position() {
        if (this.data == null) {
            return -1;
        }
        return this.data.position();
    }

    @Override
    public int remaining() {
        if (this.data == null) {
            return 0;
        }
        return this.data.remaining();
    }

    public void reset() {
        this.fin = true;
        this.rsv1 = false;
        this.rsv2 = false;
        this.rsv3 = false;
        this.opcode = (byte)-1;
        this.masked = false;
        this.data = null;
        this.payloadLength = 0;
        this.mask = null;
        this.continuationIndex = 0;
        this.continuation = false;
    }

    public Frame setContinuation(boolean continuation) {
        this.continuation = continuation;
        return this;
    }

    public Frame setContinuationIndex(int continuationIndex) {
        this.continuationIndex = continuationIndex;
        return this;
    }

    public WebSocketFrame setFin(boolean fin) {
        this.fin = fin;
        return this;
    }

    public Frame setMask(byte[] maskingKey) {
        this.mask = maskingKey;
        this.masked = this.mask != null;
        return this;
    }

    public Frame setMasked(boolean mask) {
        this.masked = mask;
        return this;
    }

    public WebSocketFrame setOpCode(byte op) {
        this.opcode = op;
        this.type = op == -1 ? null : Frame.Type.from(op);
        return this;
    }

    public WebSocketFrame setPayload(byte[] buf) {
        if (buf == null) {
            this.data = null;
            return this;
        }
        if (OpCode.isControlFrame(this.opcode) && buf.length > 125) {
            throw new ProtocolException("Control Payloads can not exceed 125 bytes in length.");
        }
        this.data = BufferUtil.toBuffer(buf);
        this.payloadStart = this.data.position();
        this.payloadLength = this.data.limit();
        return this;
    }

    public WebSocketFrame setPayload(byte[] buf, int offset, int len) {
        if (buf == null) {
            this.data = null;
            return this;
        }
        if (OpCode.isControlFrame(this.opcode) && len > 125) {
            throw new ProtocolException("Control Payloads can not exceed 125 bytes in length.");
        }
        this.data = BufferUtil.toBuffer(buf, offset, len);
        this.payloadStart = this.data.position();
        this.payloadLength = this.data.limit();
        return this;
    }

    public WebSocketFrame setPayload(ByteBuffer buf) {
        if (buf == null) {
            this.data = null;
            return this;
        }
        if (OpCode.isControlFrame(this.opcode) && buf.remaining() > 125) {
            throw new ProtocolException("Control Payloads can not exceed 125 bytes in length. (was " + buf.remaining() + " bytes)");
        }
        this.data = buf.slice();
        this.payloadStart = this.data.position();
        this.payloadLength = this.data.limit();
        return this;
    }

    public WebSocketFrame setPayload(String str) {
        this.setPayload(BufferUtil.toBuffer(str, StringUtil.__UTF8_CHARSET));
        return this;
    }

    public WebSocketFrame setRsv1(boolean rsv1) {
        this.rsv1 = rsv1;
        return this;
    }

    public WebSocketFrame setRsv2(boolean rsv2) {
        this.rsv2 = rsv2;
        return this;
    }

    public WebSocketFrame setRsv3(boolean rsv3) {
        this.rsv3 = rsv3;
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(OpCode.name(this.opcode));
        b.append('[');
        b.append("len=").append(this.payloadLength);
        b.append(",fin=").append(this.fin);
        b.append(",rsv=");
        b.append(this.rsv1 ? (char)'1' : '.');
        b.append(this.rsv2 ? (char)'1' : '.');
        b.append(this.rsv3 ? (char)'1' : '.');
        b.append(",masked=").append(this.masked);
        b.append(",continuation=").append(this.continuation);
        b.append(",payloadStart=").append(this.getPayloadStart());
        b.append(",remaining=").append(this.remaining());
        b.append(",position=").append(this.position());
        b.append(']');
        return b.toString();
    }
}

