/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.nio.NioAccumulatorConnection;
import ibis.ipl.impl.nio.NioSendPort;
import ibis.ipl.impl.nio.SendBuffer;
import ibis.ipl.impl.nio.SendReceiveThread;
import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectableChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThreadNioAccumulatorConnection
extends NioAccumulatorConnection {
    private static Logger logger = LoggerFactory.getLogger(ThreadNioAccumulatorConnection.class);
    boolean sending = false;
    IOException error = null;
    SendReceiveThread sendReceiveThread;

    ThreadNioAccumulatorConnection(NioSendPort port, SendReceiveThread sendReceiveThread, GatheringByteChannel channel, ReceivePortIdentifier peer) throws IOException {
        super(port, channel, peer);
        this.sendReceiveThread = sendReceiveThread;
        this.key = sendReceiveThread.register((SelectableChannel)((Object)channel), (Object)this);
    }

    synchronized void addToThreadSendList(SendBuffer buffer) throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        while (this.full()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("waiting for the sendlist to have a free spot");
                }
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.addToSendList(buffer);
        if (!this.sending) {
            this.sendReceiveThread.enableWriting(this.key);
            this.sending = true;
        }
    }

    synchronized void threadSend() {
        if (this.full()) {
            ((Object)((Object)this)).notifyAll();
        }
        try {
            if (this.send()) {
                this.key.interestOps(0);
                this.sending = false;
                ((Object)((Object)this)).notifyAll();
            }
        }
        catch (IOException e) {
            this.key.interestOps(0);
            this.sending = false;
            this.error = e;
            ((Object)((Object)this)).notifyAll();
        }
    }

    @Override
    public synchronized void closeConnection() {
        while (!this.empty()) {
            if (this.error != null) {
                // empty if block
            }
            if (!this.sending) {
                this.sendReceiveThread.enableWriting(this.key);
                this.sending = true;
            }
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        super.closeConnection();
    }
}

