/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.nio;

import ibis.io.Conversion;
import ibis.io.DataInputStream;
import ibis.ipl.impl.ReceivePortIdentifier;
import ibis.ipl.impl.nio.Config;
import ibis.ipl.impl.nio.NioReceivePort;
import ibis.ipl.impl.nio.Protocol;
import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ReadableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NioDissipator
extends DataInputStream
implements Config,
Protocol {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_DOUBLE = 8;
    protected static final int BUFFER_LIMIT = 55296;
    private static final int LONGS = 1;
    private static final int DOUBLES = 2;
    private static final int INTS = 3;
    private static final int FLOATS = 4;
    private static final int SHORTS = 5;
    private static final int CHARS = 6;
    private static final int BYTES = 7;
    protected static final int SIZEOF_HEADER = 16;
    private static Logger logger = LoggerFactory.getLogger(NioDissipator.class);
    protected ByteBuffer buffer;
    private ByteBuffer copyFromBuffer;
    private ByteBuffer copyToBuffer;
    protected int usedPosition = 0;
    protected int usedLimit = 0;
    private ShortBuffer header;
    private LongBuffer longs;
    private DoubleBuffer doubles;
    private FloatBuffer floats;
    private IntBuffer ints;
    private ShortBuffer shorts;
    private CharBuffer chars;
    private ByteBuffer bytes;
    private ByteOrder order;
    private long count = 0L;
    NioReceivePort.ConnectionInfo info;
    ReadableByteChannel channel;

    protected NioDissipator(ReadableByteChannel channel) throws IOException {
        this.channel = channel;
        this.order = ByteOrder.BIG_ENDIAN;
        this.buffer = ByteBuffer.allocateDirect(61440);
        this.copyFromBuffer = this.buffer.duplicate();
        this.copyToBuffer = this.buffer.duplicate();
        this.buffer.limit(55296);
        this.initViews(this.order);
        this.header.limit(0);
        this.longs.limit(0);
        this.doubles.limit(0);
        this.floats.limit(0);
        this.ints.limit(0);
        this.shorts.limit(0);
        this.chars.limit(0);
        this.bytes.limit(0);
    }

    public int bufferSize() {
        return -1;
    }

    protected void initViews(ByteOrder order) {
        if (logger.isDebugEnabled()) {
            logger.debug("initializing views in " + order + " byte order");
        }
        int position = this.buffer.position();
        int limit = this.buffer.limit();
        this.buffer.order(order);
        this.buffer.clear();
        this.header = this.buffer.asShortBuffer();
        this.longs = this.buffer.asLongBuffer();
        this.doubles = this.buffer.asDoubleBuffer();
        this.floats = this.buffer.asFloatBuffer();
        this.ints = this.buffer.asIntBuffer();
        this.shorts = this.buffer.asShortBuffer();
        this.chars = this.buffer.asCharBuffer();
        this.bytes = this.buffer.duplicate();
        this.buffer.position(position);
        this.buffer.limit(limit);
    }

    private int setView(Buffer view, int start, int bytes, int dataSize) {
        int result = (start + bytes) % 55296;
        if (result < start) {
            this.copyFromBuffer.position(0);
            this.copyFromBuffer.limit(result);
            this.copyToBuffer.position(55296);
            this.copyToBuffer.limit(start + bytes);
            this.copyToBuffer.put(this.copyFromBuffer);
        }
        view.limit((start + bytes) / dataSize);
        view.position(start / dataSize);
        if (logger.isDebugEnabled()) {
            logger.debug("setView: set view: position(" + view.position() + ") limit(" + view.limit() + "), in bytes: position(" + view.position() * dataSize + ") limit(" + view.limit() * dataSize + ")");
        }
        return result;
    }

    int unUsedLength() {
        if (this.buffer.position() >= this.usedLimit) {
            return this.buffer.position() - this.usedLimit;
        }
        return this.buffer.position() + (55296 - this.usedLimit);
    }

    int usedLength() {
        if (this.usedLimit >= this.usedPosition) {
            return this.usedPosition - this.usedLimit;
        }
        return this.usedLimit + (55296 - this.usedPosition);
    }

    void receive() throws IOException {
        short[] headerArray = new short[8];
        if (logger.isDebugEnabled()) {
            logger.debug("receiving buffer");
            if (this.remaining() > 0) {
                logger.error("receiving with data still left in the buffer, content: l[" + this.longs.remaining() + "] d[" + this.doubles.remaining() + "] i[" + this.ints.remaining() + "] f[" + this.floats.remaining() + "] s[" + this.shorts.remaining() + "] c[" + this.chars.remaining() + "] b[" + this.bytes.remaining() + "]");
                throw new IOException("tried receive() while there was data left in the buffer");
            }
        }
        this.usedPosition = this.usedLimit;
        if (this.buffer.limit() != 55296) {
            if (this.buffer.position() < this.usedPosition) {
                this.buffer.limit(this.usedPosition - 1);
            } else if (this.buffer.position() >= this.usedLimit) {
                this.buffer.limit(55296);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("usedPosition = " + this.usedPosition + " buffer.position(" + this.buffer.position() + ") buffer.limit(" + this.buffer.limit() + ")");
        }
        if (this.unUsedLength() < 16) {
            this.fillBuffer(16);
        }
        this.bytes.clear();
        byte paddingLength = this.bytes.get(this.usedPosition + 1);
        ByteOrder receivedOrder = this.bytes.get(this.usedPosition) == 1 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        if (this.order != receivedOrder) {
            this.order = receivedOrder;
            this.initViews(this.order);
        }
        int next = this.setView(this.header, this.usedPosition, 16, 2);
        this.header.get(headerArray);
        int totalSize = 16 + headerArray[1] + headerArray[2] + headerArray[3] + headerArray[4] + headerArray[5] + headerArray[6] + headerArray[7] + paddingLength;
        if (logger.isDebugEnabled()) {
            logger.debug("total size of buffer we're receiving is: " + totalSize + " padding: " + paddingLength);
        }
        if (this.unUsedLength() < totalSize) {
            this.fillBuffer(totalSize);
        }
        this.usedLimit = (this.usedPosition + totalSize) % 55296;
        next = this.setView(this.longs, next, headerArray[1], 8);
        next = this.setView(this.doubles, next, headerArray[2], 8);
        next = this.setView(this.ints, next, headerArray[3], 4);
        next = this.setView(this.floats, next, headerArray[4], 4);
        next = this.setView(this.shorts, next, headerArray[5], 2);
        next = this.setView(this.chars, next, headerArray[6], 2);
        next = this.setView(this.bytes, next, headerArray[7], 1);
        if (logger.isDebugEnabled()) {
            logger.debug("received: l[" + this.longs.remaining() + "] d[" + this.doubles.remaining() + "] i[" + this.ints.remaining() + "] f[" + this.floats.remaining() + "] s[" + this.shorts.remaining() + "] c[" + this.chars.remaining() + "] b[" + this.bytes.remaining() + "]");
        }
    }

    /*
     * Unable to fully structure code
     */
    boolean messageWaiting() throws IOException {
        if (this.info.in == null) {
            this.info.newStream();
        }
        block6: while (true) {
            if (this.info.in.available() == 0) {
                return false;
            }
            command = this.info.in.readByte();
            switch (command) {
                case 1: {
                    this.info.newStream();
                    continue block6;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    this.info.close(null);
                    throw new IOException("connection closed by peer");
                }
                case 4: {
                    length = new byte[4];
                    this.info.in.readArray(length);
                    bytes = new byte[Conversion.defaultConversion.byte2int(length, 0)];
                    this.info.in.readArray(bytes);
                    identifier = new ReceivePortIdentifier(bytes);
                    if (identifier.equals((Object)this.info.port.ident)) ** break;
                    continue block6;
                    this.info.close(null);
                    throw new IOException("connection closed by peer");
                }
            }
            break;
        }
        throw new IOException("unknown opcode in command");
    }

    void readFromChannel() throws IOException {
        int count;
        if (logger.isDebugEnabled()) {
            logger.debug("reading into buffer, position(" + this.buffer.position() + ") limit(" + this.buffer.limit() + ")");
        }
        if ((count = this.channel.read(this.buffer)) == -1) {
            throw new IOException("END-OF-STREAM encountered");
        }
        this.count += (long)count;
        if (logger.isDebugEnabled()) {
            logger.debug("read " + count + " bytes, total" + " bytes read now " + this.count);
        }
        if (!this.buffer.hasRemaining() && this.buffer.limit() == 55296 && this.usedPosition > 0) {
            this.buffer.position(0);
            this.buffer.limit(this.usedPosition - 1);
            if (logger.isDebugEnabled()) {
                logger.debug("buffer wrapped, position(" + this.buffer.position() + ") limit(" + this.buffer.limit() + ")");
            }
        }
    }

    int remaining() {
        return this.longs.remaining() * 8 + this.doubles.remaining() * 8 + this.ints.remaining() * 4 + this.floats.remaining() * 4 + this.shorts.remaining() * 2 + this.chars.remaining() * 2 + this.bytes.remaining() * 1;
    }

    public int available() {
        int result = this.remaining();
        if (this.unUsedLength() > 0) {
            ++result;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("available: " + result);
        }
        return result;
    }

    boolean dataLeft() {
        try {
            return this.info.in.available() != 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public long bytesRead() {
        return this.count;
    }

    public void resetBytesRead() {
        this.count = 0L;
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    public byte readByte() throws IOException {
        byte result;
        try {
            result = this.bytes.get();
        }
        catch (BufferUnderflowException e) {
            this.receive();
            result = this.bytes.get();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("received byte: " + result);
        }
        return result;
    }

    public int read() throws IOException {
        try {
            return this.readByte() & 0xFF;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public char readChar() throws IOException {
        try {
            return this.chars.get();
        }
        catch (BufferUnderflowException e) {
            this.receive();
            return this.chars.get();
        }
    }

    public short readShort() throws IOException {
        try {
            return this.shorts.get();
        }
        catch (BufferUnderflowException e) {
            this.receive();
            return this.shorts.get();
        }
    }

    public int readInt() throws IOException {
        try {
            return this.ints.get();
        }
        catch (BufferUnderflowException e) {
            this.receive();
            return this.ints.get();
        }
    }

    public long readLong() throws IOException {
        try {
            return this.longs.get();
        }
        catch (BufferUnderflowException e) {
            this.receive();
            return this.longs.get();
        }
    }

    public float readFloat() throws IOException {
        try {
            return this.floats.get();
        }
        catch (BufferUnderflowException e) {
            this.receive();
            return this.floats.get();
        }
    }

    public double readDouble() throws IOException {
        try {
            return this.doubles.get();
        }
        catch (BufferUnderflowException e) {
            this.receive();
            return this.doubles.get();
        }
    }

    public void readArray(boolean[] ref, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            ref[i] = this.readByte() == 1;
        }
    }

    public void readArray(byte[] ref, int off, int len) throws IOException {
        try {
            this.bytes.get(ref, off, len);
        }
        catch (BufferUnderflowException e) {
            int left = len;
            int offset = off;
            while (left > 0) {
                int size = Math.min(left, this.bytes.remaining());
                this.bytes.get(ref, offset, size);
                offset += size;
                if ((left -= size) <= 0) continue;
                this.receive();
            }
        }
        if (logger.isDebugEnabled()) {
            String message = "received byte[], Contents: ";
            for (int i = off; i < off + len; ++i) {
                message = message + ref[i] + " ";
            }
            logger.debug(message);
        }
    }

    public int read(byte[] ref) throws IOException {
        return this.read(ref, 0, ref.length);
    }

    public int read(byte[] ref, int off, int len) throws IOException {
        block7: {
            try {
                this.bytes.get(ref, off, len);
            }
            catch (BufferUnderflowException e) {
                int left = len;
                int offset = off;
                try {
                    while (left > 0) {
                        int size = Math.min(left, this.bytes.remaining());
                        this.bytes.get(ref, offset, size);
                        offset += size;
                        if ((left -= size) <= 0) continue;
                        this.receive();
                    }
                }
                catch (EOFException e2) {
                    len = offset - off;
                    if (len != 0) break block7;
                    return -1;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            String message = "received byte[], Contents: ";
            for (int i = off; i < off + len; ++i) {
                message = message + ref[i] + " ";
            }
            logger.debug(message);
        }
        return len;
    }

    public void readArray(char[] ref, int off, int len) throws IOException {
        try {
            this.chars.get(ref, off, len);
        }
        catch (BufferUnderflowException e) {
            int left = len;
            while (left > 0) {
                int size = Math.min(left, this.chars.remaining());
                this.chars.get(ref, off, size);
                off += size;
                if ((left -= size) <= 0) continue;
                this.receive();
            }
        }
    }

    public void readArray(short[] ref, int off, int len) throws IOException {
        try {
            this.shorts.get(ref, off, len);
        }
        catch (BufferUnderflowException e) {
            int left = len;
            while (left > 0) {
                int size = Math.min(left, this.shorts.remaining());
                this.shorts.get(ref, off, size);
                off += size;
                if ((left -= size) <= 0) continue;
                this.receive();
            }
        }
    }

    public void readArray(int[] ref, int off, int len) throws IOException {
        try {
            this.ints.get(ref, off, len);
        }
        catch (BufferUnderflowException e) {
            int left = len;
            while (left > 0) {
                int size = Math.min(left, this.ints.remaining());
                this.ints.get(ref, off, size);
                off += size;
                if ((left -= size) <= 0) continue;
                this.receive();
            }
        }
    }

    public void readArray(long[] ref, int off, int len) throws IOException {
        try {
            this.longs.get(ref, off, len);
        }
        catch (BufferUnderflowException e) {
            int left = len;
            while (left > 0) {
                int size = Math.min(left, this.longs.remaining());
                this.longs.get(ref, off, size);
                off += size;
                if ((left -= size) <= 0) continue;
                this.receive();
            }
        }
    }

    public void readArray(float[] ref, int off, int len) throws IOException {
        try {
            this.floats.get(ref, off, len);
        }
        catch (BufferUnderflowException e) {
            int left = len;
            while (left > 0) {
                int size = Math.min(left, this.floats.remaining());
                this.floats.get(ref, off, size);
                off += size;
                if ((left -= size) <= 0) continue;
                this.receive();
            }
        }
    }

    public void readArray(double[] ref, int off, int len) throws IOException {
        try {
            this.doubles.get(ref, off, len);
        }
        catch (BufferUnderflowException e) {
            int left = len;
            while (left > 0) {
                int size = Math.min(left, this.doubles.remaining());
                this.doubles.get(ref, off, size);
                off += size;
                if ((left -= size) <= 0) continue;
                this.receive();
            }
        }
    }

    public void readByteBuffer(ByteBuffer b) throws IOException {
        if (b.hasArray()) {
            this.readArray(b.array(), b.arrayOffset(), b.limit() - b.position());
            b.position(b.limit());
        } else {
            byte[] buf = new byte[b.limit() - b.position()];
            this.readArray(buf);
            b.put(buf);
        }
    }

    protected abstract void fillBuffer(int var1) throws IOException;

    public void close() throws IOException {
        this.channel.close();
    }
}

