# Welcome to Parameter Identification of Ship Dynamics

This [JupyterBook](https://jupyterbook.org/) has been created by me ([Martin Alexandersson](https://www.linkedin.com/in/martin-alexandersson-77823312/)) to document the research for my Phd. studies.

This book is about System Identification (SI) of ship dynamics. 

A lot of research about SI methods for ship manoeuvring where developed during 1980s, for instance the applications of Extended Kalman Filters (EKF) and Maximum Likelihood methods (ML) {cite:p}`astrom_identification_1976`. In the 1990s, studies on the application of SI to the ship manoeuvring had been paid relatively less attention to due to the rapid development of CFD methods {cite:p}`luo_parameter_2016-1`. CFD can be thought of as a "white box" where the output is generated entirely based on physical relations to the input, so that no extra data from model tests or full scale measurements are needed.
With the development of in service data collection onboard ships and also the rapid development of autonomous ships, SI based modeling has however received renewed attention.

The growing popularity of Artificial intelligence techniques (AI) have been employed to SI of ship dynamics. This can be considered as an implicit model (or so-called a black-box model) that describes the input-output mapping characteristics. The most used SI, which will be explored in this book, is the determination of hydrodynamic derivatives (coefficients) in an explicit mathematical model. This generally combines some simplified physics from a "white box model" with the data driven approach of a "black box model" resulting in a "grey box model".

The main advantage with SI is that you can identify (fit) a model by using data, either obtained from model tests or real ship operation. The fitted model can be used to make predictions related to the ship dynamics. This pattern is very common in Machine Learning, where a model is fitted to a dataset and then used to make predictions outside this data. Let's consider some useful cases:
* Data from manoeuvring model tests are fitted to a model that is used in a bridge simulator
* Extending the results from manoeuvring model tests by simulating for other speeds and rudder angles.
* Operational data can be used to develop a digital twin, which can be used to monitor and evaluate the ship performance. 

The main disadvantage is the problem of parameter *identifiability*. It can be explained from two aspects. One kind of parameter identifiability is whether the parameters can be identified or not. When solving a state space equation with respect to the ship manoeuvring motion, some parameters cannot be identified for instance the added masses or acceleration derivatives, no matter what input-output samples are provided and no matter which SI technique is adopted {cite:p}`luo_parameter_2016-1`. The other kind of parameter identifiability is the effect of parameter drift. The identified coefficients might be not physically correct but be mathematically correct {cite:p}`committee_final_2005`, which implies that even if the identified parameters deviate from their true values, the manoeuvring model can predict the manoeuvring motion well, compared with the test results. This means that model has been overfitted, giving poor predictions for points outside the fitted data for instance when a ZigZag20/20 should be predicted with a model fitted on data from a ZigZag10/10 test.  

Overcoming these challenges will be investigated in this book.