// Licensed under the MIT License
// https://github.com/craigahobbs/chisel/blob/master/LICENSE

import {SchemaMarkdownParser} from '../schemaMarkdown/parser.js';


// The Mardown model defined as Schema Markdown
export const markdownModelSmd = `\
# Markdown document struct
struct Markdown

    # The markdown document's parts
    MarkdownPart[len < 1000] parts


# Markdown document part struct
union MarkdownPart

    # A paragraph
    Paragraph paragraph

    # A horizontal rule (value is ignored)
    object(nullable) hr

    # A list
    List list

    # A code block
    CodeBlock codeBlock


# Paragraph markdown part struct
struct Paragraph

    # The paragraph style
    optional ParagraphStyle style

    # The paragraph span array
    Span[len > 0, len < 1000] spans


# Paragraph style enum
enum ParagraphStyle
    h1
    h2
    h3
    h4
    h5
    h6


# Paragraph span struct
union Span

    # Text span
    string(len > 0, len < 1000) text

    # Line break (value is ignored)
    object(nullable) br

    # Style span
    StyleSpan style

    # Link span
    LinkSpan link

    # Image span
    ImageSpan image


# Style span struct
struct StyleSpan

    # The span's character style
    CharacterStyle style

    # The contained spans
    Span[len > 0, len < 1000] spans


# Character style enum
enum CharacterStyle
    bold
    italic


# Link span struct
struct LinkSpan

    # The link's URL
    string(len > 0, len < 1000) href

    # The image's title
    optional string(len > 0, len < 1000) title

    # The contained spans
    Span[len > 0, len < 1000] spans


# Image span struct
struct ImageSpan

    # The image URL
    string(len > 0, len < 1000) src

    # The image's alternate text
    string(len > 0, len < 1000) alt

    # The image's title
    optional string(len > 0, len < 1000) title


# List markdown part struct
struct List

    # The list is numbered and this is starting number
    optional int(>= 0) start

    # The list's items
    ListItem[len > 0, len < 1000] items


# List item struct
struct ListItem

    # The markdown document's parts
    MarkdownPart[len > 0, len < 1000] parts


# Code block markdown part struct
struct CodeBlock

    # The code block's language
    optional string(len > 0, len < 100) language

    # The code block's text lines
    string[len < 1000] lines
`;


// The Markdown model
export const markdownModel = {
    'title': 'The Markdown Model',
    'types': (new SchemaMarkdownParser(markdownModelSmd)).types
};
