# Domains API
To facilitate running a home web server behind a router without a static IP, this package checks to see if external IP has changed and updates dynamic DNS rules on Google Domains, via the API; also notifies user by email if required.

### Installation:

`pip install domains-api`

Can be run from the command line:

`python -m domains_api` (or `python3`)

or imported into your projects:
```
>>>from domains_api import IPChanger
>>>ipchanger = IPChanger()
>>>ipchanger.user.domain
example.com
```

Windows/Mac/Linux it will ask for your credentials on first run and then shouldn't need any input after that. I added command line options/arguments (see `python domains_api --help`) for loading/deleting a profile and changing credentials/settings more easily.

You will need your Dynamic DNS autogenerated username and password as described in [this documentation.](https://support.google.com/domains/answer/6147083?hl=en-CA)

If you choose to receive email notifications, you will be asked to input your gmail email address and password which will then be encoded before being saved. (The notification is sent from the user's own email address via the gmail smtp server, you will need to allow less secure apps on your Google account to use.). For more info on how to set up Dynamic DNS and the process I went through writing this script check [this blog post.](https://mjfullstack.medium.com/running-a-home-web-server-without-a-static-ip-using-google-domains-python-saves-the-day-246570b26d88)

After initial setup, the script takes care of everything: if your IP has changed since you last ran it, it will update your Dynamic DNS rule on domains.google.com.

On **Windows** you can use Task Scheduler; on **Linux/Mac**, add a line to your crontab and you can choose the frequency of the checks. My hourly cron job looks like this:

`0 * * * * python3 -m domains_api >> ~/cron.log 2>&1`

If reducing downtime is essential, you could increase the frequency of checks to every 5 minutes, or even less, like this:

`*/5 * * * * ...etc`

On Google Domains the default TTL for Dynamic DNS is 1 min, but unless you expect your external IP to change very frequently, more regular cron jobs might be a slight waste of resources; even so, the script is very light weight.

The logs are written to both `domains-api.log` in `/var/log/` or `LOCALAPPDATA`, and stdout, so that they also appear in the cron log & terminal. Check `~/cron.log` if the script does not run as expected, or to see when the IP was last checked.

If you forget your IP or need to check it for any reason, running

`python -m domains_api` 

without options will log your current IP to the terminal.

Options include:

    domains-api help manual (command line options):
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    python -m domains_api                    || -run the script normally without arguments
    python -m domains_api -h --help          || -show this help manual
    python -m domains_api -c --credentials   || -change API credentials
    python -m domains_api -e --email         || -email set up wizard > use to delete email credentials (choose 'n')
    python -m domains_api -n --notifications || -toggle email notification settings > will not delete email address
    python -m domains_api -d --delete_user   || -delete current user profile
    python -m domains_api -u user.file       || (or "--user_load path/to/user.file") -load user from pickle file**
                                             || **this will overwrite any current user profile without warning!
                                             || **Backup "./.domains.user" file to store multiple profiles.

