<h1 align="center">Writema? What's Writema?</h1>

### Writema is a binary stream writing library

> Well, what does it do?

### Well I'm glad you asked!

Writema is a little library I started to help with writing binary files.

> That's it?

Well yeah, what did you expect?
Some large module I've been writing my entire life that will change the world with its amazing binary writing ability?

## Cool Badges
![Tests](https://github.com/whamer100/Writema/actions/workflows/tests.yml/badge.svg)
<br/><br/>
![](https://img.shields.io/badge/Shoutouts%20to-SimpleFlips-%23B6BFFF?link=https://www.twitch.tv/simpleflips&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsIAAA7CARUoSoAAAAarSURBVEhLhVYJbBTXGf7fm9ljZne99pq1vbbBXrwmvoIxDjJ2RUXSKK6aBkWoJCJRGgQNKEhNr6hpxBFDK5UUoaolJGqrkELTRDFJCU1ETagxJBKGGmjAB8ZX1vYaH+ztPWbneH9n7Y2DaaR80q/33vf++Y838/5/4OuAiOTM1BmSWabX0KFzLjVub0bkrujrtKT5EZ1v1SWtN6ivt+vyjUg7+NOV5+YMILbCKH5Mqt5c4sye6djK4+yrNkwJGdVvBM2M/4ft9X+Gz+At8nRil+kYHKdMjDcKE52PoqoMGAHk05lI9ejnxrtxN7fgYD7aefkS+bKbhqTJrIt97VlUk80OfKeKfnHjvkQotiQPgBzSM+3Vx4z6Ap4gX1F0weipU3Msmd9Er9dLVhjXa03iEwEN5SyThdsjzg4d44rLE3Jg+pltikJ5XXEfIfrj80HdHdyXoHD4MNHKynLh9GkCJ04suO4q7cLzcIJ0hv7ewAoSj5sr0DbNfz+HJNQ6iAZTt0Ba/0kEyE9DSH7um88iE9wC0g4pJJPAGXkJLl4yQyikk8cJTG8km8AJuaCABoZhTuWcbBbPcf0dPoWxvcxTPo4RQ8WF5wPLj61mYvIFoO/uQnr8xeuk462OdErQ9kor6f9Pv57fwYMEzp7lcGhAJA+UJNSnbgiqKZotG2Elq+ODR7rhyfd8qSKuJC8wbD8Uj+etLwO7BYwfBCu0w6bR3L6Cvz6VUIayCJnU7B8FeezCvf7fJXfn/sxGbbzMtfA8r/b0blYZ+3ZyPNJAvhP2oAEPMDt51pTHBCNPN17NogNqDhmNLt/SJFk9FEbH/oUX/Fb2ucWTF84qrVTkPQkYilmk3sq1krvC/muSvVpeFe5x3IxzLYWFlIVCK/VTfEh3IvLfTW5QDWo9b4deWWB3kkyo7RphrREKvCrb1Yip0ccT/pQhHpuyCqUxY9fllFEbClI2/Xg5KCuWk7zVKVTrOMDYBv+W6xQ8HgZG00fUBV1qyWyfFtb6OBv16q+nxmDmY3dkOSj52SjR6GGTcmeW9vbckl0l3fKBqWWxNm+1hANuCYeKGRntLiLWVWGIWN+B93ve5j44n37RFKqrka+vi2iPCG/w6zivMZczsSg6VRWjTNPsg9P005GA4pS8LKZ8dnLY6O/tsqLCZxUNt4PjrCibI2uieFsLgPzQNRx+zwszrxgKzLvVHJxJO+BampoA3G7gr4ZV0zoYUCwBG8thYVpKV6hEW1peYAoKDuHcbIX5CzmVXDPxrdcLmImMmxtrBXYtZtMGXMvE1HXBD4NdTpt5i1iDn+/u/616IdbJ5jNwOACYPj+5lcGzP2amKvcxRslBVdHe5gjdORZXsrsTsR/5xqM/Cbkee4ZnbCWNqvVSz8D34pfObYbklXYjlzOIEJ+9JPWLdruw6LZRCASAvPSSTuqXHnoAPDs1OahpMENNqJLtNiMJu518o2Dhf5FwVNo0ohXLvpHnyXCkmU8VeXk2ZotA6KCJF3/5X+n05I5//2qxA7JvX2aaq0u3LgFiJJwL9ArC8Vz2yCQrTYXAn/Anw8sif2gXgtfOcBZ7Yaqv6hZTfxBJGB9OUn4N32z+4+17b3Iad1XToC4dEPvw1UJVw+c0BTeoCRXXLsebkVwmgMJbUxLnksLCAzB+56h1A+citnGXCCiK2kTl2tql2rydxVhwQEjLXC1hTFvGEMsMGmGcgl4DR6pFgdqMTjip5DelwO66nwS0/aGjbbna1CfDFqXTZtNw14HOF4o/fhQJti4ueIv6AeJ2MOYIV3mBa0MJGSH0BlLoMk9oweSEJslThZ3a2KRdEZS/iesrjlC60ptiVLOQPFyLO6pvDQA9//ri8n1Pw3ERsztHQ4aNmMQVoHKbiYxjDy6x7KheIv5+Npn3D4gEN4qegr28sa6Ep+XVqwzbRDdrQBN1SmF/QoTSjKkM7nHwPqYmJws4CzqMpfQvalDdz6HtjVX5tsv52dUzJCnOWllyYF1ZTdT1qXbIlLr+cg26X/PRy9Gz2p532yP7a32XF2eQ7hlfwWcjEEYLz9OXhfsNPiG72AvQqG9cIk9WHmGeyvpYWu12C8D4riz1vtTDgw/mWwcvHr3p5xFfdJiLeoub9e/vZlrra4BjmwjO7KRSm82B1woWIknX9w7smOu1+t/Fos515jiSjUt/IzQYtpW25CjCAScaMltzWHxES2MIxho0ZddGoG5ywcoJXf4J6wn0tcCHECdX5+k5NP+Q4GNbn5aqGjxjDsrLDZtAzWzpAPgfZ5tYxYkh0PgAAAAASUVORK5CYII=)

## Usage

> Note, requires Python 3.8 or higher (For now at least)

### Installation

```sh
pip install writema
```

### Sample code

```py
from writema import Writema

# Let's say you want to write a file to contain in order:
# - An integer
# - An unsigned integer
# - A double
# - A string prefixed by its length with a byte
# - A large buffer blob you dont exactly know the length of
w = Writema("some_file.bin") # note: defaults to Little Endian

w.write(4, 69)  # write a 4 byte integer (int32_t)
w.uwrite(2, -1337)  # write an unsigned 2 bit integer (uint16_t)

w.write("d", 2.718281828459045)  # write the constant e as a double

string = b"Hello, World!"
length = len(string)

w.write(1, length)
w.bytes(string)

important_data = ...  # imagine theres some very large binary blob here in bytes
w.bytes(important_data)
```

Example of ways to do the same action
```py
from writema import Writema, WritemaTypes

w = Writema()

# lets say you want the end buffer to be b"AAAABBBBCCCCDDDD"
# heres four ways you can do each of the four bytes

w.write(4, 1094795585)  # Writes a 32 bit (4 byte) integer (AAAA = 1094795585)
w.write("int", 1111638594)  # this also writes a 32 bit int (BBBB = 1111638594)
w.write(WritemaTypes.int, 1128481603)  # someone might prefer this idk (CCCC = 1128481603)
w.bytes(b"DDDD")  # its a bytestring, probably the easiest to work with
```

Other examples
```py
# writing floats and doubles is a little scuffed for now, i plan to find a better solution
w.write("f", 6.9)
w.write("float", 6.9)
w.write(WritemaTypes.float, 6.9)
w.write("d", 6.90000001)
w.write("double", 6.90000001)
w.write(WritemaTypes.double, 6.90000001)

# you can also set endianness
w.set_endianness("big")
# and
w.set_endianness("little")  # the correct endianness /s
```

## Documentation

### [tba](https://www.youtube.com/watch?v=dQw4w9WgXcQ)

## License

Copyright (c) 2022 [whamer100](https://github.com/whamer100) <br />
This project is [MIT](https://github.com/whamer100/Writema/blob/master/LICENSE.md) licensed.

---
> hey is this project name just one big ligma joke
###### maybe
