import os
import re
import numpy as np
from hover.utils.common_nn import MLP
import wrappy


def dummy_text_to_vec(text):
    """
    A 'minimal' text vectorizer.
    """
    return np.random.rand(128)

@wrappy.guard(fallback_retval=dummy_text_to_vec)
def get_text_to_vec():
    """
    :returns: a text vectorizer.
    """
    import spacy
    
    # SpaCy 'vector' models are perfect for this
    #nlp = spacy.load('en_vectors_web_lg')
    
    # 'core' models are slower due to linguistic features
    nlp = spacy.load('en_core_web_md')
    
    # could use a transformer if speed is ok
    #nlp = spacy.load('en_trf_bertbaseuncased_lg')

    # memoization can be useful if the function takes a while to run, e.g. transformer models
    #@wrappy.memoize(cache_limit=50000)
    def text_to_vec(text):
        """
        A more serious example of a text vectorizer.
        """
        clean_text = re.sub(r'[\t\n]', r' ', text)
        return nlp(clean_text, disable=nlp.pipe_names).vector
    
    return text_to_vec

def get_architecture():
    return MLP

def get_state_dict_path():
    dir_path = os.path.dirname(__file__)
    return os.path.join(dir_path, 'model.pt')
