"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsPublicDiscovery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ecs = require("aws-cdk-lib/aws-ecs");
const events = require("aws-cdk-lib/aws-events");
const eventsTargets = require("aws-cdk-lib/aws-events-targets");
const iam = require("aws-cdk-lib/aws-iam");
const lambdaNodeJs = require("aws-cdk-lib/aws-lambda-nodejs");
const logs = require("aws-cdk-lib/aws-logs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class EcsPublicDiscovery extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.cluster = props.cluster;
        const route53UpdaterFunction = new lambdaNodeJs.NodejsFunction(this, 'function', {
            bundling: {
                minify: true
            },
            environment: {
                HOSTED_ZONE_ID: props.hostedZone.hostedZoneId,
                HOSTED_ZONE_NAME: props.hostedZone.zoneName
            },
            logRetention: logs.RetentionDays.ONE_YEAR,
            tracing: props.tracing
        });
        route53UpdaterFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['ec2:DescribeNetworkInterfaces'],
            resources: ['*']
        }));
        route53UpdaterFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: [
                'route53:ListResourceRecordSets',
                'route53:ChangeResourceRecordSets'
            ],
            resources: [aws_cdk_lib_1.Stack.of(this).formatArn({
                    account: '',
                    region: '',
                    resource: 'hostedzone',
                    resourceName: props.hostedZone.hostedZoneId,
                    service: 'route53'
                })]
        }));
        new events.Rule(this, 'Route53UpdaterFunctionRule', {
            eventPattern: {
                detail: {
                    clusterArn: [props.cluster.clusterArn],
                    desiredStatus: ['RUNNING', 'STOPPED'],
                    lastStatus: ['RUNNING']
                },
                detailType: ['ECS Task State Change'],
                source: ['aws.ecs']
            }
        }).addTarget(new eventsTargets.LambdaFunction(route53UpdaterFunction));
    }
    addService(options) {
        if (options.service.cluster !== this.cluster) {
            throw new Error('The service must be part of the same cluster!');
        }
        const { taskDefinition } = options.service;
        // Validate that the service has the right network mode
        if (taskDefinition.networkMode !== ecs.NetworkMode.AWS_VPC) {
            throw new Error('Cannot use ECS public discovery if NetworkMode is not AWS_VPC.');
        }
        aws_cdk_lib_1.Tags.of(options.service).add('public-discovery:name', options.name);
        if (options.dnsTtl) {
            aws_cdk_lib_1.Tags.of(options.service).add('public-discovery:ttl', String(options.dnsTtl.toSeconds()));
        }
    }
}
exports.EcsPublicDiscovery = EcsPublicDiscovery;
_a = JSII_RTTI_SYMBOL_1;
EcsPublicDiscovery[_a] = { fqn: "cdk-ecs-public-discovery.EcsPublicDiscovery", version: "1.0.0" };
//# sourceMappingURL=data:application/json;base64,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