import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="makinas",
    version="0.0.3",
    author="Nemanja Nikodijevic",
    author_email="nemanja.nikodijevic@nbt.ag",
    description="Package for interfacing with Makinas APIs",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://gitlab.com/makinas-nbt/pymakinas.git",
    packages=setuptools.find_packages(),
    install_requires=["requests>=2.22.0", "tqdm>=4.41.1"],
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.5',
    entry_points= {
        'console_scripts': ['makinas=makinas.cli:main'],
    },
)
