"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientVpnAuthorizationRule = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ec2_generated_1 = require("./ec2.generated");
/**
 * A client VPN authorization rule.
 *
 * @stability stable
 */
class ClientVpnAuthorizationRule extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        new ec2_generated_1.CfnClientVpnAuthorizationRule(this, 'Resource', {
            clientVpnEndpointId: props.clientVpnEndoint.endpointId,
            targetNetworkCidr: props.cidr,
            accessGroupId: props.groupId,
            authorizeAllGroups: !props.groupId,
            description: props.description,
        });
    }
}
exports.ClientVpnAuthorizationRule = ClientVpnAuthorizationRule;
_a = JSII_RTTI_SYMBOL_1;
ClientVpnAuthorizationRule[_a] = { fqn: "@aws-cdk/aws-ec2.ClientVpnAuthorizationRule", version: "1.103.0" };
//# sourceMappingURL=data:application/json;base64,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