import os
from .bash import BashCall
import rdkit.Chem as Chem
import re
from .stkcage import pdb_block


opls_dihedral_dict={'HC-CT-CT-HC': '0.000 0.000 0.300 0.0', 'HC-C -C -HC': '0.800 0.000 0.000 0.0', 'HC-C=-C=-HC': '0.000 0.000 0.300 0.0', 'HC-C=-C#-HC': '0.000 0.000 0.300 0.0', 'HC-C=-C#-CT': '0.000 0.000 0.300 0.0', 'CT-C=-C#-CT': '0.000 0.000 0.300 0.0', 'CT-C=-C=-CT': '0.000 0.000 0.300 0.0', 'CT-C=-C=-HC': '0.000 0.000 0.300 0.0', 'CT-C#-C=-CT': '0.000 0.000 0.300 0.0', 'CT-C#-C=-HC': '0.000 0.000 0.300 0.0', 'H3-N3-CT-HC': '0.000 0.000 0.300 0.0', 'HC-CT-CT-CT': '0.000 0.000 0.300 0.0', 'HC-CT-CT-CO': '0.000 0.000 0.300 0.0', 'HC-CO-CT-CT': '0.000 0.000 0.300 0.0', 'CT-CT-CT-CT': '1.300 -0.200 0.200 0.0', 'CT-CT-CT-CO': '1.300 -0.200 0.200 0.0', 'CT-CT-CA-CA': '0.000 0.150 0.000 0.0', 'HC-CT-CT-OH': '0.0 0.0 0.468 0.0', 'HC-CT-CT-OS': '0.0 0.0 0.468 0.0', 'HC-CT-CO-OS': '0.0 0.0 0.468 0.0', 'CT-CT-CT-O?': '-1.336 0.0 0.0 0.0', 'CT-CT-CO-O?': '1.711 -0.500 0.663 0.0', 'HC-CM-CT-O?': '0.0 0.0 0.468 0.0', 'CT-CM-CT-O?': '1.711 -0.500 0.663 0.0', 'CT-CT-CT-OH': '-1.552 0.0 0.000 0.0', 'HC-CT-OH-HO': '0.000 0.000 0.476 0.0', 'CT-CT-OH-HO': '2.674 -2.883 1.026 0.0', 'OH-CT-CT-OH': '9.066 0.0 0.0 0.0', 'HC-CT-OS-C?': '0.0 0.0 0.76 0.0', 'HC-CT-OS-CA': '0.0 0.0 0.76 0.0', 'HC-CT-OS-CM': '0.0 0.0 0.76 0.0', 'HC-CM-OS-CT': '0.0 0.0 0.76 0.0', 'HC-CO-OS-CT': '0.0 0.0 0.76 0.0', 'HC-CT-OS-CO': '0.0 0.0 0.76 0.0', 'CT-OS-CT-CT': '0.650 -0.250 0.670 0.0', 'CT-OS-CM-CT': '0.650 -0.250 0.670 0.0', 'CT-OS-CO-CT': '0.650 -0.250 0.670 0.0', 'CT-OS-CT-O?': '-0.521 -2.018 1.996 0.0', 'NT-CT-CT-OH': '8.000 0.0 0.0 0.0', 'OS-CT-CT-OS': '-0.550 0.0 0.0 0.0', 'CT-OS-CA-CA': '0.0 3.37 0.0 0.30', 'CT-OS-CW-CS': '0.0 3.37 0.0 0.30', 'CA-CA-CM-HC': '0.0 0.0 0.0 0.0', 'CA-CA-C=-HC': '0.0 0.0 0.0 0.0', 'CM-C=-C=-CT': '0.0 0.0 -0.372 0.0', 'CM-C=-C=-HC': '0.0 0.0 -0.372 0.0', 'HC-C=-N=-C': '0.0 0.0 -0.372 0.0', 'CM-C=-C#-HC': '0.0 0.0 -0.372 0.0', 'C#-C#-C=-HC': '0.0 0.0 -0.372 0.0', 'C#-C#-C=-CT': '0.0 0.0 -0.372 0.0', 'CM-C=-C#-CT': '0.0 0.0 -0.372 0.0', 'CA-CA-C#-HC': '0.0 0.0 -0.372 0.0', 'CM-C=-C=-CM': '1.423 4.055 0.858 0.0', 'C#-C#-C=-CM': '1.423 4.055 0.858 0.0', 'C#-C#-C#-C#': '1.423 4.055 0.858 0.0', 'HC-CT-CA-CA': '0.000 0.000 0.000 0.0', 'HC-CO-CA-CA': '0.000 0.000 0.000 0.0', 'HC-CY-CA-CA': '0.000 0.000 0.000 0.0', 'HC-CY-CA-NC': '0.000 0.000 0.000 0.0', 'HC-CY-CW-NA': '0.000 0.000 0.000 0.0', 'HC-CY-CW-OA': '0.000 0.000 0.000 0.0', 'HC-CM-CA-NC': '0.000 0.000 0.000 0.0', 'HC-C=-CA-NC': '0.000 0.000 0.000 0.0', 'HC-CM-CP-SA': '0.000 0.000 0.000 0.0', 'HC-C=-CP-SA': '0.000 0.000 0.000 0.0', 'CA-CA-Cl-XC': '0.000 0.000 0.000 0.0', 'CA-CA-Br-XB': '0.000 0.000 0.000 0.0', 'CA-CA-I -XI': '0.000 0.000 0.000 0.0', '??-C?-Cl-XC': '0.000 0.000 0.000 0.0', '??-C?-Br-XB': '0.000 0.000 0.000 0.0', '??-C?-I -XI': '0.000 0.000 0.000 0.0', 'H3-N3-CA-CA': '0.000 0.000 0.000 0.0', 'HC-CT-CW-??': '0.000 0.000 0.000 0.0', 'HC-CT-CP-??': '0.000 0.000 0.000 0.0', 'HC-CT-CV-??': '0.000 0.000 0.000 0.0', 'HC-CT-CR-??': '0.000 0.000 0.000 0.0', 'HC-CT-CS-??': '0.000 0.000 0.000 0.0', 'HC-CT-CQ-??': '0.000 0.000 0.000 0.0', 'HC-CT-CU-??': '0.000 0.000 0.000 0.0', 'HC-CT-CK-??': '0.000 0.000 0.000 0.0', 'HC-CT-C*-??': '0.000 0.000 0.000 0.0', 'CZ-CZ-CM-HC': '0.000 0.000 0.000 0.0', 'CZ-CZ-CM-CT': '0.000 0.000 0.000 0.0', 'CT-N3-CA-CA': '0.000 0.000 0.000 0.0', 'CT-CT-CW-??': '0.000 0.000 0.000 0.0', 'CS-CW-CT-CT': '0.000 0.000 0.000 0.0', 'CT-CT-CV-??': '0.000 0.000 0.000 0.0', 'CT-CT-CR-??': '0.000 0.000 0.000 0.0', 'CT-CT-CS-??': '0.000 0.000 0.000 0.0', 'CT-CT-CQ-??': '0.000 0.000 0.000 0.0', 'CT-CT-CU-??': '0.000 0.000 0.000 0.0', 'CT-CT-CK-??': '0.000 0.000 0.000 0.0', 'CT-CT-C*-??': '0.000 0.000 0.000 0.0', 'O?-CT-CA-CA': '0.000 0.000 0.000 0.0', 'C?-CT-NA-C?': '0.000 0.000 0.000 0.0', 'H?-CT-NA-C?': '0.000 0.000 0.000 0.0', 'HC-CT-NS-CW': '0.000 0.000 0.000 0.0', 'C?-CT-N*-C?': '0.000 0.000 0.000 0.0', 'H?-CT-N*-C?': '0.000 0.000 0.000 0.0', 'O -C -CR-O?': '0.000 0.000 0.000 0.0', 'O -C -CR-N?': '0.000 0.000 0.000 0.0', 'CA-CA-CT-N?': '0.000 0.000 0.000 0.0', 'CA-CA-CO-O?': '0.000 0.000 0.000 0.0', 'CA-CA-CT-O?': '0.000 0.000 0.000 0.0', 'NB-CV-CT-C': '0.000 0.000 0.000 0.0', 'CW-CV-CT-C': '0.000 0.000 0.000 0.0', '??-Zn-N -??': '0.000 0.000 0.000 0.0', '??-Zn-O -??': '0.000 0.000 0.000 0.0', 'HC-CT-CT-CA': '0.000 0.000 0.462 0.0', 'HC-CT-N3-CA': '0.000 0.000 0.462 0.0', 'HC-CT-CT-CW': '0.000 0.000 0.462 0.0', 'HC-CT-CT-CV': '0.000 0.000 0.462 0.0', 'HC-CT-CT-CR': '0.000 0.000 0.462 0.0', 'HC-CT-CT-CS': '0.000 0.000 0.462 0.0', 'HC-CT-CT-CQ': '0.000 0.000 0.462 0.0', 'HC-CT-CT-CU': '0.000 0.000 0.462 0.0', 'HC-CT-CT-CK': '0.000 0.000 0.462 0.0', 'HC-CT-CT-C*': '0.000 0.000 0.462 0.0', 'CT-S -S -CT': '0.000 -7.414 1.705 0.0', 'HC-CT-S -S': '0.000 0.000 0.558 0.0', 'CT-CT-S -S': '1.941 -0.836 0.935 0.0', 'HC-CT-SH-HS': '0.000 0.000 0.480 0.0', 'CT-CT-SH-HS': '-0.759 -0.282 0.680 0.0', 'HC-CT-CT-SH': '0.000 0.000 0.452 0.0', 'HC-CT-CT-SY': '0.0 0.0 0.3500 0.0', 'HC-CT-CT-S': '0.000 0.000 0.452 0.0', 'CT-CT-CT-SH': '1.262 -0.198 0.465 0.0', 'CT-CT-CT-SY': '1.262 -0.198 0.465 0.0', 'HC-CT-NT-H': '0.000 0.000 0.400 0.0', 'HC-CT-CT-NT': '-1.013 -0.709 0.473 0.0', 'CT-CT-NT-H': '1.522 -0.417 0.418 0.0', 'CT-CT-N2-H': '-0.190 -0.417 0.418 0.0', 'CT-CT-N2-H3': '-0.190 -0.417 0.418 0.0', 'CT-CT-CT-NT': '2.392 -0.674 0.550 0.0', 'HO-OH-CA-CA': '0.000 2.060 0.000 0.0', 'HO-OH-CW-CS': '0.000 2.060 0.000 0.0', 'HO-OH-CP-CS': '0.000 2.060 0.000 0.0', 'HO-OH-CM-CM': '0.000 1.682 0.000 0.0', 'N -CT-CT-CT': '1.572 0.159 0.200 0.0', 'N -CT-CT-C*': '-0.588 1.020 0.665 0.0', 'N -CT-CT-CA': '1.712 0.725 0.366 0.0', 'C -N -CT-C': '-2.511 0.210 -0.200 0.0', 'N -CT-C -N': '-0.940 2.755 -2.670 0.0', 'C -N -CT-CT': '1.130 -1.420 0.440 0.0', 'CT-CT-C -N': '1.494 -0.511 0.125 0.0', 'C -N -CT-HC': '0.000 0.000 -0.139 0.0', 'HC-CT-C -N': '0.000 0.000 0.000 0.0', 'HC-CM-C -N': '0.000 0.000 0.000 0.0', 'HC-CT-C -NM': '0.000 0.000 0.000 0.0', 'HC-CM-C -NM': '0.000 0.000 0.000 0.0', 'CQ-N -CT-CT': '0.000 0.000 0.000 0.0', 'CQ-N -CT-CA': '0.000 0.000 0.000 0.0', 'H -N -CT-??': '0.000 0.000 0.000 0.0', 'H -N -CT-CT': '0.000 0.000 0.000 0.0', 'H -N -CT-C': '0.000 0.000 0.000 0.0', '??-CT-C -O': '0.000 0.000 0.000 0.0', 'CT-CT-C -O': '1.656 1.304 0.439 0.0', 'N -CT-C -O': '0.000 0.000 0.000 0.0', 'CT-C -N -H': '0.000 4.900 0.000 0.0', 'CA-C -N -H': '0.000 4.900 0.000 0.0', 'CS-C -N -H': '0.000 4.900 0.000 0.0', 'CM-C -N -H': '0.000 4.900 0.000 0.0', 'HC-C -N -H': '0.000 4.900 0.000 0.0', 'CT-C -NM-CT': '0.000 4.900 0.000 0.0', 'O -C -NM-CT': '0.000 4.900 0.000 0.0', 'CT-C -N -CT': '2.300 6.089 0.000 0.0', 'CT-C -N -CA': '2.300 6.089 0.000 0.0', 'HC-C -N -CT': '2.300 6.089 0.000 0.0', 'CA-C -N -CA': '2.300 6.089 0.000 0.0', 'CS-C -N -CA': '2.300 6.089 0.000 0.0', 'CA-C -N -CS': '2.300 6.089 0.000 0.0', 'CS-C -N -CS': '2.300 6.089 0.000 0.0', 'CW-C -N -CA': '2.300 6.089 0.000 0.0', 'CA-C -N -CW': '2.300 6.089 0.000 0.0', 'CW-C -N -CW': '2.300 6.089 0.000 0.0', 'CS-C -N -CW': '2.300 6.089 0.000 0.0', 'CW-C -N -CS': '2.300 6.089 0.000 0.0', 'O -C -N -H': '0.000 4.900 0.000 0.0', 'O -C -N -CT': '0.000 6.089 0.000 0.0', 'O -C -N -CA': '0.000 6.089 0.000 0.0', 'NC-C -N -CA': '0.000 6.089 0.000 0.0', 'O -C -N -CM': '0.000 6.089 0.000 0.0', 'N -C -N -H': '0.000 4.900 0.000 0.0', 'N -C -N -C': '2.300 6.089 0.000 0.0', 'CT-N -CT-HC': '0.000 0.000 0.000 0.0', 'CT-N2-CT-HC': '0.000 0.000 0.000 0.0', 'CA-N -CT-HC': '0.000 0.000 0.000 0.0', 'CT-NM-CT-HC': '0.000 0.000 0.000 0.0', 'CA-NM-CT-HC': '0.000 0.000 0.000 0.0', 'CA-CA-SH-HS': '0.000 0.610 0.000 0.0', 'C?-CA-SH-HS': '0.000 0.610 0.000 0.0', 'CS-CW-SH-HS': '0.000 0.610 0.000 0.0', 'CS-CP-SH-HS': '0.000 0.610 0.000 0.0', 'N?-CA-SH-HS': '0.850 2.660 0.000 0.0', 'HC-CT-S -CT': '0.000 0.000 0.647 0.0', 'HC-CT-S -CA': '0.000 0.000 0.647 0.0', 'CT-CT-CT-S': '-1.565 -0.009 -0.450 0.0', 'CT-CT-S -CT': '0.925 -0.576 0.677 0.0', 'H -N2-CA-N2': '0.000 3.900 0.000 0.0', 'H -N2-CA-CA': '0.000 3.900 0.000 0.0', 'CT-N2-CA-N2': '0.000 7.936 0.000 0.0', 'HC-CT-N2-CA': '0.000 0.000 0.177 0.0', 'HC-CT-N2-H': '0.000 0.000 0.000 0.0', 'CT-CT-N2-CA': '1.829 0.243 -0.498 0.0', 'HC-CT-CT-N2': '0.000 0.000 -0.582 0.0', 'C -NM-CT-HC': '0.000 0.000 -0.139 0.0', 'HC-CT-N -H': '0.000 0.000 0.000 0.0', 'N -CT-CT-HC': '0.000 0.000 0.464 0.0', 'C -NM-CT-CT': '-1.396 -0.427 0.000 0.0', 'NM-CT-CT-HC': '0.000 0.000 0.464 0.0', 'NM-CT-CT-CT': '1.964 0.000 0.659 0.0', 'CM-CM-C -NM': '2.000 0.000 0.0 0.0', 'CM-CM-C -N': '2.000 0.000 0.0 0.0', 'HC-CT-C -O': '0.000 0.000 0.000 0.0', 'HC-C -C -O': '0.000 0.000 0.000 0.0', 'HC-CM-C -O': '0.000 0.000 0.000 0.0', 'HC-CT-CT-C': '0.000 0.000 -0.100 0.0', 'C -CT-CT-CT': '-4.16 -0.76 0.96 0.16', 'N -CT-CT-OH': '6.258 -1.037 1.367 0.0', 'N -CT-CT-C': '-5.501 1.527 0.000 0.0', 'C -CT-CT-OH': '-5.793 0.405 0.000 0.0', 'N -CT-CT-S?': '2.055 0.529 0.544 0.0', 'C -CT-CT-S?': '-3.323 0.529 0.000 0.0', 'NC-CA-CT-HC': '0.0 0.0 0.100 0.0', 'HC-CT-C*-CW': '0.000 0.000 -0.480 0.0', 'HC-CT-C*-CB': '0.000 0.000 0.000 0.0', 'CT-CT-C*-CW': '-0.714 0.000 0.000 0.0', 'CT-CT-C*-CB': '0.000 0.000 0.000 0.0', 'HC-CT-CC-N?': '0.000 0.000 0.419 0.0', 'CT-CT-CC-N?': '2.366 -0.262 0.505 0.0', 'HC-CT-N3-H': '0.000 0.000 0.261 0.0', 'CT-CT-N3-H': '0.000 0.000 0.347 0.0', 'HC-CT-CT-N3': '0.000 0.000 0.384 0.0', 'CT-CT-CT-N3': '2.732 -0.229 0.485 0.0', 'HC-CT-NO-ON': '0.000 0.000 0.000 0.0', '?T-CT-C -O': '0.000 0.820 0.000 0.0', '?T-CT-C -O2': '0.000 0.820 0.000 0.0', 'HC-CT-CT-NO': '0.000 0.000 -0.225 0.0', 'CT-CT-CT-C': '-0.885 1.025 -1.293 0.0', 'HC-CT-C -O2': '0.0 0.0 0.0 0.0', 'HC-CT-C -OH': '0.0 0.0 0.0 0.0', 'CA-CT-C -O': '0.000 0.546 0.000 0.0', 'CT-CT-C -OH': '0.0 1.412 0.00 0.0', 'NT-CT-C -OH': '5.260 0.820 0.0 0.0', 'HO-OH-CA-NC': '0.000 3.692 0.000 0.0', 'C -CT-CT-C': '0.598 1.558 0.255 0.0', 'O -C -OH-HO': '0.000 5.000 0.00 0.0', 'CT-C -OH-HO': '3.200 4.900 0.000 0.0', 'HC-C -OH-HO': '1.500 5.500 0.00 0.0', 'C -CT-CT-HC': '0.0 0.0 0.074 0.0', 'CT-N -CT-C': '-1.737 1.251 -3.501 0.0', 'CT-N -CT-CT': '4.753 -0.734 0.00 0.0', 'CT-CT-N -CT': '2.859 2.058 -11.266 0.0', 'CT-NM-CT-C': '-1.737 1.251 -3.501 0.0', 'CT-NM-CT-CT': '4.753 -0.734 0.00 0.0', 'CT-CT-NM-CT': '2.859 2.058 -11.266 0.0', 'CT-CT-C+-CT': '0.0 -1.0 0.00 0.0', 'CT-CT-C+-HC': '0.0 -1.0 0.00 0.0', 'HC-CT-C -CT': '0.0 0.0 0.275 0.0', 'HC-CT-C -CA': '0.0 0.0 0.275 0.0', 'HC-CT-C -HC': '0.0 0.0 0.360 0.0', 'HC-CT-C -F': '0.0 0.0 0.360 0.0', 'HC-CT-C -Cl': '0.0 0.0 0.360 0.0', 'HC-CT-C -Br': '0.0 0.0 0.360 0.0', 'CT-CT-C -F': '0.0 0.0 0.0 0.0', 'CT-CT-C -Cl': '0.0 0.0 0.0 0.0', 'CT-CT-C -Br': '0.0 0.0 0.0 0.0', 'CA-CT-CT-C': '-1.697 -0.456 0.585 0.0', 'C*-CT-CT-C': '-1.697 -0.456 0.585 0.0', 'CT-CT-C -HC': '0.0 0.0 0.0 0.0', 'CT-CT-C -CT': '1.454 -0.144 -0.775 0.0', 'C -C -OH-HO': '3.000 5.500 0.00 0.0', 'CA-CT-P -OS': '2.25 0.0 0.00 0.0', 'CT-P -OS-CT': '3.5 -3.3 1.50 0.0', 'P -OS-CT-HC': '0.0 0.0 0.30 0.0', 'O2-P -OS-CT': '0.90 -2.93 2.64 0.0', 'O -P -OS-CA': '0.0 0.0 0.00 0.0', 'O -P -OH-HO': '0.0 0.0 0.00 0.0', 'OH-P -OH-HO': '0.0 0.0 0.00 0.0', 'CA-CA-CT-P': '0.0 0.0 0.00 0.0', 'CA-CT-P -O2': '0.0 0.0 0.00 0.0', 'HC-CT-P -O2': '0.0 0.0 0.25 0.0', 'HC-CT-P -OS': '0.0 0.0 0.25 0.0', 'O2-P -OS-C?': '0.0 0.0 0.562 0.0', 'CA-CA-OS-P': '0.0 2.990 0.00 0.0', 'NT-CT-CT-Cl': '2.0 0.0 0.0 0.0', 'HC-CT-CT-Cl': '0.0 0.0 0.400 0.0', 'CT-CT-CT-Cl': '0.0 0.0 0.400 0.0', 'Cl-CT-CT-Cl': '-0.25 0.0 0.000 0.0', 'HC-CT-CT-I': '0.0 0.0 0.400 0.0', 'CT-CT-CT-I': '0.0 0.0 0.400 0.0', 'HO-OH-CT-CT': '4.478 -2.1746 0.000 0.0', 'F-CT-CT-HC': '0.000 0.000 0.3137 0.0', 'F -CT-CT-OH': '0.000 0.000 0.5401 0.0', 'H -N -SY-CA': '1.671 -4.901 0.669 0.0', 'HC-CT-N -SY': '1.362 -1.457 0.149 0.0', 'CT-N -SY-CA': '2.074 -2.966 2.473 0.0', 'CT-CT-N -SY': '2.929 -2.533 0.497 0.0', 'CA-CA-SY-N': '1.656 -0.768 -0.117 0.0', '??-??-SY-OY': '0.0 0.0 0.0 0.0', '??-CA-SY-OY': '0.0 0.0 0.0 0.0', '??-N -SY-OY': '0.0 0.0 0.0 0.0', '??-CT-SY-OY': '0.0 0.0 0.0 0.0', '??-CT-SY-N': '0.0 0.0 0.0 0.0', 'HC-CT-CT-F': '0.0 0.0 0.400 0.0', 'CT-CT-CT-F': '0.300 -0.4 0.400 0.0', 'F -CT-CT-F': '-2.5 0.0 0.250 0.0', 'F -CF-CF-F': '-2.5 0.0 0.250 0.0', 'CT-OS-CO-OH': '-0.375 -1.358 0.004 0.0', 'CT-OS-CO-OS': '-0.375 -1.358 0.004 0.0', 'OS-CO-OH-HO': '-1.257 -1.806 0.003 0.0', 'OH-CT-CT-OS': '4.319 0.0 0.0 0.0', 'CF-CF-CF-CF': '6.622 0.948 -1.388 -2.118', 'HC-CT-CT-Br': '0.0 0.0 0.400 0.0', 'CT-CT-CT-Br': '0.0 0.0 0.400 0.0', 'CA-CA-CT-Br': '0.0 0.0 0.400 0.0', 'O -C -X -Y': '0.0 21.0 0.0 0.0', 'Z -N -X -Y': '0.0 5.0 0.0 0.0', 'Z -CA-X -Y': '0.0 5.0 0.0 0.0', 'CF-CF-CF-F': '0.300 0.0 0.400 0.0', 'F -CT-CT-Cl': '-1.0 0.0 0.250 0.0', '??-CA-CA-??': '0.0 7.250 0.0 0.0', 'CA-CA-CA-CA': '0.0 7.250 0.0 0.0', 'CA-CA-CA-CY': '0.0 7.250 0.0 0.0', 'CA-CA-CA-CM': '0.0 7.250 0.0 0.0', 'CA-CA-CA-HA': '0.0 7.250 0.0 0.0', 'CY-CA-CA-HA': '0.0 7.250 0.0 0.0', 'CM-CA-CA-HA': '0.0 7.250 0.0 0.0', 'C#-CA-CA-HA': '0.0 7.250 0.0 0.0', 'C=-CA-CA-HA': '0.0 7.250 0.0 0.0', 'C=-CA-CA-CA': '0.0 7.250 0.0 0.0', 'C=-CA-CA-CT': '0.0 7.250 0.0 0.0', 'HA-CA-CA-HA': '0.0 7.250 0.0 0.0', 'CA-CA-C!-CA': '0.0 7.250 0.0 0.0', 'CA-CA-C!-C!': '0.0 7.250 0.0 0.0', 'CA-CA-CA-C!': '0.0 7.250 0.0 0.0', 'C!-CA-CA-HA': '0.0 7.250 0.0 0.0', 'HA-CA-C!-C!': '0.0 7.250 0.0 0.0', 'HA-CA-C!-CA': '0.0 7.250 0.0 0.0', 'CA-CA-C!-NC': '0.0 7.250 0.0 0.0', 'CA-C!-NC-CA': '0.0 7.250 0.0 0.0', 'C!-C!-CA-NC': '0.0 7.250 0.0 0.0', 'CA-C!-CA-NC': '0.0 7.250 0.0 0.0', 'C!-CA-CA-NC': '0.0 7.250 0.0 0.0', 'C!-C!-NC-CA': '0.0 7.250 0.0 0.0', 'C!-C!-N -C': '0.0 7.250 0.0 0.0', 'C!-C!-CM-C': '0.0 7.250 0.0 0.0', 'NC-C!-CA-HA': '0.0 7.250 0.0 0.0', 'CA-CA-CA-F': '0.0 7.250 0.0 0.0', 'CA-CA-CA-Cl': '0.0 7.250 0.0 0.0', 'CA-CA-CA-Br': '0.0 7.250 0.0 0.0', 'CA-CA-CA-I': '0.0 7.250 0.0 0.0', 'HA-CA-CA-F': '0.0 7.250 0.0 0.0', 'HA-CA-CA-Cl': '0.0 7.250 0.0 0.0', 'HA-CA-CA-Br': '0.0 7.250 0.0 0.0', 'HA-CA-CA-I': '0.0 7.250 0.0 0.0', 'CA-CA-CA-N?': '0.0 7.250 0.0 0.0', 'HA-CA-CA-NT': '0.0 7.250 0.0 0.0', 'HA-C=-C=-C?': '0.0 7.250 0.0 0.0', 'C -C=-C=-C': '0.0 7.250 0.0 0.0', 'HA-CA-CA-CT': '0.0 7.250 0.0 0.0', 'CT-CA-CA-CT': '0.0 7.250 0.0 0.0', 'CT-CA-CA-CA': '0.0 7.250 0.0 0.0', 'C#-CA-CA-CA': '0.0 7.250 0.0 0.0', 'CA-CA-CA-CB': '0.0 7.250 0.0 0.0', 'HA-CA-CA-CB': '0.0 7.250 0.0 0.0', 'HA-CA-CB-CB': '0.0 7.250 0.0 0.0', 'HA-CA-CB-CA': '0.0 7.250 0.0 0.0', 'CA-CA-CA-O?': '0.0 7.250 0.0 0.0', 'HA-CA-CA-O?': '0.0 7.250 0.0 0.0', 'CT-CA-CA-O?': '0.0 7.250 0.0 0.0', 'O?-CA-CA-O?': '0.0 7.250 0.0 0.0', 'CA-CA-CA-S?': '0.0 7.250 0.0 0.0', 'HA-CA-CA-S?': '0.0 7.250 0.0 0.0', 'CT-CA-CA-S?': '0.0 7.250 0.0 0.0', 'S?-CA-CA-S?': '0.0 7.250 0.0 0.0', 'HA-CM-C!-N?': '0.0 7.250 0.0 0.0', 'HA-CM-C!-N': '0.0 7.250 0.0 0.0', 'HA-CA-CA-N?': '0.0 7.250 0.0 0.0', 'CT-CA-CA-N?': '0.0 7.250 0.0 0.0', 'O?-CA-CA-N?': '0.0 7.250 0.0 0.0', 'N?-CA-CA-N?': '0.0 7.250 0.0 0.0', '??-CB-CB-??': '0.0 7.250 0.0 0.0', 'CA-CB-CB-CA': '0.0 7.250 0.0 0.0', 'CB-CB-CB-CB': '0.0 7.250 0.0 0.0', 'CB-CB-CB-CA': '0.0 7.250 0.0 0.0', 'CA-CA-CB-CB': '0.0 7.250 0.0 0.0', 'CB-CA-CB-CB': '0.0 7.250 0.0 0.0', 'CA-CA-CB-CA': '0.0 7.250 0.0 0.0', 'CA-CB-CA-CB': '0.0 7.250 0.0 0.0', 'C?-CB-CB-C?': '0.0 7.250 0.0 0.0', 'N?-CB-CB-C?': '0.0 7.250 0.0 0.0', 'N?-CB-CB-N?': '0.0 7.250 0.0 0.0', '??-CB-CS-??': '0.0 7.250 0.0 0.0', '??-CS-C -??': '0.0 7.250 0.0 0.0', '??-CR-CS-??': '0.0 7.250 0.0 0.0', '??-CS-CW-??': '0.0 7.250 0.0 0.0', 'C?-CS-CW-C?': '0.0 7.250 0.0 0.0', 'C?-CS-CW-H?': '0.0 7.250 0.0 0.0', 'C?-CS-CW-N?': '0.0 7.250 0.0 0.0', 'HA-CS-CW-N?': '0.0 7.250 0.0 0.0', 'HA-CS-CW-C?': '0.0 7.250 0.0 0.0', 'HA-CS-CW-HA': '0.0 7.250 0.0 0.0', 'HA-CS-CP-HA': '0.0 7.250 0.0 0.0', 'HA-CW-CS-CS': '0.0 7.250 0.0 0.0', 'HA-CP-CS-CS': '0.0 7.250 0.0 0.0', 'OS-CP-CS-CS': '0.0 7.250 0.0 0.0', 'HA-CS-CS-CW': '0.0 7.250 0.0 0.0', 'HA-CS-CS-CP': '0.0 7.250 0.0 0.0', 'OA-CW-CS-HA': '0.0 7.250 0.0 0.0', 'HA-CS-CS-HA': '0.0 7.250 0.0 0.0', 'HA-CA-CU-HA': '0.0 7.250 0.0 0.0', 'HA-CW-OA-CW': '0.0 7.250 0.0 0.0', 'NT-CW-OA-CW': '0.0 7.250 0.0 0.0', '??-NC-CA-??': '0.0 7.250 0.0 0.0', 'CS-CW-OA-CW': '0.0 7.250 0.0 0.0', 'OH-CW-CS-CS': '0.0 7.250 0.0 0.0', 'OH-CW-CS-HA': '0.0 7.250 0.0 0.0', 'OH-CW-NA-CW': '0.0 7.250 0.0 0.0', 'SH-CW-NA-CW': '0.0 7.250 0.0 0.0', 'SH-CW-CS-HA': '0.0 7.250 0.0 0.0', 'SH-CW-CS-CS': '0.0 7.250 0.0 0.0', 'S -CW-NA-CW': '0.0 7.250 0.0 0.0', 'S -CW-CS-HA': '0.0 7.250 0.0 0.0', 'S -CW-CS-CS': '0.0 7.250 0.0 0.0', 'NT-CW-NA-CW': '0.0 7.250 0.0 0.0', 'NT-CW-NA-H': '0.0 7.250 0.0 0.0', 'CW-CS-CS-CW': '0.0 7.250 0.0 0.0', 'OA-CW-CS-CS': '0.0 7.250 0.0 0.0', 'CT-CW-OA-CW': '0.0 7.250 0.0 0.0', 'CY-CW-OA-CW': '0.0 7.250 0.0 0.0', 'CT-CP-SA-CP': '0.0 7.250 0.0 0.0', 'OS-CP-SA-CP': '0.0 7.250 0.0 0.0', 'S -CP-SA-CP': '0.0 7.250 0.0 0.0', 'HA-CP-SA-CP': '0.0 7.250 0.0 0.0', 'CS-CP-SA-CP': '0.0 7.250 0.0 0.0', 'SA-CP-CS-CS': '0.0 7.250 0.0 0.0', 'CP-CS-CS-CP': '0.0 7.250 0.0 0.0', 'CT-CP-CS-CS': '0.0 7.250 0.0 0.0', 'CW-CS-CB-CB': '0.0 7.250 0.0 0.0', 'CW-OA-CW-OS': '0.0 7.250 0.0 0.0', 'CW-OA-CW-S': '0.0 7.250 0.0 0.0', 'CA-NC-CA-CA': '0.0 7.250 0.0 0.0', 'C?-NC-CA-N?': '0.0 7.250 0.0 0.0', 'CA-NC-CA-HA': '0.0 7.250 0.0 0.0', 'C=-N=-C -HC': '0.0 7.250 0.0 0.0', 'C=-N=-C -CT': '0.0 7.250 0.0 0.0', 'N=-C=-CM-HC': '0.0 7.250 0.0 0.0', 'CA-NC-NC-CT': '0.0 7.250 0.0 0.0', 'CA-NC-NC-CA': '0.0 7.250 0.0 0.0', 'CT-NC-NC-CT': '0.0 7.250 0.0 0.0', '??-NC-CB-??': '0.0 7.250 0.0 0.0', 'C?-NC-CB-C?': '0.0 7.250 0.0 0.0', 'C?-NC-CB-N?': '0.0 7.250 0.0 0.0', '??-NA-CB-??': '0.0 7.250 0.0 0.0', '??-NB-CB-??': '0.0 7.250 0.0 0.0', '??-NB-CR-??': '0.0 7.250 0.0 0.0', '??-NB-CU-??': '0.0 7.250 0.0 0.0', 'C?-NA-CB-C?': '0.0 7.250 0.0 0.0', 'C?-NA-CB-N?': '0.0 7.250 0.0 0.0', 'C?-NB-CB-C?': '0.0 7.250 0.0 0.0', 'N?-CR-SA-CW': '0.0 7.250 0.0 0.0', 'CR-NB-CV-CW': '0.0 7.250 0.0 0.0', 'CR-NB-CV-HA': '0.0 7.250 0.0 0.0', 'CU-CW-SA-CR': '0.0 7.250 0.0 0.0', 'CR-SA-CW-CV': '0.0 7.250 0.0 0.0', 'HA-CW-SA-CR': '0.0 7.250 0.0 0.0', 'CW-SA-CR-NB': '0.0 7.250 0.0 0.0', 'SA-CR-NB-CU': '0.0 7.250 0.0 0.0', 'SA-CR-NB-CV': '0.0 7.250 0.0 0.0', 'CR-NB-CU-CW': '0.0 7.250 0.0 0.0', 'NB-CU-CW-SA': '0.0 7.250 0.0 0.0', 'CU-CW-OA-CR': '0.0 7.250 0.0 0.0', 'CW-OA-CR-NB': '0.0 7.250 0.0 0.0', 'OA-CR-NB-CU': '0.0 7.250 0.0 0.0', 'NB-CU-CW-OA': '0.0 7.250 0.0 0.0', 'NB-CU-CW-HA': '0.0 7.250 0.0 0.0', 'NB-CV-CW-OA': '0.0 7.250 0.0 0.0', 'NB-CV-CW-HA': '0.0 7.250 0.0 0.0', 'NB-CV-CW-SA': '0.0 7.250 0.0 0.0', '??-N -CB-??': '0.0 7.250 0.0 0.0', 'HA-CU-CW-??': '0.0 7.250 0.0 0.0', 'HA-CW-CU-??': '0.0 7.250 0.0 0.0', '??-NC-CR-??': '0.0 7.250 0.0 0.0', '??-NC-CQ-??': '0.0 7.250 0.0 0.0', 'C?-NC-CQ-HA': '0.0 7.250 0.0 0.0', 'C?-NC-CQ-N?': '0.0 7.250 0.0 0.0', '??-N -CQ-??': '0.0 7.250 0.0 0.0', 'C?-N -CQ-N?': '0.0 7.250 0.0 0.0', 'C?-N -CQ-HA': '0.0 7.250 0.0 0.0', 'H -N -CQ-??': '0.0 7.250 0.0 0.0', 'NC-CA-CB-O?': '0.0 7.250 0.0 0.0', 'C!-C!-CB-O?': '0.0 7.250 0.0 0.0', 'NC-C!-CB-CS': '0.0 7.250 0.0 0.0', 'O?-CB-CS-NC': '0.0 7.250 0.0 0.0', 'NC-CS-CS-C?': '0.0 7.250 0.0 0.0', 'LP-NC-CA-CA': '0.0 7.250 0.0 0.0', 'LP-NC-CA-HA': '0.0 7.250 0.0 0.0', 'LP-NC-CB-CA': '0.0 7.250 0.0 0.0', 'LP-NC-NC-CA': '0.0 7.250 0.0 0.0', 'LP-NB-CR-NA': '0.0 7.250 0.0 0.0', 'LP-NB-CV-CW': '0.0 7.250 0.0 0.0', 'LP-NB-CR-??': '0.0 7.250 0.0 0.0', 'LP-NB-CV-??': '0.0 7.250 0.0 0.0', 'LP-NB-NA-CW': '0.0 7.250 0.0 0.0', 'LP-NB-NA-??': '0.0 7.250 0.0 0.0', '??-CW-NA-??': '0.0 3.0 0.0 0.0', '??-NA-CR-??': '0.0 4.65 0.0 0.0', 'HA-CR-NB-??': '0.0 10.0 0.0 0.0', 'N?-CR-NB-C?': '0.0 10.0 0.0 0.0', '??-CR-NB-??': '0.0 10.0 0.0 0.0', '??-CW-NB-??': '0.0 10.0 0.0 0.0', '??-CR-NA-??': '0.0 10.0 0.0 0.0', 'HA-CR-NA-??': '0.0 10.0 0.0 0.0', 'N?-CR-NA-C?': '0.0 10.0 0.0 0.0', '??-CR-NC-??': '0.0 10.0 0.0 0.0', '??-CK-NB-??': '0.0 10.0 0.0 0.0', '??-CK-NA-??': '0.0 10.0 0.0 0.0', '??-CK-NC-??': '0.0 10.0 0.0 0.0', '??-NA-NB-??': '0.0 10.0 0.0 0.0', '??-NB-NB-??': '0.0 10.0 0.0 0.0', '??-NB-CV-??': '0.0 4.80 0.0 0.0', '??-CW-CV-??': '0.0 10.75 0.0 0.0', 'C?-CW-CV-C?': '0.0 10.75 0.0 0.0', 'C?-CW-CV-HA': '0.0 10.75 0.0 0.0', 'HA-CW-CV-C?': '0.0 10.75 0.0 0.0', 'HA-CW-CV-HA': '0.0 10.75 0.0 0.0', '??-CW-CW-??': '0.0 10.75 0.0 0.0', 'C?-CW-CW-C?': '0.0 10.75 0.0 0.0', 'N?-CW-CW-N?': '0.0 10.75 0.0 0.0', 'C?-CW-CW-HA': '0.0 10.75 0.0 0.0', 'N?-CW-CW-HA': '0.0 10.75 0.0 0.0', 'H?-CW-CW-C?': '0.0 10.75 0.0 0.0', 'H?-CW-CW-HA': '0.0 10.75 0.0 0.0', 'HA-CW-CW-HA': '0.0 10.75 0.0 0.0', 'SA-CW-CW-HA': '0.0 10.75 0.0 0.0', 'SA-CW-CU-HA': '0.0 10.75 0.0 0.0', 'SA-CW-CV-HA': '0.0 10.75 0.0 0.0', 'SA-CP-CS-HA': '0.0 10.75 0.0 0.0', 'SA-CP-CP-HA': '0.0 10.75 0.0 0.0', '??-NA-CW-??': '0.0 5.00 0.0 0.0', 'C?-NA-CW-C?': '0.0 5.00 0.0 0.0', 'N?-NA-CW-C?': '0.0 5.00 0.0 0.0', 'C?-NA-CW-H?': '0.0 5.00 0.0 0.0', 'N?-NA-CW-H?': '0.0 5.00 0.0 0.0', 'H -NA-CW-??': '0.0 5.00 0.0 0.0', 'H -NA-CR-??': '0.0 5.00 0.0 0.0', 'H -NA-CB-??': '0.0 5.00 0.0 0.0', 'H -NA-CW-C!': '0.0 5.00 0.0 0.0', 'CW-NA-CW-CS': '0.0 5.00 0.0 0.0', 'H -NA-CW-CS': '0.0 5.00 0.0 0.0', 'CW-NA-CW-C!': '0.0 5.00 0.0 0.0', 'HA-CW-NA-CW': '0.0 5.00 0.0 0.0', 'H -NA-CW-HA': '0.0 5.00 0.0 0.0', 'CT-NS-CW-C!': '0.0 5.00 0.0 0.0', 'CS-CW-NS-CW': '0.0 5.00 0.0 0.0', 'CT-NS-CW-CS': '0.0 5.00 0.0 0.0', 'HA-CW-NS-CW': '0.0 5.00 0.0 0.0', 'HA-CW-NS-CT': '0.0 5.00 0.0 0.0', '??-C*-CW-??': '0.0 13.05 0.0 0.0', '??-C*-CB-??': '0.0 3.35 0.0 0.0', '??-CA-CB-??': '0.0 7.00 0.0 0.0', 'C?-CA-CB-C?': '0.0 7.00 0.0 0.0', 'N?-CA-CB-N?': '0.0 7.00 0.0 0.0', 'C?-CA-CB-N?': '0.0 7.00 0.0 0.0', 'N?-CA-CB-C?': '0.0 7.00 0.0 0.0', '??-C -CB-??': '0.0 7.00 0.0 0.0', 'O -C -CB-C?': '0.0 7.00 0.0 0.0', 'N?-C -CB-N?': '0.0 7.00 0.0 0.0', 'O -C -CB-N?': '0.0 7.00 0.0 0.0', 'N?-C -CB-C?': '0.0 7.00 0.0 0.0', '??-CB-CN-??': '0.0 6.0 0.0 0.0', '??-NA-CN-??': '0.0 3.05 0.0 0.0', 'CW-CW-N -C': '0.0 3.0 0.0 0.0', 'NC-CA-NT-H': '0.000 3.80 0.0 0.0', 'N?-CA-NT-H': '0.000 3.80 0.0 0.0', 'N?-CA-N2-H': '0.000 3.80 0.0 0.0', 'HC-CT-C -OS': '0.000 0.000 0.1320 0.0', 'CT-C -OS-CT': '4.669 5.124 0.0000 0.0', 'OS-C -OS-CT': '4.669 5.124 0.0000 0.0', 'HC-C -OS-CT': '4.669 5.124 0.0000 0.0', 'O -C -OS-CT': '0.000 5.000 0.00 0.0', 'C -OS-CT-HC': '0.000 0.000 0.1980 0.0', 'CT-CT-C -OS': '0.000 0.000 -0.5530 0.0', 'CT-CT-OS-C': '-1.220 -0.126 0.4220 0.0', 'CA-CT-CT-N3': '1.000 0.0 0.0 0.0', 'CA-CT-CT-NT': '-0.800 0.0 0.0 0.0', 'CT-CT-NO-ON': '0.0 0.40 0.0 0.0', 'CA-CA-NO-ON': '0.0 1.15 0.0 0.0', 'N2-CA-CA-CA': '0.000 1.620 0.000 -0.44', 'CT-NY-CA-NC': '0.000 3.651 0.000 0.0', 'CT-NT-CT-CT': '0.416 -0.128 0.695 0.0', 'NT-CT-CT-NT': '11.035 -0.968 0.270 0.0', 'HC-CT-NT-CT': '0.0 0.0 0.56 0.0', 'HC-CT-NT-CA': '0.0 0.0 0.56 0.0', 'CT-CT-CW-NA': '1.244 0.000 0.167 0.0', 'CT-C=-C=-CM': '0.900 0.230 -0.505 0.0', 'CT-C=-C -O?': '0.900 0.230 -0.505 0.0', 'CT-CM-C -O?': '0.900 0.230 -0.505 0.0', 'CT-C -C=-CM': '0.8 -3.0 0.0 0.0', 'CM-C=-C -OH': '3.2 -3.0 0.0 0.0', 'CM-CM-C -OH': '3.2 -3.0 0.0 0.0', 'C#-C#-C -OH': '3.2 -3.0 0.0 0.0', 'CM-C=-C -O': '2.5 6.0 0.0 0.0', 'CM-CM-C -O': '2.5 6.0 0.0 0.0', 'C#-C#-C -O': '2.5 6.0 0.0 0.0', 'CA-CA-C -CT': '0.0 0.2 0.0 0.0', 'CA-CA-C -HC': '0.0 0.2 0.0 0.0', 'CA-CA-N -??': '0.0 2.100 0.0 0.0', 'CA-CA-N -H': '0.0 2.100 0.0 0.0', 'CA-CA-N -C': '0.0 2.100 0.0 0.0', 'CA-CA-N -CT': '0.0 2.100 0.0 0.0', 'CA-CA-N -CR': '0.0 2.100 0.0 0.0', 'CA-CA-N -CW': '0.0 2.100 0.0 0.0', 'CA-CA-NT-CR': '0.0 2.100 0.0 0.0', 'CA-CA-NT-CW': '0.0 2.100 0.0 0.0', 'SA-CR-N -CA': '0.0 2.100 0.0 0.0', 'SA-CR-NT-CA': '0.0 2.100 0.0 0.0', 'NB-CR-N -CA': '0.0 2.100 0.0 0.0', 'NB-CR-NT-CA': '0.0 2.100 0.0 0.0', 'NB-CR-N3-CA': '0.0 2.100 0.0 0.0', 'SA-CR-N -H': '0.0 2.133 0.0 0.0', 'SA-CR-NT-H': '0.0 2.100 0.0 0.0', 'NB-CR-N -H': '0.0 2.100 0.0 0.0', 'NB-CR-N -CT': '0.0 2.100 0.0 0.0', 'NB-CR-N3-CT': '0.0 2.100 0.0 0.0', 'NB-CR-NT-H': '0.0 2.100 0.0 0.0', 'OA-CR-N -CA': '0.0 2.100 0.0 0.0', 'OA-CR-N -H': '0.0 2.133 0.0 0.0', 'OA-CW-N -CA': '0.0 2.100 0.0 0.0', 'OA-CW-N -H': '0.0 2.100 0.0 0.0', 'SA-CW-N -CA': '0.0 2.100 0.0 0.0', 'SA-CW-N -H': '0.0 2.100 0.0 0.0', 'CA-CA-N -CQ': '0.0 2.100 0.0 0.0', 'CA-CA-NT-CQ': '0.0 2.100 0.0 0.0', 'CA-CA-C -O': '0.0 2.100 0.0 0.0', 'CA-CA-C -OS': '0.0 2.100 0.0 0.0', 'CA-CA-C -OH': '0.0 2.100 0.0 0.0', 'CS-CS-C -O': '0.0 2.100 0.0 0.0', 'CW-CS-C -O': '0.0 2.100 0.0 0.0', 'CS-CS-C -S=': '0.0 2.100 0.0 0.0', 'CW-CS-C -S=': '0.0 2.100 0.0 0.0', 'CA-CA-OS-C': '0.0 2.500 0.0 0.0', 'CA-C -OH-HO': '4.000 5.000 0.00 0.0', 'CA-C -OS-CT': '4.000 5.000 0.00 0.0', 'O -C -OS-CA': '0.000 5.000 0.000 0.0', 'CT-C -OS-CA': '1.500 5.000 0.000 0.0', 'CA-CA-C -N': '0.000 1.100 0.0 0.0', 'CS-CS-C -N': '0.000 1.100 0.0 0.0', 'CW-CS-C -N': '0.000 1.100 0.0 0.0', 'CA-CA-NT-H': '0.0 2.133 0.0 0.0', 'CA-CA-N2-H': '0.0 2.133 0.0 0.0', 'CS-CW-NT-H': '0.0 2.133 0.0 0.0', '??-CA-N2-H': '0.0 2.133 0.0 0.0', '??-CQ-N2-H': '0.0 2.133 0.0 0.0', 'CB-CA-N2-H': '0.0 2.133 0.0 0.0', 'CA-CA-NT-CT': '0.0 3.880 0.0 0.15', 'CS-CW-NT-CT': '0.0 3.880 0.0 0.15', 'CT-CM-CT-CT': '2.817 -0.169 0.543 0.0', 'CM-CM-CT-CT': '0.346 0.405 -0.904 0.0', 'C#-C#-CT-CT': '0.346 0.405 -0.904 0.0', 'C=-CM-CT-CT': '0.346 0.405 -0.904 0.0', 'C=-C=-CT-CT': '0.346 0.405 -0.904 0.0', 'CM-CM-CA-CA': '0.0 3.431 0.0 0.0', 'CM-C=-CA-CA': '0.0 3.431 0.0 0.0', 'CM-CM-CW-CS': '0.0 3.431 0.0 0.0', 'C#-C#-CA-CA': '1.241 3.353 -0.286 0.0', 'CT-CM-CA-CA': '0.205 -0.531 0.000 0.0', 'CT-C#-CA-CA': '0.205 -0.531 0.000 0.0', 'Z -CM-X -Y': '0.0 30.0 0.0 0.0', '??-CM-CM-??': '0.0 14.0 0.0 0.0', '??-C#-C#-??': '0.0 14.0 0.0 0.0', 'CT-CM-CM-CT': '0.0 14.0 0.0 0.0', 'CT-CM-C=-CT': '0.0 14.0 0.0 0.0', 'CT-CM-C=-HC': '0.0 14.0 0.0 0.0', 'HC-CM-C=-HC': '0.0 14.0 0.0 0.0', 'HC-CM-C=-CT': '0.0 14.0 0.0 0.0', 'CT-CM-CM-HC': '0.0 14.0 0.0 0.0', 'CA-CM-CM-HC': '0.0 14.0 0.0 0.0', 'CA-C=-CM-HC': '0.0 14.0 0.0 0.0', 'CA-C=-CM-CT': '0.0 14.0 0.0 0.0', 'C -CM-CM-HC': '0.0 14.0 0.0 0.0', 'HC-CM-CM-HC': '0.0 14.0 0.0 0.0', 'HC-CM-C=-C=': '0.0 14.0 0.0 0.0', 'CT-CM-C=-C=': '0.0 14.0 0.0 0.0', 'HC-C#-C#-HC': '0.0 14.0 0.0 0.0', 'HC-C#-C#-CT': '0.0 14.0 0.0 0.0', 'CT-C#-C#-CT': '0.0 14.0 0.0 0.0', 'C=-C#-C#-C=': '0.0 14.0 0.0 0.0', 'C#-C#-C#-C=': '0.0 14.0 0.0 0.0', 'C#-C#-C#-CA': '0.0 14.0 0.0 0.0', 'C#-C#-C#-CT': '0.0 14.0 0.0 0.0', 'C#-C#-C#-HC': '0.0 14.0 0.0 0.0', 'HC-C#-C#-C=': '0.0 14.0 0.0 0.0', 'CT-C#-C#-C=': '0.0 14.0 0.0 0.0', 'CA-C#-C#-HC': '0.0 14.0 0.0 0.0', 'CA-C#-C#-CT': '0.0 14.0 0.0 0.0', 'CA-C#-C#-C=': '0.0 14.0 0.0 0.0', 'CA-C#-C#-CA': '0.0 14.0 0.0 0.0', 'C#-C=-CM-HC': '0.0 14.0 0.0 0.0', 'C#-C=-CM-CT': '0.0 14.0 0.0 0.0', 'CZ-CM-CM-HC': '0.0 14.0 0.0 0.0', 'CZ-CM-CM-CT': '0.0 14.0 0.0 0.0', 'CZ-CM-CM-C?': '0.0 14.0 0.0 0.0', 'Cl-CM-CM-HC': '0.0 14.0 0.0 0.0', 'HC-CM-CM-OS': '0.0 14.0 0.0 0.0', 'CT-CM-CM-OS': '0.0 14.0 0.0 0.0', 'HC-CM-CM-OH': '0.0 14.0 0.0 0.0', 'CT-CM-CM-OH': '0.0 14.0 0.0 0.0', 'C -CM-CM-N': '0.0 14.0 0.0 0.0', 'C -C=-CM-N': '0.0 14.0 0.0 0.0', 'CT-C -NC-CT': '0.0 14.0 0.0 0.0', 'HC-C -NC-H': '0.0 14.0 0.0 0.0', 'N -C -NC-H': '0.0 14.0 0.0 0.0', 'N -C -NC-CT': '0.0 14.0 0.0 0.0', 'N -C -NC-CA': '0.0 14.0 0.0 0.0', 'N -C -NC-CZ': '0.0 14.0 0.0 0.0', 'CT-C -NC-O?': '0.0 14.0 0.0 0.0', 'HC-C -NC-O?': '0.0 14.0 0.0 0.0', 'CA-C!-C -CA': '0.0 2.17 0.0 0.0', 'CA-C!-NA-NB': '0.0 2.17 0.0 0.0', 'CA-C!-NA-CW': '0.0 2.17 0.0 0.0', 'CA-C!-CW-C?': '0.0 2.17 0.0 0.0', 'CA-C!-CW-NA': '0.0 2.0 0.0 0.0', 'CA-C!-CS-C?': '0.0 2.17 0.0 0.0', 'CA-C!-CM-C?': '0.0 2.17 0.0 0.0', 'CA-C!-CU-C?': '0.0 2.17 0.0 0.0', 'CA-C!-CU-NB': '0.0 2.17 0.0 0.0', 'CA-C!-CV-C?': '0.0 2.17 0.0 0.0', 'CA-C!-CV-NB': '0.0 1.59 0.0 0.0', 'CA-C!-CR-OA': '0.0 2.17 0.0 0.0', 'CA-C!-CW-SA': '0.0 2.17 0.0 0.0', 'CA-C!-CR-SA': '0.0 2.17 0.0 0.0', 'CA-C!-N -C': '0.0 1.76 0.0 0.23', 'CA-C!-N -CM': '0.0 2.17 0.0 0.0', 'NC-C!-N -C': '0.0 2.17 0.0 0.0', 'NC-C!-N -CM': '0.0 2.17 0.0 0.0', 'CS-CS-CS-N?': '0.0 2.17 0.0 0.0', 'OS-CS-CS-C?': '0.0 2.17 0.0 0.0', 'OS-CS-CS-N?': '0.0 2.17 0.0 0.0', 'NA-CS-CS-C?': '0.0 2.17 0.0 0.0', 'NA-CS-CS-N?': '0.0 2.17 0.0 0.0', 'CW-CV-CS-C?': '0.0 2.17 0.0 0.0', 'CW-CV-CS-N?': '0.0 2.17 0.0 0.0', 'NB-CV-CS-C?': '0.0 2.17 0.0 0.0', 'NB-CV-CS-N?': '0.0 2.17 0.0 0.0', 'N?-CR-CS-C?': '0.0 2.17 0.0 0.0', 'N?-CR-CW-C?': '0.0 2.17 0.0 0.0', '??-N -CU-??': '0.0 2.17 0.0 0.0', '??-N -CW-??': '0.0 2.17 0.0 0.0', '??-N -CS-??': '0.0 2.17 0.0 0.0', '??-CM-CU-??': '0.0 2.17 0.0 0.0', '??-CM-CW-??': '0.0 2.17 0.0 0.0', '??-CM-CS-??': '0.0 2.17 0.0 0.0', 'NC-C!-CU-C?': '0.0 2.17 0.0 0.0', 'NC-C!-CU-N?': '0.0 2.17 0.0 0.0', 'CA-C!-CU-N?': '0.0 2.17 0.0 0.0', 'Cl-CM-CM-Cl': '-1.6 14.0 0.0 0.0', 'HC-CT-P+-CT': '0.000 0.000 0.300 0.0', 'HC-CT-CT-P+': '0.000 0.000 0.300 0.0', 'CT-CT-P+-CT': '1.000 -0.500 0.500 0.0', 'CK-N*-CT-OS': '-1.50 -1.50 0.0 0.0', 'CK-NA-CT-CT': '-1.00 -0.35 0.0 0.0', 'CM-CM-CA-NC': '0.797 4.193 -0.564 -0.282', 'CM-C=-CA-NC': '0.797 4.193 -0.564 -0.282', 'C -NC-OH-HO': '3.0 3.0 0.0 0.0', 'C -NC-OS-CT': '3.0 3.0 0.0 0.0', 'CM-CM-OS-CT': '-3.5 3.0 0.0 0.0', 'C=-CM-OS-CT': '-3.5 3.0 0.0 0.0', 'CM-CM-CT-F': '0.500 0.0 0.0 0.0', 'CM-CM-CT-O?': '0.500 0.0 0.0 0.0', 'C=-CM-CT-O?': '0.500 0.0 0.0 0.0', 'CM-C=-CT-O?': '0.500 0.0 0.0 0.0', 'CM-CT-OH-HO': '-0.9 0.0 0.0 0.0', 'CA-CT-OH-HO': '-0.9 0.0 0.0 0.0', 'C=-CT-OH-HO': '-0.9 0.0 0.0 0.0', 'HC-CT-SY-OY': '0.0000 0.0000 0.3500 0.0', 'HC-CT-SY-OH': '0.0000 0.0000 0.3500 0.0', 'HC-CT-SY-CT': '0.0000 0.0000 0.3500 0.0', 'HC-CT-SY-CA': '0.0000 0.0000 0.3500 0.0', 'CT-CT-SY-CT': '0.0 0.0 0.0 0.0', 'CT-CT-SY-OY': '0.0 0.0 0.0 0.0', '??-CT-CZ-NZ': '0.0 0.0 0.0 0.0', '??-CA-CZ-NZ': '0.0 0.0 0.0 0.0', '??-C#-CZ-NZ': '0.0 0.0 0.0 0.0', '??-CT-NZ-CZ': '0.0 0.0 0.0 0.0', 'HC-CT-NZ-CZ': '0.0 0.0 0.0 0.0', '??-CA-NZ-CZ': '0.0 0.0 0.0 0.0', 'CA-CA-NZ-CZ': '0.0 0.0 0.0 0.0', '??-CZ-CZ-??': '0.0 0.0 0.0 0.0', '??-CT-CZ-CZ': '0.0 0.0 0.0 0.0', 'CT-CT-CZ-CZ': '0.0 0.0 0.0 0.0', 'HC-CT-CZ-CZ': '0.0 0.0 0.0 0.0', 'HC-CZ-CZ-CT': '0.0 0.0 0.0 0.0', 'CT-CZ-CZ-CT': '0.0 0.0 0.0 0.0', 'CM-CZ-CZ-HC': '0.0 0.0 0.0 0.0', 'CM-CM-CZ-CZ': '0.0 0.0 0.0 0.0', 'CT-CZ-CZ-CM': '0.0 0.0 0.0 0.0', 'CT-CZ-CZ-C#': '0.0 0.0 0.0 0.0', 'HC-CZ-CZ-C#': '0.0 0.0 0.0 0.0', 'CA-CA-SY-CT': '0.0 -0.9 0.0 0.0', 'CT-SY-OH-HO': '-0.75 0.0 0.0 0.0', 'OY-SY-OH-HO': '0.75 0.0 0.0 0.0', 'CA-SY-OH-HO': '2.0 0.0 0.0 0.0', 'NA-CW-CT-HC': '0.071 0.0 0.188 0.0', 'CR-NA-CT-OS': '-1.50 -1.50 0.0 0.0', 'CR-N*-CT-OS': '-1.50 -1.50 0.0 0.0', 'CK-NA-CT-OS': '-1.50 -1.50 0.0 0.0', 'C?-NA-CT-OS': '0.00 -1.876 0.0 0.0', 'C?-N*-CT-OS': '1.50 -1.50 0.0 0.0', 'CR-NA-CT-CT': '-1.00 -0.35 0.0 0.0', 'CR-N*-CT-CT': '-1.00 -0.35 0.0 0.0', 'CK-N*-CT-CT': '-1.00 -0.35 0.0 0.0', 'C?-NA-CT-CT': '0.00 -0.576 0.0 0.0', 'C?-N*-CT-CT': '1.00 -0.35 0.0 0.0', 'N?-CT-OS-CT': '-0.50 -1.50 1.0 0.0', 'NA-CW-CY-CY': '1.10 -2.2 0.3 0.0', '??-CY-CY-??': '0.0 0.0 0.0 0.0', '??-CY-N$-??': '0.0 0.0 0.0 0.0', '??-CY-C$-??': '0.0 0.0 0.0 0.0', 'CY-CY-C$-N$': '0.0 0.0 0.0 0.0', 'CY-CY-C$-O': '0.0 0.0 0.0 0.0', '??-CY-S -??': '0.0 0.0 0.0 0.0', 'CY-CY-N$-??': '0.0 0.0 0.0 0.0', 'HC-CY-N$-C?': '0.0 0.0 0.0 0.0', 'HC-CY-C$-O': '0.0 0.0 0.0 0.0', 'HC-CY-C$-SA': '0.0 0.0 0.0 0.0', 'HC-CY-C$-N$': '0.0 0.0 0.0 0.0', 'N -CY-CY-??': '0.0 0.0 0.0 0.0', 'CY-CY-N -H': '0.0 0.0 0.0 0.0', 'C$-CY-N -H': '0.0 0.0 0.0 0.0', 'HC-CY-N -C': '0.0 0.0 0.0 0.0', 'HC-CY-N -H': '0.0 0.0 0.0 0.0', 'C?-N$-CT-C?': '0.0 0.0 0.0 0.0', 'C?-N$-CT-HC': '0.0 0.0 0.0 0.0', 'CY-C$-N$-CT': '2.300 6.089 0.000 0.0', 'CY-C$-N$-CY': '2.300 6.089 0.000 0.0', 'CY-N -CT-CT': '2.300 6.089 0.000 0.0', 'CY-C$-N$-CA': '2.300 6.089 0.000 0.0', 'O -C$-N$-H': '0.000 4.900 0.000 0.0', 'CY-C$-N$-H': '0.000 4.900 0.000 0.0', 'O -C$-N$-CT': '0.000 6.089 0.000 0.0', 'O -C$-N$-CA': '0.000 6.089 0.000 0.0', 'O -C -N -CY': '0.000 6.089 0.000 0.0', 'C -N -CY-CY': '-0.71 2.1 -1.83 0.0', 'C -N -CY-C$': '-1.396 -0.427 0.000 0.0', 'O -C$-N$-CY': '0.000 20.000 0.000 0.0', 'HC-CY-CY-HC': '0.000 0.000 0.000 0.0', 'HC-CY-CY-CY': '0.000 0.000 0.000 0.0', 'CT-CY-CY-CY': '0.000 0.000 0.000 0.0', 'CA-CY-CY-CY': '0.000 0.000 0.000 0.0', 'CM-CY-CY-CY': '0.000 0.000 0.000 0.0', 'HC-CY-CY-CT': '0.000 0.000 0.000 0.0', 'HC-CY-CY-CA': '0.000 0.000 0.000 0.0', 'HC-CY-CY-CW': '0.000 0.000 0.000 0.0', 'HC-CY-CY-CM': '0.000 0.000 0.000 0.0', 'CT-CY-CY-CT': '0.000 0.000 0.000 0.0', 'CY-CY-CY-CY': '0.000 0.000 0.000 0.0', 'CA-CY-CY-CT': '0.000 0.000 0.000 0.0', 'CA-CY-CY-CM': '0.000 0.000 0.000 0.0', 'HC-CT-CY-CY': '0.000 0.000 0.300 0.0', 'HC-CT-CY-CT': '0.000 0.000 0.300 0.0', 'CM-CM-CW-NA': '-0.70 3.60 0.0 0.0', 'HO-OH-CW-NA': '0.0 -1.5 0.1 0.0', 'HC-CT-CM-CM': '0.0 0.0 -0.372 0.0', 'HC-CT-C#-C#': '0.0 0.0 -0.372 0.0', 'HC-CT-CM-C=': '0.0 0.0 -0.372 0.0', 'HC-CT-C=-C=': '0.0 0.0 -0.372 0.0', 'HC-CT-C=-CM': '0.0 0.0 -0.372 0.0', 'HC-CT-C=-C#': '0.0 0.0 -0.372 0.0', 'HC-CM-CT-HC': '0.000 0.000 0.318 0.0', 'HC-C#-CT-HC': '0.000 0.000 0.318 0.0', 'HC-CT-CT-CM': '0.000 0.000 0.366 0.0', 'HC-CT-CT-C#': '0.000 0.000 0.366 0.0', 'HC-CT-CT-CZ': '0.000 0.000 0.366 0.0', 'CT-CT-CT-CZ': '0.000 -0.650 0.0 0.0', 'HC-CT-CM-CT': '0.0 0.0 0.300 0.0', 'HC-CT-C#-CT': '0.0 0.0 0.300 0.0', 'HC-CT-CM-C:': '0.0 0.0 -0.250 0.0', 'CM-HC-CM-HC': '0.0 -8.0 0.0 0.0', 'CM-HC-CM-CT': '0.0 -8.0 0.0 0.0', 'CM-CT-CM-HC': '0.0 -8.0 0.0 0.0', 'CM-CT-CM-CT': '0.0 -8.0 0.0 0.0', 'HC-CM-C:-CM': '0.0 0.0 0.0 0.0', 'CT-CM-C:-CM': '0.0 0.0 0.0 0.0', 'CY-CY-CA-CA': '0.0 1.9 0.0 0.0', 'CY-CY-CW-CS': '0.0 1.9 0.0 0.0', 'CT-OS-CW-NA': '1.165 0.285 0.0 0.0', 'HS-SH-CW-NA': '-0.95 -4.1 0.0 0.0', 'NA-CW-NT-CT': '1.75 -1.12 0.0 0.74', 'NA-CW-NT-H': '0.0 -2.24 0.0 0.0', 'OA-CW-CT-CT': '0.14 -0.09 0.54 0.0', 'CY-CY-CW-OA': '-0.129 -0.71 2.18 0.0', 'CM-CM-CW-OA': '0.0 3.2 -1.3 0.0', 'OA-CW-OH-HO': '1.3 -1.0 0.33 0.0', 'OA-CW-OS-CT': '1.5 -0.574 1.3 0.0', 'HS-SH-CW-OA': '0.59 -2.50 0.46 0.0', 'NB-CR-C -O': '0.000 1.000 0.000 0.0', 'NA-CR-C -O': '2.000 1.000 0.000 0.0', 'NB-CR-C -CR': '0.000 1.000 0.000 0.0', 'NA-CR-C -CR': '-2.000 1.000 0.000 0.0', 'OA-CW-C -O': '-0.750 1.500 0.000 0.0', 'OA-CW-C -CW': '0.000 1.500 0.000 0.0', 'CS-CW-C -O': '0.750 1.500 0.000 0.0', 'CS-CW-C -CW': '0.000 1.500 0.000 0.0', 'OA-CW-S -CT': '1.2 -2.84 1.2 0.0', 'H -NT-CW-OA': '0.0 -1.57 0.0 0.0', 'CY-CY-CA-NC': '-0.7 4.30 1.1 0.0', 'CT-NT-OS-CT': '0.0 0.0 0.3 0.0', 'CT-NT-OH-HO': '0.0 0.0 0.3 0.0', 'H -NT-OS-CT': '0.0 0.0 0.3 0.0', 'H -NT-OH-HO': '0.0 0.0 0.3 0.0', 'CT-NT-NT-CT': '0.0 0.0 0.3 0.0', 'CT-NT-NT-H': '0.0 0.0 0.3 0.0', 'H -NT-NT-H': '0.0 0.0 0.3 0.0', 'OS-C -N -CT': '2.300 6.089 0.0 0.0', 'OH-C -N -CT': '2.300 6.089 0.0 0.0', 'OS-C -N -H': '0.000 4.900 0.0 0.0', 'OH-C -N -H': '0.000 4.900 0.0 0.0', 'N -C -OS-CT': '-2.000 5.000 0.0 0.0', 'N -C -OH-HO': '-2.000 5.000 0.0 0.0', 'HC-NC-NZ-NZ': '0.0 0.0 0.0 0.0', 'CT-NC-NZ-NZ': '0.0 0.0 0.0 0.0', 'CT-CT-NC-NZ': '0.0 0.0 0.0 0.0', 'HC-CT-C -S=': '0.0 0.0 0.0 0.0', 'S=-C -N -H': '-0.700 5.000 0.000 0.0', 'S=-C -N -CT': '0.000 6.500 0.000 0.0', 'S=-C -N -CA': '0.000 6.500 0.000 0.0', 'S=-C -N -CM': '0.000 6.500 0.000 0.0', 'S=-C -OS-CT': '0.000 5.000 0.000 0.0', 'S=-C -OH-HO': '0.000 5.500 0.00 0.0', 'CT-S -CA-CA': '0.000 2.151 0.000 0.295', 'CT-S -CW-CS': '0.000 2.660 0.000 0.326', 'C -N=-C=-CM': '0.000 1.300 2.200 0.0', 'N -C -N -CT': '4.6 0.0 0.0 0.0', 'OA-CW-NT-CT': '0.0 -1.40 1.30 0.47', 'SA-CP-CT-HC': '0.97 0.08 0.14 0.0', 'SA-CP-CT-CT': '0.0 0.26 0.1 0.0', 'O -C -C -CT': '0.000 0.500 0.000 0.0', 'O -C -C -HC': '0.000 0.200 0.000 0.0', 'HC-C -C -CT': '0.800 -0.760 0.000 0.0', 'CT-C -C -CT': '0.700 -1.500 0.000 0.0', 'C -C -CT-HC': '0.000 0.000 0.085 0.0', 'N -C -C -O': '0.000 0.000 0.000 0.0', 'N -C -C -HC': '-0.900 0.300 0.000 0.0', 'N -C -C -CT': '-0.500 0.200 0.000 0.0', 'C -C -N -CT': '0.400 4.900 0.000 0.0', 'H -N -C -C': '0.000 4.900 0.000 0.0', 'O -C -C -O': '1.60 3.20 0.0 0.0', 'SA-CP-CY-CY': '0.0 -1.04 0.0 0.23', 'SA-CP-CY-HC': '1.19 0.0 0.40 0.0', 'CM-CM-CP-SA': '-2.0 4.2 -0.35 0.0', 'HO-OH-CP-SA': '2.63 -1.0 0.34 0.0', 'CT-OS-CP-SA': '0.61 0.0 0.5 0.0', 'HS-SH-CP-SA': '0.79 -3.58 0.3 0.0', 'CT-S -CP-SA': '0.33 -2.30 0.275 0.0', 'H -NT-CP-SA': '0.0 -1.19 0.0 0.0', 'CT-NT-CP-SA': '-1.10 0.12 0.0 0.6', 'CT-C -N -OH': '4.542 6.603 1.045 0.0', 'O -C -N -OH': '0.000 6.603 0.000 0.0', 'C -N -OH-HO': '5.519 -6.700 0.581 0.0', 'H -N -OH-HO': '2.722 -5.154 0.000 0.0', 'HC-CT-CW-OA': '0.0 0.0 0.340 0.0', 'F -CT-CA-CA': '0.000 0.450 0.000 0.0', 'F -CT-CW-??': '0.000 0.450 0.000 0.0', 'F -CT-CS-??': '0.000 0.450 0.000 0.0', 'Cl-CT-CA-CA': '0.000 -0.400 0.000 0.0', 'Cl-CT-CW-??': '0.000 -0.400 0.000 0.0', 'Cl-CT-CS-??': '0.000 -0.400 0.000 0.0', 'Cl-CT-C -O': '-0.650 0.000 0.000 0.0', 'Cl-CT-C -N': '0.650 0.000 0.000 0.0', 'C -CT-CT-CA': '-1.406 1.777 0.000 0.0', 'H -Si-Si-H': '0.000 0.000 0.140 0.0', 'CT-Si-Si-H': '0.000 0.000 0.100 0.0', 'CT-Si-Si-CT': '1.000 -0.200 0.000 0.0', 'HC-CT-Si-Si': '0.000 0.000 0.140 0.0', 'HC-CT-Si-H': '0.000 0.000 0.180 0.0', 'CT-CT-Si-H': '0.000 0.000 0.260 0.0', 'CA-CA-Si-H': '0.000 0.000 0.260 0.0', 'CT-Si-CT-HC': '0.000 0.000 0.180 0.0', 'Si-CT-CT-HC': '0.000 0.000 0.260 0.0', 'CT-CT-CT-Si': '0.400 0.000 0.200 0.0', 'CT-CT-Si-CT': '0.800 0.000 0.200 0.0', 'Si-CT-CT-Si': '5.200 -0.500 0.000 0.0', 'H -Si-OH-HO': '0.000 0.000 0.180 0.0', 'H -Si-OS-CT': '0.000 0.000 0.180 0.0', 'CT-Si-OH-HO': '0.000 0.000 0.180 0.0', 'CT-Si-OS-CT': '1.000 0.000 0.000 0.0', 'HC-CT-Si-OH': '0.000 0.000 0.180 0.0', 'HC-CT-Si-OS': '0.000 0.000 0.180 0.0', 'HC-CT-OS-Si': '0.000 0.000 0.180 0.0', 'OS-Si-OS-Si': '0.000 0.000 0.000 0.0', 'Si-OS-Si-CT': '0.000 0.000 0.000 0.0', 'CT-OS-CA-NC': '0.0 4.7 0.0 0.0', 'CT-S -CA-NC': '1.51 4.0 0.7 0.0', 'CT-CT-CA-NC': '0.0 0.0 0.418 0.183', 'CT-OS-CQ-NC': '0.0 5.2 0.0 0.0', 'CT-S -CQ-NC': '0.0 4.8 0.0 0.0', 'CT-CT-CQ-NC': '0.0 0.5 -0.5 0.0', 'CT-S -CW-NA': '0.556 -3.865 0.0 0.0', 'C -CT-CT-C*': '-0.506 0.975 0.000 0.0', 'N -CT-CT-CV': '-0.542 0.435 0.000 0.0', 'N -CT-CT-CW': '-0.542 0.435 0.000 0.0', 'C -CT-CT-CV': '-1.282 1.645 -0.017 0.0', 'C -CT-CT-CW': '-1.282 1.645 -0.017 0.0', 'N -CT-CT-CX': '-3.038 0.419 0.000 0.0', 'C -CT-CT-CX': '-1.708 1.516 -0.502 0.0', 'CT-CT-C -O2': '0.000 1.000 1.350 0.0', 'C3-C2-OS-C2': '-7.4 3.0 1.8 0.0', 'C3-C2-OS-C3': '-8.4 3.0 1.8 0.0', 'C2-C2-C2-C2': '-3.400 1.250 3.100 0.0', 'C3-C2-C2-C2': '-3.400 1.250 3.100 0.0', 'C3-C2-C2-C3': '-3.400 1.250 3.100 0.0', 'CH-C2-C2-C2': '-3.400 1.250 3.100 0.0', 'CH-C2-C2-CH': '-3.400 1.250 3.100 0.0', 'CT-C2-C2-C2': '-3.400 1.250 3.100 0.0', 'C2-CH-C2-C2': '-3.400 1.250 3.100 0.0', 'C2-CT-C2-C2': '-3.400 1.250 3.100 0.0', 'C3-C2-OH-HO': '0.300 0.000 1.300 0.0', 'C2-C2-OH-HO': '0.300 0.000 1.300 0.0', 'CH-C2-OH-HO': '0.300 0.000 1.300 0.0', 'C3-CH-OH-HO': '0.300 0.000 0.500 0.0', 'C2-CH-OH-HO': '0.300 0.000 0.500 0.0', 'C3-CT-OH-HO': '0.0 0.0 0.200 0.0', 'C2-CT-OH-HO': '0.0 0.0 0.200 0.0', 'C2-C2-C2-O?': '-2.500 1.250 3.100 0.0', 'C3-C2-C2-O?': '-2.500 1.250 3.100 0.0', 'C2-CH-C2-O?': '-2.500 1.250 3.100 0.0', 'C2-C2-C2-Br': '-2.000 0.500 3.250 0.0', 'C3-C2-C2-Br': '-2.000 0.500 3.250 0.0', 'C2-C2-C2-F': '-2.000 0.700 3.000 0.0', 'C3-C2-C2-F': '-2.000 0.700 3.000 0.0', 'CW-CU-C!-CA': '-0.400 -0.300 0.500 0.0', 'CA-C!-C!-CA': '0.0 1.65 0.0 -0.05', 'CA-C!-C!-NC': '0.0 2.01 0.0 0.0', 'C=-C!-C!-NC': '0.0 2.01 0.0 0.0', 'C#-C!-C!-NC': '0.0 2.01 0.0 0.0', 'NC-C!-C!-NC': '0.0 1.11 0.0 -0.13', 'CA-C!-CS-CW': '0.0 1.49 0.0 0.0', 'CA-C!-CW-CS': '0.0 1.49 0.0 0.0', 'CA-C!-CP-CS': '0.0 1.49 0.0 0.0', 'CA-C!-CS-CP': '0.0 1.49 0.0 0.0', 'CA-C!-CS-CS': '0.0 1.49 0.0 0.0', 'C=-C!-CS-CS': '0.0 1.49 0.0 0.0', 'C=-C!-CS-CW': '0.0 1.49 0.0 0.0', 'C=-C!-CW-CS': '0.0 1.49 0.0 0.0', 'C=-C!-CS-CP': '0.0 1.49 0.0 0.0', 'C=-C!-CP-CS': '0.0 1.49 0.0 0.0', 'C#-C!-CS-CS': '0.0 1.49 0.0 0.0', 'C#-C!-CS-CW': '0.0 1.49 0.0 0.0', 'C#-C!-CW-CS': '0.0 1.49 0.0 0.0', 'C#-C!-CS-CP': '0.0 1.49 0.0 0.0', 'C#-C!-CP-CS': '0.0 1.49 0.0 0.0', 'CA-C!-CW-OS': '0.0 1.73 0.0 0.0', 'C=-C!-CW-OS': '0.0 1.73 0.0 0.0', 'C#-C!-CW-OS': '0.0 1.73 0.0 0.0', 'CA-C!-CP-S': '0.0 1.33 0.0 0.0', 'C=-C!-CP-S': '0.0 1.33 0.0 0.0', 'C#-C!-CP-S': '0.0 1.33 0.0 0.0', 'CA-C!-CR-NA': '0.0 2.0 0.0 0.0', 'C=-C!-CW-NA': '0.0 2.0 0.0 0.0', 'C=-C!-CR-NA': '0.0 2.0 0.0 0.0', 'C#-C!-CW-NA': '0.0 2.0 0.0 0.0', 'C#-C!-CR-NA': '0.0 2.0 0.0 0.0', 'CA-C!-CW-NS': '0.0 3.01 0.0 0.22', 'C=-C!-CW-NS': '0.0 3.01 0.0 0.22', 'C#-C!-CW-NS': '0.0 3.01 0.0 0.22', 'CA-C!-CR-NB': '0.0 1.59 0.0 0.0', 'C=-C!-CR-NB': '0.0 1.59 0.0 0.0', 'C#-C!-CR-NB': '0.0 1.59 0.0 0.0', 'CA-C!-NX-CW': '0.0 1.47 0.0 -0.07', 'C=-C!-NX-CW': '0.0 1.47 0.0 -0.07', 'C#-C!-NX-CW': '0.0 1.47 0.0 -0.07', 'CA-C!-NX-NB': '0.0 1.76 0.0 0.0', 'NC-C!-CS-CS': '0.0 1.95 0.0 0.0', 'NC-C!-CS-CW': '0.0 1.95 0.0 0.0', 'NC-C!-CW-CS': '0.0 1.95 0.0 0.0', 'NC-C!-CS-CP': '0.0 1.95 0.0 0.0', 'NC-C!-CP-CS': '0.0 1.95 0.0 0.0', 'NC-C!-CW-OS': '0.0 2.29 0.0 0.0', 'NC-C!-CP-S': '0.0 2.65 0.0 0.0', 'NC-C!-CW-NA': '0.0 3.33 0.0 0.0', 'NC-C!-CR-NA': '0.0 3.33 0.0 0.0', 'NC-C!-CR-NB': '0.0 1.03 0.0 0.0', 'NC-C!-CV-NB': '0.0 1.03 0.0 0.0', 'NC-C!-CW-NS': '0.0 3.7 0.0 0.0', 'NC-C!-NX-CW': '0.0 2.49 0.0 0.0', 'NC-C!-C!-NA': '0.0 2.84 0.0 0.0', 'CA-C!-C!-NA': '0.0 1.6 0.0 -0.18', 'CW-NX-C!-NA': '0.0 1.28 0.65 -0.23', 'CS-CS-C!-NA': '2.75 1.21 1.09 0.0', 'CS-CW-C!-NA': '2.75 1.21 1.09 0.0', 'OS-CW-C!-NA': '2.8 2.1 1.3 0.0', 'NA-C!-CW-NA': '7.33 2.18 0.51 0.0', 'NA-C!-CR-NA': '7.33 2.18 0.51 0.0', 'NA-C!-CW-NS': '6.25 1.78 1.43 0.0', 'NA-C!-CR-NB': '4.0 2.13 1.6 0.0', 'NA-C!-CP-S': '0.63 0.8 1.54 -0.74', 'H -N2-CR-NA': '0.0 1.87 0.00 -0.18', 'CW-CS-C!-NA': '1.5 1.5 0.87 0.0', 'NA-C!-CS-CP': '2.91 1.83 1.21 0.0', 'NA-C!-CP-CS': '2.91 1.83 1.21 0.0', 'CA-OS-CA-CA': '3.25 2.16 1.28 0.36', 'NC-CA-OS-CA': '-3.76 5.03 0.61 0.46', 'NE-CT-CT-CT': '4.64 -1.27 0.45 0.08', 'NC-CA-NT-CT': '-0.92 5.10 0.0 0.0', 'CA-CA-CT-N': '0.0 1.1 2.59 0.47', 'OS-CW-CT-C': '0.34 -0.27 0.63 0.0', 'CS-CW-CT-C': '0.08 -0.16 -0.33 0.43', 'CR-NA-CT-C': '3.42 0.2 -2.51 0.0', 'CW-NA-CT-C': '1.82 -0.78 -1.92 0.0'}

def GetParmsFromBOSS(BOSSdir,block):
    os.environ["BOSSdir"] = BOSSdir
    mol_init=Chem.MolFromPDBBlock(pdb_block(block), removeHs=False)
    with open("block_init.mol","w") as f:
        print(Chem.MolToMolBlock(block.to_rdkit_mol()),file=f)
    BashCall("$BOSSdir/scripts/xMOLZ block_init 2>>log")
    # read out file
    try:
        with open("out", 'r') as f:
            out = f.read()
    except IOError:
        print("No \"out\" file after BOSS calculation!!")
    mol_opt = Chem.MolFromPDBFile("plt.pdb", removeHs=False)
    BashCall("rm -f AM1tmp block_init.z optzmat slvzmat sum block_init.mol plt.pdb out log")
    assert mol_init.HasSubstructMatch(mol_opt),\
        print("This block may have very terrible initial conformation that the pdb from BOSS cannot map!!!")
    opt_id_to_init_id = mol_init.GetSubstructMatch(mol_opt)
    if type(opt_id_to_init_id[0]) == type(tuple()):
        opt_id_to_init_id = opt_id_to_init_id[0]

    # BOSS 中的电荷, pair, 以及添加参数表里的参数
    opls_atom = re.search("OPLS Force Field Parameters(.+)Net Charge", out, re.S)
    opls_type_charge_pair_str = opls_atom.group(1).split("\n")[4:-2]
    opls_type_charge_pair_dict = {opt_id_to_init_id[j]: [i.split()[0], i.split()[2], i.split()[3], i.split()[4]]
                                  for j, i in enumerate(opls_type_charge_pair_str)}
    # get bond coe
    opls_bond_str = re.search("Bond Stretching Parameters(.+)Angle Bending Parameters", out, re.S).group(
        1).split("\n")[2:-2]
    opls_bond_dict = dict()
    for i in opls_bond_str:
        last = i[97:].strip()
        if len(last) in [4, 5]:
            tmp = i.split()
            opls_bond_dict[last] = [tmp[2], tmp[3]]  # r k
    # print(opls_bond_dict)
    # get angle coe
    opls_angle_str = re.search("Angle Bending Parameters(.+)Dipole Moment", out, re.S).group(1).split("\n")[
                     2:-2]
    opls_angle_dict = dict()
    for i in opls_angle_str:
        last = i[81:].strip()
        if len(last) in [7, 8]:
            tmp = i.split()
            opls_angle_dict[last] = [tmp[3], tmp[4]]  # theta k
    # print(opls_angle_dict)
    # dihedral coe
    dihedral_replace_list = re.findall(r"For (.+) Using (.+) Type:", out)
    dihedral_replace_list2 = [[j.strip() for j in i] for i in dihedral_replace_list]
    for i in dihedral_replace_list2:
        if i[0] not in opls_dihedral_dict:
            opls_dihedral_dict[i[0]] = opls_dihedral_dict[i[1]]
    ## addition information
    # lack angle coe
    miss_ang = re.findall("Missing Angle Bend Parameters.+Type:(.+) Seeking Synonym", out)
    for i in miss_ang:
        print("Missing Angle ", i, " parameters, use estimated value in Boss!")
    return [opls_type_charge_pair_dict, opls_bond_dict, opls_angle_dict, opls_dihedral_dict]
