# ПРИМЕР ПОЛУЧЕНИЯ НАСТРОЕК МОДУЛЯ:
                                              #
from pyiArduinoI2Ctds import *                #   Подключаем библиотеку для работы с TDS/EC-метром I2C-flash.
tds = pyiArduinoI2Ctds(0x09)                  #   Объявляем объект tds  для работы с функциями и методами библиотеки pyiArduinoI2Ctds, указывая адрес модуля на шине I2C.
                                              #   Если объявить объект без указания адреса (pyiArduinoI2Ctds tds ), то адрес будет найден автоматически.
print("F    = "         , end='')             #
print(tds.getFrequency(), end='')             #   Выводим частоту переменного тока используемую для измерений от 50 до 500 Гц.
print("Гц.\r\nTDS1 = "  , end='')             #
print(tds.getKnownTDS(1), end='')             #   Выводим требуемую концентрацию 1 раствора для калибровки модуля кнопкой от 0 до 10'000 ppm.
print("ppm.\r\nTDS2 = " , end='')             #
print(tds.getKnownTDS(2), end='')             #   Выводим требуемую концентрацию 2 раствора для калибровки модуля кнопкой от 0 до 10'000 ppm.
print("ppm.\r\nKt   = " , end='')             #
print(tds.getKt()     ,4, end='')             #   Выводим температурный коэффициент жидкости от 0,0000 до 6,5535.
print("\r\nKp   = "     , end='')             #
print(tds.getKp()     ,2, end='')             #   Выводим коэффициент пересчёта от 0,01 до 2,55.
print("\r\nT    = "     , end='')             #
print(tds.get_T()     ,2, end='')             #   Выводим опорную температуру жидкости от 0,00 до 63,75 °С.
print("°С.\r\nKa   = "  , end='')             #
print(tds.getKa()     ,2, end='')             #   Выводим множитель степеной функции от 0,01 до 167'772.15.
print(".\r\nKb   = "    , end='')             #
print(tds.getKb()     ,3, end='')             #   Выводим степень степенной функции от -0,010 до -65.535.
print(".\r\n"           , end='')             #
