/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Random;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Map$;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import spire.algebra.Sign;
import spire.algebra.Sign$;
import spire.algebra.Sign$Positive$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.prime.Factors;
import spire.math.prime.Factors$;
import spire.math.prime.Siever;

public final class package$ {
    public static package$ MODULE$;
    private final Random srand;
    private final int SieveSize;

    static {
        new package$();
    }

    public boolean isPrime(SafeLong n) {
        return n.isProbablePrime(40);
    }

    public Factors factor(SafeLong n) {
        return this.factorPollardRho(n);
    }

    public Factors factorTrialDivision(SafeLong n0) {
        if (BoxesRunTime.equalsNumObject(n0, BoxesRunTime.boxToInteger(0))) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n = n0.abs();
        Sign sign = Sign$.MODULE$.apply(n0.signum());
        if (BoxesRunTime.equalsNumNum(n, SafeLong$.MODULE$.one())) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign);
        }
        GenMap facts = Map$.MODULE$.empty();
        SafeLong x = n;
        Tuple2<SafeLong, Object> tuple2 = this.findPowers(x, SafeLong$.MODULE$.apply(2L));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SafeLong x1 = tuple2._1();
        int e1 = tuple2._2$mcI$sp();
        Tuple2<SafeLong, Integer> tuple22 = new Tuple2<SafeLong, Integer>(x1, BoxesRunTime.boxToInteger(e1));
        Tuple2<SafeLong, Integer> tuple23 = tuple22;
        SafeLong x12 = tuple23._1();
        int e12 = tuple23._2$mcI$sp();
        if (e12 > 0) {
            facts.update(SafeLong$.MODULE$.apply(2L), BoxesRunTime.boxToInteger(e12));
            x = x12;
        }
        SafeLong limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x);
        SafeLong index$macro$543 = SafeLong$.MODULE$.apply(3L);
        while (index$macro$543.$less$eq(limit) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
            Tuple2<SafeLong, Object> tuple24 = this.findPowers(x, index$macro$543);
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            SafeLong x2 = tuple24._1();
            int e2 = tuple24._2$mcI$sp();
            Tuple2<SafeLong, Integer> tuple25 = new Tuple2<SafeLong, Integer>(x2, BoxesRunTime.boxToInteger(e2));
            Tuple2<SafeLong, Integer> tuple26 = tuple25;
            SafeLong x22 = tuple26._1();
            int e22 = tuple26._2$mcI$sp();
            if (e22 > 0) {
                facts.update(index$macro$543, BoxesRunTime.boxToInteger(e22));
                x = x22;
                limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x);
            }
            index$macro$543 = index$macro$543.$plus(2L);
        }
        if (x.$greater(SafeLong$.MODULE$.apply(1L))) {
            facts.update(x, BoxesRunTime.boxToInteger(1));
        }
        return new Factors(facts.toMap(Predef$.MODULE$.$conforms()), sign);
    }

    public Factors factorWheelDivision(SafeLong n0) {
        if (BoxesRunTime.equalsNumObject(n0, BoxesRunTime.boxToInteger(0))) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n = n0.abs();
        Sign sign = Sign$.MODULE$.apply(n0.signum());
        if (BoxesRunTime.equalsNumObject(n, BoxesRunTime.boxToInteger(1))) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), sign);
        }
        GenMap facts = Map$.MODULE$.empty();
        SafeLong x = n;
        Tuple2<SafeLong, Object> tuple2 = this.findPowers(x, SafeLong$.MODULE$.apply(2L));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SafeLong x1 = tuple2._1();
        int e1 = tuple2._2$mcI$sp();
        Tuple2<SafeLong, Integer> tuple22 = new Tuple2<SafeLong, Integer>(x1, BoxesRunTime.boxToInteger(e1));
        Tuple2<SafeLong, Integer> tuple23 = tuple22;
        SafeLong x12 = tuple23._1();
        int e12 = tuple23._2$mcI$sp();
        if (e12 > 0) {
            facts.update(SafeLong$.MODULE$.apply(2L), BoxesRunTime.boxToInteger(e12));
            x = x12;
        }
        SafeLong index$macro$544 = SafeLong$.MODULE$.apply(3L);
        while (index$macro$544.$less(SafeLong$.MODULE$.apply(30L)) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
            Tuple2<SafeLong, Object> tuple24 = this.findPowers(x, index$macro$544);
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            SafeLong x2 = tuple24._1();
            int e2 = tuple24._2$mcI$sp();
            Tuple2<SafeLong, Integer> tuple25 = new Tuple2<SafeLong, Integer>(x2, BoxesRunTime.boxToInteger(e2));
            Tuple2<SafeLong, Integer> tuple26 = tuple25;
            SafeLong x22 = tuple26._1();
            int e22 = tuple26._2$mcI$sp();
            if (e22 > 0) {
                facts.update(index$macro$544, BoxesRunTime.boxToInteger(e22));
                x = x22;
            }
            index$macro$544 = index$macro$544.$plus(2L);
        }
        SafeLong limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x);
        SafeLong b = SafeLong$.MODULE$.apply(31L);
        int i = 0;
        int[] offsets = new int[]{2, 2, 2, 4, 2, 4, 2, 4, 6, 2};
        while (b.$less$eq(limit) && x.$greater(SafeLong$.MODULE$.apply(1L))) {
            Tuple2<SafeLong, Object> tuple27 = this.findPowers(x, b);
            if (tuple27 == null) {
                throw new MatchError(tuple27);
            }
            SafeLong x2 = tuple27._1();
            int e2 = tuple27._2$mcI$sp();
            Tuple2<SafeLong, Integer> tuple28 = new Tuple2<SafeLong, Integer>(x2, BoxesRunTime.boxToInteger(e2));
            Tuple2<SafeLong, Integer> tuple29 = tuple28;
            SafeLong x23 = tuple29._1();
            int e23 = tuple29._2$mcI$sp();
            if (e23 > 0) {
                facts.update(b, BoxesRunTime.boxToInteger(e23));
                x = x23;
                limit = (SafeLong)SafeLong$.MODULE$.SafeLongAlgebra().sqrt(x);
            }
            b = b.$plus(offsets[i]);
            i = (i + 1) % 10;
        }
        if (x.$greater(SafeLong$.MODULE$.apply(1L))) {
            facts.update(x, BoxesRunTime.boxToInteger(1));
        }
        return new Factors(facts.toMap(Predef$.MODULE$.$conforms()), sign);
    }

    public Factors factorPollardRho(SafeLong n0) {
        if (BoxesRunTime.equalsNumObject(n0, BoxesRunTime.boxToInteger(0))) {
            return Factors$.MODULE$.zero();
        }
        SafeLong n = n0.abs();
        if (BoxesRunTime.equalsNumObject(n, BoxesRunTime.boxToInteger(1))) {
            return new Factors((Map<SafeLong, Object>)Predef$.MODULE$.Map().empty(), Sign$.MODULE$.apply(n0.signum()));
        }
        return n0.$less(SafeLong$.MODULE$.apply(0L)) ? this.factor$1(n).unary_$minus() : this.factor$1(n);
    }

    private Random srand() {
        return this.srand;
    }

    private SafeLong rand(SafeLong n) {
        int bits = n.bitLength();
        BigInteger x = new BigInteger(bits, this.srand());
        while (x.signum() == 0) {
            x = new BigInteger(bits, this.srand());
        }
        return SafeLong$.MODULE$.apply(BigInt$.MODULE$.javaBigInteger2bigInt(x));
    }

    private Tuple2<SafeLong, Object> findPowers(SafeLong x0, SafeLong b) {
        SafeLong x = x0;
        int e = 0;
        while (x.$greater(SafeLong$.MODULE$.apply(1L)) && BoxesRunTime.equalsNumObject(x.$percent(b), BoxesRunTime.boxToInteger(0))) {
            ++e;
            x = x.$div(b);
        }
        return new Tuple2<SafeLong, Object>(x, BoxesRunTime.boxToInteger(e));
    }

    private int SieveSize() {
        return this.SieveSize;
    }

    public Siever sieverUpToNth(long n) {
        double upper = (double)n * spire.math.package$.MODULE$.log(n) + (double)n * spire.math.package$.MODULE$.log(spire.math.package$.MODULE$.log((double)n - 0.9385));
        long cutoff = spire.math.package$.MODULE$.max(1000L, (long)(spire.math.package$.MODULE$.sqrt(upper) + (double)512L));
        return new Siever(this.SieveSize(), SafeLong$.MODULE$.apply(cutoff));
    }

    public SafeLong nth(long n) {
        return this.sieverUpToNth(n).nth(n);
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong[] fill(int n) {
        SafeLong[] safeLongArray;
        if (n <= 0) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToInteger(n)).toString());
        }
        if (n == 1) {
            safeLongArray = (SafeLong[])((Object[])new SafeLong[]{SafeLong$.MODULE$.two()});
        } else {
            void var3_3;
            Siever siever = this.sieverUpToNth(n);
            SafeLong[] arr = new SafeLong[n];
            arr[0] = SafeLong$.MODULE$.two();
            arr[1] = SafeLong$.MODULE$.three();
            this.loop$1(2, SafeLong$.MODULE$.three(), siever, arr);
            safeLongArray = var3_3;
        }
        return safeLongArray;
    }

    public SafeLong[] fill(int start, int limit) {
        SafeLong[] safeLongArray;
        if (start == 0) {
            safeLongArray = this.fill(limit);
        } else {
            Siever siever = this.sieverUpToNth(start + limit);
            safeLongArray = this.loop$2(1, SafeLong$.MODULE$.three(), start, limit, siever);
        }
        return safeLongArray;
    }

    public Stream<SafeLong> stream() {
        return this.stream(this.SieveSize(), SafeLong$.MODULE$.apply(1000000L));
    }

    public Stream<SafeLong> stream(int chunkSize, SafeLong cutoff) {
        SafeLong safeLong = SafeLong$.MODULE$.two();
        return Stream$.MODULE$.consWrapper((Function0<Stream> & Serializable & scala.Serializable)() -> {
            SafeLong safeLong = SafeLong$.MODULE$.three();
            return Stream$.MODULE$.consWrapper((Function0<Stream> & Serializable & scala.Serializable)() -> new Siever(chunkSize, cutoff).streamAfter(SafeLong$.MODULE$.three())).$hash$colon$colon(safeLong);
        }).$hash$colon$colon(safeLong);
    }

    private static final SafeLong f$1(SafeLong x, SafeLong n$1, SafeLong c$1) {
        return x.$times(x).$percent(n$1).$plus(c$1).$percent(n$1);
    }

    private final SafeLong fastRho$1(SafeLong x, SafeLong q0, SafeLong r, SafeLong m, SafeLong n$1, SafeLong c$1) {
        SafeLong ys;
        SafeLong g;
        while (true) {
            SafeLong y = x;
            SafeLong q = q0;
            int index$macro$545 = 0;
            while (r.$greater(SafeLong$.MODULE$.apply(index$macro$545))) {
                y = package$.f$1(y, n$1, c$1);
                ++index$macro$545;
            }
            g = SafeLong$.MODULE$.one();
            SafeLong k = SafeLong$.MODULE$.zero();
            ys = y;
            while (r.$greater(k) && BoxesRunTime.equalsNumObject(g, BoxesRunTime.boxToInteger(1))) {
                ys = y;
                SafeLong limit = m.min(r.$minus(k));
                int index$macro$546 = 0;
                while (limit.$greater(SafeLong$.MODULE$.apply(index$macro$546))) {
                    y = package$.f$1(y, n$1, c$1);
                    q = q.$times(x.$minus(y).abs()).$percent(n$1);
                    ++index$macro$546;
                }
                g = BoxesRunTime.equalsNumObject(q, BoxesRunTime.boxToInteger(0)) ? n$1 : n$1.gcd(q);
                k = k.$plus(m);
            }
            if (!BoxesRunTime.equalsNumObject(g, BoxesRunTime.boxToInteger(1))) break;
            r = r.$times(2L);
            q0 = q;
            x = y;
        }
        return BoxesRunTime.equalsNumNum(g, n$1) ? this.slowRho$1(x, ys, n$1, c$1) : g;
    }

    private final SafeLong slowRho$1(SafeLong x, SafeLong ys, SafeLong n$1, SafeLong c$1) {
        SafeLong yys;
        SafeLong g;
        while (BoxesRunTime.equalsNumObject(g = n$1.gcd(x.$minus(yys = package$.f$1(ys, n$1, c$1)).abs()), BoxesRunTime.boxToInteger(1))) {
            ys = yys;
        }
        return g;
    }

    private final SafeLong rho$1(SafeLong n, SafeLong c) {
        return this.fastRho$1(this.rand(n), SafeLong$.MODULE$.one(), SafeLong$.MODULE$.one(), this.rand(n), n, c);
    }

    private final Factors factor$1(SafeLong n) {
        Factors factors;
        if (BoxesRunTime.equalsNumObject(n, BoxesRunTime.boxToInteger(1))) {
            factors = Factors$.MODULE$.one();
        } else if (this.isPrime(n)) {
            factors = new Factors((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<SafeLong, Integer>(n, BoxesRunTime.boxToInteger(1))})), Sign$Positive$.MODULE$);
        } else if (n.isEven()) {
            SafeLong x = n.$div(2L);
            int e = 1;
            while (x.isEven()) {
                x = x.$div(2L);
                ++e;
            }
            factors = new Factors((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<SafeLong, Integer>(SafeLong$.MODULE$.apply(2L), BoxesRunTime.boxToInteger(e))})), Sign$Positive$.MODULE$).$times(this.factor$1(x));
        } else {
            SafeLong divisor = this.rho$1(n, this.rand(n));
            while (BoxesRunTime.equalsNumNum(divisor, n)) {
                divisor = this.rho$1(n, this.rand(n));
            }
            factors = this.factor$1(divisor).$times(this.factor$1(n.$div(divisor)));
        }
        return factors;
    }

    private final void loop$1(int i, SafeLong last, Siever siever$1, SafeLong[] arr$1) {
        while (i < arr$1.length) {
            SafeLong p;
            arr$1[i] = p = siever$1.nextAfter(last);
            last = p;
            ++i;
        }
    }

    private final SafeLong[] loop$2(int i, SafeLong p, int start$1, int limit$1, Siever siever$2) {
        while (i < start$1) {
            p = siever$2.nextAfter(p);
            ++i;
        }
        return siever$2.arrayAt(p, limit$1);
    }

    private package$() {
        MODULE$ = this;
        this.srand = new Random();
        this.SieveSize = 9600000;
    }
}

