/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BoxQuery {
    @SerializedName(value="ergoTreeTemplateHash")
    private String ergoTreeTemplateHash = null;
    @SerializedName(value="registers")
    private Map<String, String> registers = null;
    @SerializedName(value="constants")
    private Map<String, String> constants = null;
    @SerializedName(value="assets")
    private List<String> assets = null;

    public BoxQuery ergoTreeTemplateHash(String string) {
        this.ergoTreeTemplateHash = string;
        return this;
    }

    @Schema(required=true, description="SHA-256 hash of ErgoTree template this box script should have")
    public String getErgoTreeTemplateHash() {
        return this.ergoTreeTemplateHash;
    }

    public void setErgoTreeTemplateHash(String string) {
        this.ergoTreeTemplateHash = string;
    }

    public BoxQuery registers(Map<String, String> map2) {
        this.registers = map2;
        return this;
    }

    public BoxQuery putRegistersItem(String string, String string2) {
        if (this.registers == null) {
            this.registers = new HashMap<String, String>();
        }
        this.registers.put(string, string2);
        return this;
    }

    @Schema(description="Pairs of (register ID, register value) this box should contain")
    public Map<String, String> getRegisters() {
        return this.registers;
    }

    public void setRegisters(Map<String, String> map2) {
        this.registers = map2;
    }

    public BoxQuery constants(Map<String, String> map2) {
        this.constants = map2;
        return this;
    }

    public BoxQuery putConstantsItem(String string, String string2) {
        if (this.constants == null) {
            this.constants = new HashMap<String, String>();
        }
        this.constants.put(string, string2);
        return this;
    }

    @Schema(description="Pairs of (constant index, constant value) this box should contain")
    public Map<String, String> getConstants() {
        return this.constants;
    }

    public void setConstants(Map<String, String> map2) {
        this.constants = map2;
    }

    public BoxQuery assets(List<String> list) {
        this.assets = list;
        return this;
    }

    public BoxQuery addAssetsItem(String string) {
        if (this.assets == null) {
            this.assets = new ArrayList<String>();
        }
        this.assets.add(string);
        return this;
    }

    @Schema(description="IDs of tokens this box should contain")
    public List<String> getAssets() {
        return this.assets;
    }

    public void setAssets(List<String> list) {
        this.assets = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BoxQuery boxQuery = (BoxQuery)object;
        return Objects.equals(this.ergoTreeTemplateHash, boxQuery.ergoTreeTemplateHash) && Objects.equals(this.registers, boxQuery.registers) && Objects.equals(this.constants, boxQuery.constants) && Objects.equals(this.assets, boxQuery.assets);
    }

    public int hashCode() {
        return Objects.hash(this.ergoTreeTemplateHash, this.registers, this.constants, this.assets);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class BoxQuery {\n");
        stringBuilder.append("    ergoTreeTemplateHash: ").append(this.toIndentedString(this.ergoTreeTemplateHash)).append("\n");
        stringBuilder.append("    registers: ").append(this.toIndentedString(this.registers)).append("\n");
        stringBuilder.append("    constants: ").append(this.toIndentedString(this.constants)).append("\n");
        stringBuilder.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

