/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gsonfire.annotations.ExcludeByValue;
import io.gsonfire.gson.ExclusionByValueStrategy;
import io.gsonfire.util.FieldNameResolver;
import io.gsonfire.util.JsonUtils;
import io.gsonfire.util.reflection.Factory;
import io.gsonfire.util.reflection.FieldInspector;
import java.io.IOException;
import java.lang.reflect.Field;

public final class ExcludeByValueTypeAdapterFactory
implements TypeAdapterFactory {
    private final FieldInspector fieldInspector;
    private final Factory factory;
    private FieldNameResolver fieldNameResolver = null;

    public ExcludeByValueTypeAdapterFactory(FieldInspector fieldInspector, Factory factory) {
        this.fieldInspector = fieldInspector;
        this.factory = factory;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (this.fieldNameResolver == null) {
            this.fieldNameResolver = new FieldNameResolver(gson);
        }
        TypeAdapter<T> originalTypeAdapter = gson.getDelegateAdapter(this, type);
        return new ExcludeByValueTypeAdapter(gson, originalTypeAdapter);
    }

    private class ExcludeByValueTypeAdapter
    extends TypeAdapter {
        private final Gson gson;
        private final TypeAdapter originalTypeAdapter;

        public ExcludeByValueTypeAdapter(Gson gson, TypeAdapter originalTypeAdapter) {
            this.gson = gson;
            this.originalTypeAdapter = originalTypeAdapter;
        }

        public void write(JsonWriter out, Object src) throws IOException {
            if (src == null) {
                this.originalTypeAdapter.write(out, src);
            } else {
                JsonObject postProcessedObject = null;
                for (Field f : ExcludeByValueTypeAdapterFactory.this.fieldInspector.getAnnotatedMembers(src.getClass(), ExcludeByValue.class)) {
                    try {
                        String fieldName;
                        ExcludeByValue excludeByValue = f.getAnnotation(ExcludeByValue.class);
                        Class<? extends ExclusionByValueStrategy> exclusionByValueStrategyClass = excludeByValue.value();
                        ExclusionByValueStrategy strategy = ExcludeByValueTypeAdapterFactory.this.factory.get(exclusionByValueStrategyClass);
                        if (!strategy.shouldSkipField(f.get(src)) || (fieldName = ExcludeByValueTypeAdapterFactory.this.fieldNameResolver.getFieldName(f)) == null) continue;
                        if (postProcessedObject == null) {
                            JsonElement originalResult = JsonUtils.toJsonTree(this.originalTypeAdapter, out, src);
                            if (originalResult == null || originalResult.isJsonNull() || !originalResult.isJsonObject()) break;
                            postProcessedObject = originalResult.getAsJsonObject();
                        }
                        postProcessedObject.remove(fieldName);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (postProcessedObject != null) {
                    this.gson.toJson(postProcessedObject, out);
                } else {
                    this.originalTypeAdapter.write(out, src);
                }
            }
        }

        public Object read(JsonReader in) throws IOException {
            return this.originalTypeAdapter.read(in);
        }
    }
}

