[![Python package](https://github.com/OlivierBinette/er-evaluation/actions/workflows/python-package.yml/badge.svg)](https://github.com/OlivierBinette/er-evaluation/actions/workflows/python-package.yml)
[![PyPI version](https://badge.fury.io/py/er-evaluation.svg)](https://badge.fury.io/py/er-evaluation)

# 🔎 ER-Evaluation: An End-to-End Evaluation Framework for Entity Resolution Systems

**ER-Evaluation** is a Python package for the evaluation of entity resolution (ER) systems. It provides data structure definitions, summary statistics, visualizations, error analysis tools, and statistically principled performance estimators.

## Installation

Install the released version from PyPI using:
```bash
pip install er-evaluation
```

## Documentation

Please refer to the documentation website [olivierbinette.ca/er-evaluation](http://olivierbinette.ca/er-evaluation/build/html/index.html).

## Acknowledgements

**ER-Evaluation** is an extension of the [PatentsView/PatentsView-Evaluation](https://github.com/PatentsView/PatentsView-Evaluation/) project sponsored by the American Institutes for Research and the U.S. Patents and Trademarks Office. We aim to provide a unified source of evaluation tools for entity resolution systems which are maintained as an open source academic project.

### Publications

- [Binette, Olivier, Sokhna A York, Emma Hickerson, Youngsoo Baek, Sarvo Madhavan, Christina Jones. (2022). Estimating the Performance of Entity Resolution Algorithms: Lessons Learned Through PatentsView.org. arXiv e-prints: arxiv:2210.01230](https://arxiv.org/abs/2210.01230)

- Upcoming: "A Statistical Evaluation Framework for Black-Box Entity Resolution Systems With Application to Inventor Name Disambiguation"

### Funding

This project was made possible through support from the Natural Sciences and Engineering Research Council of Canada, Fonds de Recherche du Québec - Nature et Technologies, Duke University, the American Institutes for Research, and the U.S. Patents and Trademarks Office.

## Citation

Please acknowledge the above publications as well as the ER-Evaluation Python package:

- Binette, Olivier. (2022). ER-Evaluation: An End-to-End Evaluation Framework for Entity Resolution Systems. Available online at https://github.com/OlivierBinette/ER-Evaluation
