# Frequently Asked Questions

Your question is not here? Please use
[stackoverflow](https://stackoverflow.com/questions/tagged/textx). Just make
sure your question is tagged with `textx`.


## Is TextX suitable to generate Django model code ?
Yes, textX is perfectly suitable for the task. Actually, that is something it is created for. To make a clean little language that fits your needs in describing your requirements/solution and than generate a bunch of stuff for various target platforms. See the Entity example is the docs. It's very simplistic but would provide you a good starting point.

I see the success of Django and similar frameworks (like ROR for example) mainly due to use of internal DSLs (django models is a DSL that is interpreted on-the-fly to provide ORM etc., or admin is interpreted on the fly to provide CRUDS interface). With textX you can go further by having an external DSL where you can fully control your syntax and you can generate the rest of the stuff. Down the road, if you decide to leave Django, just change your generators and regenerate for the new platform.

!!! note
    Taken from [#121](https://github.com/textX/textX/issues/121).


## What is an idiomatic way to test models generated by a grammar ?
Exact comparison of models is probably not a good idea : differences in the model may be unsignificant from the semantic point of view.

A more practical and sensible approach is to construct the model using textX and then to traverse the model, asserting various facts about it, duck typing style.

You may want to look at property-oriented testing, with frameworks as [hypothesis](https://hypothesis.works).

!!! note
    Inspired from [#116](https://github.com/textX/textX/issues/116).


## How to parse whitespace sensitive grammar (like Python) ?
There is no direct support for whitespace sensitive languages at the moment. An [incoming work](https://github.com/textX/textX/issues/15) is going to deal with this.

!!! note
    Taken from [#44](https://github.com/textX/textX/issues/44).


## How to use line terminator as EOL token (like Python) ?
You can disable whitespace skipping using `ws` [parser parameter](http://textx.github.io/textX/parser_config/#whitespace-handling) to redefine whitespaces or disable whitespace entirely using `skipws` param.

You can also do that [per rule](http://textx.github.io/textX/grammar/#rule-modifiers). This way you can catch whitespaces in your grammar. For your particular case, when you should match inside single line only, there is even simpler solution by using [`eolterm` repetition modifier](http://textx.github.io/textX/grammar/#repetition-modifiers).

See for example implementation of [pyFlies conditions](https://github.com/igordejanovic/pyFlies/blob/master/examples/Simon/Simon.pf). In this DSL each state is a separate line.

!!! note
    Taken from [#44](https://github.com/textX/textX/issues/44).


## TextX allows to get AST from code. How to convert the AST back to code ?
This feature is not implemented for the moment. It will be made possible by an incoming frontend for TextX
based on [another parsing method](http://www.igordejanovic.net/2017/08/09/parglare-python-parser.html).

For the moment, the closest thing you have is [the Entity example](https://github.com/textX/textX/tree/master/examples/Entity)
showing how to generate source code from models.

!!! note
    Taken from [#36](https://github.com/textX/textX/issues/36).


## Is the `.dot` output fully deterministic ?
No, because internally the `id()` function is used when generating the `.dot`
output for nodes identification.

!!! note
    Taken from [#101](https://github.com/textX/textX/issues/101).


## How is using a model processor is different from simply calling a function taking a model after the parsing is complete ?
No difference. Model processor is only a convenience that ensures that calling a processor is not forgotten.

!!! note
    Taken from [#124](https://github.com/textX/textX/issues/124).


## Are object processors also called after the parsing is complete ?
Object processors are called after parsing and reference resolution. Thus, an object processor always have all references resolved.

!!! note
    Taken from [#124](https://github.com/textX/textX/issues/124).


## If an object processor returns a value of another object type, does a processor for that type is called ?
If you return a value in an object processor, the current object is replaced. The replaced object is not further processed.

!!! note
    Taken from [#124](https://github.com/textX/textX/issues/124).


## Is there an existing DSL for JSON schema ?
We are not aware of any project using textX for JSON Schema implementation.

It however shouldn't be hard to define grammar for JSON Schema in textX. You can start with the [JSON example](https://github.com/textX/textX/tree/master/examples/json).
Actually, JSON schema is JSON file so it can be parsed with any JSON parser (the [official python one](https://docs.python.org/3/library/json.html), or even textX JSON example)
and validated and analysed afterwards. You could then extract schema validation rules and apply them to subsequent JSON files.
JSON schema is meta-language, thus it could be applied to itself.

However, there are standard JSON Schema implementations in Python that do that well and probably will parse much faster than textX.

TextX targets situation where you want to parse something that doesn't have readily available parser, like some custom textual formats or DSLs.
For example, to combine JSON Schema with other formalisms.

!!! note
    Taken from [#51](https://github.com/textX/textX/issues/51).
