# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetLbRouteResult',
    'AwaitableGetLbRouteResult',
    'get_lb_route',
    'get_lb_route_output',
]

@pulumi.output_type
class GetLbRouteResult:
    """
    A collection of values returned by getLbRoute.
    """
    def __init__(__self__, backend_id=None, created_at=None, frontend_id=None, id=None, match_host_header=None, match_sni=None, route_id=None, updated_at=None):
        if backend_id and not isinstance(backend_id, str):
            raise TypeError("Expected argument 'backend_id' to be a str")
        pulumi.set(__self__, "backend_id", backend_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if frontend_id and not isinstance(frontend_id, str):
            raise TypeError("Expected argument 'frontend_id' to be a str")
        pulumi.set(__self__, "frontend_id", frontend_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if match_host_header and not isinstance(match_host_header, str):
            raise TypeError("Expected argument 'match_host_header' to be a str")
        pulumi.set(__self__, "match_host_header", match_host_header)
        if match_sni and not isinstance(match_sni, str):
            raise TypeError("Expected argument 'match_sni' to be a str")
        pulumi.set(__self__, "match_sni", match_sni)
        if route_id and not isinstance(route_id, str):
            raise TypeError("Expected argument 'route_id' to be a str")
        pulumi.set(__self__, "route_id", route_id)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> str:
        return pulumi.get(self, "backend_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> str:
        return pulumi.get(self, "frontend_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="matchHostHeader")
    def match_host_header(self) -> str:
        return pulumi.get(self, "match_host_header")

    @property
    @pulumi.getter(name="matchSni")
    def match_sni(self) -> str:
        return pulumi.get(self, "match_sni")

    @property
    @pulumi.getter(name="routeId")
    def route_id(self) -> str:
        return pulumi.get(self, "route_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        return pulumi.get(self, "updated_at")


class AwaitableGetLbRouteResult(GetLbRouteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLbRouteResult(
            backend_id=self.backend_id,
            created_at=self.created_at,
            frontend_id=self.frontend_id,
            id=self.id,
            match_host_header=self.match_host_header,
            match_sni=self.match_sni,
            route_id=self.route_id,
            updated_at=self.updated_at)


def get_lb_route(route_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLbRouteResult:
    """
    Get information about Scaleway Load-Balancer Routes.
    For more information, see [the documentation](https://developers.scaleway.com/en/products/lb/zoned_api/#route-ff94b7).

    ## Example Usage

    ```python
    import pulumi
    import ediri_scaleway as scaleway
    import pulumi_scaleway as scaleway

    ip01 = scaleway.LbIp("ip01")
    lb01 = scaleway.Lb("lb01",
        ip_id=ip01.id,
        type="lb-s")
    bkd01 = scaleway.LbBackend("bkd01",
        lb_id=lb01.id,
        forward_protocol="tcp",
        forward_port=80,
        proxy_protocol="none")
    frt01 = scaleway.LbFrontend("frt01",
        lb_id=lb01.id,
        backend_id=bkd01.id,
        inbound_port=80)
    rt01 = scaleway.LbRoute("rt01",
        frontend_id=frt01.id,
        backend_id=bkd01.id,
        match_sni="sni.scaleway.com")
    by_id = scaleway.get_lb_route_output(route_id=rt01.id)
    ```


    :param str route_id: The route id.
    """
    __args__ = dict()
    __args__['routeId'] = route_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getLbRoute:getLbRoute', __args__, opts=opts, typ=GetLbRouteResult).value

    return AwaitableGetLbRouteResult(
        backend_id=__ret__.backend_id,
        created_at=__ret__.created_at,
        frontend_id=__ret__.frontend_id,
        id=__ret__.id,
        match_host_header=__ret__.match_host_header,
        match_sni=__ret__.match_sni,
        route_id=__ret__.route_id,
        updated_at=__ret__.updated_at)


@_utilities.lift_output_func(get_lb_route)
def get_lb_route_output(route_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLbRouteResult]:
    """
    Get information about Scaleway Load-Balancer Routes.
    For more information, see [the documentation](https://developers.scaleway.com/en/products/lb/zoned_api/#route-ff94b7).

    ## Example Usage

    ```python
    import pulumi
    import ediri_scaleway as scaleway
    import pulumi_scaleway as scaleway

    ip01 = scaleway.LbIp("ip01")
    lb01 = scaleway.Lb("lb01",
        ip_id=ip01.id,
        type="lb-s")
    bkd01 = scaleway.LbBackend("bkd01",
        lb_id=lb01.id,
        forward_protocol="tcp",
        forward_port=80,
        proxy_protocol="none")
    frt01 = scaleway.LbFrontend("frt01",
        lb_id=lb01.id,
        backend_id=bkd01.id,
        inbound_port=80)
    rt01 = scaleway.LbRoute("rt01",
        frontend_id=frt01.id,
        backend_id=bkd01.id,
        match_sni="sni.scaleway.com")
    by_id = scaleway.get_lb_route_output(route_id=rt01.id)
    ```


    :param str route_id: The route id.
    """
    ...
