# import export
## A Python package methods decorator

![Lines of code](https://img.shields.io/tokei/lines/github/ablaternae/py-export)
![Downloads](https://img.shields.io/pypi/dm/import-export)
[![Statistic](https://pepy.tech/badge/import-export/week)](https://pepy.tech/project/import-export)
![GitHub](https://img.shields.io/github/license/ablaternae/py-export)

Let me show here

### 1. install
```bash
pip install -U import-export
```

### 2. use 
```python
"""mypack.py"""
import export

def fee():
    return 'twee'
	
@export
def moo():
    return 'moow'
    
@export
class C(object):
    pass
```
```python
> from mypack import *
> print(fee())
NameError: name 'fee' is not defined
> print(moo())
moow
> print(C())
<mypack.C object at 0x00********>
```
**NB:**
```python
> import mypack
> print(mypack.fee())
twee
```

### How it work
* just add decorated resource name to the tuple `module.__all__`

### Implementation features
* no requirements, but `sys` only
* uses some hack `from sys import modules` and so won't leave _beta_
* does not store itself in module variables
* runs for all version python

## License
* It's free software, see the [LICENSE](https://github.com/ablaternae/py-export/blob/main/LICENSE.md) for more details.


## Credits
* This project is inspired [export v.0.1.2](https://pypi.org/project/export/0.1.2/) by http://github.com/zsiciarz/export
* Written in [CudaText](https://cudatext.github.io/) by [@Alexey-T](https://github.com/Alexey-T/CudaText/)
* Lot a thnx SO topic authors https://stackoverflow.com/q/44834


## TODO
* [x] `export(None)` == raise Exception('doesn\'t work')
* [ ] ~may be implement `private()` `public()` etc decorator to classes as new version of competing library~
* [ ] next part coming soon! 
