# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pysignald_async']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'pysignald-async',
    'version': '0.1.10',
    'description': 'Python bindings for signald',
    'long_description': 'Signald python bindings\n=======================\n\nMost of the content here is generated by ``util/generate_api.py`` that\nuses the output of the ‘protocol’ request of the\n`signald <https://gitlab.com/signald/signald>`__\n`API <https://docs.signald.org/>`__.\n\nSince this output is incomplete, a few manual additions are present in\n``pysignald_async/api.py``.\n\nInstall\n-------\n\n``pip install pysignald-async``\n\nUsage\n-----\n\nAn example can be found in `this signal/XMPP\ngateway <https://gitlab.com/nicocool84/spectrum2_signald/-/blob/master/spectrum2_signald/signald.py>`__.\n\nExample 1: registration\n***********************\n\n.. code:: py\n\n   import asyncio\n\n   from pysignald_async import SignaldAPI\n\n   async def main():\n       loop = asyncio.get_running_loop()\n       _, signald = await loop.create_unix_connection(\n           SignaldAPI, path=SIGNALD_SOCKET_PATH)\n       await signald.register(username="+XXXXXX")\n       # Some async code to get the SMS code\n       await signald.verify(username="+XXXXXX", code=code)\n       await signald.on_con_lost\n\n   SIGNALD_SOCKET_PATH = "/var/run/signald/signald.sock"\n\n   asyncio.run(main())\n\nExample 2: echo bot\n*******************\n\n.. code:: py\n\n    from pysignald_async.api import JsonAddressv1, JsonMessageEnvelopev1\n\n    class EchoBot(SignaldAPI):\n        def handle_envelope(self, envelope: JsonMessageEnvelopev1):\n            message = envelope.dataMessage\n            source = envelope.source.number\n            # envelopes contain typing notifications, receipts, so\n            # let\'s check if it\'s actually a messages\n            if message not None and source is not None:\n                # signald can handle multiple accounts\n                username = envelope.username\n                asyncio.create_task(\n                    self.signald.send(\n                        username=user.legacy_id,\n                        recipientAddress=JsonAddressv1(\n                            number=legacy_buddy_id),\n                        messageBody=message.body,\n                    )\n                )\n\n    async def main():\n        loop = asyncio.get_running_loop()\n        _, signald = await loop.create_unix_connection(\n            SignaldAPI, path=SIGNALD_SOCKET_PATH)\n        # Username is a phone number that has either been registered or linked in signald\n        await signald.subscribe(username="+XXXXXX")\n\n    SIGNALD_SOCKET_PATH = "/var/run/signald/signald.sock"\n\n    asyncio.run(main())\n\n\n\nDocs are available on `readthedocs <https://pysignald-async.readthedocs.org>`_.\n',
    'author': 'Nicolas Cedilnik',
    'author_email': 'nicoco@nicoco.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/nicocool84/pysignald-async',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
