from setuptools import find_packages
from setuptools import setup

setup(
    name="prometheus-salt-exporter",
    version="0.1.0rc1",
    author="ioki sre.core",
    author_email="sreint@ioki.com",
    description=("Prometheus Exporter for Salt highstate metrics run from the Salt master."),
    long_description=open("README.rst").read(),
    license="MIT",
    keywords="prometheus exporter salt monitoring",
    url="https://github.com/zadjadr/prometheus-salt-exporter",
    package_dir={"": "src"},
    packages=find_packages("src"),
    entry_points={
        "console_scripts": [
            "prometheus_salt_exporter=prometheus_salt_exporter.main:main",
        ],
    },
    python_requires=">=3.8",
    install_requires=[
        "prometheus_client>=0.16",
        "salt",
    ],
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Information Technology",
        "Intended Audience :: System Administrators",
        "Topic :: System :: Monitoring",
        "Topic :: System :: Networking :: Monitoring",
        "License :: OSI Approved :: MIT License",
    ],
)
