# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class AddAccountRelationRequest(TeaModel):
    def __init__(
        self,
        child_nick: str = None,
        child_user_id: int = None,
        parent_user_id: int = None,
        permission_codes: List[str] = None,
        relation_type: str = None,
        request_id: str = None,
        role_codes: List[str] = None,
    ):
        # The display name of the member. This helps clarify the scenario in which the account is used.
        self.child_nick = child_nick
        # The ID of the Alibaba Cloud account that is used as the member.
        self.child_user_id = child_user_id
        # The ID of the Alibaba Cloud account that is used as the management account.
        self.parent_user_id = parent_user_id
        # The permissions that can be granted to the member. Valid values:
        # 
        # *   SYNCHRONIZE_FINANCE_IDENTITY: allows the credit control identity to be shared with the member.
        # *   SYNCHRONIZE_FINANCE_DISCOUNT_POLICY_TO_TARGET: allows the discount policy to be shared with the member.
        # *   FORBID_WITHDRAW_CASH: does not allow the member to withdraw the balance.
        # *   FORBID_MANAGE_INVOICE: does not allow the member to manage invoices.
        # *   CHECK_FINANCE_INFO: requests to view information about the financial relationship.
        # *   MANAGE_TARGET_INVOICE: allows the member to manage invoices.
        # *   CHECK_TARGET_CONSUMPTION: allows the member to view the bills.
        self.permission_codes = permission_codes
        # The type of the financial relationship. Set the value to enterprise_group.
        self.relation_type = relation_type
        # The unique ID of the request. The ID is used to mark a request and troubleshoot a problem.
        self.request_id = request_id
        # The roles that can be assigned to the member. Set the value to trusteeship.
        self.role_codes = role_codes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.child_nick is not None:
            result['ChildNick'] = self.child_nick
        if self.child_user_id is not None:
            result['ChildUserId'] = self.child_user_id
        if self.parent_user_id is not None:
            result['ParentUserId'] = self.parent_user_id
        if self.permission_codes is not None:
            result['PermissionCodes'] = self.permission_codes
        if self.relation_type is not None:
            result['RelationType'] = self.relation_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.role_codes is not None:
            result['RoleCodes'] = self.role_codes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChildNick') is not None:
            self.child_nick = m.get('ChildNick')
        if m.get('ChildUserId') is not None:
            self.child_user_id = m.get('ChildUserId')
        if m.get('ParentUserId') is not None:
            self.parent_user_id = m.get('ParentUserId')
        if m.get('PermissionCodes') is not None:
            self.permission_codes = m.get('PermissionCodes')
        if m.get('RelationType') is not None:
            self.relation_type = m.get('RelationType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RoleCodes') is not None:
            self.role_codes = m.get('RoleCodes')
        return self


class AddAccountRelationResponseBodyData(TeaModel):
    def __init__(
        self,
        host_id: str = None,
        relation_id: int = None,
    ):
        # HostId
        self.host_id = host_id
        # The ID of the financial relationship.
        self.relation_id = relation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.relation_id is not None:
            result['RelationId'] = self.relation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('RelationId') is not None:
            self.relation_id = m.get('RelationId')
        return self


class AddAccountRelationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AddAccountRelationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AddAccountRelationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddAccountRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddAccountRelationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAccountRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateCostUnitResourceRequestResourceInstanceList(TeaModel):
    def __init__(
        self,
        apportion_code: str = None,
        commodity_code: str = None,
        resource_id: str = None,
        resource_user_id: int = None,
    ):
        self.apportion_code = apportion_code
        self.commodity_code = commodity_code
        self.resource_id = resource_id
        self.resource_user_id = resource_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apportion_code is not None:
            result['ApportionCode'] = self.apportion_code
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_user_id is not None:
            result['ResourceUserId'] = self.resource_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApportionCode') is not None:
            self.apportion_code = m.get('ApportionCode')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceUserId') is not None:
            self.resource_user_id = m.get('ResourceUserId')
        return self


class AllocateCostUnitResourceRequest(TeaModel):
    def __init__(
        self,
        from_unit_id: int = None,
        from_unit_user_id: int = None,
        resource_instance_list: List[AllocateCostUnitResourceRequestResourceInstanceList] = None,
        to_unit_id: int = None,
        to_unit_user_id: int = None,
    ):
        self.from_unit_id = from_unit_id
        self.from_unit_user_id = from_unit_user_id
        self.resource_instance_list = resource_instance_list
        self.to_unit_id = to_unit_id
        self.to_unit_user_id = to_unit_user_id

    def validate(self):
        if self.resource_instance_list:
            for k in self.resource_instance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_unit_id is not None:
            result['FromUnitId'] = self.from_unit_id
        if self.from_unit_user_id is not None:
            result['FromUnitUserId'] = self.from_unit_user_id
        result['ResourceInstanceList'] = []
        if self.resource_instance_list is not None:
            for k in self.resource_instance_list:
                result['ResourceInstanceList'].append(k.to_map() if k else None)
        if self.to_unit_id is not None:
            result['ToUnitId'] = self.to_unit_id
        if self.to_unit_user_id is not None:
            result['ToUnitUserId'] = self.to_unit_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FromUnitId') is not None:
            self.from_unit_id = m.get('FromUnitId')
        if m.get('FromUnitUserId') is not None:
            self.from_unit_user_id = m.get('FromUnitUserId')
        self.resource_instance_list = []
        if m.get('ResourceInstanceList') is not None:
            for k in m.get('ResourceInstanceList'):
                temp_model = AllocateCostUnitResourceRequestResourceInstanceList()
                self.resource_instance_list.append(temp_model.from_map(k))
        if m.get('ToUnitId') is not None:
            self.to_unit_id = m.get('ToUnitId')
        if m.get('ToUnitUserId') is not None:
            self.to_unit_user_id = m.get('ToUnitUserId')
        return self


class AllocateCostUnitResourceResponseBodyData(TeaModel):
    def __init__(
        self,
        is_success: bool = None,
        to_unit_id: int = None,
        to_unit_user_id: int = None,
    ):
        self.is_success = is_success
        self.to_unit_id = to_unit_id
        self.to_unit_user_id = to_unit_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.to_unit_id is not None:
            result['ToUnitId'] = self.to_unit_id
        if self.to_unit_user_id is not None:
            result['ToUnitUserId'] = self.to_unit_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('ToUnitId') is not None:
            self.to_unit_id = m.get('ToUnitId')
        if m.get('ToUnitUserId') is not None:
            self.to_unit_user_id = m.get('ToUnitUserId')
        return self


class AllocateCostUnitResourceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AllocateCostUnitResourceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AllocateCostUnitResourceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AllocateCostUnitResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AllocateCostUnitResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllocateCostUnitResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyInvoiceRequest(TeaModel):
    def __init__(
        self,
        address_id: int = None,
        apply_user_nick: str = None,
        customer_id: int = None,
        invoice_amount: int = None,
        invoice_by_amount: bool = None,
        invoicing_type: int = None,
        owner_id: int = None,
        process_way: int = None,
        selected_ids: List[int] = None,
        user_remark: str = None,
    ):
        # The ID of the address to which the invoice is delivered. This parameter is required if the invoice is a paper invoice. Set the ID to the value of the AddressId parameter returned by calling the QueryCustomerAddressList operation.
        self.address_id = address_id
        # The nickname of the applicant. The system does not verify the nickname.
        self.apply_user_nick = apply_user_nick
        # The ID of the customer. Set the ID to the value of the CustomerId parameter returned by calling the QueryInvoicingCustomerList operation.
        self.customer_id = customer_id
        # The amount of the invoice. Unit: Cent.
        self.invoice_amount = invoice_amount
        # Specifies whether to invoice by amount. A value of true indicates that the user applies for the invoice based on the InvoiceAmount parameter. A value of false indicates that the user applies for the invoice based on the total amount of the invoicing items.
        self.invoice_by_amount = invoice_by_amount
        # The type of the invoice. Valid values:
        # 
        # *   0: paper invoice
        # *   1: electronic invoice
        self.invoicing_type = invoicing_type
        self.owner_id = owner_id
        # The channel that is used to process the invoice. A value of 0 indicates that the invoice is processed by Alibaba Cloud. A value of 1 indicates that the invoice is processed by the tax platform. Set the value to 1.
        self.process_way = process_way
        # The IDs of the selected invoicing items. Set the IDs to the IDs returned by calling the QueryEvaluateList operation.
        self.selected_ids = selected_ids
        # The remarks made by the user.
        self.user_remark = user_remark

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address_id is not None:
            result['AddressId'] = self.address_id
        if self.apply_user_nick is not None:
            result['ApplyUserNick'] = self.apply_user_nick
        if self.customer_id is not None:
            result['CustomerId'] = self.customer_id
        if self.invoice_amount is not None:
            result['InvoiceAmount'] = self.invoice_amount
        if self.invoice_by_amount is not None:
            result['InvoiceByAmount'] = self.invoice_by_amount
        if self.invoicing_type is not None:
            result['InvoicingType'] = self.invoicing_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.process_way is not None:
            result['ProcessWay'] = self.process_way
        if self.selected_ids is not None:
            result['SelectedIds'] = self.selected_ids
        if self.user_remark is not None:
            result['UserRemark'] = self.user_remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddressId') is not None:
            self.address_id = m.get('AddressId')
        if m.get('ApplyUserNick') is not None:
            self.apply_user_nick = m.get('ApplyUserNick')
        if m.get('CustomerId') is not None:
            self.customer_id = m.get('CustomerId')
        if m.get('InvoiceAmount') is not None:
            self.invoice_amount = m.get('InvoiceAmount')
        if m.get('InvoiceByAmount') is not None:
            self.invoice_by_amount = m.get('InvoiceByAmount')
        if m.get('InvoicingType') is not None:
            self.invoicing_type = m.get('InvoicingType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProcessWay') is not None:
            self.process_way = m.get('ProcessWay')
        if m.get('SelectedIds') is not None:
            self.selected_ids = m.get('SelectedIds')
        if m.get('UserRemark') is not None:
            self.user_remark = m.get('UserRemark')
        return self


class ApplyInvoiceResponseBodyData(TeaModel):
    def __init__(
        self,
        invoice_apply_id: int = None,
    ):
        # The ID of the application.
        self.invoice_apply_id = invoice_apply_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invoice_apply_id is not None:
            result['InvoiceApplyId'] = self.invoice_apply_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InvoiceApplyId') is not None:
            self.invoice_apply_id = m.get('InvoiceApplyId')
        return self


class ApplyInvoiceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ApplyInvoiceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The error message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ApplyInvoiceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ApplyInvoiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ApplyInvoiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyInvoiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOrderRequest(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        owner_id: int = None,
    ):
        self.order_id = order_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class CancelOrderResponseBodyData(TeaModel):
    def __init__(
        self,
        host_id: str = None,
    ):
        self.host_id = host_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_id is not None:
            result['HostId'] = self.host_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        return self


class CancelOrderResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CancelOrderResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CancelOrderResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeResellerConsumeAmountRequest(TeaModel):
    def __init__(
        self,
        adjust_type: str = None,
        amount: str = None,
        business_type: str = None,
        currency: str = None,
        extend_map: str = None,
        out_biz_id: str = None,
        owner_id: int = None,
        source: str = None,
    ):
        # The type of the consumption amount adjustment. Valid values: increase: The consumption amount increases because new consumption occurs. decrease: The consumption amount decreases because funds are added to the account. This parameter is required.
        self.adjust_type = adjust_type
        # The amount to be adjusted. Unit: CNY
        self.amount = amount
        # The type of the business.
        self.business_type = business_type
        # The type of the currency.
        self.currency = currency
        # The extended field of a message.
        self.extend_map = extend_map
        # The ID of the primary key for external business. The ID is used for idempotence verification.
        self.out_biz_id = out_biz_id
        self.owner_id = owner_id
        # The source of the request. Specify the system name for the parameter.
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_type is not None:
            result['AdjustType'] = self.adjust_type
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.extend_map is not None:
            result['ExtendMap'] = self.extend_map
        if self.out_biz_id is not None:
            result['OutBizId'] = self.out_biz_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjustType') is not None:
            self.adjust_type = m.get('AdjustType')
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('ExtendMap') is not None:
            self.extend_map = m.get('ExtendMap')
        if m.get('OutBizId') is not None:
            self.out_biz_id = m.get('OutBizId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class ChangeResellerConsumeAmountResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code returned if the call failed. For more information, see the "Error codes" section of the topic.
        self.code = code
        # The consumption quota for the quota ledger after adjustment.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call is successful. A value of true indicates that the call is successful. A value of false indicates that the call failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ChangeResellerConsumeAmountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeResellerConsumeAmountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeResellerConsumeAmountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmRelationRequest(TeaModel):
    def __init__(
        self,
        child_user_id: int = None,
        confirm_code: str = None,
        parent_user_id: int = None,
        permission_codes: List[str] = None,
        relation_id: int = None,
        relation_type: str = None,
        request_id: str = None,
    ):
        # The ID of the Alibaba Cloud account that is used as the member.
        self.child_user_id = child_user_id
        # The operation to be performed to confirm the invitation. Valid values:
        # 
        # *   child_agree: The member accepts the invitation.
        # *   child_disagree: The member rejects the invitation.
        # *   Canceled by the master account: The management account cancels the confirmation.
        self.confirm_code = confirm_code
        # The ID of the Alibaba Cloud account that is used as the management account.
        self.parent_user_id = parent_user_id
        # The permissions that can be granted to the member. Valid values:
        # 
        # *   SYNCHRONIZE_FINANCE_IDENTITY: allows the credit control identity to be shared with the member.
        # *   SYNCHRONIZE_FINANCE_DISCOUNT_POLICY_TO_TARGET: allows the discount policy to be shared with the member.
        # *   FORBID_WITHDRAW_CASH: does not allow the member to withdraw the balance.
        # *   FORBID_MANAGE_INVOICE: does not allow the member to manage invoices.
        # *   CHECK_FINANCE_INFO: requests to view information about the financial relationship.
        # *   MANAGE_TARGET_INVOICE: allows the member to manage invoices.
        # *   CHECK_TARGET_CONSUMPTION: allows the member to view the bills.
        self.permission_codes = permission_codes
        # The ID of the financial relationship. Set this parameter to the value of the RelationId response parameter returned by calling the QueryRelationList operation.
        self.relation_id = relation_id
        # The type of the financial relationship. Set the value to enterprise_group.
        self.relation_type = relation_type
        # The unique ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.child_user_id is not None:
            result['ChildUserId'] = self.child_user_id
        if self.confirm_code is not None:
            result['ConfirmCode'] = self.confirm_code
        if self.parent_user_id is not None:
            result['ParentUserId'] = self.parent_user_id
        if self.permission_codes is not None:
            result['PermissionCodes'] = self.permission_codes
        if self.relation_id is not None:
            result['RelationId'] = self.relation_id
        if self.relation_type is not None:
            result['RelationType'] = self.relation_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChildUserId') is not None:
            self.child_user_id = m.get('ChildUserId')
        if m.get('ConfirmCode') is not None:
            self.confirm_code = m.get('ConfirmCode')
        if m.get('ParentUserId') is not None:
            self.parent_user_id = m.get('ParentUserId')
        if m.get('PermissionCodes') is not None:
            self.permission_codes = m.get('PermissionCodes')
        if m.get('RelationId') is not None:
            self.relation_id = m.get('RelationId')
        if m.get('RelationType') is not None:
            self.relation_type = m.get('RelationType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConfirmRelationResponseBodyData(TeaModel):
    def __init__(
        self,
        host_id: str = None,
    ):
        # HostId
        self.host_id = host_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_id is not None:
            result['HostId'] = self.host_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        return self


class ConfirmRelationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ConfirmRelationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The unique ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ConfirmRelationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ConfirmRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConfirmRelationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfirmRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConvertChargeTypeRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        owner_id: int = None,
        period: int = None,
        product_code: str = None,
        product_type: str = None,
        subscription_type: str = None,
    ):
        self.instance_id = instance_id
        self.owner_id = owner_id
        self.period = period
        self.product_code = product_code
        self.product_type = product_type
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class ConvertChargeTypeResponseBodyData(TeaModel):
    def __init__(
        self,
        order_id: str = None,
    ):
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class ConvertChargeTypeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ConvertChargeTypeResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ConvertChargeTypeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ConvertChargeTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConvertChargeTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConvertChargeTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAgAccountRequest(TeaModel):
    def __init__(
        self,
        account_attr: str = None,
        city_name: str = None,
        enterprise_name: str = None,
        first_name: str = None,
        last_name: str = None,
        login_email: str = None,
        nation_code: str = None,
        postcode: str = None,
        province_name: str = None,
    ):
        # The attribute of the account. To view the attribute of the account, use the account to log on to the Alibaba Cloud Management Console, move the pointer over the profile picture in the upper-right corner, and then click **Security Settings**.
        self.account_attr = account_attr
        # The name of the city.
        self.city_name = city_name
        # The name of the enterprise.
        self.enterprise_name = enterprise_name
        # The first name.
        self.first_name = first_name
        # The last name.
        # 
        # The last name can be up to 64 characters in length.
        self.last_name = last_name
        # The email address used to log on to the account.
        self.login_email = login_email
        # The country code.
        self.nation_code = nation_code
        # The zip code.
        self.postcode = postcode
        # The name of the province. This parameter is optional.
        self.province_name = province_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_attr is not None:
            result['AccountAttr'] = self.account_attr
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.enterprise_name is not None:
            result['EnterpriseName'] = self.enterprise_name
        if self.first_name is not None:
            result['FirstName'] = self.first_name
        if self.last_name is not None:
            result['LastName'] = self.last_name
        if self.login_email is not None:
            result['LoginEmail'] = self.login_email
        if self.nation_code is not None:
            result['NationCode'] = self.nation_code
        if self.postcode is not None:
            result['Postcode'] = self.postcode
        if self.province_name is not None:
            result['ProvinceName'] = self.province_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountAttr') is not None:
            self.account_attr = m.get('AccountAttr')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('EnterpriseName') is not None:
            self.enterprise_name = m.get('EnterpriseName')
        if m.get('FirstName') is not None:
            self.first_name = m.get('FirstName')
        if m.get('LastName') is not None:
            self.last_name = m.get('LastName')
        if m.get('LoginEmail') is not None:
            self.login_email = m.get('LoginEmail')
        if m.get('NationCode') is not None:
            self.nation_code = m.get('NationCode')
        if m.get('Postcode') is not None:
            self.postcode = m.get('Postcode')
        if m.get('ProvinceName') is not None:
            self.province_name = m.get('ProvinceName')
        return self


class CreateAgAccountResponseBodyAgRelationDto(TeaModel):
    def __init__(
        self,
        mpk: str = None,
        pk: str = None,
        ram_admin_role_name: str = None,
        type: str = None,
    ):
        # The ID of the account that is used to call the CreateAgAccount operation.
        self.mpk = mpk
        # The ID of the account that is created.
        self.pk = pk
        # The role of the account that is created.
        self.ram_admin_role_name = ram_admin_role_name
        # The type of the relationship.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mpk is not None:
            result['Mpk'] = self.mpk
        if self.pk is not None:
            result['Pk'] = self.pk
        if self.ram_admin_role_name is not None:
            result['RamAdminRoleName'] = self.ram_admin_role_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mpk') is not None:
            self.mpk = m.get('Mpk')
        if m.get('Pk') is not None:
            self.pk = m.get('Pk')
        if m.get('RamAdminRoleName') is not None:
            self.ram_admin_role_name = m.get('RamAdminRoleName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateAgAccountResponseBody(TeaModel):
    def __init__(
        self,
        ag_relation_dto: CreateAgAccountResponseBodyAgRelationDto = None,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The relationship between the account that is used to call the CreateAgAccount operation and the account that is created.
        self.ag_relation_dto = ag_relation_dto
        # The status code returned.
        self.code = code
        # The error message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.ag_relation_dto:
            self.ag_relation_dto.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ag_relation_dto is not None:
            result['AgRelationDto'] = self.ag_relation_dto.to_map()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgRelationDto') is not None:
            temp_model = CreateAgAccountResponseBodyAgRelationDto()
            self.ag_relation_dto = temp_model.from_map(m['AgRelationDto'])
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateAgAccountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAgAccountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAgAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCostUnitRequestUnitEntityList(TeaModel):
    def __init__(
        self,
        owner_uid: int = None,
        parent_unit_id: int = None,
        unit_name: str = None,
    ):
        self.owner_uid = owner_uid
        self.parent_unit_id = parent_unit_id
        self.unit_name = unit_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.parent_unit_id is not None:
            result['ParentUnitId'] = self.parent_unit_id
        if self.unit_name is not None:
            result['UnitName'] = self.unit_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('ParentUnitId') is not None:
            self.parent_unit_id = m.get('ParentUnitId')
        if m.get('UnitName') is not None:
            self.unit_name = m.get('UnitName')
        return self


class CreateCostUnitRequest(TeaModel):
    def __init__(
        self,
        unit_entity_list: List[CreateCostUnitRequestUnitEntityList] = None,
    ):
        self.unit_entity_list = unit_entity_list

    def validate(self):
        if self.unit_entity_list:
            for k in self.unit_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UnitEntityList'] = []
        if self.unit_entity_list is not None:
            for k in self.unit_entity_list:
                result['UnitEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.unit_entity_list = []
        if m.get('UnitEntityList') is not None:
            for k in m.get('UnitEntityList'):
                temp_model = CreateCostUnitRequestUnitEntityList()
                self.unit_entity_list.append(temp_model.from_map(k))
        return self


class CreateCostUnitResponseBodyDataCostUnitDtoList(TeaModel):
    def __init__(
        self,
        owner_uid: int = None,
        parent_unit_id: int = None,
        unit_id: int = None,
        unit_name: str = None,
    ):
        self.owner_uid = owner_uid
        self.parent_unit_id = parent_unit_id
        self.unit_id = unit_id
        self.unit_name = unit_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.parent_unit_id is not None:
            result['ParentUnitId'] = self.parent_unit_id
        if self.unit_id is not None:
            result['UnitId'] = self.unit_id
        if self.unit_name is not None:
            result['UnitName'] = self.unit_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('ParentUnitId') is not None:
            self.parent_unit_id = m.get('ParentUnitId')
        if m.get('UnitId') is not None:
            self.unit_id = m.get('UnitId')
        if m.get('UnitName') is not None:
            self.unit_name = m.get('UnitName')
        return self


class CreateCostUnitResponseBodyData(TeaModel):
    def __init__(
        self,
        cost_unit_dto_list: List[CreateCostUnitResponseBodyDataCostUnitDtoList] = None,
    ):
        self.cost_unit_dto_list = cost_unit_dto_list

    def validate(self):
        if self.cost_unit_dto_list:
            for k in self.cost_unit_dto_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CostUnitDtoList'] = []
        if self.cost_unit_dto_list is not None:
            for k in self.cost_unit_dto_list:
                result['CostUnitDtoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cost_unit_dto_list = []
        if m.get('CostUnitDtoList') is not None:
            for k in m.get('CostUnitDtoList'):
                temp_model = CreateCostUnitResponseBodyDataCostUnitDtoList()
                self.cost_unit_dto_list.append(temp_model.from_map(k))
        return self


class CreateCostUnitResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateCostUnitResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateCostUnitResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateCostUnitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCostUnitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCostUnitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceRequestParameter(TeaModel):
    def __init__(
        self,
        code: str = None,
        value: str = None,
    ):
        # The code property of the Nth module. Value of N: 1 to 100. If multiple module property parameters are involved, concatenate multiple parameters based on the value of N in sequence.
        self.code = code
        # The value property of the Nth module. Value of N: 1 to 100.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateInstanceRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        logistics: str = None,
        owner_id: int = None,
        parameter: List[CreateInstanceRequestParameter] = None,
        period: int = None,
        product_code: str = None,
        product_type: str = None,
        renew_period: int = None,
        renewal_status: str = None,
        subscription_type: str = None,
    ):
        # The client token that is used to ensure the idempotence of the request. The server checks whether a request that uses the same client token has been received. If a request that uses the same client token has been received, the server returns the same request result as the previous request.
        self.client_token = client_token
        # The logistics address of this order. This parameter is generally valid for physical orders.
        self.logistics = logistics
        self.owner_id = owner_id
        # The details of the modules.
        self.parameter = parameter
        # The subscription duration. Unit: month. The value must be an integral multiple of 12.
        # 
        # >  This parameter is required if you create a subscription instance.
        self.period = period
        # The code of the service to which the instance belongs. You can query the service code by calling the **QueryProductList** operation or viewing **Codes of Alibaba Cloud Services**.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type
        # The auto-renewal period. Unit: month.
        # 
        # >  This parameter is required if the **RenewalStatus** parameter is set to **AutoRenewal**.
        self.renew_period = renew_period
        # The renewal method. Valid values:
        # 
        # *   AutoRenewal: The instance is automatically renewed.
        # *   ManualRenewal: The instance is manually renewed.
        # 
        # Default value: ManualRenewal.
        self.renewal_status = renewal_status
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method.
        # *   PayAsYouGo: the pay-as-you-go billing method.
        self.subscription_type = subscription_type

    def validate(self):
        if self.parameter:
            for k in self.parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.logistics is not None:
            result['Logistics'] = self.logistics
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        result['Parameter'] = []
        if self.parameter is not None:
            for k in self.parameter:
                result['Parameter'].append(k.to_map() if k else None)
        if self.period is not None:
            result['Period'] = self.period
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.renew_period is not None:
            result['RenewPeriod'] = self.renew_period
        if self.renewal_status is not None:
            result['RenewalStatus'] = self.renewal_status
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Logistics') is not None:
            self.logistics = m.get('Logistics')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        self.parameter = []
        if m.get('Parameter') is not None:
            for k in m.get('Parameter'):
                temp_model = CreateInstanceRequestParameter()
                self.parameter.append(temp_model.from_map(k))
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RenewPeriod') is not None:
            self.renew_period = m.get('RenewPeriod')
        if m.get('RenewalStatus') is not None:
            self.renewal_status = m.get('RenewalStatus')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class CreateInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        order_id: str = None,
    ):
        # The ID of the instance for which the order was created.
        self.instance_id = instance_id
        # The ID of the order that was created.
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateInstanceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateInstanceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The error message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateResellerUserQuotaRequest(TeaModel):
    def __init__(
        self,
        amount: str = None,
        currency: str = None,
        out_biz_id: str = None,
        owner_id: int = None,
    ):
        # The amount. Unit: CNY. This parameter is required if you create a quota account.
        self.amount = amount
        # The name of the currency.
        self.currency = currency
        # The ID of business in an external system.
        self.out_biz_id = out_biz_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.out_biz_id is not None:
            result['OutBizId'] = self.out_biz_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('OutBizId') is not None:
            self.out_biz_id = m.get('OutBizId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class CreateResellerUserQuotaResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code returned if the call failed. For more information, see the "Error codes" section of this topic.
        self.code = code
        # Indicates whether the request is successful.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call is successful. A value of true indicates that the call is successful. A value of false indicates that the call failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateResellerUserQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateResellerUserQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateResellerUserQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateResourcePackageRequest(TeaModel):
    def __init__(
        self,
        duration: int = None,
        effective_date: str = None,
        owner_id: int = None,
        package_type: str = None,
        pricing_cycle: str = None,
        product_code: str = None,
        specification: str = None,
    ):
        self.duration = duration
        self.effective_date = effective_date
        self.owner_id = owner_id
        self.package_type = package_type
        self.pricing_cycle = pricing_cycle
        self.product_code = product_code
        self.specification = specification

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.effective_date is not None:
            result['EffectiveDate'] = self.effective_date
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.specification is not None:
            result['Specification'] = self.specification
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EffectiveDate') is not None:
            self.effective_date = m.get('EffectiveDate')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        return self


class CreateResourcePackageResponseBodyData(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        order_id: int = None,
    ):
        self.instance_id = instance_id
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateResourcePackageResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateResourcePackageResponseBodyData = None,
        message: str = None,
        order_id: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.order_id = order_id
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateResourcePackageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateResourcePackageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateResourcePackageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateResourcePackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSavingsPlansInstanceRequest(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
        duration: str = None,
        effective_date: str = None,
        pay_mode: str = None,
        pool_value: str = None,
        pricing_cycle: str = None,
        region: str = None,
        spec_type: str = None,
        specification: str = None,
        type: str = None,
    ):
        # The code of the service.
        self.commodity_code = commodity_code
        # The service duration. This parameter is used together with the PricingCycle parameter.
        self.duration = duration
        # The time when the savings plan takes effect. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.effective_date = effective_date
        # The payment mode. Valid values:
        # 
        # *   total: all upfront
        # *   half: partial upfront
        # *   zero: no upfront
        self.pay_mode = pay_mode
        # The contracted amount. unit: CNY
        self.pool_value = pool_value
        # The unit of the service duration. This parameter is used together with the During parameter. Valid values:
        # 
        # *   Year
        # *   Month
        self.pricing_cycle = pricing_cycle
        # The ID of the region in which you create the savings plan. You must specify this parameter if the Type parameter is not set to universal.
        self.region = region
        # The specification type. This parameter is used together with the Specification parameter. You must specify this parameter if the Type parameter is not set to universal. Valid values:
        # 
        # *   group: specification group
        # *   family: specification family
        self.spec_type = spec_type
        # The specifications of the savings plan. This parameter is used together with the SpecType parameter.
        self.specification = specification
        # The type of the savings plan. Valid values:
        # 
        # *   universal: general-purpose type
        # *   ecs: ECS compute type
        # *   elasticy: elastic type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.effective_date is not None:
            result['EffectiveDate'] = self.effective_date
        if self.pay_mode is not None:
            result['PayMode'] = self.pay_mode
        if self.pool_value is not None:
            result['PoolValue'] = self.pool_value
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.region is not None:
            result['Region'] = self.region
        if self.spec_type is not None:
            result['SpecType'] = self.spec_type
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EffectiveDate') is not None:
            self.effective_date = m.get('EffectiveDate')
        if m.get('PayMode') is not None:
            self.pay_mode = m.get('PayMode')
        if m.get('PoolValue') is not None:
            self.pool_value = m.get('PoolValue')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SpecType') is not None:
            self.spec_type = m.get('SpecType')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateSavingsPlansInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        order_id: int = None,
    ):
        # The ID of the order.
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class CreateSavingsPlansInstanceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateSavingsPlansInstanceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The error message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateSavingsPlansInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSavingsPlansInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSavingsPlansInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSavingsPlansInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCostUnitRequest(TeaModel):
    def __init__(
        self,
        owner_uid: int = None,
        unit_id: int = None,
    ):
        self.owner_uid = owner_uid
        self.unit_id = unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.unit_id is not None:
            result['UnitId'] = self.unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('UnitId') is not None:
            self.unit_id = m.get('UnitId')
        return self


class DeleteCostUnitResponseBodyData(TeaModel):
    def __init__(
        self,
        is_success: bool = None,
        owner_uid: int = None,
        unit_id: int = None,
    ):
        self.is_success = is_success
        self.owner_uid = owner_uid
        self.unit_id = unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.unit_id is not None:
            result['UnitId'] = self.unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('UnitId') is not None:
            self.unit_id = m.get('UnitId')
        return self


class DeleteCostUnitResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeleteCostUnitResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteCostUnitResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteCostUnitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCostUnitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCostUnitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCostBudgetsSummaryRequest(TeaModel):
    def __init__(
        self,
        budget_name: str = None,
        budget_status: str = None,
        budget_type: str = None,
        max_results: int = None,
        next_token: str = None,
    ):
        self.budget_name = budget_name
        self.budget_status = budget_status
        self.budget_type = budget_type
        self.max_results = max_results
        self.next_token = next_token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget_name is not None:
            result['BudgetName'] = self.budget_name
        if self.budget_status is not None:
            result['BudgetStatus'] = self.budget_status
        if self.budget_type is not None:
            result['BudgetType'] = self.budget_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BudgetName') is not None:
            self.budget_name = m.get('BudgetName')
        if m.get('BudgetStatus') is not None:
            self.budget_status = m.get('BudgetStatus')
        if m.get('BudgetType') is not None:
            self.budget_type = m.get('BudgetType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class DescribeCostBudgetsSummaryResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        budget: Dict[str, Any] = None,
        budget_name: str = None,
        budget_status: str = None,
        budget_type: str = None,
        calculated_values: Dict[str, Any] = None,
        consume_period: Dict[str, Any] = None,
    ):
        self.budget = budget
        self.budget_name = budget_name
        self.budget_status = budget_status
        self.budget_type = budget_type
        self.calculated_values = calculated_values
        self.consume_period = consume_period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.budget is not None:
            result['Budget'] = self.budget
        if self.budget_name is not None:
            result['BudgetName'] = self.budget_name
        if self.budget_status is not None:
            result['BudgetStatus'] = self.budget_status
        if self.budget_type is not None:
            result['BudgetType'] = self.budget_type
        if self.calculated_values is not None:
            result['CalculatedValues'] = self.calculated_values
        if self.consume_period is not None:
            result['ConsumePeriod'] = self.consume_period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Budget') is not None:
            self.budget = m.get('Budget')
        if m.get('BudgetName') is not None:
            self.budget_name = m.get('BudgetName')
        if m.get('BudgetStatus') is not None:
            self.budget_status = m.get('BudgetStatus')
        if m.get('BudgetType') is not None:
            self.budget_type = m.get('BudgetType')
        if m.get('CalculatedValues') is not None:
            self.calculated_values = m.get('CalculatedValues')
        if m.get('ConsumePeriod') is not None:
            self.consume_period = m.get('ConsumePeriod')
        return self


class DescribeCostBudgetsSummaryResponseBodyData(TeaModel):
    def __init__(
        self,
        host_id: str = None,
        items: List[DescribeCostBudgetsSummaryResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        self.host_id = host_id
        self.items = items
        self.max_results = max_results
        self.next_token = next_token
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_id is not None:
            result['HostId'] = self.host_id
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeCostBudgetsSummaryResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCostBudgetsSummaryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeCostBudgetsSummaryResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeCostBudgetsSummaryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCostBudgetsSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCostBudgetsSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCostBudgetsSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceAmortizedCostByAmortizationPeriodRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id_list: List[str] = None,
        bill_user_id_list: List[str] = None,
        billing_cycle: str = None,
        consume_period_filter: List[str] = None,
        cost_unit_code: str = None,
        instance_id_list: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        product_code: str = None,
        product_detail: str = None,
        subscription_type: str = None,
    ):
        # The ID of the member to which the bill belongs. The member ID is used to filter bills. If you specify a value for this parameter, you can query the bills of the specified member. If you leave this parameter empty, the bills of the current account and all members of the current account are queried. You can specify a maximum of 10 IDs.
        self.bill_owner_id_list = bill_owner_id_list
        # The ID of the member that needs to settle the bill. The member ID is used to filter bills. If you specify a value for this parameter, you can query the bills of the specified member account. If you leave this parameter empty, the bills of the current account and all members of the current account are queried by default. You can specify a maximum of 10 IDs.
        self.bill_user_id_list = bill_user_id_list
        # The allocation month. Format: YYYY-MM.
        self.billing_cycle = billing_cycle
        # The billing cycle that is used to filter bills. You can specify a maximum of 10 billing cycles.
        self.consume_period_filter = consume_period_filter
        # The code of the cost center.
        self.cost_unit_code = cost_unit_code
        # The instance ID that is used to filter bills. You can specify multiple instance IDs to query bills of multiple instances. If you leave this parameter empty, the bills of all instances are queried by default. You can specify a maximum of 10 instance IDs.
        self.instance_id_list = instance_id_list
        # The maximum number of entries to return. Default value: 20. Maximum value: 300.
        self.max_results = max_results
        # The position from which the query starts. The parameter must be left empty or set to the value of the NextToken parameter returned from the last call. Otherwise, an error is returned. If this parameter is left empty, data is queried from the beginning.
        self.next_token = next_token
        # The code of the service. You can obtain the value of this parameter by calling the QueryProductList operation or the DescribeResourcePackageProduct operation.
        self.product_code = product_code
        # The specific service resource.
        self.product_detail = product_detail
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id_list is not None:
            result['BillOwnerIdList'] = self.bill_owner_id_list
        if self.bill_user_id_list is not None:
            result['BillUserIdList'] = self.bill_user_id_list
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.consume_period_filter is not None:
            result['ConsumePeriodFilter'] = self.consume_period_filter
        if self.cost_unit_code is not None:
            result['CostUnitCode'] = self.cost_unit_code
        if self.instance_id_list is not None:
            result['InstanceIdList'] = self.instance_id_list
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerIdList') is not None:
            self.bill_owner_id_list = m.get('BillOwnerIdList')
        if m.get('BillUserIdList') is not None:
            self.bill_user_id_list = m.get('BillUserIdList')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('ConsumePeriodFilter') is not None:
            self.consume_period_filter = m.get('ConsumePeriodFilter')
        if m.get('CostUnitCode') is not None:
            self.cost_unit_code = m.get('CostUnitCode')
        if m.get('InstanceIdList') is not None:
            self.instance_id_list = m.get('InstanceIdList')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class DescribeInstanceAmortizedCostByAmortizationPeriodResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        amortization_period: str = None,
        amortization_status: str = None,
        bill_account_id: int = None,
        bill_account_name: str = None,
        bill_owner_id: int = None,
        bill_owner_name: str = None,
        biz_type: str = None,
        consume_period: str = None,
        cost_unit: str = None,
        cost_unit_code: str = None,
        current_amortization_deducted_by_cash_coupons: float = None,
        current_amortization_deducted_by_coupons: float = None,
        current_amortization_deducted_by_prepaid_card: float = None,
        current_amortization_expenditure_amount: float = None,
        current_amortization_invoice_discount: float = None,
        current_amortization_pretax_amount: float = None,
        current_amortization_pretax_gross_amount: float = None,
        current_amortization_round_down_discount: float = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        expenditure_amount: float = None,
        instance_id: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        invoice_discount: float = None,
        pretax_amount: float = None,
        pretax_gross_amount: float = None,
        previously_amortized_deducted_by_cash_coupons: float = None,
        previously_amortized_deducted_by_coupons: float = None,
        previously_amortized_deducted_by_prepaid_card: float = None,
        previously_amortized_expenditure_amount: float = None,
        previously_amortized_invoice_discount: float = None,
        previously_amortized_pretax_amount: float = None,
        previously_amortized_pretax_gross_amount: float = None,
        previously_amortized_round_down_discount: float = None,
        product_code: str = None,
        product_detail: str = None,
        product_detail_code: str = None,
        product_name: str = None,
        region: str = None,
        remaining_amortization_deducted_by_cash_coupons: float = None,
        remaining_amortization_deducted_by_coupons: float = None,
        remaining_amortization_deducted_by_prepaid_card: float = None,
        remaining_amortization_expenditure_amount: float = None,
        remaining_amortization_invoice_discount: float = None,
        remaining_amortization_pretax_amount: float = None,
        remaining_amortization_pretax_gross_amount: float = None,
        remaining_amortization_round_down_discount: float = None,
        resource_group: str = None,
        round_down_discount: float = None,
        split_account_name: str = None,
        split_item_id: str = None,
        split_item_name: str = None,
        split_product_detail: str = None,
        subscription_type: str = None,
        tag: str = None,
        zone: str = None,
    ):
        # The allocation month. Format: YYYYMM.
        self.amortization_period = amortization_period
        # The allocation status. Valid values:
        # 
        # *   amortized: allocated
        # *   unAmortized: not allocated
        self.amortization_status = amortization_status
        # The ID of the account to which the bill belongs.
        self.bill_account_id = bill_account_id
        # The name of the account to which the bill belongs.
        self.bill_account_name = bill_account_name
        # The ID of the account to which the resource belongs.
        self.bill_owner_id = bill_owner_id
        # The name of the account to which the resource belongs.
        self.bill_owner_name = bill_owner_name
        # The business type.
        self.biz_type = biz_type
        # The billing cycle. Format: YYYYMM.
        self.consume_period = consume_period
        # The cost center.
        self.cost_unit = cost_unit
        # The code of the cost center.
        self.cost_unit_code = cost_unit_code
        # The amount deducted by using vouchers and allocated to the current allocation month.
        self.current_amortization_deducted_by_cash_coupons = current_amortization_deducted_by_cash_coupons
        # The amount deducted by using coupons and allocated to the current allocation month.
        self.current_amortization_deducted_by_coupons = current_amortization_deducted_by_coupons
        # The amount deducted by using prepaid cards and allocated to the current allocation month.
        self.current_amortization_deducted_by_prepaid_card = current_amortization_deducted_by_prepaid_card
        # The expenditure amount allocated to the current allocation month. Invoicing is supported.
        self.current_amortization_expenditure_amount = current_amortization_expenditure_amount
        # The discount amount allocated to the current allocation month.
        self.current_amortization_invoice_discount = current_amortization_invoice_discount
        # The pretax amount allocated to the current allocation month.
        self.current_amortization_pretax_amount = current_amortization_pretax_amount
        # The pretax gross amount allocated to the current allocation month.
        self.current_amortization_pretax_gross_amount = current_amortization_pretax_gross_amount
        # The round-off amount allocated to the current allocation month.
        self.current_amortization_round_down_discount = current_amortization_round_down_discount
        # The amount deducted by using vouchers.
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        # The amount deducted by using coupons.
        self.deducted_by_coupons = deducted_by_coupons
        # The amount deducted by using prepaid cards.
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        # The expenditure amount. Invoicing is supported.
        self.expenditure_amount = expenditure_amount
        # The ID of the instance.
        self.instance_id = instance_id
        # The public IP address of the instance.
        self.internet_ip = internet_ip
        # The private IP address of the instance.
        self.intranet_ip = intranet_ip
        # The discount amount.
        self.invoice_discount = invoice_discount
        # The pretax amount.
        self.pretax_amount = pretax_amount
        # The pretax gross amount.
        self.pretax_gross_amount = pretax_gross_amount
        # The amount deducted by using vouchers and allocated before the current allocation month.
        self.previously_amortized_deducted_by_cash_coupons = previously_amortized_deducted_by_cash_coupons
        # The amount deducted by using coupons and allocated before the current allocation month.
        self.previously_amortized_deducted_by_coupons = previously_amortized_deducted_by_coupons
        # The amount deducted by using prepaid cards and allocated before the current allocation month.
        self.previously_amortized_deducted_by_prepaid_card = previously_amortized_deducted_by_prepaid_card
        # The expenditure amount allocated before the allocation month. Invoicing is supported.
        self.previously_amortized_expenditure_amount = previously_amortized_expenditure_amount
        # The discount amount allocated before the current allocation month.
        self.previously_amortized_invoice_discount = previously_amortized_invoice_discount
        # The pretax amount allocated before the current allocation month.
        self.previously_amortized_pretax_amount = previously_amortized_pretax_amount
        # The pretax gross amount allocated before the current allocation month.
        self.previously_amortized_pretax_gross_amount = previously_amortized_pretax_gross_amount
        # The round-off amount allocated before the current allocation month.
        self.previously_amortized_round_down_discount = previously_amortized_round_down_discount
        # The code of the service.
        self.product_code = product_code
        # The specific service resource.
        self.product_detail = product_detail
        # The code of the specific service resource.
        self.product_detail_code = product_detail_code
        # The name of the service.
        self.product_name = product_name
        # The region.
        self.region = region
        # The amount deducted by using vouchers and to be allocated to one or more future allocation months.
        self.remaining_amortization_deducted_by_cash_coupons = remaining_amortization_deducted_by_cash_coupons
        # The amount deducted by using coupons and to be allocated to one or more future allocation months.
        self.remaining_amortization_deducted_by_coupons = remaining_amortization_deducted_by_coupons
        # The amount deducted by using prepaid cards and to be allocated to one or more future allocation months.
        self.remaining_amortization_deducted_by_prepaid_card = remaining_amortization_deducted_by_prepaid_card
        # The expenditure amount to be allocated to one or more future allocation months. Invoicing is supported.
        self.remaining_amortization_expenditure_amount = remaining_amortization_expenditure_amount
        # The discount amount to be allocated to one or more future allocation months.
        self.remaining_amortization_invoice_discount = remaining_amortization_invoice_discount
        # The pretax amount to be allocated to one or more future allocation months.
        self.remaining_amortization_pretax_amount = remaining_amortization_pretax_amount
        # The pretax gross amount to be allocated to one or more future allocation months.
        self.remaining_amortization_pretax_gross_amount = remaining_amortization_pretax_gross_amount
        # The round-off amount to be allocated to one or more future allocation months.
        self.remaining_amortization_round_down_discount = remaining_amortization_round_down_discount
        # The name of the resource group.
        self.resource_group = resource_group
        # The round-off amount.
        self.round_down_discount = round_down_discount
        # The name of the account to which the split item belongs.
        self.split_account_name = split_account_name
        # The ID of the split item.
        self.split_item_id = split_item_id
        # The name of the split item.
        self.split_item_name = split_item_name
        # The name of the specific service resource to which the split item belongs.
        self.split_product_detail = split_product_detail
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        self.subscription_type = subscription_type
        # The tag of the instance.
        self.tag = tag
        # The ID of the zone.
        self.zone = zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amortization_period is not None:
            result['AmortizationPeriod'] = self.amortization_period
        if self.amortization_status is not None:
            result['AmortizationStatus'] = self.amortization_status
        if self.bill_account_id is not None:
            result['BillAccountID'] = self.bill_account_id
        if self.bill_account_name is not None:
            result['BillAccountName'] = self.bill_account_name
        if self.bill_owner_id is not None:
            result['BillOwnerID'] = self.bill_owner_id
        if self.bill_owner_name is not None:
            result['BillOwnerName'] = self.bill_owner_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.consume_period is not None:
            result['ConsumePeriod'] = self.consume_period
        if self.cost_unit is not None:
            result['CostUnit'] = self.cost_unit
        if self.cost_unit_code is not None:
            result['CostUnitCode'] = self.cost_unit_code
        if self.current_amortization_deducted_by_cash_coupons is not None:
            result['CurrentAmortizationDeductedByCashCoupons'] = self.current_amortization_deducted_by_cash_coupons
        if self.current_amortization_deducted_by_coupons is not None:
            result['CurrentAmortizationDeductedByCoupons'] = self.current_amortization_deducted_by_coupons
        if self.current_amortization_deducted_by_prepaid_card is not None:
            result['CurrentAmortizationDeductedByPrepaidCard'] = self.current_amortization_deducted_by_prepaid_card
        if self.current_amortization_expenditure_amount is not None:
            result['CurrentAmortizationExpenditureAmount'] = self.current_amortization_expenditure_amount
        if self.current_amortization_invoice_discount is not None:
            result['CurrentAmortizationInvoiceDiscount'] = self.current_amortization_invoice_discount
        if self.current_amortization_pretax_amount is not None:
            result['CurrentAmortizationPretaxAmount'] = self.current_amortization_pretax_amount
        if self.current_amortization_pretax_gross_amount is not None:
            result['CurrentAmortizationPretaxGrossAmount'] = self.current_amortization_pretax_gross_amount
        if self.current_amortization_round_down_discount is not None:
            result['CurrentAmortizationRoundDownDiscount'] = self.current_amortization_round_down_discount
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.expenditure_amount is not None:
            result['ExpenditureAmount'] = self.expenditure_amount
        if self.instance_id is not None:
            result['InstanceID'] = self.instance_id
        if self.internet_ip is not None:
            result['InternetIP'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIP'] = self.intranet_ip
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.previously_amortized_deducted_by_cash_coupons is not None:
            result['PreviouslyAmortizedDeductedByCashCoupons'] = self.previously_amortized_deducted_by_cash_coupons
        if self.previously_amortized_deducted_by_coupons is not None:
            result['PreviouslyAmortizedDeductedByCoupons'] = self.previously_amortized_deducted_by_coupons
        if self.previously_amortized_deducted_by_prepaid_card is not None:
            result['PreviouslyAmortizedDeductedByPrepaidCard'] = self.previously_amortized_deducted_by_prepaid_card
        if self.previously_amortized_expenditure_amount is not None:
            result['PreviouslyAmortizedExpenditureAmount'] = self.previously_amortized_expenditure_amount
        if self.previously_amortized_invoice_discount is not None:
            result['PreviouslyAmortizedInvoiceDiscount'] = self.previously_amortized_invoice_discount
        if self.previously_amortized_pretax_amount is not None:
            result['PreviouslyAmortizedPretaxAmount'] = self.previously_amortized_pretax_amount
        if self.previously_amortized_pretax_gross_amount is not None:
            result['PreviouslyAmortizedPretaxGrossAmount'] = self.previously_amortized_pretax_gross_amount
        if self.previously_amortized_round_down_discount is not None:
            result['PreviouslyAmortizedRoundDownDiscount'] = self.previously_amortized_round_down_discount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.product_detail_code is not None:
            result['ProductDetailCode'] = self.product_detail_code
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.region is not None:
            result['Region'] = self.region
        if self.remaining_amortization_deducted_by_cash_coupons is not None:
            result['RemainingAmortizationDeductedByCashCoupons'] = self.remaining_amortization_deducted_by_cash_coupons
        if self.remaining_amortization_deducted_by_coupons is not None:
            result['RemainingAmortizationDeductedByCoupons'] = self.remaining_amortization_deducted_by_coupons
        if self.remaining_amortization_deducted_by_prepaid_card is not None:
            result['RemainingAmortizationDeductedByPrepaidCard'] = self.remaining_amortization_deducted_by_prepaid_card
        if self.remaining_amortization_expenditure_amount is not None:
            result['RemainingAmortizationExpenditureAmount'] = self.remaining_amortization_expenditure_amount
        if self.remaining_amortization_invoice_discount is not None:
            result['RemainingAmortizationInvoiceDiscount'] = self.remaining_amortization_invoice_discount
        if self.remaining_amortization_pretax_amount is not None:
            result['RemainingAmortizationPretaxAmount'] = self.remaining_amortization_pretax_amount
        if self.remaining_amortization_pretax_gross_amount is not None:
            result['RemainingAmortizationPretaxGrossAmount'] = self.remaining_amortization_pretax_gross_amount
        if self.remaining_amortization_round_down_discount is not None:
            result['RemainingAmortizationRoundDownDiscount'] = self.remaining_amortization_round_down_discount
        if self.resource_group is not None:
            result['ResourceGroup'] = self.resource_group
        if self.round_down_discount is not None:
            result['RoundDownDiscount'] = self.round_down_discount
        if self.split_account_name is not None:
            result['SplitAccountName'] = self.split_account_name
        if self.split_item_id is not None:
            result['SplitItemID'] = self.split_item_id
        if self.split_item_name is not None:
            result['SplitItemName'] = self.split_item_name
        if self.split_product_detail is not None:
            result['SplitProductDetail'] = self.split_product_detail
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.zone is not None:
            result['Zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AmortizationPeriod') is not None:
            self.amortization_period = m.get('AmortizationPeriod')
        if m.get('AmortizationStatus') is not None:
            self.amortization_status = m.get('AmortizationStatus')
        if m.get('BillAccountID') is not None:
            self.bill_account_id = m.get('BillAccountID')
        if m.get('BillAccountName') is not None:
            self.bill_account_name = m.get('BillAccountName')
        if m.get('BillOwnerID') is not None:
            self.bill_owner_id = m.get('BillOwnerID')
        if m.get('BillOwnerName') is not None:
            self.bill_owner_name = m.get('BillOwnerName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('ConsumePeriod') is not None:
            self.consume_period = m.get('ConsumePeriod')
        if m.get('CostUnit') is not None:
            self.cost_unit = m.get('CostUnit')
        if m.get('CostUnitCode') is not None:
            self.cost_unit_code = m.get('CostUnitCode')
        if m.get('CurrentAmortizationDeductedByCashCoupons') is not None:
            self.current_amortization_deducted_by_cash_coupons = m.get('CurrentAmortizationDeductedByCashCoupons')
        if m.get('CurrentAmortizationDeductedByCoupons') is not None:
            self.current_amortization_deducted_by_coupons = m.get('CurrentAmortizationDeductedByCoupons')
        if m.get('CurrentAmortizationDeductedByPrepaidCard') is not None:
            self.current_amortization_deducted_by_prepaid_card = m.get('CurrentAmortizationDeductedByPrepaidCard')
        if m.get('CurrentAmortizationExpenditureAmount') is not None:
            self.current_amortization_expenditure_amount = m.get('CurrentAmortizationExpenditureAmount')
        if m.get('CurrentAmortizationInvoiceDiscount') is not None:
            self.current_amortization_invoice_discount = m.get('CurrentAmortizationInvoiceDiscount')
        if m.get('CurrentAmortizationPretaxAmount') is not None:
            self.current_amortization_pretax_amount = m.get('CurrentAmortizationPretaxAmount')
        if m.get('CurrentAmortizationPretaxGrossAmount') is not None:
            self.current_amortization_pretax_gross_amount = m.get('CurrentAmortizationPretaxGrossAmount')
        if m.get('CurrentAmortizationRoundDownDiscount') is not None:
            self.current_amortization_round_down_discount = m.get('CurrentAmortizationRoundDownDiscount')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('ExpenditureAmount') is not None:
            self.expenditure_amount = m.get('ExpenditureAmount')
        if m.get('InstanceID') is not None:
            self.instance_id = m.get('InstanceID')
        if m.get('InternetIP') is not None:
            self.internet_ip = m.get('InternetIP')
        if m.get('IntranetIP') is not None:
            self.intranet_ip = m.get('IntranetIP')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('PreviouslyAmortizedDeductedByCashCoupons') is not None:
            self.previously_amortized_deducted_by_cash_coupons = m.get('PreviouslyAmortizedDeductedByCashCoupons')
        if m.get('PreviouslyAmortizedDeductedByCoupons') is not None:
            self.previously_amortized_deducted_by_coupons = m.get('PreviouslyAmortizedDeductedByCoupons')
        if m.get('PreviouslyAmortizedDeductedByPrepaidCard') is not None:
            self.previously_amortized_deducted_by_prepaid_card = m.get('PreviouslyAmortizedDeductedByPrepaidCard')
        if m.get('PreviouslyAmortizedExpenditureAmount') is not None:
            self.previously_amortized_expenditure_amount = m.get('PreviouslyAmortizedExpenditureAmount')
        if m.get('PreviouslyAmortizedInvoiceDiscount') is not None:
            self.previously_amortized_invoice_discount = m.get('PreviouslyAmortizedInvoiceDiscount')
        if m.get('PreviouslyAmortizedPretaxAmount') is not None:
            self.previously_amortized_pretax_amount = m.get('PreviouslyAmortizedPretaxAmount')
        if m.get('PreviouslyAmortizedPretaxGrossAmount') is not None:
            self.previously_amortized_pretax_gross_amount = m.get('PreviouslyAmortizedPretaxGrossAmount')
        if m.get('PreviouslyAmortizedRoundDownDiscount') is not None:
            self.previously_amortized_round_down_discount = m.get('PreviouslyAmortizedRoundDownDiscount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('ProductDetailCode') is not None:
            self.product_detail_code = m.get('ProductDetailCode')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RemainingAmortizationDeductedByCashCoupons') is not None:
            self.remaining_amortization_deducted_by_cash_coupons = m.get('RemainingAmortizationDeductedByCashCoupons')
        if m.get('RemainingAmortizationDeductedByCoupons') is not None:
            self.remaining_amortization_deducted_by_coupons = m.get('RemainingAmortizationDeductedByCoupons')
        if m.get('RemainingAmortizationDeductedByPrepaidCard') is not None:
            self.remaining_amortization_deducted_by_prepaid_card = m.get('RemainingAmortizationDeductedByPrepaidCard')
        if m.get('RemainingAmortizationExpenditureAmount') is not None:
            self.remaining_amortization_expenditure_amount = m.get('RemainingAmortizationExpenditureAmount')
        if m.get('RemainingAmortizationInvoiceDiscount') is not None:
            self.remaining_amortization_invoice_discount = m.get('RemainingAmortizationInvoiceDiscount')
        if m.get('RemainingAmortizationPretaxAmount') is not None:
            self.remaining_amortization_pretax_amount = m.get('RemainingAmortizationPretaxAmount')
        if m.get('RemainingAmortizationPretaxGrossAmount') is not None:
            self.remaining_amortization_pretax_gross_amount = m.get('RemainingAmortizationPretaxGrossAmount')
        if m.get('RemainingAmortizationRoundDownDiscount') is not None:
            self.remaining_amortization_round_down_discount = m.get('RemainingAmortizationRoundDownDiscount')
        if m.get('ResourceGroup') is not None:
            self.resource_group = m.get('ResourceGroup')
        if m.get('RoundDownDiscount') is not None:
            self.round_down_discount = m.get('RoundDownDiscount')
        if m.get('SplitAccountName') is not None:
            self.split_account_name = m.get('SplitAccountName')
        if m.get('SplitItemID') is not None:
            self.split_item_id = m.get('SplitItemID')
        if m.get('SplitItemName') is not None:
            self.split_item_name = m.get('SplitItemName')
        if m.get('SplitProductDetail') is not None:
            self.split_product_detail = m.get('SplitProductDetail')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        return self


class DescribeInstanceAmortizedCostByAmortizationPeriodResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        items: List[DescribeInstanceAmortizedCostByAmortizationPeriodResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        # The ID of the account.
        self.account_id = account_id
        # The name of the account.
        self.account_name = account_name
        # The data entries returned.
        self.items = items
        # The maximum number of entries returned.
        self.max_results = max_results
        # The position from which the results started to return. The parameter must be left empty or set to the value of the NextToken parameter returned from the last call. Otherwise, an error is returned. If this parameter is left empty, data is queried from the beginning.
        self.next_token = next_token
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeInstanceAmortizedCostByAmortizationPeriodResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstanceAmortizedCostByAmortizationPeriodResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeInstanceAmortizedCostByAmortizationPeriodResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeInstanceAmortizedCostByAmortizationPeriodResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeInstanceAmortizedCostByAmortizationPeriodResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceAmortizedCostByAmortizationPeriodResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceAmortizedCostByAmortizationPeriodResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceAmortizedCostByConsumePeriodRequest(TeaModel):
    def __init__(
        self,
        amortization_period_filter: List[str] = None,
        bill_owner_id_list: List[str] = None,
        bill_user_id_list: List[str] = None,
        billing_cycle: str = None,
        cost_unit_code: str = None,
        instance_id_list: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        product_code: str = None,
        product_detail: str = None,
        subscription_type: str = None,
    ):
        self.amortization_period_filter = amortization_period_filter
        self.bill_owner_id_list = bill_owner_id_list
        self.bill_user_id_list = bill_user_id_list
        self.billing_cycle = billing_cycle
        self.cost_unit_code = cost_unit_code
        self.instance_id_list = instance_id_list
        self.max_results = max_results
        self.next_token = next_token
        self.product_code = product_code
        self.product_detail = product_detail
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amortization_period_filter is not None:
            result['AmortizationPeriodFilter'] = self.amortization_period_filter
        if self.bill_owner_id_list is not None:
            result['BillOwnerIdList'] = self.bill_owner_id_list
        if self.bill_user_id_list is not None:
            result['BillUserIdList'] = self.bill_user_id_list
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.cost_unit_code is not None:
            result['CostUnitCode'] = self.cost_unit_code
        if self.instance_id_list is not None:
            result['InstanceIdList'] = self.instance_id_list
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AmortizationPeriodFilter') is not None:
            self.amortization_period_filter = m.get('AmortizationPeriodFilter')
        if m.get('BillOwnerIdList') is not None:
            self.bill_owner_id_list = m.get('BillOwnerIdList')
        if m.get('BillUserIdList') is not None:
            self.bill_user_id_list = m.get('BillUserIdList')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('CostUnitCode') is not None:
            self.cost_unit_code = m.get('CostUnitCode')
        if m.get('InstanceIdList') is not None:
            self.instance_id_list = m.get('InstanceIdList')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class DescribeInstanceAmortizedCostByConsumePeriodResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        amortization_period: str = None,
        amortization_status: str = None,
        bill_account_id: int = None,
        bill_account_name: str = None,
        bill_owner_id: int = None,
        bill_owner_name: str = None,
        biz_type: str = None,
        consume_period: str = None,
        cost_unit: str = None,
        cost_unit_code: str = None,
        current_amortization_deducted_by_cash_coupons: float = None,
        current_amortization_deducted_by_coupons: float = None,
        current_amortization_deducted_by_prepaid_card: float = None,
        current_amortization_expenditure_amount: float = None,
        current_amortization_invoice_discount: float = None,
        current_amortization_pretax_amount: float = None,
        current_amortization_pretax_gross_amount: float = None,
        current_amortization_round_down_discount: float = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        expenditure_amount: float = None,
        instance_id: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        invoice_discount: float = None,
        pretax_amount: float = None,
        pretax_gross_amount: float = None,
        previously_amortized_deducted_by_cash_coupons: float = None,
        previously_amortized_deducted_by_coupons: float = None,
        previously_amortized_deducted_by_prepaid_card: float = None,
        previously_amortized_expenditure_amount: float = None,
        previously_amortized_invoice_discount: float = None,
        previously_amortized_pretax_amount: float = None,
        previously_amortized_pretax_gross_amount: float = None,
        previously_amortized_round_down_discount: float = None,
        product_code: str = None,
        product_detail: str = None,
        product_detail_code: str = None,
        product_name: str = None,
        region: str = None,
        remaining_amortization_deducted_by_cash_coupons: float = None,
        remaining_amortization_deducted_by_coupons: float = None,
        remaining_amortization_deducted_by_prepaid_card: float = None,
        remaining_amortization_expenditure_amount: float = None,
        remaining_amortization_invoice_discount: float = None,
        remaining_amortization_pretax_amount: float = None,
        remaining_amortization_pretax_gross_amount: float = None,
        remaining_amortization_round_down_discount: float = None,
        resource_group: str = None,
        round_down_discount: float = None,
        split_account_name: str = None,
        split_item_id: str = None,
        split_item_name: str = None,
        split_product_detail: str = None,
        subscription_type: str = None,
        tag: str = None,
        zone: str = None,
    ):
        self.amortization_period = amortization_period
        self.amortization_status = amortization_status
        self.bill_account_id = bill_account_id
        self.bill_account_name = bill_account_name
        self.bill_owner_id = bill_owner_id
        self.bill_owner_name = bill_owner_name
        self.biz_type = biz_type
        self.consume_period = consume_period
        self.cost_unit = cost_unit
        self.cost_unit_code = cost_unit_code
        self.current_amortization_deducted_by_cash_coupons = current_amortization_deducted_by_cash_coupons
        self.current_amortization_deducted_by_coupons = current_amortization_deducted_by_coupons
        self.current_amortization_deducted_by_prepaid_card = current_amortization_deducted_by_prepaid_card
        self.current_amortization_expenditure_amount = current_amortization_expenditure_amount
        self.current_amortization_invoice_discount = current_amortization_invoice_discount
        self.current_amortization_pretax_amount = current_amortization_pretax_amount
        self.current_amortization_pretax_gross_amount = current_amortization_pretax_gross_amount
        self.current_amortization_round_down_discount = current_amortization_round_down_discount
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        self.deducted_by_coupons = deducted_by_coupons
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        self.expenditure_amount = expenditure_amount
        self.instance_id = instance_id
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.invoice_discount = invoice_discount
        self.pretax_amount = pretax_amount
        self.pretax_gross_amount = pretax_gross_amount
        self.previously_amortized_deducted_by_cash_coupons = previously_amortized_deducted_by_cash_coupons
        self.previously_amortized_deducted_by_coupons = previously_amortized_deducted_by_coupons
        self.previously_amortized_deducted_by_prepaid_card = previously_amortized_deducted_by_prepaid_card
        self.previously_amortized_expenditure_amount = previously_amortized_expenditure_amount
        self.previously_amortized_invoice_discount = previously_amortized_invoice_discount
        self.previously_amortized_pretax_amount = previously_amortized_pretax_amount
        self.previously_amortized_pretax_gross_amount = previously_amortized_pretax_gross_amount
        self.previously_amortized_round_down_discount = previously_amortized_round_down_discount
        self.product_code = product_code
        self.product_detail = product_detail
        self.product_detail_code = product_detail_code
        self.product_name = product_name
        self.region = region
        self.remaining_amortization_deducted_by_cash_coupons = remaining_amortization_deducted_by_cash_coupons
        self.remaining_amortization_deducted_by_coupons = remaining_amortization_deducted_by_coupons
        self.remaining_amortization_deducted_by_prepaid_card = remaining_amortization_deducted_by_prepaid_card
        self.remaining_amortization_expenditure_amount = remaining_amortization_expenditure_amount
        self.remaining_amortization_invoice_discount = remaining_amortization_invoice_discount
        self.remaining_amortization_pretax_amount = remaining_amortization_pretax_amount
        self.remaining_amortization_pretax_gross_amount = remaining_amortization_pretax_gross_amount
        self.remaining_amortization_round_down_discount = remaining_amortization_round_down_discount
        self.resource_group = resource_group
        self.round_down_discount = round_down_discount
        self.split_account_name = split_account_name
        self.split_item_id = split_item_id
        self.split_item_name = split_item_name
        self.split_product_detail = split_product_detail
        self.subscription_type = subscription_type
        self.tag = tag
        self.zone = zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amortization_period is not None:
            result['AmortizationPeriod'] = self.amortization_period
        if self.amortization_status is not None:
            result['AmortizationStatus'] = self.amortization_status
        if self.bill_account_id is not None:
            result['BillAccountID'] = self.bill_account_id
        if self.bill_account_name is not None:
            result['BillAccountName'] = self.bill_account_name
        if self.bill_owner_id is not None:
            result['BillOwnerID'] = self.bill_owner_id
        if self.bill_owner_name is not None:
            result['BillOwnerName'] = self.bill_owner_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.consume_period is not None:
            result['ConsumePeriod'] = self.consume_period
        if self.cost_unit is not None:
            result['CostUnit'] = self.cost_unit
        if self.cost_unit_code is not None:
            result['CostUnitCode'] = self.cost_unit_code
        if self.current_amortization_deducted_by_cash_coupons is not None:
            result['CurrentAmortizationDeductedByCashCoupons'] = self.current_amortization_deducted_by_cash_coupons
        if self.current_amortization_deducted_by_coupons is not None:
            result['CurrentAmortizationDeductedByCoupons'] = self.current_amortization_deducted_by_coupons
        if self.current_amortization_deducted_by_prepaid_card is not None:
            result['CurrentAmortizationDeductedByPrepaidCard'] = self.current_amortization_deducted_by_prepaid_card
        if self.current_amortization_expenditure_amount is not None:
            result['CurrentAmortizationExpenditureAmount'] = self.current_amortization_expenditure_amount
        if self.current_amortization_invoice_discount is not None:
            result['CurrentAmortizationInvoiceDiscount'] = self.current_amortization_invoice_discount
        if self.current_amortization_pretax_amount is not None:
            result['CurrentAmortizationPretaxAmount'] = self.current_amortization_pretax_amount
        if self.current_amortization_pretax_gross_amount is not None:
            result['CurrentAmortizationPretaxGrossAmount'] = self.current_amortization_pretax_gross_amount
        if self.current_amortization_round_down_discount is not None:
            result['CurrentAmortizationRoundDownDiscount'] = self.current_amortization_round_down_discount
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.expenditure_amount is not None:
            result['ExpenditureAmount'] = self.expenditure_amount
        if self.instance_id is not None:
            result['InstanceID'] = self.instance_id
        if self.internet_ip is not None:
            result['InternetIP'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIP'] = self.intranet_ip
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.previously_amortized_deducted_by_cash_coupons is not None:
            result['PreviouslyAmortizedDeductedByCashCoupons'] = self.previously_amortized_deducted_by_cash_coupons
        if self.previously_amortized_deducted_by_coupons is not None:
            result['PreviouslyAmortizedDeductedByCoupons'] = self.previously_amortized_deducted_by_coupons
        if self.previously_amortized_deducted_by_prepaid_card is not None:
            result['PreviouslyAmortizedDeductedByPrepaidCard'] = self.previously_amortized_deducted_by_prepaid_card
        if self.previously_amortized_expenditure_amount is not None:
            result['PreviouslyAmortizedExpenditureAmount'] = self.previously_amortized_expenditure_amount
        if self.previously_amortized_invoice_discount is not None:
            result['PreviouslyAmortizedInvoiceDiscount'] = self.previously_amortized_invoice_discount
        if self.previously_amortized_pretax_amount is not None:
            result['PreviouslyAmortizedPretaxAmount'] = self.previously_amortized_pretax_amount
        if self.previously_amortized_pretax_gross_amount is not None:
            result['PreviouslyAmortizedPretaxGrossAmount'] = self.previously_amortized_pretax_gross_amount
        if self.previously_amortized_round_down_discount is not None:
            result['PreviouslyAmortizedRoundDownDiscount'] = self.previously_amortized_round_down_discount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.product_detail_code is not None:
            result['ProductDetailCode'] = self.product_detail_code
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.region is not None:
            result['Region'] = self.region
        if self.remaining_amortization_deducted_by_cash_coupons is not None:
            result['RemainingAmortizationDeductedByCashCoupons'] = self.remaining_amortization_deducted_by_cash_coupons
        if self.remaining_amortization_deducted_by_coupons is not None:
            result['RemainingAmortizationDeductedByCoupons'] = self.remaining_amortization_deducted_by_coupons
        if self.remaining_amortization_deducted_by_prepaid_card is not None:
            result['RemainingAmortizationDeductedByPrepaidCard'] = self.remaining_amortization_deducted_by_prepaid_card
        if self.remaining_amortization_expenditure_amount is not None:
            result['RemainingAmortizationExpenditureAmount'] = self.remaining_amortization_expenditure_amount
        if self.remaining_amortization_invoice_discount is not None:
            result['RemainingAmortizationInvoiceDiscount'] = self.remaining_amortization_invoice_discount
        if self.remaining_amortization_pretax_amount is not None:
            result['RemainingAmortizationPretaxAmount'] = self.remaining_amortization_pretax_amount
        if self.remaining_amortization_pretax_gross_amount is not None:
            result['RemainingAmortizationPretaxGrossAmount'] = self.remaining_amortization_pretax_gross_amount
        if self.remaining_amortization_round_down_discount is not None:
            result['RemainingAmortizationRoundDownDiscount'] = self.remaining_amortization_round_down_discount
        if self.resource_group is not None:
            result['ResourceGroup'] = self.resource_group
        if self.round_down_discount is not None:
            result['RoundDownDiscount'] = self.round_down_discount
        if self.split_account_name is not None:
            result['SplitAccountName'] = self.split_account_name
        if self.split_item_id is not None:
            result['SplitItemID'] = self.split_item_id
        if self.split_item_name is not None:
            result['SplitItemName'] = self.split_item_name
        if self.split_product_detail is not None:
            result['SplitProductDetail'] = self.split_product_detail
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.zone is not None:
            result['Zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AmortizationPeriod') is not None:
            self.amortization_period = m.get('AmortizationPeriod')
        if m.get('AmortizationStatus') is not None:
            self.amortization_status = m.get('AmortizationStatus')
        if m.get('BillAccountID') is not None:
            self.bill_account_id = m.get('BillAccountID')
        if m.get('BillAccountName') is not None:
            self.bill_account_name = m.get('BillAccountName')
        if m.get('BillOwnerID') is not None:
            self.bill_owner_id = m.get('BillOwnerID')
        if m.get('BillOwnerName') is not None:
            self.bill_owner_name = m.get('BillOwnerName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('ConsumePeriod') is not None:
            self.consume_period = m.get('ConsumePeriod')
        if m.get('CostUnit') is not None:
            self.cost_unit = m.get('CostUnit')
        if m.get('CostUnitCode') is not None:
            self.cost_unit_code = m.get('CostUnitCode')
        if m.get('CurrentAmortizationDeductedByCashCoupons') is not None:
            self.current_amortization_deducted_by_cash_coupons = m.get('CurrentAmortizationDeductedByCashCoupons')
        if m.get('CurrentAmortizationDeductedByCoupons') is not None:
            self.current_amortization_deducted_by_coupons = m.get('CurrentAmortizationDeductedByCoupons')
        if m.get('CurrentAmortizationDeductedByPrepaidCard') is not None:
            self.current_amortization_deducted_by_prepaid_card = m.get('CurrentAmortizationDeductedByPrepaidCard')
        if m.get('CurrentAmortizationExpenditureAmount') is not None:
            self.current_amortization_expenditure_amount = m.get('CurrentAmortizationExpenditureAmount')
        if m.get('CurrentAmortizationInvoiceDiscount') is not None:
            self.current_amortization_invoice_discount = m.get('CurrentAmortizationInvoiceDiscount')
        if m.get('CurrentAmortizationPretaxAmount') is not None:
            self.current_amortization_pretax_amount = m.get('CurrentAmortizationPretaxAmount')
        if m.get('CurrentAmortizationPretaxGrossAmount') is not None:
            self.current_amortization_pretax_gross_amount = m.get('CurrentAmortizationPretaxGrossAmount')
        if m.get('CurrentAmortizationRoundDownDiscount') is not None:
            self.current_amortization_round_down_discount = m.get('CurrentAmortizationRoundDownDiscount')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('ExpenditureAmount') is not None:
            self.expenditure_amount = m.get('ExpenditureAmount')
        if m.get('InstanceID') is not None:
            self.instance_id = m.get('InstanceID')
        if m.get('InternetIP') is not None:
            self.internet_ip = m.get('InternetIP')
        if m.get('IntranetIP') is not None:
            self.intranet_ip = m.get('IntranetIP')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('PreviouslyAmortizedDeductedByCashCoupons') is not None:
            self.previously_amortized_deducted_by_cash_coupons = m.get('PreviouslyAmortizedDeductedByCashCoupons')
        if m.get('PreviouslyAmortizedDeductedByCoupons') is not None:
            self.previously_amortized_deducted_by_coupons = m.get('PreviouslyAmortizedDeductedByCoupons')
        if m.get('PreviouslyAmortizedDeductedByPrepaidCard') is not None:
            self.previously_amortized_deducted_by_prepaid_card = m.get('PreviouslyAmortizedDeductedByPrepaidCard')
        if m.get('PreviouslyAmortizedExpenditureAmount') is not None:
            self.previously_amortized_expenditure_amount = m.get('PreviouslyAmortizedExpenditureAmount')
        if m.get('PreviouslyAmortizedInvoiceDiscount') is not None:
            self.previously_amortized_invoice_discount = m.get('PreviouslyAmortizedInvoiceDiscount')
        if m.get('PreviouslyAmortizedPretaxAmount') is not None:
            self.previously_amortized_pretax_amount = m.get('PreviouslyAmortizedPretaxAmount')
        if m.get('PreviouslyAmortizedPretaxGrossAmount') is not None:
            self.previously_amortized_pretax_gross_amount = m.get('PreviouslyAmortizedPretaxGrossAmount')
        if m.get('PreviouslyAmortizedRoundDownDiscount') is not None:
            self.previously_amortized_round_down_discount = m.get('PreviouslyAmortizedRoundDownDiscount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('ProductDetailCode') is not None:
            self.product_detail_code = m.get('ProductDetailCode')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RemainingAmortizationDeductedByCashCoupons') is not None:
            self.remaining_amortization_deducted_by_cash_coupons = m.get('RemainingAmortizationDeductedByCashCoupons')
        if m.get('RemainingAmortizationDeductedByCoupons') is not None:
            self.remaining_amortization_deducted_by_coupons = m.get('RemainingAmortizationDeductedByCoupons')
        if m.get('RemainingAmortizationDeductedByPrepaidCard') is not None:
            self.remaining_amortization_deducted_by_prepaid_card = m.get('RemainingAmortizationDeductedByPrepaidCard')
        if m.get('RemainingAmortizationExpenditureAmount') is not None:
            self.remaining_amortization_expenditure_amount = m.get('RemainingAmortizationExpenditureAmount')
        if m.get('RemainingAmortizationInvoiceDiscount') is not None:
            self.remaining_amortization_invoice_discount = m.get('RemainingAmortizationInvoiceDiscount')
        if m.get('RemainingAmortizationPretaxAmount') is not None:
            self.remaining_amortization_pretax_amount = m.get('RemainingAmortizationPretaxAmount')
        if m.get('RemainingAmortizationPretaxGrossAmount') is not None:
            self.remaining_amortization_pretax_gross_amount = m.get('RemainingAmortizationPretaxGrossAmount')
        if m.get('RemainingAmortizationRoundDownDiscount') is not None:
            self.remaining_amortization_round_down_discount = m.get('RemainingAmortizationRoundDownDiscount')
        if m.get('ResourceGroup') is not None:
            self.resource_group = m.get('ResourceGroup')
        if m.get('RoundDownDiscount') is not None:
            self.round_down_discount = m.get('RoundDownDiscount')
        if m.get('SplitAccountName') is not None:
            self.split_account_name = m.get('SplitAccountName')
        if m.get('SplitItemID') is not None:
            self.split_item_id = m.get('SplitItemID')
        if m.get('SplitItemName') is not None:
            self.split_item_name = m.get('SplitItemName')
        if m.get('SplitProductDetail') is not None:
            self.split_product_detail = m.get('SplitProductDetail')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        return self


class DescribeInstanceAmortizedCostByConsumePeriodResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        items: List[DescribeInstanceAmortizedCostByConsumePeriodResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        self.account_id = account_id
        self.account_name = account_name
        self.items = items
        self.max_results = max_results
        self.next_token = next_token
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeInstanceAmortizedCostByConsumePeriodResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstanceAmortizedCostByConsumePeriodResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeInstanceAmortizedCostByConsumePeriodResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeInstanceAmortizedCostByConsumePeriodResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeInstanceAmortizedCostByConsumePeriodResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceAmortizedCostByConsumePeriodResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceAmortizedCostByConsumePeriodResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceBillRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        billing_cycle: str = None,
        billing_date: str = None,
        granularity: str = None,
        instance_id: str = None,
        is_billing_item: bool = None,
        is_hide_zero_charge: bool = None,
        max_results: int = None,
        next_token: str = None,
        owner_id: int = None,
        product_code: str = None,
        product_type: str = None,
        subscription_type: str = None,
    ):
        # The ID of the member. If you specify this parameter, the bills of the member are queried. If you do not specify this parameter, the bills of the current account are queried by default.
        self.bill_owner_id = bill_owner_id
        # The billing cycle. Specify the parameter in the YYYY-MM format.
        self.billing_cycle = billing_cycle
        # The billing date. This parameter is required only when the Granularity parameter is set to DAILY. Format: YYYY-MM-DD.
        self.billing_date = billing_date
        # The granularity at which bills are queried. Valid values:
        # 
        # *   MONTHLY: queries bills on a monthly basis. The data that you query is the same as the data searched by instances on the Billing Details tab of the Bill Details page in the User Center console.
        # *   DAILY: queries bills on a daily basis. The data that you query is the same as the data searched by days on the Billing Details tab of the Bill Details page in the User Center console.
        # 
        # The BillingDate parameter is required if you set the Granularity parameter to DAILY.
        self.granularity = granularity
        # The ID of the instance.
        self.instance_id = instance_id
        # Specifies whether to query data by billable items. Valid values:
        # 
        # *   false: The data that you query is the same as the data searched by instances on the Billing Details tab of the Bill Details page in the User Center console.
        # *   true: The data that you query is the same as the data searched by billable items on the Billing Details tab of the Bill Details page in the User Center console.
        # 
        # Default value: false.
        self.is_billing_item = is_billing_item
        # Specifies whether to filter bills if both the pretax gross amount and pretax amount are 0. Valid values:
        # 
        # *   false: does not filter bills.
        # *   true: filters bills.
        self.is_hide_zero_charge = is_hide_zero_charge
        # The maximum number of entries to return. Default value: 20. Maximum value: 300.
        self.max_results = max_results
        # The token that is used to indicate the position where the results for the current call start. The parameter must be left empty or set to the value of the NextToken parameter that is returned from the last call. Otherwise, an error is returned. If the parameter is left empty, data is queried from the first item.
        self.next_token = next_token
        self.owner_id = owner_id
        # The code of the service.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method.
        # *   PayAsYouGo: the pay-as-you-go billing method.
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.billing_date is not None:
            result['BillingDate'] = self.billing_date
        if self.granularity is not None:
            result['Granularity'] = self.granularity
        if self.instance_id is not None:
            result['InstanceID'] = self.instance_id
        if self.is_billing_item is not None:
            result['IsBillingItem'] = self.is_billing_item
        if self.is_hide_zero_charge is not None:
            result['IsHideZeroCharge'] = self.is_hide_zero_charge
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('BillingDate') is not None:
            self.billing_date = m.get('BillingDate')
        if m.get('Granularity') is not None:
            self.granularity = m.get('Granularity')
        if m.get('InstanceID') is not None:
            self.instance_id = m.get('InstanceID')
        if m.get('IsBillingItem') is not None:
            self.is_billing_item = m.get('IsBillingItem')
        if m.get('IsHideZeroCharge') is not None:
            self.is_hide_zero_charge = m.get('IsHideZeroCharge')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class DescribeInstanceBillResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        adjust_amount: float = None,
        bill_account_id: str = None,
        bill_account_name: str = None,
        billing_date: str = None,
        billing_item: str = None,
        billing_item_code: str = None,
        billing_type: str = None,
        biz_type: str = None,
        cash_amount: float = None,
        commodity_code: str = None,
        cost_unit: str = None,
        currency: str = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        deducted_by_resource_package: str = None,
        instance_config: str = None,
        instance_id: str = None,
        instance_spec: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        invoice_discount: float = None,
        item: str = None,
        item_name: str = None,
        list_price: str = None,
        list_price_unit: str = None,
        nick_name: str = None,
        outstanding_amount: float = None,
        owner_id: str = None,
        payment_amount: float = None,
        pip_code: str = None,
        pretax_amount: float = None,
        pretax_gross_amount: float = None,
        product_code: str = None,
        product_detail: str = None,
        product_name: str = None,
        product_type: str = None,
        region: str = None,
        resource_group: str = None,
        service_period: str = None,
        service_period_unit: str = None,
        subscription_type: str = None,
        tag: str = None,
        usage: str = None,
        usage_unit: str = None,
        zone: str = None,
    ):
        # The amount deducted with credit refund.
        self.adjust_amount = adjust_amount
        # The ID of the account to which the bill belongs.
        self.bill_account_id = bill_account_id
        # The name of the account to which the bill belongs.
        self.bill_account_name = bill_account_name
        # The billing date. This parameter is returned only if the Granularity parameter is set to DAILY. Format: YYYY-MM-DD.
        self.billing_date = billing_date
        # The billable item. A value is returned only if the IsBillingItem parameter is set to true.
        self.billing_item = billing_item
        # The code of the billable item.
        self.billing_item_code = billing_item_code
        # The billing method.
        self.billing_type = billing_type
        # The type of business.
        self.biz_type = biz_type
        # The amount paid in cash. The amount deducted with credit refund is not included.
        self.cash_amount = cash_amount
        # The code of the commodity. The code is the same as that in Cost Center.
        self.commodity_code = commodity_code
        # The cost center.
        self.cost_unit = cost_unit
        # The type of currency. Valid values:
        # 
        # *   CNY
        # *   USD
        # *   JPY
        self.currency = currency
        # The amount deducted with vouchers.
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        # The amount deducted with coupons.
        self.deducted_by_coupons = deducted_by_coupons
        # The amount deducted with prepaid cards.
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        # The amount deducted with resource plans. This parameter is valid only when the isBillingItem parameter is set to true.
        self.deducted_by_resource_package = deducted_by_resource_package
        # The configurations of the instance.
        self.instance_config = instance_config
        # The ID of the instance.
        self.instance_id = instance_id
        # The type of the instance.
        self.instance_spec = instance_spec
        # The public IP address.
        self.internet_ip = internet_ip
        # The private IP address.
        self.intranet_ip = intranet_ip
        # The discount amount.
        self.invoice_discount = invoice_discount
        # The type of the bill.
        # 
        # *   SubscriptionOrder: the subscription bill.
        # *   PayAsYouGoBill: the pay-as-you-go bill,
        # *   Refund: the refund.
        # *   Adjustment: the adjustment bill.
        self.item = item
        # The name of the project.
        self.item_name = item_name
        # The unit price of the service. This parameter is valid only when the isBillingItem parameter is set to true.
        self.list_price = list_price
        # The unit of the unit price. This parameter is valid only when the isBillingItem parameter is set to true.
        self.list_price_unit = list_price_unit
        # The name of the instance.
        self.nick_name = nick_name
        # The unsettled amount.
        self.outstanding_amount = outstanding_amount
        # The ID of the account that owns the resource. This parameter is returned in multi-account payment scenario.
        self.owner_id = owner_id
        # The amount paid in cash. The amount deducted with credit refund is not included.
        self.payment_amount = payment_amount
        # The code of the service. The code is the same as that in Cost Center.
        self.pip_code = pip_code
        # The pretax amount.
        self.pretax_amount = pretax_amount
        # The pretax gross amount.
        self.pretax_gross_amount = pretax_gross_amount
        # The code of the service.
        self.product_code = product_code
        # The details of the service.
        self.product_detail = product_detail
        # The name of the service.
        self.product_name = product_name
        # The type of the service.
        self.product_type = product_type
        # The ID of the region.
        self.region = region
        # The ID of the resource group.
        self.resource_group = resource_group
        # The service duration.
        self.service_period = service_period
        # The unit of the service duration.
        self.service_period_unit = service_period_unit
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method.
        # *   PayAsYouGo: the pay-as-you-go billing method.
        self.subscription_type = subscription_type
        # The tag of the resource.
        self.tag = tag
        # The usage of the service. This parameter is valid only when the isBillingItem parameter is set to true. The usage is the total usage in all bills in the billing cycle, not the amount that you purchase. For example, if 1 GB of storage is used and bills are generated every hour, the usage is 1 GB per hour. In this case, the usage is 24 GB per day.
        self.usage = usage
        # The unit of usage. This parameter is valid only when the isBillingItem parameter is set to true.
        self.usage_unit = usage_unit
        # The ID of the zone.
        self.zone = zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_amount is not None:
            result['AdjustAmount'] = self.adjust_amount
        if self.bill_account_id is not None:
            result['BillAccountID'] = self.bill_account_id
        if self.bill_account_name is not None:
            result['BillAccountName'] = self.bill_account_name
        if self.billing_date is not None:
            result['BillingDate'] = self.billing_date
        if self.billing_item is not None:
            result['BillingItem'] = self.billing_item
        if self.billing_item_code is not None:
            result['BillingItemCode'] = self.billing_item_code
        if self.billing_type is not None:
            result['BillingType'] = self.billing_type
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.cash_amount is not None:
            result['CashAmount'] = self.cash_amount
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.cost_unit is not None:
            result['CostUnit'] = self.cost_unit
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.deducted_by_resource_package is not None:
            result['DeductedByResourcePackage'] = self.deducted_by_resource_package
        if self.instance_config is not None:
            result['InstanceConfig'] = self.instance_config
        if self.instance_id is not None:
            result['InstanceID'] = self.instance_id
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.internet_ip is not None:
            result['InternetIP'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIP'] = self.intranet_ip
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.item is not None:
            result['Item'] = self.item
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.list_price is not None:
            result['ListPrice'] = self.list_price
        if self.list_price_unit is not None:
            result['ListPriceUnit'] = self.list_price_unit
        if self.nick_name is not None:
            result['NickName'] = self.nick_name
        if self.outstanding_amount is not None:
            result['OutstandingAmount'] = self.outstanding_amount
        if self.owner_id is not None:
            result['OwnerID'] = self.owner_id
        if self.payment_amount is not None:
            result['PaymentAmount'] = self.payment_amount
        if self.pip_code is not None:
            result['PipCode'] = self.pip_code
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_group is not None:
            result['ResourceGroup'] = self.resource_group
        if self.service_period is not None:
            result['ServicePeriod'] = self.service_period
        if self.service_period_unit is not None:
            result['ServicePeriodUnit'] = self.service_period_unit
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.usage_unit is not None:
            result['UsageUnit'] = self.usage_unit
        if self.zone is not None:
            result['Zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjustAmount') is not None:
            self.adjust_amount = m.get('AdjustAmount')
        if m.get('BillAccountID') is not None:
            self.bill_account_id = m.get('BillAccountID')
        if m.get('BillAccountName') is not None:
            self.bill_account_name = m.get('BillAccountName')
        if m.get('BillingDate') is not None:
            self.billing_date = m.get('BillingDate')
        if m.get('BillingItem') is not None:
            self.billing_item = m.get('BillingItem')
        if m.get('BillingItemCode') is not None:
            self.billing_item_code = m.get('BillingItemCode')
        if m.get('BillingType') is not None:
            self.billing_type = m.get('BillingType')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('CashAmount') is not None:
            self.cash_amount = m.get('CashAmount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CostUnit') is not None:
            self.cost_unit = m.get('CostUnit')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('DeductedByResourcePackage') is not None:
            self.deducted_by_resource_package = m.get('DeductedByResourcePackage')
        if m.get('InstanceConfig') is not None:
            self.instance_config = m.get('InstanceConfig')
        if m.get('InstanceID') is not None:
            self.instance_id = m.get('InstanceID')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('InternetIP') is not None:
            self.internet_ip = m.get('InternetIP')
        if m.get('IntranetIP') is not None:
            self.intranet_ip = m.get('IntranetIP')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('ListPrice') is not None:
            self.list_price = m.get('ListPrice')
        if m.get('ListPriceUnit') is not None:
            self.list_price_unit = m.get('ListPriceUnit')
        if m.get('NickName') is not None:
            self.nick_name = m.get('NickName')
        if m.get('OutstandingAmount') is not None:
            self.outstanding_amount = m.get('OutstandingAmount')
        if m.get('OwnerID') is not None:
            self.owner_id = m.get('OwnerID')
        if m.get('PaymentAmount') is not None:
            self.payment_amount = m.get('PaymentAmount')
        if m.get('PipCode') is not None:
            self.pip_code = m.get('PipCode')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceGroup') is not None:
            self.resource_group = m.get('ResourceGroup')
        if m.get('ServicePeriod') is not None:
            self.service_period = m.get('ServicePeriod')
        if m.get('ServicePeriodUnit') is not None:
            self.service_period_unit = m.get('ServicePeriodUnit')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('UsageUnit') is not None:
            self.usage_unit = m.get('UsageUnit')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        return self


class DescribeInstanceBillResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        billing_cycle: str = None,
        items: List[DescribeInstanceBillResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        # The ID of the account.
        self.account_id = account_id
        # The name of the account.
        self.account_name = account_name
        # The billing cycle in the YYYY-MM format.
        self.billing_cycle = billing_cycle
        # The details of the bill.
        self.items = items
        # The maximum number of entries returned.
        self.max_results = max_results
        # The position where the query stopped. If this parameter is left empty, all the results are returned. If you perform another call, you must set the NextToken parameter to the value of this parameter.
        self.next_token = next_token
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeInstanceBillResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstanceBillResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeInstanceBillResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The error message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeInstanceBillResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeInstanceBillResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceBillResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceBillResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePricingModuleRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        product_code: str = None,
        product_type: str = None,
        subscription_type: str = None,
    ):
        self.owner_id = owner_id
        self.product_code = product_code
        self.product_type = product_type
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class DescribePricingModuleResponseBodyDataAttributeListAttributeValuesAttributeValue(TeaModel):
    def __init__(
        self,
        name: str = None,
        remark: str = None,
        type: str = None,
        value: str = None,
    ):
        self.name = name
        self.remark = remark
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribePricingModuleResponseBodyDataAttributeListAttributeValues(TeaModel):
    def __init__(
        self,
        attribute_value: List[DescribePricingModuleResponseBodyDataAttributeListAttributeValuesAttributeValue] = None,
    ):
        self.attribute_value = attribute_value

    def validate(self):
        if self.attribute_value:
            for k in self.attribute_value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttributeValue'] = []
        if self.attribute_value is not None:
            for k in self.attribute_value:
                result['AttributeValue'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attribute_value = []
        if m.get('AttributeValue') is not None:
            for k in m.get('AttributeValue'):
                temp_model = DescribePricingModuleResponseBodyDataAttributeListAttributeValuesAttributeValue()
                self.attribute_value.append(temp_model.from_map(k))
        return self


class DescribePricingModuleResponseBodyDataAttributeListAttribute(TeaModel):
    def __init__(
        self,
        code: str = None,
        name: str = None,
        unit: str = None,
        values: DescribePricingModuleResponseBodyDataAttributeListAttributeValues = None,
    ):
        self.code = code
        self.name = name
        self.unit = unit
        self.values = values

    def validate(self):
        if self.values:
            self.values.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.values is not None:
            result['Values'] = self.values.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Values') is not None:
            temp_model = DescribePricingModuleResponseBodyDataAttributeListAttributeValues()
            self.values = temp_model.from_map(m['Values'])
        return self


class DescribePricingModuleResponseBodyDataAttributeList(TeaModel):
    def __init__(
        self,
        attribute: List[DescribePricingModuleResponseBodyDataAttributeListAttribute] = None,
    ):
        self.attribute = attribute

    def validate(self):
        if self.attribute:
            for k in self.attribute:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Attribute'] = []
        if self.attribute is not None:
            for k in self.attribute:
                result['Attribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attribute = []
        if m.get('Attribute') is not None:
            for k in m.get('Attribute'):
                temp_model = DescribePricingModuleResponseBodyDataAttributeListAttribute()
                self.attribute.append(temp_model.from_map(k))
        return self


class DescribePricingModuleResponseBodyDataModuleListModuleConfigList(TeaModel):
    def __init__(
        self,
        config_list: List[str] = None,
    ):
        self.config_list = config_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_list is not None:
            result['ConfigList'] = self.config_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigList') is not None:
            self.config_list = m.get('ConfigList')
        return self


class DescribePricingModuleResponseBodyDataModuleListModule(TeaModel):
    def __init__(
        self,
        config_list: DescribePricingModuleResponseBodyDataModuleListModuleConfigList = None,
        currency: str = None,
        module_code: str = None,
        module_name: str = None,
        price_type: str = None,
    ):
        self.config_list = config_list
        self.currency = currency
        self.module_code = module_code
        self.module_name = module_name
        self.price_type = price_type

    def validate(self):
        if self.config_list:
            self.config_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_list is not None:
            result['ConfigList'] = self.config_list.to_map()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.price_type is not None:
            result['PriceType'] = self.price_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigList') is not None:
            temp_model = DescribePricingModuleResponseBodyDataModuleListModuleConfigList()
            self.config_list = temp_model.from_map(m['ConfigList'])
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('PriceType') is not None:
            self.price_type = m.get('PriceType')
        return self


class DescribePricingModuleResponseBodyDataModuleList(TeaModel):
    def __init__(
        self,
        module: List[DescribePricingModuleResponseBodyDataModuleListModule] = None,
    ):
        self.module = module

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Module'] = []
        if self.module is not None:
            for k in self.module:
                result['Module'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.module = []
        if m.get('Module') is not None:
            for k in m.get('Module'):
                temp_model = DescribePricingModuleResponseBodyDataModuleListModule()
                self.module.append(temp_model.from_map(k))
        return self


class DescribePricingModuleResponseBodyData(TeaModel):
    def __init__(
        self,
        attribute_list: DescribePricingModuleResponseBodyDataAttributeList = None,
        module_list: DescribePricingModuleResponseBodyDataModuleList = None,
    ):
        self.attribute_list = attribute_list
        self.module_list = module_list

    def validate(self):
        if self.attribute_list:
            self.attribute_list.validate()
        if self.module_list:
            self.module_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_list is not None:
            result['AttributeList'] = self.attribute_list.to_map()
        if self.module_list is not None:
            result['ModuleList'] = self.module_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeList') is not None:
            temp_model = DescribePricingModuleResponseBodyDataAttributeList()
            self.attribute_list = temp_model.from_map(m['AttributeList'])
        if m.get('ModuleList') is not None:
            temp_model = DescribePricingModuleResponseBodyDataModuleList()
            self.module_list = temp_model.from_map(m['ModuleList'])
        return self


class DescribePricingModuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribePricingModuleResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribePricingModuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribePricingModuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePricingModuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePricingModuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeProductAmortizedCostByAmortizationPeriodRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id_list: List[str] = None,
        bill_user_id_list: List[str] = None,
        billing_cycle: str = None,
        consume_period_filter: List[str] = None,
        cost_unit_code: str = None,
        max_results: int = None,
        next_token: str = None,
        product_code: str = None,
        product_detail: str = None,
        subscription_type: str = None,
    ):
        # The instance ID that is used to filter bills. You can specify multiple instance IDs to query bills of multiple instances. If you leave this parameter empty, the bills of all instances are queried by default. You can specify a maximum of 10 instance IDs.
        self.bill_owner_id_list = bill_owner_id_list
        # The ID of the member that needs to settle the bill. The member ID is used to filter bills. If you specify a value for this parameter, you can query the bills of the specified member. If you leave this parameter empty, the bills of the current account and all members of the current account are queried by default. You can specify a maximum of 10 IDs.
        self.bill_user_id_list = bill_user_id_list
        # The allocation month. Format: YYYY-MM.
        self.billing_cycle = billing_cycle
        # The billing cycle that is used to filter bills. You can specify a maximum of 10 billing cycles.
        self.consume_period_filter = consume_period_filter
        # The code of the cost center.
        self.cost_unit_code = cost_unit_code
        # The maximum number of entries to return. Default value: 20. Maximum value: 300.
        self.max_results = max_results
        # The position from which the query starts. The parameter must be left empty or set to the value of the NextToken parameter returned from the last call. Otherwise, an error is returned. If this parameter is left empty, data is queried from the beginning.
        self.next_token = next_token
        # The code of the service. You can obtain the value of this parameter by calling the QueryProductList operation or the DescribeResourcePackageProduct operation.
        self.product_code = product_code
        # The specific service resource.
        self.product_detail = product_detail
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id_list is not None:
            result['BillOwnerIdList'] = self.bill_owner_id_list
        if self.bill_user_id_list is not None:
            result['BillUserIdList'] = self.bill_user_id_list
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.consume_period_filter is not None:
            result['ConsumePeriodFilter'] = self.consume_period_filter
        if self.cost_unit_code is not None:
            result['CostUnitCode'] = self.cost_unit_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerIdList') is not None:
            self.bill_owner_id_list = m.get('BillOwnerIdList')
        if m.get('BillUserIdList') is not None:
            self.bill_user_id_list = m.get('BillUserIdList')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('ConsumePeriodFilter') is not None:
            self.consume_period_filter = m.get('ConsumePeriodFilter')
        if m.get('CostUnitCode') is not None:
            self.cost_unit_code = m.get('CostUnitCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class DescribeProductAmortizedCostByAmortizationPeriodResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        amortization_period: str = None,
        amortization_status: str = None,
        bill_account_id: int = None,
        bill_account_name: str = None,
        bill_owner_id: int = None,
        bill_owner_name: str = None,
        biz_type: str = None,
        consume_period: str = None,
        current_amortization_deducted_by_cash_coupons: float = None,
        current_amortization_deducted_by_coupons: float = None,
        current_amortization_deducted_by_prepaid_card: float = None,
        current_amortization_expenditure_amount: float = None,
        current_amortization_invoice_discount: float = None,
        current_amortization_pretax_amount: float = None,
        current_amortization_pretax_gross_amount: float = None,
        current_amortization_round_down_discount: float = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        expenditure_amount: float = None,
        invoice_discount: float = None,
        pretax_amount: float = None,
        pretax_gross_amount: float = None,
        previously_amortized_deducted_by_cash_coupons: float = None,
        previously_amortized_deducted_by_coupons: float = None,
        previously_amortized_deducted_by_prepaid_card: float = None,
        previously_amortized_expenditure_amount: float = None,
        previously_amortized_invoice_discount: float = None,
        previously_amortized_pretax_amount: float = None,
        previously_amortized_pretax_gross_amount: float = None,
        previously_amortized_round_down_discount: float = None,
        product_code: str = None,
        product_detail: str = None,
        product_detail_code: str = None,
        product_name: str = None,
        remaining_amortization_deducted_by_cash_coupons: float = None,
        remaining_amortization_deducted_by_coupons: float = None,
        remaining_amortization_deducted_by_prepaid_card: float = None,
        remaining_amortization_expenditure_amount: float = None,
        remaining_amortization_invoice_discount: float = None,
        remaining_amortization_pretax_amount: float = None,
        remaining_amortization_pretax_gross_amount: float = None,
        remaining_amortization_round_down_discount: float = None,
        round_down_discount: float = None,
        subscription_type: str = None,
    ):
        # The allocation month. Format: YYYYMM.
        self.amortization_period = amortization_period
        # The allocation status. Valid values:
        # 
        # *   amortized: allocated
        # *   unAmortized: not allocated
        self.amortization_status = amortization_status
        # The ID of the account to which the bill belongs.
        self.bill_account_id = bill_account_id
        # The name of the account to which the bill belongs.
        self.bill_account_name = bill_account_name
        # The ID of the account to which the resource belongs.
        self.bill_owner_id = bill_owner_id
        # The name of the account to which the resource belongs.
        self.bill_owner_name = bill_owner_name
        # The business type.
        self.biz_type = biz_type
        # The billing cycle. Format: YYYYMM.
        self.consume_period = consume_period
        # The amount deducted by using vouchers and allocated to the current allocation month.
        self.current_amortization_deducted_by_cash_coupons = current_amortization_deducted_by_cash_coupons
        # The amount deducted by using coupons and allocated to the current allocation month.
        self.current_amortization_deducted_by_coupons = current_amortization_deducted_by_coupons
        # The amount deducted by using prepaid cards and allocated to the current allocation month.
        self.current_amortization_deducted_by_prepaid_card = current_amortization_deducted_by_prepaid_card
        # The expenditure amount allocated to the current allocation month. Invoicing is supported.
        self.current_amortization_expenditure_amount = current_amortization_expenditure_amount
        # The discount amount allocated to the current allocation month.
        self.current_amortization_invoice_discount = current_amortization_invoice_discount
        # The pretax amount allocated to the current allocation month.
        self.current_amortization_pretax_amount = current_amortization_pretax_amount
        # The pretax gross amount allocated to the current allocation month.
        self.current_amortization_pretax_gross_amount = current_amortization_pretax_gross_amount
        # The round-off amount allocated to the current allocation month.
        self.current_amortization_round_down_discount = current_amortization_round_down_discount
        # The amount deducted by using vouchers.
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        # The amount deducted by using coupons.
        self.deducted_by_coupons = deducted_by_coupons
        # The amount deducted by using prepaid cards.
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        # The expenditure amount. Invoicing is supported.
        self.expenditure_amount = expenditure_amount
        # The discount amount.
        self.invoice_discount = invoice_discount
        # The pretax amount.
        self.pretax_amount = pretax_amount
        # The pretax gross amount.
        self.pretax_gross_amount = pretax_gross_amount
        # The amount deducted by using vouchers and allocated before the current allocation month.
        self.previously_amortized_deducted_by_cash_coupons = previously_amortized_deducted_by_cash_coupons
        # The amount deducted by using coupons and allocated before the current allocation month.
        self.previously_amortized_deducted_by_coupons = previously_amortized_deducted_by_coupons
        # The amount deducted by using prepaid cards and allocated before the current allocation month.
        self.previously_amortized_deducted_by_prepaid_card = previously_amortized_deducted_by_prepaid_card
        # The expenditure amount allocated before the current allocation month. Invoicing is supported.
        self.previously_amortized_expenditure_amount = previously_amortized_expenditure_amount
        # The discount amount allocated before the current allocation month.
        self.previously_amortized_invoice_discount = previously_amortized_invoice_discount
        # The pretax amount allocated before the current allocation month.
        self.previously_amortized_pretax_amount = previously_amortized_pretax_amount
        # The pretax gross amount allocated before the current allocation month.
        self.previously_amortized_pretax_gross_amount = previously_amortized_pretax_gross_amount
        # The round-off amount allocated before the current allocation month.
        self.previously_amortized_round_down_discount = previously_amortized_round_down_discount
        # The code of the service.
        self.product_code = product_code
        # The specific service resource.
        self.product_detail = product_detail
        # The code of the specific service resource.
        self.product_detail_code = product_detail_code
        # The name of the service.
        self.product_name = product_name
        # The amount deducted by using vouchers and to be allocated to one or more future allocation months.
        self.remaining_amortization_deducted_by_cash_coupons = remaining_amortization_deducted_by_cash_coupons
        # The amount deducted by using coupons and to be allocated to one or more future allocation months.
        self.remaining_amortization_deducted_by_coupons = remaining_amortization_deducted_by_coupons
        # The amount deducted by using prepaid cards and to be allocated to one or more future allocation months.
        self.remaining_amortization_deducted_by_prepaid_card = remaining_amortization_deducted_by_prepaid_card
        # The expenditure amount to be allocated to one or more future allocation months. Invoicing is supported.
        self.remaining_amortization_expenditure_amount = remaining_amortization_expenditure_amount
        # The discount amount to be allocated to one or more future allocation months.
        self.remaining_amortization_invoice_discount = remaining_amortization_invoice_discount
        # The pretax amount to be allocated to one or more future allocation months.
        self.remaining_amortization_pretax_amount = remaining_amortization_pretax_amount
        # The pretax gross amount to be allocated to one or more future allocation months.
        self.remaining_amortization_pretax_gross_amount = remaining_amortization_pretax_gross_amount
        # The round-off amount to be allocated to one or more future allocation months.
        self.remaining_amortization_round_down_discount = remaining_amortization_round_down_discount
        # The round-off amount.
        self.round_down_discount = round_down_discount
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amortization_period is not None:
            result['AmortizationPeriod'] = self.amortization_period
        if self.amortization_status is not None:
            result['AmortizationStatus'] = self.amortization_status
        if self.bill_account_id is not None:
            result['BillAccountID'] = self.bill_account_id
        if self.bill_account_name is not None:
            result['BillAccountName'] = self.bill_account_name
        if self.bill_owner_id is not None:
            result['BillOwnerID'] = self.bill_owner_id
        if self.bill_owner_name is not None:
            result['BillOwnerName'] = self.bill_owner_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.consume_period is not None:
            result['ConsumePeriod'] = self.consume_period
        if self.current_amortization_deducted_by_cash_coupons is not None:
            result['CurrentAmortizationDeductedByCashCoupons'] = self.current_amortization_deducted_by_cash_coupons
        if self.current_amortization_deducted_by_coupons is not None:
            result['CurrentAmortizationDeductedByCoupons'] = self.current_amortization_deducted_by_coupons
        if self.current_amortization_deducted_by_prepaid_card is not None:
            result['CurrentAmortizationDeductedByPrepaidCard'] = self.current_amortization_deducted_by_prepaid_card
        if self.current_amortization_expenditure_amount is not None:
            result['CurrentAmortizationExpenditureAmount'] = self.current_amortization_expenditure_amount
        if self.current_amortization_invoice_discount is not None:
            result['CurrentAmortizationInvoiceDiscount'] = self.current_amortization_invoice_discount
        if self.current_amortization_pretax_amount is not None:
            result['CurrentAmortizationPretaxAmount'] = self.current_amortization_pretax_amount
        if self.current_amortization_pretax_gross_amount is not None:
            result['CurrentAmortizationPretaxGrossAmount'] = self.current_amortization_pretax_gross_amount
        if self.current_amortization_round_down_discount is not None:
            result['CurrentAmortizationRoundDownDiscount'] = self.current_amortization_round_down_discount
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.expenditure_amount is not None:
            result['ExpenditureAmount'] = self.expenditure_amount
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.previously_amortized_deducted_by_cash_coupons is not None:
            result['PreviouslyAmortizedDeductedByCashCoupons'] = self.previously_amortized_deducted_by_cash_coupons
        if self.previously_amortized_deducted_by_coupons is not None:
            result['PreviouslyAmortizedDeductedByCoupons'] = self.previously_amortized_deducted_by_coupons
        if self.previously_amortized_deducted_by_prepaid_card is not None:
            result['PreviouslyAmortizedDeductedByPrepaidCard'] = self.previously_amortized_deducted_by_prepaid_card
        if self.previously_amortized_expenditure_amount is not None:
            result['PreviouslyAmortizedExpenditureAmount'] = self.previously_amortized_expenditure_amount
        if self.previously_amortized_invoice_discount is not None:
            result['PreviouslyAmortizedInvoiceDiscount'] = self.previously_amortized_invoice_discount
        if self.previously_amortized_pretax_amount is not None:
            result['PreviouslyAmortizedPretaxAmount'] = self.previously_amortized_pretax_amount
        if self.previously_amortized_pretax_gross_amount is not None:
            result['PreviouslyAmortizedPretaxGrossAmount'] = self.previously_amortized_pretax_gross_amount
        if self.previously_amortized_round_down_discount is not None:
            result['PreviouslyAmortizedRoundDownDiscount'] = self.previously_amortized_round_down_discount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.product_detail_code is not None:
            result['ProductDetailCode'] = self.product_detail_code
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.remaining_amortization_deducted_by_cash_coupons is not None:
            result['RemainingAmortizationDeductedByCashCoupons'] = self.remaining_amortization_deducted_by_cash_coupons
        if self.remaining_amortization_deducted_by_coupons is not None:
            result['RemainingAmortizationDeductedByCoupons'] = self.remaining_amortization_deducted_by_coupons
        if self.remaining_amortization_deducted_by_prepaid_card is not None:
            result['RemainingAmortizationDeductedByPrepaidCard'] = self.remaining_amortization_deducted_by_prepaid_card
        if self.remaining_amortization_expenditure_amount is not None:
            result['RemainingAmortizationExpenditureAmount'] = self.remaining_amortization_expenditure_amount
        if self.remaining_amortization_invoice_discount is not None:
            result['RemainingAmortizationInvoiceDiscount'] = self.remaining_amortization_invoice_discount
        if self.remaining_amortization_pretax_amount is not None:
            result['RemainingAmortizationPretaxAmount'] = self.remaining_amortization_pretax_amount
        if self.remaining_amortization_pretax_gross_amount is not None:
            result['RemainingAmortizationPretaxGrossAmount'] = self.remaining_amortization_pretax_gross_amount
        if self.remaining_amortization_round_down_discount is not None:
            result['RemainingAmortizationRoundDownDiscount'] = self.remaining_amortization_round_down_discount
        if self.round_down_discount is not None:
            result['RoundDownDiscount'] = self.round_down_discount
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AmortizationPeriod') is not None:
            self.amortization_period = m.get('AmortizationPeriod')
        if m.get('AmortizationStatus') is not None:
            self.amortization_status = m.get('AmortizationStatus')
        if m.get('BillAccountID') is not None:
            self.bill_account_id = m.get('BillAccountID')
        if m.get('BillAccountName') is not None:
            self.bill_account_name = m.get('BillAccountName')
        if m.get('BillOwnerID') is not None:
            self.bill_owner_id = m.get('BillOwnerID')
        if m.get('BillOwnerName') is not None:
            self.bill_owner_name = m.get('BillOwnerName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('ConsumePeriod') is not None:
            self.consume_period = m.get('ConsumePeriod')
        if m.get('CurrentAmortizationDeductedByCashCoupons') is not None:
            self.current_amortization_deducted_by_cash_coupons = m.get('CurrentAmortizationDeductedByCashCoupons')
        if m.get('CurrentAmortizationDeductedByCoupons') is not None:
            self.current_amortization_deducted_by_coupons = m.get('CurrentAmortizationDeductedByCoupons')
        if m.get('CurrentAmortizationDeductedByPrepaidCard') is not None:
            self.current_amortization_deducted_by_prepaid_card = m.get('CurrentAmortizationDeductedByPrepaidCard')
        if m.get('CurrentAmortizationExpenditureAmount') is not None:
            self.current_amortization_expenditure_amount = m.get('CurrentAmortizationExpenditureAmount')
        if m.get('CurrentAmortizationInvoiceDiscount') is not None:
            self.current_amortization_invoice_discount = m.get('CurrentAmortizationInvoiceDiscount')
        if m.get('CurrentAmortizationPretaxAmount') is not None:
            self.current_amortization_pretax_amount = m.get('CurrentAmortizationPretaxAmount')
        if m.get('CurrentAmortizationPretaxGrossAmount') is not None:
            self.current_amortization_pretax_gross_amount = m.get('CurrentAmortizationPretaxGrossAmount')
        if m.get('CurrentAmortizationRoundDownDiscount') is not None:
            self.current_amortization_round_down_discount = m.get('CurrentAmortizationRoundDownDiscount')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('ExpenditureAmount') is not None:
            self.expenditure_amount = m.get('ExpenditureAmount')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('PreviouslyAmortizedDeductedByCashCoupons') is not None:
            self.previously_amortized_deducted_by_cash_coupons = m.get('PreviouslyAmortizedDeductedByCashCoupons')
        if m.get('PreviouslyAmortizedDeductedByCoupons') is not None:
            self.previously_amortized_deducted_by_coupons = m.get('PreviouslyAmortizedDeductedByCoupons')
        if m.get('PreviouslyAmortizedDeductedByPrepaidCard') is not None:
            self.previously_amortized_deducted_by_prepaid_card = m.get('PreviouslyAmortizedDeductedByPrepaidCard')
        if m.get('PreviouslyAmortizedExpenditureAmount') is not None:
            self.previously_amortized_expenditure_amount = m.get('PreviouslyAmortizedExpenditureAmount')
        if m.get('PreviouslyAmortizedInvoiceDiscount') is not None:
            self.previously_amortized_invoice_discount = m.get('PreviouslyAmortizedInvoiceDiscount')
        if m.get('PreviouslyAmortizedPretaxAmount') is not None:
            self.previously_amortized_pretax_amount = m.get('PreviouslyAmortizedPretaxAmount')
        if m.get('PreviouslyAmortizedPretaxGrossAmount') is not None:
            self.previously_amortized_pretax_gross_amount = m.get('PreviouslyAmortizedPretaxGrossAmount')
        if m.get('PreviouslyAmortizedRoundDownDiscount') is not None:
            self.previously_amortized_round_down_discount = m.get('PreviouslyAmortizedRoundDownDiscount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('ProductDetailCode') is not None:
            self.product_detail_code = m.get('ProductDetailCode')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('RemainingAmortizationDeductedByCashCoupons') is not None:
            self.remaining_amortization_deducted_by_cash_coupons = m.get('RemainingAmortizationDeductedByCashCoupons')
        if m.get('RemainingAmortizationDeductedByCoupons') is not None:
            self.remaining_amortization_deducted_by_coupons = m.get('RemainingAmortizationDeductedByCoupons')
        if m.get('RemainingAmortizationDeductedByPrepaidCard') is not None:
            self.remaining_amortization_deducted_by_prepaid_card = m.get('RemainingAmortizationDeductedByPrepaidCard')
        if m.get('RemainingAmortizationExpenditureAmount') is not None:
            self.remaining_amortization_expenditure_amount = m.get('RemainingAmortizationExpenditureAmount')
        if m.get('RemainingAmortizationInvoiceDiscount') is not None:
            self.remaining_amortization_invoice_discount = m.get('RemainingAmortizationInvoiceDiscount')
        if m.get('RemainingAmortizationPretaxAmount') is not None:
            self.remaining_amortization_pretax_amount = m.get('RemainingAmortizationPretaxAmount')
        if m.get('RemainingAmortizationPretaxGrossAmount') is not None:
            self.remaining_amortization_pretax_gross_amount = m.get('RemainingAmortizationPretaxGrossAmount')
        if m.get('RemainingAmortizationRoundDownDiscount') is not None:
            self.remaining_amortization_round_down_discount = m.get('RemainingAmortizationRoundDownDiscount')
        if m.get('RoundDownDiscount') is not None:
            self.round_down_discount = m.get('RoundDownDiscount')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class DescribeProductAmortizedCostByAmortizationPeriodResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        items: List[DescribeProductAmortizedCostByAmortizationPeriodResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        # The ID of the account.
        self.account_id = account_id
        # The name of the account.
        self.account_name = account_name
        # The data entries returned.
        self.items = items
        # The maximum number of entries returned.
        self.max_results = max_results
        # The position from which the results started to return. The parameter must be left empty or set to the value of the NextToken parameter returned from the last call. Otherwise, an error is returned. If this parameter is left empty, data is queried from the beginning.
        self.next_token = next_token
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeProductAmortizedCostByAmortizationPeriodResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeProductAmortizedCostByAmortizationPeriodResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeProductAmortizedCostByAmortizationPeriodResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeProductAmortizedCostByAmortizationPeriodResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeProductAmortizedCostByAmortizationPeriodResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeProductAmortizedCostByAmortizationPeriodResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeProductAmortizedCostByAmortizationPeriodResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeProductAmortizedCostByConsumePeriodRequest(TeaModel):
    def __init__(
        self,
        amortization_period_filter: List[str] = None,
        bill_owner_id_list: List[str] = None,
        bill_user_id_list: List[str] = None,
        billing_cycle: str = None,
        cost_unit_code: str = None,
        max_results: int = None,
        next_token: str = None,
        product_code: str = None,
        product_detail: str = None,
        subscription_type: str = None,
    ):
        self.amortization_period_filter = amortization_period_filter
        self.bill_owner_id_list = bill_owner_id_list
        self.bill_user_id_list = bill_user_id_list
        self.billing_cycle = billing_cycle
        self.cost_unit_code = cost_unit_code
        self.max_results = max_results
        self.next_token = next_token
        self.product_code = product_code
        self.product_detail = product_detail
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amortization_period_filter is not None:
            result['AmortizationPeriodFilter'] = self.amortization_period_filter
        if self.bill_owner_id_list is not None:
            result['BillOwnerIdList'] = self.bill_owner_id_list
        if self.bill_user_id_list is not None:
            result['BillUserIdList'] = self.bill_user_id_list
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.cost_unit_code is not None:
            result['CostUnitCode'] = self.cost_unit_code
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AmortizationPeriodFilter') is not None:
            self.amortization_period_filter = m.get('AmortizationPeriodFilter')
        if m.get('BillOwnerIdList') is not None:
            self.bill_owner_id_list = m.get('BillOwnerIdList')
        if m.get('BillUserIdList') is not None:
            self.bill_user_id_list = m.get('BillUserIdList')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('CostUnitCode') is not None:
            self.cost_unit_code = m.get('CostUnitCode')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class DescribeProductAmortizedCostByConsumePeriodResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        amortization_period: str = None,
        amortization_status: str = None,
        bill_account_id: int = None,
        bill_account_name: str = None,
        bill_owner_id: int = None,
        bill_owner_name: str = None,
        biz_type: str = None,
        consume_period: str = None,
        current_amortization_deducted_by_cash_coupons: float = None,
        current_amortization_deducted_by_coupons: float = None,
        current_amortization_deducted_by_prepaid_card: float = None,
        current_amortization_expenditure_amount: float = None,
        current_amortization_invoice_discount: float = None,
        current_amortization_pretax_amount: float = None,
        current_amortization_pretax_gross_amount: float = None,
        current_amortization_round_down_discount: float = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        expenditure_amount: float = None,
        invoice_discount: float = None,
        pretax_amount: float = None,
        pretax_gross_amount: float = None,
        previously_amortized_deducted_by_cash_coupons: float = None,
        previously_amortized_deducted_by_coupons: float = None,
        previously_amortized_deducted_by_prepaid_card: float = None,
        previously_amortized_expenditure_amount: float = None,
        previously_amortized_invoice_discount: float = None,
        previously_amortized_pretax_amount: float = None,
        previously_amortized_pretax_gross_amount: float = None,
        previously_amortized_round_down_discount: float = None,
        product_code: str = None,
        product_detail: str = None,
        product_detail_code: str = None,
        product_name: str = None,
        remaining_amortization_deducted_by_cash_coupons: float = None,
        remaining_amortization_deducted_by_coupons: float = None,
        remaining_amortization_deducted_by_prepaid_card: float = None,
        remaining_amortization_expenditure_amount: float = None,
        remaining_amortization_invoice_discount: float = None,
        remaining_amortization_pretax_amount: float = None,
        remaining_amortization_pretax_gross_amount: float = None,
        remaining_amortization_round_down_discount: float = None,
        round_down_discount: float = None,
        subscription_type: str = None,
    ):
        self.amortization_period = amortization_period
        self.amortization_status = amortization_status
        self.bill_account_id = bill_account_id
        self.bill_account_name = bill_account_name
        self.bill_owner_id = bill_owner_id
        self.bill_owner_name = bill_owner_name
        self.biz_type = biz_type
        self.consume_period = consume_period
        self.current_amortization_deducted_by_cash_coupons = current_amortization_deducted_by_cash_coupons
        self.current_amortization_deducted_by_coupons = current_amortization_deducted_by_coupons
        self.current_amortization_deducted_by_prepaid_card = current_amortization_deducted_by_prepaid_card
        self.current_amortization_expenditure_amount = current_amortization_expenditure_amount
        self.current_amortization_invoice_discount = current_amortization_invoice_discount
        self.current_amortization_pretax_amount = current_amortization_pretax_amount
        self.current_amortization_pretax_gross_amount = current_amortization_pretax_gross_amount
        self.current_amortization_round_down_discount = current_amortization_round_down_discount
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        self.deducted_by_coupons = deducted_by_coupons
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        self.expenditure_amount = expenditure_amount
        self.invoice_discount = invoice_discount
        self.pretax_amount = pretax_amount
        self.pretax_gross_amount = pretax_gross_amount
        self.previously_amortized_deducted_by_cash_coupons = previously_amortized_deducted_by_cash_coupons
        self.previously_amortized_deducted_by_coupons = previously_amortized_deducted_by_coupons
        self.previously_amortized_deducted_by_prepaid_card = previously_amortized_deducted_by_prepaid_card
        self.previously_amortized_expenditure_amount = previously_amortized_expenditure_amount
        self.previously_amortized_invoice_discount = previously_amortized_invoice_discount
        self.previously_amortized_pretax_amount = previously_amortized_pretax_amount
        self.previously_amortized_pretax_gross_amount = previously_amortized_pretax_gross_amount
        self.previously_amortized_round_down_discount = previously_amortized_round_down_discount
        self.product_code = product_code
        self.product_detail = product_detail
        self.product_detail_code = product_detail_code
        self.product_name = product_name
        self.remaining_amortization_deducted_by_cash_coupons = remaining_amortization_deducted_by_cash_coupons
        self.remaining_amortization_deducted_by_coupons = remaining_amortization_deducted_by_coupons
        self.remaining_amortization_deducted_by_prepaid_card = remaining_amortization_deducted_by_prepaid_card
        self.remaining_amortization_expenditure_amount = remaining_amortization_expenditure_amount
        self.remaining_amortization_invoice_discount = remaining_amortization_invoice_discount
        self.remaining_amortization_pretax_amount = remaining_amortization_pretax_amount
        self.remaining_amortization_pretax_gross_amount = remaining_amortization_pretax_gross_amount
        self.remaining_amortization_round_down_discount = remaining_amortization_round_down_discount
        self.round_down_discount = round_down_discount
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amortization_period is not None:
            result['AmortizationPeriod'] = self.amortization_period
        if self.amortization_status is not None:
            result['AmortizationStatus'] = self.amortization_status
        if self.bill_account_id is not None:
            result['BillAccountID'] = self.bill_account_id
        if self.bill_account_name is not None:
            result['BillAccountName'] = self.bill_account_name
        if self.bill_owner_id is not None:
            result['BillOwnerID'] = self.bill_owner_id
        if self.bill_owner_name is not None:
            result['BillOwnerName'] = self.bill_owner_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.consume_period is not None:
            result['ConsumePeriod'] = self.consume_period
        if self.current_amortization_deducted_by_cash_coupons is not None:
            result['CurrentAmortizationDeductedByCashCoupons'] = self.current_amortization_deducted_by_cash_coupons
        if self.current_amortization_deducted_by_coupons is not None:
            result['CurrentAmortizationDeductedByCoupons'] = self.current_amortization_deducted_by_coupons
        if self.current_amortization_deducted_by_prepaid_card is not None:
            result['CurrentAmortizationDeductedByPrepaidCard'] = self.current_amortization_deducted_by_prepaid_card
        if self.current_amortization_expenditure_amount is not None:
            result['CurrentAmortizationExpenditureAmount'] = self.current_amortization_expenditure_amount
        if self.current_amortization_invoice_discount is not None:
            result['CurrentAmortizationInvoiceDiscount'] = self.current_amortization_invoice_discount
        if self.current_amortization_pretax_amount is not None:
            result['CurrentAmortizationPretaxAmount'] = self.current_amortization_pretax_amount
        if self.current_amortization_pretax_gross_amount is not None:
            result['CurrentAmortizationPretaxGrossAmount'] = self.current_amortization_pretax_gross_amount
        if self.current_amortization_round_down_discount is not None:
            result['CurrentAmortizationRoundDownDiscount'] = self.current_amortization_round_down_discount
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.expenditure_amount is not None:
            result['ExpenditureAmount'] = self.expenditure_amount
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.previously_amortized_deducted_by_cash_coupons is not None:
            result['PreviouslyAmortizedDeductedByCashCoupons'] = self.previously_amortized_deducted_by_cash_coupons
        if self.previously_amortized_deducted_by_coupons is not None:
            result['PreviouslyAmortizedDeductedByCoupons'] = self.previously_amortized_deducted_by_coupons
        if self.previously_amortized_deducted_by_prepaid_card is not None:
            result['PreviouslyAmortizedDeductedByPrepaidCard'] = self.previously_amortized_deducted_by_prepaid_card
        if self.previously_amortized_expenditure_amount is not None:
            result['PreviouslyAmortizedExpenditureAmount'] = self.previously_amortized_expenditure_amount
        if self.previously_amortized_invoice_discount is not None:
            result['PreviouslyAmortizedInvoiceDiscount'] = self.previously_amortized_invoice_discount
        if self.previously_amortized_pretax_amount is not None:
            result['PreviouslyAmortizedPretaxAmount'] = self.previously_amortized_pretax_amount
        if self.previously_amortized_pretax_gross_amount is not None:
            result['PreviouslyAmortizedPretaxGrossAmount'] = self.previously_amortized_pretax_gross_amount
        if self.previously_amortized_round_down_discount is not None:
            result['PreviouslyAmortizedRoundDownDiscount'] = self.previously_amortized_round_down_discount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.product_detail_code is not None:
            result['ProductDetailCode'] = self.product_detail_code
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.remaining_amortization_deducted_by_cash_coupons is not None:
            result['RemainingAmortizationDeductedByCashCoupons'] = self.remaining_amortization_deducted_by_cash_coupons
        if self.remaining_amortization_deducted_by_coupons is not None:
            result['RemainingAmortizationDeductedByCoupons'] = self.remaining_amortization_deducted_by_coupons
        if self.remaining_amortization_deducted_by_prepaid_card is not None:
            result['RemainingAmortizationDeductedByPrepaidCard'] = self.remaining_amortization_deducted_by_prepaid_card
        if self.remaining_amortization_expenditure_amount is not None:
            result['RemainingAmortizationExpenditureAmount'] = self.remaining_amortization_expenditure_amount
        if self.remaining_amortization_invoice_discount is not None:
            result['RemainingAmortizationInvoiceDiscount'] = self.remaining_amortization_invoice_discount
        if self.remaining_amortization_pretax_amount is not None:
            result['RemainingAmortizationPretaxAmount'] = self.remaining_amortization_pretax_amount
        if self.remaining_amortization_pretax_gross_amount is not None:
            result['RemainingAmortizationPretaxGrossAmount'] = self.remaining_amortization_pretax_gross_amount
        if self.remaining_amortization_round_down_discount is not None:
            result['RemainingAmortizationRoundDownDiscount'] = self.remaining_amortization_round_down_discount
        if self.round_down_discount is not None:
            result['RoundDownDiscount'] = self.round_down_discount
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AmortizationPeriod') is not None:
            self.amortization_period = m.get('AmortizationPeriod')
        if m.get('AmortizationStatus') is not None:
            self.amortization_status = m.get('AmortizationStatus')
        if m.get('BillAccountID') is not None:
            self.bill_account_id = m.get('BillAccountID')
        if m.get('BillAccountName') is not None:
            self.bill_account_name = m.get('BillAccountName')
        if m.get('BillOwnerID') is not None:
            self.bill_owner_id = m.get('BillOwnerID')
        if m.get('BillOwnerName') is not None:
            self.bill_owner_name = m.get('BillOwnerName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('ConsumePeriod') is not None:
            self.consume_period = m.get('ConsumePeriod')
        if m.get('CurrentAmortizationDeductedByCashCoupons') is not None:
            self.current_amortization_deducted_by_cash_coupons = m.get('CurrentAmortizationDeductedByCashCoupons')
        if m.get('CurrentAmortizationDeductedByCoupons') is not None:
            self.current_amortization_deducted_by_coupons = m.get('CurrentAmortizationDeductedByCoupons')
        if m.get('CurrentAmortizationDeductedByPrepaidCard') is not None:
            self.current_amortization_deducted_by_prepaid_card = m.get('CurrentAmortizationDeductedByPrepaidCard')
        if m.get('CurrentAmortizationExpenditureAmount') is not None:
            self.current_amortization_expenditure_amount = m.get('CurrentAmortizationExpenditureAmount')
        if m.get('CurrentAmortizationInvoiceDiscount') is not None:
            self.current_amortization_invoice_discount = m.get('CurrentAmortizationInvoiceDiscount')
        if m.get('CurrentAmortizationPretaxAmount') is not None:
            self.current_amortization_pretax_amount = m.get('CurrentAmortizationPretaxAmount')
        if m.get('CurrentAmortizationPretaxGrossAmount') is not None:
            self.current_amortization_pretax_gross_amount = m.get('CurrentAmortizationPretaxGrossAmount')
        if m.get('CurrentAmortizationRoundDownDiscount') is not None:
            self.current_amortization_round_down_discount = m.get('CurrentAmortizationRoundDownDiscount')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('ExpenditureAmount') is not None:
            self.expenditure_amount = m.get('ExpenditureAmount')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('PreviouslyAmortizedDeductedByCashCoupons') is not None:
            self.previously_amortized_deducted_by_cash_coupons = m.get('PreviouslyAmortizedDeductedByCashCoupons')
        if m.get('PreviouslyAmortizedDeductedByCoupons') is not None:
            self.previously_amortized_deducted_by_coupons = m.get('PreviouslyAmortizedDeductedByCoupons')
        if m.get('PreviouslyAmortizedDeductedByPrepaidCard') is not None:
            self.previously_amortized_deducted_by_prepaid_card = m.get('PreviouslyAmortizedDeductedByPrepaidCard')
        if m.get('PreviouslyAmortizedExpenditureAmount') is not None:
            self.previously_amortized_expenditure_amount = m.get('PreviouslyAmortizedExpenditureAmount')
        if m.get('PreviouslyAmortizedInvoiceDiscount') is not None:
            self.previously_amortized_invoice_discount = m.get('PreviouslyAmortizedInvoiceDiscount')
        if m.get('PreviouslyAmortizedPretaxAmount') is not None:
            self.previously_amortized_pretax_amount = m.get('PreviouslyAmortizedPretaxAmount')
        if m.get('PreviouslyAmortizedPretaxGrossAmount') is not None:
            self.previously_amortized_pretax_gross_amount = m.get('PreviouslyAmortizedPretaxGrossAmount')
        if m.get('PreviouslyAmortizedRoundDownDiscount') is not None:
            self.previously_amortized_round_down_discount = m.get('PreviouslyAmortizedRoundDownDiscount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('ProductDetailCode') is not None:
            self.product_detail_code = m.get('ProductDetailCode')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('RemainingAmortizationDeductedByCashCoupons') is not None:
            self.remaining_amortization_deducted_by_cash_coupons = m.get('RemainingAmortizationDeductedByCashCoupons')
        if m.get('RemainingAmortizationDeductedByCoupons') is not None:
            self.remaining_amortization_deducted_by_coupons = m.get('RemainingAmortizationDeductedByCoupons')
        if m.get('RemainingAmortizationDeductedByPrepaidCard') is not None:
            self.remaining_amortization_deducted_by_prepaid_card = m.get('RemainingAmortizationDeductedByPrepaidCard')
        if m.get('RemainingAmortizationExpenditureAmount') is not None:
            self.remaining_amortization_expenditure_amount = m.get('RemainingAmortizationExpenditureAmount')
        if m.get('RemainingAmortizationInvoiceDiscount') is not None:
            self.remaining_amortization_invoice_discount = m.get('RemainingAmortizationInvoiceDiscount')
        if m.get('RemainingAmortizationPretaxAmount') is not None:
            self.remaining_amortization_pretax_amount = m.get('RemainingAmortizationPretaxAmount')
        if m.get('RemainingAmortizationPretaxGrossAmount') is not None:
            self.remaining_amortization_pretax_gross_amount = m.get('RemainingAmortizationPretaxGrossAmount')
        if m.get('RemainingAmortizationRoundDownDiscount') is not None:
            self.remaining_amortization_round_down_discount = m.get('RemainingAmortizationRoundDownDiscount')
        if m.get('RoundDownDiscount') is not None:
            self.round_down_discount = m.get('RoundDownDiscount')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class DescribeProductAmortizedCostByConsumePeriodResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        items: List[DescribeProductAmortizedCostByConsumePeriodResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        self.account_id = account_id
        self.account_name = account_name
        self.items = items
        self.max_results = max_results
        self.next_token = next_token
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeProductAmortizedCostByConsumePeriodResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeProductAmortizedCostByConsumePeriodResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeProductAmortizedCostByConsumePeriodResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeProductAmortizedCostByConsumePeriodResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeProductAmortizedCostByConsumePeriodResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeProductAmortizedCostByConsumePeriodResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeProductAmortizedCostByConsumePeriodResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeResourceCoverageDetailRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        end_period: str = None,
        max_results: int = None,
        next_token: str = None,
        period_type: str = None,
        resource_type: str = None,
        start_period: str = None,
    ):
        # The ID of the account for which you want to query coverage details. If you do not set this parameter, the data of the current Alibaba Cloud account and its RAM users is queried. To query the data of a RAM user, specify the ID of the RAM user.
        self.bill_owner_id = bill_owner_id
        # The end of the time range to query. The end is excluded from the time range. If you do not set this parameter, the end time is the current time. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.end_period = end_period
        # The maximum number of entries to return. Default value: 20. Maximum value: 300.
        self.max_results = max_results
        # The token that is used to retrieve the next page of results. You do not need to set this parameter if you query coverage details within a specific time range for the first time. The response returns a token that you can use to query coverage details that are displayed on the next page. If a null value is returned for the NextToken parameter, no more coverage details can be queried.
        self.next_token = next_token
        # The time granularity at which coverage details are queried. Valid values: MONTH, DAY, and HOUR.
        self.period_type = period_type
        # The type of deduction plans whose coverage details are queried. Valid values: RI and SCU.
        self.resource_type = resource_type
        # The beginning of the time range to query.
        # 
        # The beginning is included in the time range. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.start_period = start_period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.end_period is not None:
            result['EndPeriod'] = self.end_period
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period_type is not None:
            result['PeriodType'] = self.period_type
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.start_period is not None:
            result['StartPeriod'] = self.start_period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('EndPeriod') is not None:
            self.end_period = m.get('EndPeriod')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PeriodType') is not None:
            self.period_type = m.get('PeriodType')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('StartPeriod') is not None:
            self.start_period = m.get('StartPeriod')
        return self


class DescribeResourceCoverageDetailResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        capacity_unit: str = None,
        commodity_code: str = None,
        commodity_name: str = None,
        coverage_percentage: float = None,
        currency: str = None,
        deduct_quantity: float = None,
        end_time: str = None,
        instance_id: str = None,
        instance_spec: str = None,
        payment_amount: float = None,
        product_code: str = None,
        product_name: str = None,
        region: str = None,
        region_no: str = None,
        start_time: str = None,
        total_quantity: float = None,
        user_id: str = None,
        user_name: str = None,
        zone: str = None,
        zone_name: str = None,
    ):
        # The unit that is used to measure the resources deducted from deduction plans.
        self.capacity_unit = capacity_unit
        # The code of the service.
        self.commodity_code = commodity_code
        # The name and billing method of the service.
        self.commodity_name = commodity_name
        # The coverage rate of a deduction plan.
        self.coverage_percentage = coverage_percentage
        # The currency in which deduction plans were priced.
        self.currency = currency
        # The amount of the resources deducted from a deduction plan.
        self.deduct_quantity = deduct_quantity
        # The end of the time range in which the coverage details were queried.
        self.end_time = end_time
        # The ID of a pay-as-you-go instance.
        self.instance_id = instance_id
        # The specifications of a deduction plan.
        self.instance_spec = instance_spec
        # The amount of the bill.
        self.payment_amount = payment_amount
        # The code of the service.
        self.product_code = product_code
        # The name of the service.
        self.product_name = product_name
        # The region.
        self.region = region
        # The code of the region.
        self.region_no = region_no
        # The beginning of the time range in which the coverage details were queried.
        self.start_time = start_time
        # The total amount of resources consumed.
        self.total_quantity = total_quantity
        # The ID of the account.
        self.user_id = user_id
        # The username of the account.
        self.user_name = user_name
        # The code of the zone.
        self.zone = zone
        # The zone.
        self.zone_name = zone_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_unit is not None:
            result['CapacityUnit'] = self.capacity_unit
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.commodity_name is not None:
            result['CommodityName'] = self.commodity_name
        if self.coverage_percentage is not None:
            result['CoveragePercentage'] = self.coverage_percentage
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deduct_quantity is not None:
            result['DeductQuantity'] = self.deduct_quantity
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.payment_amount is not None:
            result['PaymentAmount'] = self.payment_amount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.region is not None:
            result['Region'] = self.region
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.total_quantity is not None:
            result['TotalQuantity'] = self.total_quantity
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.zone is not None:
            result['Zone'] = self.zone
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CapacityUnit') is not None:
            self.capacity_unit = m.get('CapacityUnit')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CommodityName') is not None:
            self.commodity_name = m.get('CommodityName')
        if m.get('CoveragePercentage') is not None:
            self.coverage_percentage = m.get('CoveragePercentage')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductQuantity') is not None:
            self.deduct_quantity = m.get('DeductQuantity')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('PaymentAmount') is not None:
            self.payment_amount = m.get('PaymentAmount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TotalQuantity') is not None:
            self.total_quantity = m.get('TotalQuantity')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        return self


class DescribeResourceCoverageDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[DescribeResourceCoverageDetailResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        # The data entries.
        self.items = items
        # The number of entries returned on the current page.
        self.max_results = max_results
        # The token of the next page.
        self.next_token = next_token
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeResourceCoverageDetailResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeResourceCoverageDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeResourceCoverageDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The returned data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeResourceCoverageDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeResourceCoverageDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeResourceCoverageDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeResourceCoverageDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeResourceCoverageTotalRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        end_period: str = None,
        period_type: str = None,
        resource_type: str = None,
        start_period: str = None,
    ):
        # The ID of the account for which you want to query total coverage data. If you do not set this parameter, the data of the current Alibaba Cloud account and its RAM users is queried. To query the data of a RAM user, specify the ID of the RAM user.
        self.bill_owner_id = bill_owner_id
        # The end of the time range to query. The end is excluded from the time range. If you do not set this parameter, the end time is the current time. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.end_period = end_period
        # The time granularity at which total coverage data is queried. Valid values: MONTH, DAY, and HOUR.
        self.period_type = period_type
        # The type of deduction plans whose total coverage data is queried. Valid values: RI and SCU.
        self.resource_type = resource_type
        # The beginning of the time range to query. The beginning is included in the time range. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.start_period = start_period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.end_period is not None:
            result['EndPeriod'] = self.end_period
        if self.period_type is not None:
            result['PeriodType'] = self.period_type
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.start_period is not None:
            result['StartPeriod'] = self.start_period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('EndPeriod') is not None:
            self.end_period = m.get('EndPeriod')
        if m.get('PeriodType') is not None:
            self.period_type = m.get('PeriodType')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('StartPeriod') is not None:
            self.start_period = m.get('StartPeriod')
        return self


class DescribeResourceCoverageTotalResponseBodyDataPeriodCoverage(TeaModel):
    def __init__(
        self,
        coverage_percentage: float = None,
        period: str = None,
    ):
        # The coverage rate of deduction plans within the specified period.
        self.coverage_percentage = coverage_percentage
        # The period.
        # 
        # The value is in the format of yyyyMMddHH.
        self.period = period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.coverage_percentage is not None:
            result['CoveragePercentage'] = self.coverage_percentage
        if self.period is not None:
            result['Period'] = self.period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoveragePercentage') is not None:
            self.coverage_percentage = m.get('CoveragePercentage')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        return self


class DescribeResourceCoverageTotalResponseBodyDataTotalCoverage(TeaModel):
    def __init__(
        self,
        capacity_unit: str = None,
        coverage_percentage: float = None,
        deduct_quantity: float = None,
        total_quantity: float = None,
    ):
        # The unit that is used to measure the resources deducted from deduction plans.
        self.capacity_unit = capacity_unit
        # The total coverage rate of deduction plans.
        self.coverage_percentage = coverage_percentage
        # The total amount of the resources deducted from deduction plans.
        self.deduct_quantity = deduct_quantity
        # The total amount of resources consumed.
        self.total_quantity = total_quantity

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_unit is not None:
            result['CapacityUnit'] = self.capacity_unit
        if self.coverage_percentage is not None:
            result['CoveragePercentage'] = self.coverage_percentage
        if self.deduct_quantity is not None:
            result['DeductQuantity'] = self.deduct_quantity
        if self.total_quantity is not None:
            result['TotalQuantity'] = self.total_quantity
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CapacityUnit') is not None:
            self.capacity_unit = m.get('CapacityUnit')
        if m.get('CoveragePercentage') is not None:
            self.coverage_percentage = m.get('CoveragePercentage')
        if m.get('DeductQuantity') is not None:
            self.deduct_quantity = m.get('DeductQuantity')
        if m.get('TotalQuantity') is not None:
            self.total_quantity = m.get('TotalQuantity')
        return self


class DescribeResourceCoverageTotalResponseBodyData(TeaModel):
    def __init__(
        self,
        period_coverage: List[DescribeResourceCoverageTotalResponseBodyDataPeriodCoverage] = None,
        total_coverage: DescribeResourceCoverageTotalResponseBodyDataTotalCoverage = None,
    ):
        # The information about the coverage rate of deduction plans within a period.
        self.period_coverage = period_coverage
        # The information about the total coverage data of deduction plans.
        self.total_coverage = total_coverage

    def validate(self):
        if self.period_coverage:
            for k in self.period_coverage:
                if k:
                    k.validate()
        if self.total_coverage:
            self.total_coverage.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PeriodCoverage'] = []
        if self.period_coverage is not None:
            for k in self.period_coverage:
                result['PeriodCoverage'].append(k.to_map() if k else None)
        if self.total_coverage is not None:
            result['TotalCoverage'] = self.total_coverage.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.period_coverage = []
        if m.get('PeriodCoverage') is not None:
            for k in m.get('PeriodCoverage'):
                temp_model = DescribeResourceCoverageTotalResponseBodyDataPeriodCoverage()
                self.period_coverage.append(temp_model.from_map(k))
        if m.get('TotalCoverage') is not None:
            temp_model = DescribeResourceCoverageTotalResponseBodyDataTotalCoverage()
            self.total_coverage = temp_model.from_map(m['TotalCoverage'])
        return self


class DescribeResourceCoverageTotalResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeResourceCoverageTotalResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The returned data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeResourceCoverageTotalResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeResourceCoverageTotalResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeResourceCoverageTotalResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeResourceCoverageTotalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeResourcePackageProductRequest(TeaModel):
    def __init__(
        self,
        product_code: str = None,
    ):
        # The code of the service.
        self.product_code = product_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        return self


class DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypePropertiesProperty(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # The name of the property.
        self.name = name
        # The value of the property.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeProperties(TeaModel):
    def __init__(
        self,
        property: List[DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypePropertiesProperty] = None,
    ):
        self.property = property

    def validate(self):
        if self.property:
            for k in self.property:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Property'] = []
        if self.property is not None:
            for k in self.property:
                result['Property'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.property = []
        if m.get('Property') is not None:
            for k in m.get('Property'):
                temp_model = DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypePropertiesProperty()
                self.property.append(temp_model.from_map(k))
        return self


class DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecificationsSpecificationAvailableDurationsAvailableDuration(TeaModel):
    def __init__(
        self,
        name: str = None,
        unit: str = None,
        value: int = None,
    ):
        # The name of the validity period.
        self.name = name
        # The unit of the validity period for the resource plan. Valid values:
        # 
        # *   Month
        # *   Year
        # 
        # Default value: Month.
        self.unit = unit
        # The value of the validity period.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecificationsSpecificationAvailableDurations(TeaModel):
    def __init__(
        self,
        available_duration: List[DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecificationsSpecificationAvailableDurationsAvailableDuration] = None,
    ):
        self.available_duration = available_duration

    def validate(self):
        if self.available_duration:
            for k in self.available_duration:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableDuration'] = []
        if self.available_duration is not None:
            for k in self.available_duration:
                result['AvailableDuration'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.available_duration = []
        if m.get('AvailableDuration') is not None:
            for k in m.get('AvailableDuration'):
                temp_model = DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecificationsSpecificationAvailableDurationsAvailableDuration()
                self.available_duration.append(temp_model.from_map(k))
        return self


class DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecificationsSpecification(TeaModel):
    def __init__(
        self,
        available_durations: DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecificationsSpecificationAvailableDurations = None,
        name: str = None,
        value: str = None,
    ):
        # The validity periods available for the resource plan.
        self.available_durations = available_durations
        # The name of the specification.
        self.name = name
        # The value of the specification.
        self.value = value

    def validate(self):
        if self.available_durations:
            self.available_durations.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_durations is not None:
            result['AvailableDurations'] = self.available_durations.to_map()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableDurations') is not None:
            temp_model = DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecificationsSpecificationAvailableDurations()
            self.available_durations = temp_model.from_map(m['AvailableDurations'])
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecifications(TeaModel):
    def __init__(
        self,
        specification: List[DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecificationsSpecification] = None,
    ):
        self.specification = specification

    def validate(self):
        if self.specification:
            for k in self.specification:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Specification'] = []
        if self.specification is not None:
            for k in self.specification:
                result['Specification'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.specification = []
        if m.get('Specification') is not None:
            for k in m.get('Specification'):
                temp_model = DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecificationsSpecification()
                self.specification.append(temp_model.from_map(k))
        return self


class DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageType(TeaModel):
    def __init__(
        self,
        code: str = None,
        name: str = None,
        properties: DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeProperties = None,
        specifications: DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecifications = None,
    ):
        # The code of the resource plan.
        self.code = code
        # The name of the resource plan type.
        self.name = name
        # The properties of the resource plan.
        self.properties = properties
        # The specifications of the resource plan.
        self.specifications = specifications

    def validate(self):
        if self.properties:
            self.properties.validate()
        if self.specifications:
            self.specifications.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.name is not None:
            result['Name'] = self.name
        if self.properties is not None:
            result['Properties'] = self.properties.to_map()
        if self.specifications is not None:
            result['Specifications'] = self.specifications.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Properties') is not None:
            temp_model = DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeProperties()
            self.properties = temp_model.from_map(m['Properties'])
        if m.get('Specifications') is not None:
            temp_model = DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageTypeSpecifications()
            self.specifications = temp_model.from_map(m['Specifications'])
        return self


class DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypes(TeaModel):
    def __init__(
        self,
        package_type: List[DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageType] = None,
    ):
        self.package_type = package_type

    def validate(self):
        if self.package_type:
            for k in self.package_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PackageType'] = []
        if self.package_type is not None:
            for k in self.package_type:
                result['PackageType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.package_type = []
        if m.get('PackageType') is not None:
            for k in m.get('PackageType'):
                temp_model = DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypesPackageType()
                self.package_type.append(temp_model.from_map(k))
        return self


class DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackage(TeaModel):
    def __init__(
        self,
        name: str = None,
        package_types: DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypes = None,
        product_code: str = None,
        product_type: str = None,
    ):
        # The name of the resource plan.
        self.name = name
        # The types of the resource plans.
        self.package_types = package_types
        # The code of the service.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type

    def validate(self):
        if self.package_types:
            self.package_types.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.package_types is not None:
            result['PackageTypes'] = self.package_types.to_map()
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PackageTypes') is not None:
            temp_model = DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackagePackageTypes()
            self.package_types = temp_model.from_map(m['PackageTypes'])
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        return self


class DescribeResourcePackageProductResponseBodyDataResourcePackages(TeaModel):
    def __init__(
        self,
        resource_package: List[DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackage] = None,
    ):
        self.resource_package = resource_package

    def validate(self):
        if self.resource_package:
            for k in self.resource_package:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ResourcePackage'] = []
        if self.resource_package is not None:
            for k in self.resource_package:
                result['ResourcePackage'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.resource_package = []
        if m.get('ResourcePackage') is not None:
            for k in m.get('ResourcePackage'):
                temp_model = DescribeResourcePackageProductResponseBodyDataResourcePackagesResourcePackage()
                self.resource_package.append(temp_model.from_map(k))
        return self


class DescribeResourcePackageProductResponseBodyData(TeaModel):
    def __init__(
        self,
        resource_packages: DescribeResourcePackageProductResponseBodyDataResourcePackages = None,
    ):
        # The details about the resource plans.
        self.resource_packages = resource_packages

    def validate(self):
        if self.resource_packages:
            self.resource_packages.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_packages is not None:
            result['ResourcePackages'] = self.resource_packages.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourcePackages') is not None:
            temp_model = DescribeResourcePackageProductResponseBodyDataResourcePackages()
            self.resource_packages = temp_model.from_map(m['ResourcePackages'])
        return self


class DescribeResourcePackageProductResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeResourcePackageProductResponseBodyData = None,
        message: str = None,
        order_id: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the order.
        self.order_id = order_id
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeResourcePackageProductResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeResourcePackageProductResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeResourcePackageProductResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeResourcePackageProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeResourceUsageDetailRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        end_period: str = None,
        max_results: int = None,
        next_token: str = None,
        period_type: str = None,
        resource_type: str = None,
        start_period: str = None,
    ):
        self.bill_owner_id = bill_owner_id
        # The end of the time range to query. The end is excluded from the time range. If you do not set this parameter, the end time is the current time. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.end_period = end_period
        # The maximum number of entries to return. Default value: 20. Maximum value: 300.
        self.max_results = max_results
        # The token that is used to retrieve the next page of results. You do not need to set this parameter if you query usage details within a specific time range for the first time. The response returns a token that you can use to query usage details that are displayed on the next page. If a null value is returned for the NextToken parameter, no more usage details can be queried.
        self.next_token = next_token
        # The time granularity at which usage details are queried. Valid values: MONTH, DAY, and HOUR.
        self.period_type = period_type
        # The type of deduction plans whose usage details are queried. Valid values: RI and SCU.
        self.resource_type = resource_type
        # The beginning of the time range to query. The beginning is included in the time range. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.start_period = start_period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.end_period is not None:
            result['EndPeriod'] = self.end_period
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.period_type is not None:
            result['PeriodType'] = self.period_type
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.start_period is not None:
            result['StartPeriod'] = self.start_period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('EndPeriod') is not None:
            self.end_period = m.get('EndPeriod')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('PeriodType') is not None:
            self.period_type = m.get('PeriodType')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('StartPeriod') is not None:
            self.start_period = m.get('StartPeriod')
        return self


class DescribeResourceUsageDetailResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        capacity_unit: str = None,
        currency: str = None,
        deduct_quantity: float = None,
        end_time: str = None,
        image_type: str = None,
        instance_spec: str = None,
        postpaid_cost: str = None,
        potential_saved_cost: str = None,
        quantity: int = None,
        region: str = None,
        region_no: str = None,
        reservation_cost: str = None,
        resource_instance_id: str = None,
        saved_cost: str = None,
        start_time: str = None,
        status: str = None,
        status_name: str = None,
        total_quantity: float = None,
        usage_percentage: float = None,
        user_id: str = None,
        user_name: str = None,
        zone: str = None,
        zone_name: str = None,
    ):
        # The unit that is used to measure the resources deducted from deduction plans.
        self.capacity_unit = capacity_unit
        # The currency in which deduction plans were priced.
        self.currency = currency
        # The amount of the resources deducted from deduction plans.
        self.deduct_quantity = deduct_quantity
        # The end of the time range in which the usage details were queried.
        self.end_time = end_time
        # The operating system.
        self.image_type = image_type
        # The specifications of a deduction plan.
        self.instance_spec = instance_spec
        # The equivalent of pay-as-you-go costs.
        self.postpaid_cost = postpaid_cost
        # The potential net savings.
        self.potential_saved_cost = potential_saved_cost
        # The number of deduction plans.
        self.quantity = quantity
        # The region.
        self.region = region
        # The code of the region.
        self.region_no = region_no
        # The fee of purchased deduction plans.
        self.reservation_cost = reservation_cost
        # The ID of a deduction plan.
        self.resource_instance_id = resource_instance_id
        # The net savings.
        self.saved_cost = saved_cost
        # The beginning of the time range in which the usage details were queried.
        self.start_time = start_time
        # The status of the deduction plan.
        self.status = status
        # The name of the state.
        self.status_name = status_name
        # The total capacity of deduction plans.
        self.total_quantity = total_quantity
        # The usage of deduction plans.
        self.usage_percentage = usage_percentage
        # The ID of the account.
        self.user_id = user_id
        # The username of the account.
        self.user_name = user_name
        # The code of the zone.
        self.zone = zone
        # The zone.
        self.zone_name = zone_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_unit is not None:
            result['CapacityUnit'] = self.capacity_unit
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deduct_quantity is not None:
            result['DeductQuantity'] = self.deduct_quantity
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.image_type is not None:
            result['ImageType'] = self.image_type
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.postpaid_cost is not None:
            result['PostpaidCost'] = self.postpaid_cost
        if self.potential_saved_cost is not None:
            result['PotentialSavedCost'] = self.potential_saved_cost
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.region is not None:
            result['Region'] = self.region
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.reservation_cost is not None:
            result['ReservationCost'] = self.reservation_cost
        if self.resource_instance_id is not None:
            result['ResourceInstanceId'] = self.resource_instance_id
        if self.saved_cost is not None:
            result['SavedCost'] = self.saved_cost
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.status_name is not None:
            result['StatusName'] = self.status_name
        if self.total_quantity is not None:
            result['TotalQuantity'] = self.total_quantity
        if self.usage_percentage is not None:
            result['UsagePercentage'] = self.usage_percentage
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.zone is not None:
            result['Zone'] = self.zone
        if self.zone_name is not None:
            result['ZoneName'] = self.zone_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CapacityUnit') is not None:
            self.capacity_unit = m.get('CapacityUnit')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductQuantity') is not None:
            self.deduct_quantity = m.get('DeductQuantity')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ImageType') is not None:
            self.image_type = m.get('ImageType')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('PostpaidCost') is not None:
            self.postpaid_cost = m.get('PostpaidCost')
        if m.get('PotentialSavedCost') is not None:
            self.potential_saved_cost = m.get('PotentialSavedCost')
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('ReservationCost') is not None:
            self.reservation_cost = m.get('ReservationCost')
        if m.get('ResourceInstanceId') is not None:
            self.resource_instance_id = m.get('ResourceInstanceId')
        if m.get('SavedCost') is not None:
            self.saved_cost = m.get('SavedCost')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusName') is not None:
            self.status_name = m.get('StatusName')
        if m.get('TotalQuantity') is not None:
            self.total_quantity = m.get('TotalQuantity')
        if m.get('UsagePercentage') is not None:
            self.usage_percentage = m.get('UsagePercentage')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        if m.get('ZoneName') is not None:
            self.zone_name = m.get('ZoneName')
        return self


class DescribeResourceUsageDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[DescribeResourceUsageDetailResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        # The data entries.
        self.items = items
        # The number of entries returned on the current page.
        self.max_results = max_results
        # The token of the next page.
        self.next_token = next_token
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeResourceUsageDetailResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeResourceUsageDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeResourceUsageDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The returned data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeResourceUsageDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeResourceUsageDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeResourceUsageDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeResourceUsageDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeResourceUsageTotalRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        end_period: str = None,
        period_type: str = None,
        resource_type: str = None,
        start_period: str = None,
    ):
        self.bill_owner_id = bill_owner_id
        self.end_period = end_period
        self.period_type = period_type
        self.resource_type = resource_type
        self.start_period = start_period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.end_period is not None:
            result['EndPeriod'] = self.end_period
        if self.period_type is not None:
            result['PeriodType'] = self.period_type
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.start_period is not None:
            result['StartPeriod'] = self.start_period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('EndPeriod') is not None:
            self.end_period = m.get('EndPeriod')
        if m.get('PeriodType') is not None:
            self.period_type = m.get('PeriodType')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('StartPeriod') is not None:
            self.start_period = m.get('StartPeriod')
        return self


class DescribeResourceUsageTotalResponseBodyDataPeriodCoverage(TeaModel):
    def __init__(
        self,
        period: str = None,
        usage_percentage: float = None,
    ):
        # The period.
        self.period = period
        # The usage of deduction plans within the specified period.
        self.usage_percentage = usage_percentage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.period is not None:
            result['Period'] = self.period
        if self.usage_percentage is not None:
            result['UsagePercentage'] = self.usage_percentage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('UsagePercentage') is not None:
            self.usage_percentage = m.get('UsagePercentage')
        return self


class DescribeResourceUsageTotalResponseBodyDataTotalUsage(TeaModel):
    def __init__(
        self,
        postpaid_cost: float = None,
        potential_saved_cost: float = None,
        reservation_cost: float = None,
        saved_cost: float = None,
        usage_percentage: float = None,
    ):
        # The total costs of pay-as-you-go instances.
        self.postpaid_cost = postpaid_cost
        # The total potential savings.
        self.potential_saved_cost = potential_saved_cost
        # The fee of purchased deduction plans.
        self.reservation_cost = reservation_cost
        # The total savings.
        self.saved_cost = saved_cost
        # The total usage of deduction plans.
        self.usage_percentage = usage_percentage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.postpaid_cost is not None:
            result['PostpaidCost'] = self.postpaid_cost
        if self.potential_saved_cost is not None:
            result['PotentialSavedCost'] = self.potential_saved_cost
        if self.reservation_cost is not None:
            result['ReservationCost'] = self.reservation_cost
        if self.saved_cost is not None:
            result['SavedCost'] = self.saved_cost
        if self.usage_percentage is not None:
            result['UsagePercentage'] = self.usage_percentage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PostpaidCost') is not None:
            self.postpaid_cost = m.get('PostpaidCost')
        if m.get('PotentialSavedCost') is not None:
            self.potential_saved_cost = m.get('PotentialSavedCost')
        if m.get('ReservationCost') is not None:
            self.reservation_cost = m.get('ReservationCost')
        if m.get('SavedCost') is not None:
            self.saved_cost = m.get('SavedCost')
        if m.get('UsagePercentage') is not None:
            self.usage_percentage = m.get('UsagePercentage')
        return self


class DescribeResourceUsageTotalResponseBodyData(TeaModel):
    def __init__(
        self,
        period_coverage: List[DescribeResourceUsageTotalResponseBodyDataPeriodCoverage] = None,
        total_usage: DescribeResourceUsageTotalResponseBodyDataTotalUsage = None,
    ):
        # The information about the usage of deduction plans within a period.
        self.period_coverage = period_coverage
        # The information about the total usage data of deduction plans.
        self.total_usage = total_usage

    def validate(self):
        if self.period_coverage:
            for k in self.period_coverage:
                if k:
                    k.validate()
        if self.total_usage:
            self.total_usage.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PeriodCoverage'] = []
        if self.period_coverage is not None:
            for k in self.period_coverage:
                result['PeriodCoverage'].append(k.to_map() if k else None)
        if self.total_usage is not None:
            result['TotalUsage'] = self.total_usage.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.period_coverage = []
        if m.get('PeriodCoverage') is not None:
            for k in m.get('PeriodCoverage'):
                temp_model = DescribeResourceUsageTotalResponseBodyDataPeriodCoverage()
                self.period_coverage.append(temp_model.from_map(k))
        if m.get('TotalUsage') is not None:
            temp_model = DescribeResourceUsageTotalResponseBodyDataTotalUsage()
            self.total_usage = temp_model.from_map(m['TotalUsage'])
        return self


class DescribeResourceUsageTotalResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeResourceUsageTotalResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The returned data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeResourceUsageTotalResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeResourceUsageTotalResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeResourceUsageTotalResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeResourceUsageTotalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSavingsPlansCoverageDetailRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        end_period: str = None,
        max_results: int = None,
        period_type: str = None,
        start_period: str = None,
        token: str = None,
    ):
        # The ID of the account for which you want to query coverage details. If you do not set this parameter, the data of the current Alibaba Cloud account and its RAM users is queried. To query the data of a RAM user, specify the ID of the RAM user.
        self.bill_owner_id = bill_owner_id
        # The end of the time range to query. The end is excluded from the time range. If you do not set this parameter, the end time is the current time. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.end_period = end_period
        # The maximum number of entries to return. Default value: 20. Maximum value: 300.
        self.max_results = max_results
        # The time granularity at which coverage details are queried. Valid values: MONTH, DAY, and HOUR.
        self.period_type = period_type
        # The beginning of the time range to query. The beginning is included in the time range. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.start_period = start_period
        # The token that is used to retrieve the next page of results. You do not need to set this parameter if you query coverage details within a specific time range for the first time. The response returns a token that you can use to query coverage details that are displayed on the next page. If a null value is returned for the NextToken parameter, no more coverage details can be queried.
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.end_period is not None:
            result['EndPeriod'] = self.end_period
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.period_type is not None:
            result['PeriodType'] = self.period_type
        if self.start_period is not None:
            result['StartPeriod'] = self.start_period
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('EndPeriod') is not None:
            self.end_period = m.get('EndPeriod')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('PeriodType') is not None:
            self.period_type = m.get('PeriodType')
        if m.get('StartPeriod') is not None:
            self.start_period = m.get('StartPeriod')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class DescribeSavingsPlansCoverageDetailResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        coverage_percentage: float = None,
        currency: str = None,
        deduct_amount: float = None,
        end_period: str = None,
        instance_id: str = None,
        instance_spec: str = None,
        postpaid_cost: float = None,
        region: str = None,
        start_period: str = None,
        total_amount: float = None,
        user_id: int = None,
        user_name: str = None,
    ):
        # The coverage.
        self.coverage_percentage = coverage_percentage
        # The currency.
        self.currency = currency
        # The deducted amount.
        self.deduct_amount = deduct_amount
        # The end time.
        self.end_period = end_period
        # The ID of the instance.
        self.instance_id = instance_id
        # The specifications.
        self.instance_spec = instance_spec
        # The pay-as-you-go cost.
        self.postpaid_cost = postpaid_cost
        # The region.
        self.region = region
        # The start time.
        self.start_period = start_period
        # The total expenditure.
        self.total_amount = total_amount
        # The ID of the account.
        self.user_id = user_id
        # The username of the account.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.coverage_percentage is not None:
            result['CoveragePercentage'] = self.coverage_percentage
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deduct_amount is not None:
            result['DeductAmount'] = self.deduct_amount
        if self.end_period is not None:
            result['EndPeriod'] = self.end_period
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.postpaid_cost is not None:
            result['PostpaidCost'] = self.postpaid_cost
        if self.region is not None:
            result['Region'] = self.region
        if self.start_period is not None:
            result['StartPeriod'] = self.start_period
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoveragePercentage') is not None:
            self.coverage_percentage = m.get('CoveragePercentage')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductAmount') is not None:
            self.deduct_amount = m.get('DeductAmount')
        if m.get('EndPeriod') is not None:
            self.end_period = m.get('EndPeriod')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('PostpaidCost') is not None:
            self.postpaid_cost = m.get('PostpaidCost')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('StartPeriod') is not None:
            self.start_period = m.get('StartPeriod')
        if m.get('TotalAmount') is not None:
            self.total_amount = m.get('TotalAmount')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeSavingsPlansCoverageDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[DescribeSavingsPlansCoverageDetailResponseBodyDataItems] = None,
        next_token: str = None,
        total_count: int = None,
    ):
        # The data entries.
        self.items = items
        # The token of the next page.
        self.next_token = next_token
        # The total number of entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeSavingsPlansCoverageDetailResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSavingsPlansCoverageDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeSavingsPlansCoverageDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The return data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSavingsPlansCoverageDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSavingsPlansCoverageDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSavingsPlansCoverageDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSavingsPlansCoverageDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSavingsPlansCoverageTotalRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        end_period: str = None,
        period_type: str = None,
        start_period: str = None,
    ):
        # The ID of the account for which you want to query coverage summary. If you do not set this parameter, the data of the current Alibaba Cloud account and its RAM users is queried. To query the data of a RAM user, specify the ID of the RAM user.
        self.bill_owner_id = bill_owner_id
        # The end of the time range to query. The end is excluded from the time range. If you do not set this parameter, the end time is the current time. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.end_period = end_period
        # The time granularity at which coverage summary are queried. Valid values: MONTH, DAY, and HOUR.
        self.period_type = period_type
        # The beginning of the time range to query. The beginning is included in the time range. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.start_period = start_period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.end_period is not None:
            result['EndPeriod'] = self.end_period
        if self.period_type is not None:
            result['PeriodType'] = self.period_type
        if self.start_period is not None:
            result['StartPeriod'] = self.start_period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('EndPeriod') is not None:
            self.end_period = m.get('EndPeriod')
        if m.get('PeriodType') is not None:
            self.period_type = m.get('PeriodType')
        if m.get('StartPeriod') is not None:
            self.start_period = m.get('StartPeriod')
        return self


class DescribeSavingsPlansCoverageTotalResponseBodyDataPeriodCoverage(TeaModel):
    def __init__(
        self,
        percentage: float = None,
        period: str = None,
    ):
        # The coverage.
        self.percentage = percentage
        # The period.
        # 
        # The value is in the format of yyyyMMddHH.
        self.period = period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.period is not None:
            result['Period'] = self.period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        return self


class DescribeSavingsPlansCoverageTotalResponseBodyDataTotalCoverage(TeaModel):
    def __init__(
        self,
        coverage_percentage: float = None,
        deduct_amount: float = None,
    ):
        # The total coverage.
        self.coverage_percentage = coverage_percentage
        # The total deducted amount.
        self.deduct_amount = deduct_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.coverage_percentage is not None:
            result['CoveragePercentage'] = self.coverage_percentage
        if self.deduct_amount is not None:
            result['DeductAmount'] = self.deduct_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CoveragePercentage') is not None:
            self.coverage_percentage = m.get('CoveragePercentage')
        if m.get('DeductAmount') is not None:
            self.deduct_amount = m.get('DeductAmount')
        return self


class DescribeSavingsPlansCoverageTotalResponseBodyData(TeaModel):
    def __init__(
        self,
        period_coverage: List[DescribeSavingsPlansCoverageTotalResponseBodyDataPeriodCoverage] = None,
        total_coverage: DescribeSavingsPlansCoverageTotalResponseBodyDataTotalCoverage = None,
    ):
        # The coverage in different periods.
        self.period_coverage = period_coverage
        # The coverage summary.
        self.total_coverage = total_coverage

    def validate(self):
        if self.period_coverage:
            for k in self.period_coverage:
                if k:
                    k.validate()
        if self.total_coverage:
            self.total_coverage.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PeriodCoverage'] = []
        if self.period_coverage is not None:
            for k in self.period_coverage:
                result['PeriodCoverage'].append(k.to_map() if k else None)
        if self.total_coverage is not None:
            result['TotalCoverage'] = self.total_coverage.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.period_coverage = []
        if m.get('PeriodCoverage') is not None:
            for k in m.get('PeriodCoverage'):
                temp_model = DescribeSavingsPlansCoverageTotalResponseBodyDataPeriodCoverage()
                self.period_coverage.append(temp_model.from_map(k))
        if m.get('TotalCoverage') is not None:
            temp_model = DescribeSavingsPlansCoverageTotalResponseBodyDataTotalCoverage()
            self.total_coverage = temp_model.from_map(m['TotalCoverage'])
        return self


class DescribeSavingsPlansCoverageTotalResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeSavingsPlansCoverageTotalResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The return data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSavingsPlansCoverageTotalResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSavingsPlansCoverageTotalResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSavingsPlansCoverageTotalResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSavingsPlansCoverageTotalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSavingsPlansUsageDetailRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        end_period: str = None,
        max_results: int = None,
        period_type: str = None,
        start_period: str = None,
        token: str = None,
    ):
        # The ID of the account for which you want to query usage details. If you do not set this parameter, the data of the current Alibaba Cloud account and its RAM users is queried. To query the data of a RAM user, specify the ID of the RAM user.
        self.bill_owner_id = bill_owner_id
        # The end of the time range to query. The end is excluded from the time range. If you do not set this parameter, the end time is the current time. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.end_period = end_period
        # The maximum number of entries to return. Default value: 20. Maximum value: 300.
        self.max_results = max_results
        # The time granularity at which usage details are queried. Valid values: MONTH, DAY, and HOUR.
        self.period_type = period_type
        # The beginning of the time range to query. The beginning is included in the time range. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.start_period = start_period
        # The token that is used to retrieve the next page of results. You do not need to set this parameter if you query usage details within a specific time range for the first time. The response returns a token that you can use to query usage details that are displayed on the next page. If a null value is returned for the NextToken parameter, no more coverage details can be queried.
        self.token = token

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.end_period is not None:
            result['EndPeriod'] = self.end_period
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.period_type is not None:
            result['PeriodType'] = self.period_type
        if self.start_period is not None:
            result['StartPeriod'] = self.start_period
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('EndPeriod') is not None:
            self.end_period = m.get('EndPeriod')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('PeriodType') is not None:
            self.period_type = m.get('PeriodType')
        if m.get('StartPeriod') is not None:
            self.start_period = m.get('StartPeriod')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class DescribeSavingsPlansUsageDetailResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        currency: str = None,
        deduct_value: float = None,
        end_period: str = None,
        instance_id: str = None,
        pool_value: float = None,
        postpaid_cost: float = None,
        saved_cost: float = None,
        start_period: str = None,
        status: str = None,
        type: str = None,
        usage_percentage: float = None,
        user_id: int = None,
        user_name: str = None,
    ):
        # The currency.
        self.currency = currency
        # The used amount of the savings plan.
        self.deduct_value = deduct_value
        # The end time.
        self.end_period = end_period
        # The ID of the instance.
        self.instance_id = instance_id
        # The total amount of the savings plan.
        self.pool_value = pool_value
        # The pay-as-you-go cost.
        self.postpaid_cost = postpaid_cost
        # The amount that is saved.
        self.saved_cost = saved_cost
        # The start time.
        self.start_period = start_period
        # The status of the instance.
        # 
        # A value of -1 indicates that the payment is overdue. A value of 1 indicates that the instance is active.
        self.status = status
        # The type of the savings plan. Valid values: universal and ECS compute.
        self.type = type
        # The usage.
        self.usage_percentage = usage_percentage
        # The ID of the account.
        self.user_id = user_id
        # The username of the account.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deduct_value is not None:
            result['DeductValue'] = self.deduct_value
        if self.end_period is not None:
            result['EndPeriod'] = self.end_period
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.pool_value is not None:
            result['PoolValue'] = self.pool_value
        if self.postpaid_cost is not None:
            result['PostpaidCost'] = self.postpaid_cost
        if self.saved_cost is not None:
            result['SavedCost'] = self.saved_cost
        if self.start_period is not None:
            result['StartPeriod'] = self.start_period
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.usage_percentage is not None:
            result['UsagePercentage'] = self.usage_percentage
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductValue') is not None:
            self.deduct_value = m.get('DeductValue')
        if m.get('EndPeriod') is not None:
            self.end_period = m.get('EndPeriod')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PoolValue') is not None:
            self.pool_value = m.get('PoolValue')
        if m.get('PostpaidCost') is not None:
            self.postpaid_cost = m.get('PostpaidCost')
        if m.get('SavedCost') is not None:
            self.saved_cost = m.get('SavedCost')
        if m.get('StartPeriod') is not None:
            self.start_period = m.get('StartPeriod')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UsagePercentage') is not None:
            self.usage_percentage = m.get('UsagePercentage')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeSavingsPlansUsageDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[DescribeSavingsPlansUsageDetailResponseBodyDataItems] = None,
        next_token: str = None,
        total_count: int = None,
    ):
        # The data entries.
        self.items = items
        # The token of the next page.
        self.next_token = next_token
        # The total number of entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeSavingsPlansUsageDetailResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSavingsPlansUsageDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeSavingsPlansUsageDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The return data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSavingsPlansUsageDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSavingsPlansUsageDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSavingsPlansUsageDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSavingsPlansUsageDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSavingsPlansUsageTotalRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        end_period: str = None,
        period_type: str = None,
        start_period: str = None,
    ):
        # The ID of the account for which you want to query usage summary. If you do not set this parameter, the data of the current Alibaba Cloud account and its RAM users is queried. To query the data of a RAM user, specify the ID of the RAM user.
        self.bill_owner_id = bill_owner_id
        # The end of the time range to query. The end is excluded from the time range. If you do not set this parameter, the end time is the current time. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.end_period = end_period
        # The time granularity at which usage summary are queried. Valid values: MONTH, DAY, and HOUR.
        self.period_type = period_type
        # The beginning of the time range to query. The beginning is included in the time range. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.start_period = start_period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.end_period is not None:
            result['EndPeriod'] = self.end_period
        if self.period_type is not None:
            result['PeriodType'] = self.period_type
        if self.start_period is not None:
            result['StartPeriod'] = self.start_period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('EndPeriod') is not None:
            self.end_period = m.get('EndPeriod')
        if m.get('PeriodType') is not None:
            self.period_type = m.get('PeriodType')
        if m.get('StartPeriod') is not None:
            self.start_period = m.get('StartPeriod')
        return self


class DescribeSavingsPlansUsageTotalResponseBodyDataPeriodCoverage(TeaModel):
    def __init__(
        self,
        percentage: float = None,
        period: str = None,
    ):
        # The usage.
        self.percentage = percentage
        # The period.
        # 
        # The value is in the format of yyyyMMddHH.
        self.period = period

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.period is not None:
            result['Period'] = self.period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        return self


class DescribeSavingsPlansUsageTotalResponseBodyDataTotalUsage(TeaModel):
    def __init__(
        self,
        pool_value: float = None,
        postpaid_cost: float = None,
        saved_cost: float = None,
        usage_percentage: float = None,
    ):
        # The total amount of the savings plan.
        self.pool_value = pool_value
        # The pay-as-you-go cost.
        self.postpaid_cost = postpaid_cost
        # The amount that is saved.
        self.saved_cost = saved_cost
        # The total usage.
        self.usage_percentage = usage_percentage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pool_value is not None:
            result['PoolValue'] = self.pool_value
        if self.postpaid_cost is not None:
            result['PostpaidCost'] = self.postpaid_cost
        if self.saved_cost is not None:
            result['SavedCost'] = self.saved_cost
        if self.usage_percentage is not None:
            result['UsagePercentage'] = self.usage_percentage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PoolValue') is not None:
            self.pool_value = m.get('PoolValue')
        if m.get('PostpaidCost') is not None:
            self.postpaid_cost = m.get('PostpaidCost')
        if m.get('SavedCost') is not None:
            self.saved_cost = m.get('SavedCost')
        if m.get('UsagePercentage') is not None:
            self.usage_percentage = m.get('UsagePercentage')
        return self


class DescribeSavingsPlansUsageTotalResponseBodyData(TeaModel):
    def __init__(
        self,
        period_coverage: List[DescribeSavingsPlansUsageTotalResponseBodyDataPeriodCoverage] = None,
        total_usage: DescribeSavingsPlansUsageTotalResponseBodyDataTotalUsage = None,
    ):
        # The usage in different periods.
        self.period_coverage = period_coverage
        # The usage summary.
        self.total_usage = total_usage

    def validate(self):
        if self.period_coverage:
            for k in self.period_coverage:
                if k:
                    k.validate()
        if self.total_usage:
            self.total_usage.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PeriodCoverage'] = []
        if self.period_coverage is not None:
            for k in self.period_coverage:
                result['PeriodCoverage'].append(k.to_map() if k else None)
        if self.total_usage is not None:
            result['TotalUsage'] = self.total_usage.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.period_coverage = []
        if m.get('PeriodCoverage') is not None:
            for k in m.get('PeriodCoverage'):
                temp_model = DescribeSavingsPlansUsageTotalResponseBodyDataPeriodCoverage()
                self.period_coverage.append(temp_model.from_map(k))
        if m.get('TotalUsage') is not None:
            temp_model = DescribeSavingsPlansUsageTotalResponseBodyDataTotalUsage()
            self.total_usage = temp_model.from_map(m['TotalUsage'])
        return self


class DescribeSavingsPlansUsageTotalResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeSavingsPlansUsageTotalResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The return data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSavingsPlansUsageTotalResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSavingsPlansUsageTotalResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSavingsPlansUsageTotalResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSavingsPlansUsageTotalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSplitItemBillRequestTagFilter(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_values: List[str] = None,
    ):
        self.tag_key = tag_key
        self.tag_values = tag_values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_values is not None:
            result['TagValues'] = self.tag_values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValues') is not None:
            self.tag_values = m.get('TagValues')
        return self


class DescribeSplitItemBillRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        billing_cycle: str = None,
        billing_date: str = None,
        granularity: str = None,
        instance_id: str = None,
        max_results: int = None,
        next_token: str = None,
        owner_id: int = None,
        product_code: str = None,
        product_type: str = None,
        split_item_id: str = None,
        subscription_type: str = None,
        tag_filter: List[DescribeSplitItemBillRequestTagFilter] = None,
    ):
        self.bill_owner_id = bill_owner_id
        self.billing_cycle = billing_cycle
        self.billing_date = billing_date
        self.granularity = granularity
        self.instance_id = instance_id
        self.max_results = max_results
        self.next_token = next_token
        self.owner_id = owner_id
        self.product_code = product_code
        self.product_type = product_type
        self.split_item_id = split_item_id
        self.subscription_type = subscription_type
        self.tag_filter = tag_filter

    def validate(self):
        if self.tag_filter:
            for k in self.tag_filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.billing_date is not None:
            result['BillingDate'] = self.billing_date
        if self.granularity is not None:
            result['Granularity'] = self.granularity
        if self.instance_id is not None:
            result['InstanceID'] = self.instance_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.split_item_id is not None:
            result['SplitItemID'] = self.split_item_id
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        result['TagFilter'] = []
        if self.tag_filter is not None:
            for k in self.tag_filter:
                result['TagFilter'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('BillingDate') is not None:
            self.billing_date = m.get('BillingDate')
        if m.get('Granularity') is not None:
            self.granularity = m.get('Granularity')
        if m.get('InstanceID') is not None:
            self.instance_id = m.get('InstanceID')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SplitItemID') is not None:
            self.split_item_id = m.get('SplitItemID')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        self.tag_filter = []
        if m.get('TagFilter') is not None:
            for k in m.get('TagFilter'):
                temp_model = DescribeSplitItemBillRequestTagFilter()
                self.tag_filter.append(temp_model.from_map(k))
        return self


class DescribeSplitItemBillResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        adjust_amount: float = None,
        bill_account_id: str = None,
        bill_account_name: str = None,
        billing_date: str = None,
        billing_item: str = None,
        billing_item_code: str = None,
        billing_type: str = None,
        biz_type: str = None,
        cash_amount: float = None,
        commodity_code: str = None,
        cost_unit: str = None,
        currency: str = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        deducted_by_resource_package: str = None,
        instance_config: str = None,
        instance_id: str = None,
        instance_spec: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        invoice_discount: float = None,
        item: str = None,
        item_name: str = None,
        list_price: str = None,
        list_price_unit: str = None,
        nick_name: str = None,
        outstanding_amount: float = None,
        owner_id: str = None,
        payment_amount: float = None,
        pip_code: str = None,
        pretax_amount: float = None,
        pretax_gross_amount: float = None,
        product_code: str = None,
        product_detail: str = None,
        product_name: str = None,
        product_type: str = None,
        region: str = None,
        resource_group: str = None,
        service_period: str = None,
        service_period_unit: str = None,
        split_account_id: str = None,
        split_account_name: str = None,
        split_billing_cycle: str = None,
        split_billing_date: str = None,
        split_commodity_code: str = None,
        split_item_id: str = None,
        split_item_name: str = None,
        split_product_detail: str = None,
        subscription_type: str = None,
        tag: str = None,
        usage: str = None,
        usage_unit: str = None,
        zone: str = None,
    ):
        self.adjust_amount = adjust_amount
        self.bill_account_id = bill_account_id
        self.bill_account_name = bill_account_name
        self.billing_date = billing_date
        self.billing_item = billing_item
        self.billing_item_code = billing_item_code
        self.billing_type = billing_type
        self.biz_type = biz_type
        self.cash_amount = cash_amount
        self.commodity_code = commodity_code
        self.cost_unit = cost_unit
        self.currency = currency
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        self.deducted_by_coupons = deducted_by_coupons
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        self.deducted_by_resource_package = deducted_by_resource_package
        self.instance_config = instance_config
        self.instance_id = instance_id
        self.instance_spec = instance_spec
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.invoice_discount = invoice_discount
        self.item = item
        self.item_name = item_name
        self.list_price = list_price
        self.list_price_unit = list_price_unit
        self.nick_name = nick_name
        self.outstanding_amount = outstanding_amount
        self.owner_id = owner_id
        self.payment_amount = payment_amount
        self.pip_code = pip_code
        self.pretax_amount = pretax_amount
        self.pretax_gross_amount = pretax_gross_amount
        self.product_code = product_code
        self.product_detail = product_detail
        self.product_name = product_name
        self.product_type = product_type
        self.region = region
        self.resource_group = resource_group
        self.service_period = service_period
        self.service_period_unit = service_period_unit
        self.split_account_id = split_account_id
        self.split_account_name = split_account_name
        self.split_billing_cycle = split_billing_cycle
        self.split_billing_date = split_billing_date
        self.split_commodity_code = split_commodity_code
        self.split_item_id = split_item_id
        self.split_item_name = split_item_name
        self.split_product_detail = split_product_detail
        self.subscription_type = subscription_type
        self.tag = tag
        self.usage = usage
        self.usage_unit = usage_unit
        self.zone = zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_amount is not None:
            result['AdjustAmount'] = self.adjust_amount
        if self.bill_account_id is not None:
            result['BillAccountID'] = self.bill_account_id
        if self.bill_account_name is not None:
            result['BillAccountName'] = self.bill_account_name
        if self.billing_date is not None:
            result['BillingDate'] = self.billing_date
        if self.billing_item is not None:
            result['BillingItem'] = self.billing_item
        if self.billing_item_code is not None:
            result['BillingItemCode'] = self.billing_item_code
        if self.billing_type is not None:
            result['BillingType'] = self.billing_type
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.cash_amount is not None:
            result['CashAmount'] = self.cash_amount
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.cost_unit is not None:
            result['CostUnit'] = self.cost_unit
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.deducted_by_resource_package is not None:
            result['DeductedByResourcePackage'] = self.deducted_by_resource_package
        if self.instance_config is not None:
            result['InstanceConfig'] = self.instance_config
        if self.instance_id is not None:
            result['InstanceID'] = self.instance_id
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.internet_ip is not None:
            result['InternetIP'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIP'] = self.intranet_ip
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.item is not None:
            result['Item'] = self.item
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.list_price is not None:
            result['ListPrice'] = self.list_price
        if self.list_price_unit is not None:
            result['ListPriceUnit'] = self.list_price_unit
        if self.nick_name is not None:
            result['NickName'] = self.nick_name
        if self.outstanding_amount is not None:
            result['OutstandingAmount'] = self.outstanding_amount
        if self.owner_id is not None:
            result['OwnerID'] = self.owner_id
        if self.payment_amount is not None:
            result['PaymentAmount'] = self.payment_amount
        if self.pip_code is not None:
            result['PipCode'] = self.pip_code
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_group is not None:
            result['ResourceGroup'] = self.resource_group
        if self.service_period is not None:
            result['ServicePeriod'] = self.service_period
        if self.service_period_unit is not None:
            result['ServicePeriodUnit'] = self.service_period_unit
        if self.split_account_id is not None:
            result['SplitAccountID'] = self.split_account_id
        if self.split_account_name is not None:
            result['SplitAccountName'] = self.split_account_name
        if self.split_billing_cycle is not None:
            result['SplitBillingCycle'] = self.split_billing_cycle
        if self.split_billing_date is not None:
            result['SplitBillingDate'] = self.split_billing_date
        if self.split_commodity_code is not None:
            result['SplitCommodityCode'] = self.split_commodity_code
        if self.split_item_id is not None:
            result['SplitItemID'] = self.split_item_id
        if self.split_item_name is not None:
            result['SplitItemName'] = self.split_item_name
        if self.split_product_detail is not None:
            result['SplitProductDetail'] = self.split_product_detail
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.usage_unit is not None:
            result['UsageUnit'] = self.usage_unit
        if self.zone is not None:
            result['Zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjustAmount') is not None:
            self.adjust_amount = m.get('AdjustAmount')
        if m.get('BillAccountID') is not None:
            self.bill_account_id = m.get('BillAccountID')
        if m.get('BillAccountName') is not None:
            self.bill_account_name = m.get('BillAccountName')
        if m.get('BillingDate') is not None:
            self.billing_date = m.get('BillingDate')
        if m.get('BillingItem') is not None:
            self.billing_item = m.get('BillingItem')
        if m.get('BillingItemCode') is not None:
            self.billing_item_code = m.get('BillingItemCode')
        if m.get('BillingType') is not None:
            self.billing_type = m.get('BillingType')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('CashAmount') is not None:
            self.cash_amount = m.get('CashAmount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CostUnit') is not None:
            self.cost_unit = m.get('CostUnit')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('DeductedByResourcePackage') is not None:
            self.deducted_by_resource_package = m.get('DeductedByResourcePackage')
        if m.get('InstanceConfig') is not None:
            self.instance_config = m.get('InstanceConfig')
        if m.get('InstanceID') is not None:
            self.instance_id = m.get('InstanceID')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('InternetIP') is not None:
            self.internet_ip = m.get('InternetIP')
        if m.get('IntranetIP') is not None:
            self.intranet_ip = m.get('IntranetIP')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('ListPrice') is not None:
            self.list_price = m.get('ListPrice')
        if m.get('ListPriceUnit') is not None:
            self.list_price_unit = m.get('ListPriceUnit')
        if m.get('NickName') is not None:
            self.nick_name = m.get('NickName')
        if m.get('OutstandingAmount') is not None:
            self.outstanding_amount = m.get('OutstandingAmount')
        if m.get('OwnerID') is not None:
            self.owner_id = m.get('OwnerID')
        if m.get('PaymentAmount') is not None:
            self.payment_amount = m.get('PaymentAmount')
        if m.get('PipCode') is not None:
            self.pip_code = m.get('PipCode')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceGroup') is not None:
            self.resource_group = m.get('ResourceGroup')
        if m.get('ServicePeriod') is not None:
            self.service_period = m.get('ServicePeriod')
        if m.get('ServicePeriodUnit') is not None:
            self.service_period_unit = m.get('ServicePeriodUnit')
        if m.get('SplitAccountID') is not None:
            self.split_account_id = m.get('SplitAccountID')
        if m.get('SplitAccountName') is not None:
            self.split_account_name = m.get('SplitAccountName')
        if m.get('SplitBillingCycle') is not None:
            self.split_billing_cycle = m.get('SplitBillingCycle')
        if m.get('SplitBillingDate') is not None:
            self.split_billing_date = m.get('SplitBillingDate')
        if m.get('SplitCommodityCode') is not None:
            self.split_commodity_code = m.get('SplitCommodityCode')
        if m.get('SplitItemID') is not None:
            self.split_item_id = m.get('SplitItemID')
        if m.get('SplitItemName') is not None:
            self.split_item_name = m.get('SplitItemName')
        if m.get('SplitProductDetail') is not None:
            self.split_product_detail = m.get('SplitProductDetail')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('UsageUnit') is not None:
            self.usage_unit = m.get('UsageUnit')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        return self


class DescribeSplitItemBillResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        billing_cycle: str = None,
        items: List[DescribeSplitItemBillResponseBodyDataItems] = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        self.account_id = account_id
        self.account_name = account_name
        self.billing_cycle = billing_cycle
        self.items = items
        self.max_results = max_results
        self.next_token = next_token
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeSplitItemBillResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSplitItemBillResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeSplitItemBillResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeSplitItemBillResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSplitItemBillResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSplitItemBillResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSplitItemBillResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableBillGenerationRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
        product_code: str = None,
    ):
        self.owner_id = owner_id
        # The code of the product.
        self.product_code = product_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        return self


class EnableBillGenerationResponseBodyData(TeaModel):
    def __init__(
        self,
        boolean: bool = None,
    ):
        # Indicates whether the feature is enabled.
        self.boolean = boolean

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.boolean is not None:
            result['Boolean'] = self.boolean
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Boolean') is not None:
            self.boolean = m.get('Boolean')
        return self


class EnableBillGenerationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: EnableBillGenerationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = EnableBillGenerationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EnableBillGenerationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: EnableBillGenerationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableBillGenerationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAccountRelationRequest(TeaModel):
    def __init__(
        self,
        relation_id: int = None,
        request_id: str = None,
    ):
        # The ID of the financial relationship.
        self.relation_id = relation_id
        # The unique ID of the request. The ID is used to mark a request and troubleshoot a problem.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.relation_id is not None:
            result['RelationId'] = self.relation_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RelationId') is not None:
            self.relation_id = m.get('RelationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAccountRelationResponseBodyData(TeaModel):
    def __init__(
        self,
        child_user_id: int = None,
        end_time: int = None,
        gmt_modified: int = None,
        id: int = None,
        parent_user_id: int = None,
        start_time: int = None,
        status: str = None,
        type: str = None,
    ):
        # The ID of the Alibaba Cloud account that is used as a member.
        self.child_user_id = child_user_id
        # The time when the financial relationship between the management account and the member was terminated.
        self.end_time = end_time
        # The time when the financial relationship between the management account and the member was modified.
        self.gmt_modified = gmt_modified
        # The ID of the financial relationship.
        self.id = id
        # The ID of the Alibaba Cloud account that is used as the management account.
        self.parent_user_id = parent_user_id
        # The time when the financial relationship between the management account and the member was established.
        self.start_time = start_time
        # The status of the financial relationship between the management account and the member.
        self.status = status
        # The type of the financial relationship.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.child_user_id is not None:
            result['ChildUserId'] = self.child_user_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.parent_user_id is not None:
            result['ParentUserId'] = self.parent_user_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChildUserId') is not None:
            self.child_user_id = m.get('ChildUserId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ParentUserId') is not None:
            self.parent_user_id = m.get('ParentUserId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAccountRelationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetAccountRelationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # data
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAccountRelationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAccountRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetAccountRelationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAccountRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomerAccountInfoRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
    ):
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class GetCustomerAccountInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        account_type: str = None,
        credit_limit_status: str = None,
        hosting_status: str = None,
        is_certified: bool = None,
        login_email: str = None,
        mpk: int = None,
    ):
        # The type of the account. A value of 1 indicates an enterprise account. A value of 0 indicates an individual account.
        self.account_type = account_type
        # The business status of the customer. Valid values:
        # 
        # Freeze: The business is frozen.
        # 
        # Thaw: The business is unfrozen.
        # 
        # Trusteeship: The business is hosted.
        # 
        # TrusteeshipCancel: The business is not hosted.
        self.credit_limit_status = credit_limit_status
        # The hosting status of the credit information and instances of the customer. If the credit information and instances of the customer are managed on Alibaba Cloud, Alibaba Cloud suspends a customer service upon overdue payment. Valid values:
        # 
        # FREEZE: The business of the customer is frozen.
        # 
        # TRUSTEESHIP: The business of the customer is hosted.
        self.hosting_status = hosting_status
        # Indicates whether the account passes the real-name verification.
        self.is_certified = is_certified
        # The email address of the customer.
        self.login_email = login_email
        # The ID of the management account.
        self.mpk = mpk

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.credit_limit_status is not None:
            result['CreditLimitStatus'] = self.credit_limit_status
        if self.hosting_status is not None:
            result['HostingStatus'] = self.hosting_status
        if self.is_certified is not None:
            result['IsCertified'] = self.is_certified
        if self.login_email is not None:
            result['LoginEmail'] = self.login_email
        if self.mpk is not None:
            result['Mpk'] = self.mpk
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('CreditLimitStatus') is not None:
            self.credit_limit_status = m.get('CreditLimitStatus')
        if m.get('HostingStatus') is not None:
            self.hosting_status = m.get('HostingStatus')
        if m.get('IsCertified') is not None:
            self.is_certified = m.get('IsCertified')
        if m.get('LoginEmail') is not None:
            self.login_email = m.get('LoginEmail')
        if m.get('Mpk') is not None:
            self.mpk = m.get('Mpk')
        return self


class GetCustomerAccountInfoResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetCustomerAccountInfoResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call is successful. A value of true indicates that the call is successful. A value of false indicates that the call failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCustomerAccountInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCustomerAccountInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomerAccountInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomerAccountInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomerListResponseBodyData(TeaModel):
    def __init__(
        self,
        uid_list: List[str] = None,
    ):
        # The list of customer IDs.
        self.uid_list = uid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uid_list is not None:
            result['UidList'] = self.uid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UidList') is not None:
            self.uid_list = m.get('UidList')
        return self


class GetCustomerListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetCustomerListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request. You can use the ID to query logs and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the call is successful. Valid values:
        # 
        # *   **true**: The call is successful.
        # *   **false**: The call failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCustomerListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCustomerListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetCustomerListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomerListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOrderDetailRequest(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        owner_id: int = None,
    ):
        self.order_id = order_id
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class GetOrderDetailResponseBodyDataOrderListOrder(TeaModel):
    def __init__(
        self,
        after_tax_amount: str = None,
        commodity_code: str = None,
        config: str = None,
        create_time: str = None,
        currency: str = None,
        instance_ids: str = None,
        operator: str = None,
        order_id: str = None,
        order_sub_type: str = None,
        order_type: str = None,
        original_config: str = None,
        payment_currency: str = None,
        payment_status: str = None,
        payment_time: str = None,
        pretax_amount: str = None,
        pretax_amount_local: str = None,
        pretax_gross_amount: str = None,
        product_code: str = None,
        product_type: str = None,
        quantity: str = None,
        region: str = None,
        related_order_id: str = None,
        sub_order_id: str = None,
        subscription_type: str = None,
        tax: str = None,
        usage_end_time: str = None,
        usage_start_time: str = None,
    ):
        self.after_tax_amount = after_tax_amount
        self.commodity_code = commodity_code
        self.config = config
        self.create_time = create_time
        self.currency = currency
        self.instance_ids = instance_ids
        self.operator = operator
        self.order_id = order_id
        self.order_sub_type = order_sub_type
        self.order_type = order_type
        self.original_config = original_config
        self.payment_currency = payment_currency
        self.payment_status = payment_status
        self.payment_time = payment_time
        self.pretax_amount = pretax_amount
        self.pretax_amount_local = pretax_amount_local
        self.pretax_gross_amount = pretax_gross_amount
        self.product_code = product_code
        self.product_type = product_type
        self.quantity = quantity
        self.region = region
        self.related_order_id = related_order_id
        self.sub_order_id = sub_order_id
        self.subscription_type = subscription_type
        self.tax = tax
        self.usage_end_time = usage_end_time
        self.usage_start_time = usage_start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.after_tax_amount is not None:
            result['AfterTaxAmount'] = self.after_tax_amount
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.config is not None:
            result['Config'] = self.config
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.instance_ids is not None:
            result['InstanceIDs'] = self.instance_ids
        if self.operator is not None:
            result['Operator'] = self.operator
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.order_sub_type is not None:
            result['OrderSubType'] = self.order_sub_type
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.original_config is not None:
            result['OriginalConfig'] = self.original_config
        if self.payment_currency is not None:
            result['PaymentCurrency'] = self.payment_currency
        if self.payment_status is not None:
            result['PaymentStatus'] = self.payment_status
        if self.payment_time is not None:
            result['PaymentTime'] = self.payment_time
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_amount_local is not None:
            result['PretaxAmountLocal'] = self.pretax_amount_local
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.region is not None:
            result['Region'] = self.region
        if self.related_order_id is not None:
            result['RelatedOrderId'] = self.related_order_id
        if self.sub_order_id is not None:
            result['SubOrderId'] = self.sub_order_id
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tax is not None:
            result['Tax'] = self.tax
        if self.usage_end_time is not None:
            result['UsageEndTime'] = self.usage_end_time
        if self.usage_start_time is not None:
            result['UsageStartTime'] = self.usage_start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AfterTaxAmount') is not None:
            self.after_tax_amount = m.get('AfterTaxAmount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('InstanceIDs') is not None:
            self.instance_ids = m.get('InstanceIDs')
        if m.get('Operator') is not None:
            self.operator = m.get('Operator')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('OrderSubType') is not None:
            self.order_sub_type = m.get('OrderSubType')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('OriginalConfig') is not None:
            self.original_config = m.get('OriginalConfig')
        if m.get('PaymentCurrency') is not None:
            self.payment_currency = m.get('PaymentCurrency')
        if m.get('PaymentStatus') is not None:
            self.payment_status = m.get('PaymentStatus')
        if m.get('PaymentTime') is not None:
            self.payment_time = m.get('PaymentTime')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxAmountLocal') is not None:
            self.pretax_amount_local = m.get('PretaxAmountLocal')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RelatedOrderId') is not None:
            self.related_order_id = m.get('RelatedOrderId')
        if m.get('SubOrderId') is not None:
            self.sub_order_id = m.get('SubOrderId')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tax') is not None:
            self.tax = m.get('Tax')
        if m.get('UsageEndTime') is not None:
            self.usage_end_time = m.get('UsageEndTime')
        if m.get('UsageStartTime') is not None:
            self.usage_start_time = m.get('UsageStartTime')
        return self


class GetOrderDetailResponseBodyDataOrderList(TeaModel):
    def __init__(
        self,
        order: List[GetOrderDetailResponseBodyDataOrderListOrder] = None,
    ):
        self.order = order

    def validate(self):
        if self.order:
            for k in self.order:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Order'] = []
        if self.order is not None:
            for k in self.order:
                result['Order'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.order = []
        if m.get('Order') is not None:
            for k in m.get('Order'):
                temp_model = GetOrderDetailResponseBodyDataOrderListOrder()
                self.order.append(temp_model.from_map(k))
        return self


class GetOrderDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        host_name: str = None,
        order_list: GetOrderDetailResponseBodyDataOrderList = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.host_name = host_name
        self.order_list = order_list
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.order_list:
            self.order_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.order_list is not None:
            result['OrderList'] = self.order_list.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('OrderList') is not None:
            temp_model = GetOrderDetailResponseBodyDataOrderList()
            self.order_list = temp_model.from_map(m['OrderList'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetOrderDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetOrderDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetOrderDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetOrderDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetOrderDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOrderDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetPayAsYouGoPriceRequestModuleList(TeaModel):
    def __init__(
        self,
        config: str = None,
        module_code: str = None,
        price_type: str = None,
    ):
        # The configuration of the Nth pricing module. Valid values of N: 1 to 50. Format: AA:aa,BB:bb. The values of AA and BB are the property IDs of the pricing module. The values of aa and bb are the property values of the pricing module.
        # 
        # >  You can call the [DescribePricingModule](~~96469~~) operation to obtain the configuration parameters of the pricing module.
        self.config = config
        # The code of the Nth pricing module.
        # 
        # >  You can call the [DescribePricingModule](~~96469~~) operation to obtain the module code.
        self.module_code = module_code
        # The price type of the Nth pricing module. Valid values:
        # 
        # *   Hour: hourly price
        # *   Usage: usage price
        # *   Month: monthly price
        # *   Year: annual price
        # 
        # >  You can call the [DescribePricingModule](~~96469~~) operation to obtain the configuration parameters of the pricing module.
        self.price_type = price_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.price_type is not None:
            result['PriceType'] = self.price_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('PriceType') is not None:
            self.price_type = m.get('PriceType')
        return self


class GetPayAsYouGoPriceRequest(TeaModel):
    def __init__(
        self,
        module_list: List[GetPayAsYouGoPriceRequestModuleList] = None,
        owner_id: int = None,
        product_code: str = None,
        product_type: str = None,
        region: str = None,
        subscription_type: str = None,
    ):
        # The details of pricing modules.
        self.module_list = module_list
        self.owner_id = owner_id
        # The code of the service.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type
        # The ID of the region in which the instance resides.
        self.region = region
        # The billing method. Set the value to PayAsYouGo.
        self.subscription_type = subscription_type

    def validate(self):
        if self.module_list:
            for k in self.module_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ModuleList'] = []
        if self.module_list is not None:
            for k in self.module_list:
                result['ModuleList'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region is not None:
            result['Region'] = self.region
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.module_list = []
        if m.get('ModuleList') is not None:
            for k in m.get('ModuleList'):
                temp_model = GetPayAsYouGoPriceRequestModuleList()
                self.module_list.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class GetPayAsYouGoPriceResponseBodyDataModuleDetailsModuleDetail(TeaModel):
    def __init__(
        self,
        cost_after_discount: float = None,
        invoice_discount: float = None,
        module_code: str = None,
        original_cost: float = None,
        unit_price: float = None,
    ):
        # The discount price.
        self.cost_after_discount = cost_after_discount
        # The discount that was applied.
        self.invoice_discount = invoice_discount
        # The code of the pricing module.
        self.module_code = module_code
        # The original price.
        self.original_cost = original_cost
        # The unit price.
        self.unit_price = unit_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost_after_discount is not None:
            result['CostAfterDiscount'] = self.cost_after_discount
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.original_cost is not None:
            result['OriginalCost'] = self.original_cost
        if self.unit_price is not None:
            result['UnitPrice'] = self.unit_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CostAfterDiscount') is not None:
            self.cost_after_discount = m.get('CostAfterDiscount')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('OriginalCost') is not None:
            self.original_cost = m.get('OriginalCost')
        if m.get('UnitPrice') is not None:
            self.unit_price = m.get('UnitPrice')
        return self


class GetPayAsYouGoPriceResponseBodyDataModuleDetails(TeaModel):
    def __init__(
        self,
        module_detail: List[GetPayAsYouGoPriceResponseBodyDataModuleDetailsModuleDetail] = None,
    ):
        self.module_detail = module_detail

    def validate(self):
        if self.module_detail:
            for k in self.module_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ModuleDetail'] = []
        if self.module_detail is not None:
            for k in self.module_detail:
                result['ModuleDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.module_detail = []
        if m.get('ModuleDetail') is not None:
            for k in m.get('ModuleDetail'):
                temp_model = GetPayAsYouGoPriceResponseBodyDataModuleDetailsModuleDetail()
                self.module_detail.append(temp_model.from_map(k))
        return self


class GetPayAsYouGoPriceResponseBodyDataPromotionDetailsPromotionDetail(TeaModel):
    def __init__(
        self,
        promotion_desc: str = None,
        promotion_id: int = None,
        promotion_name: str = None,
    ):
        # The description of the discount.
        self.promotion_desc = promotion_desc
        # The ID of the discount.
        self.promotion_id = promotion_id
        # The name of the discount.
        self.promotion_name = promotion_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.promotion_desc is not None:
            result['PromotionDesc'] = self.promotion_desc
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.promotion_name is not None:
            result['PromotionName'] = self.promotion_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PromotionDesc') is not None:
            self.promotion_desc = m.get('PromotionDesc')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('PromotionName') is not None:
            self.promotion_name = m.get('PromotionName')
        return self


class GetPayAsYouGoPriceResponseBodyDataPromotionDetails(TeaModel):
    def __init__(
        self,
        promotion_detail: List[GetPayAsYouGoPriceResponseBodyDataPromotionDetailsPromotionDetail] = None,
    ):
        self.promotion_detail = promotion_detail

    def validate(self):
        if self.promotion_detail:
            for k in self.promotion_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PromotionDetail'] = []
        if self.promotion_detail is not None:
            for k in self.promotion_detail:
                result['PromotionDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.promotion_detail = []
        if m.get('PromotionDetail') is not None:
            for k in m.get('PromotionDetail'):
                temp_model = GetPayAsYouGoPriceResponseBodyDataPromotionDetailsPromotionDetail()
                self.promotion_detail.append(temp_model.from_map(k))
        return self


class GetPayAsYouGoPriceResponseBodyData(TeaModel):
    def __init__(
        self,
        currency: str = None,
        module_details: GetPayAsYouGoPriceResponseBodyDataModuleDetails = None,
        promotion_details: GetPayAsYouGoPriceResponseBodyDataPromotionDetails = None,
    ):
        # The type of the currency. Valid values:
        # 
        # *   CNY: Chinese Yuan
        # *   USD: US dollar
        # *   JPY: Japanese Yen
        self.currency = currency
        # The price details of the pricing module.
        self.module_details = module_details
        # The details of the discount.
        self.promotion_details = promotion_details

    def validate(self):
        if self.module_details:
            self.module_details.validate()
        if self.promotion_details:
            self.promotion_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.module_details is not None:
            result['ModuleDetails'] = self.module_details.to_map()
        if self.promotion_details is not None:
            result['PromotionDetails'] = self.promotion_details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('ModuleDetails') is not None:
            temp_model = GetPayAsYouGoPriceResponseBodyDataModuleDetails()
            self.module_details = temp_model.from_map(m['ModuleDetails'])
        if m.get('PromotionDetails') is not None:
            temp_model = GetPayAsYouGoPriceResponseBodyDataPromotionDetails()
            self.promotion_details = temp_model.from_map(m['PromotionDetails'])
        return self


class GetPayAsYouGoPriceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetPayAsYouGoPriceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetPayAsYouGoPriceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetPayAsYouGoPriceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetPayAsYouGoPriceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetPayAsYouGoPriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetResourcePackagePriceRequest(TeaModel):
    def __init__(
        self,
        duration: int = None,
        effective_date: str = None,
        instance_id: str = None,
        order_type: str = None,
        owner_id: int = None,
        package_type: str = None,
        pricing_cycle: str = None,
        product_code: str = None,
        specification: str = None,
    ):
        # The validity period of the resource plan. The value must be the same as the duration of the resource plan specified in the specifications.
        self.duration = duration
        # The time when the resource plan takes effect. If you do not specify this parameter, the resource plan immediately takes effect by default. Specify the time in the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time must be in UTC.
        self.effective_date = effective_date
        # The ID of the instance.
        self.instance_id = instance_id
        # The type of the order. Valid values:
        # 
        # *   BUY: You place the order to purchase an instance.
        # *   UPGRADE: You place the order to upgrade an instance.
        # *   RENEW: You place the order to renew an instance.
        # 
        # Default value: BUY.
        self.order_type = order_type
        self.owner_id = owner_id
        # The type of the resource plan. The value must be the same as the value of the **ProductCode** parameter that is returned when you call the **DescribeResourcePackageProduct** operation.
        self.package_type = package_type
        # The unit of validity period of the resource plan. Valid values:
        # 
        # *   Month
        # *   Year
        self.pricing_cycle = pricing_cycle
        # The code of service. You can query the service code by calling the **QueryProductList** operation or viewing **Codes of Alibaba Cloud Services**.
        self.product_code = product_code
        # The specifications of the resource plan.
        self.specification = specification

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.effective_date is not None:
            result['EffectiveDate'] = self.effective_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.specification is not None:
            result['Specification'] = self.specification
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EffectiveDate') is not None:
            self.effective_date = m.get('EffectiveDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        return self


class GetResourcePackagePriceResponseBodyDataPromotionsPromotion(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
    ):
        # The ID of the promotion.
        self.id = id
        # The description of the discount.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetResourcePackagePriceResponseBodyDataPromotions(TeaModel):
    def __init__(
        self,
        promotion: List[GetResourcePackagePriceResponseBodyDataPromotionsPromotion] = None,
    ):
        self.promotion = promotion

    def validate(self):
        if self.promotion:
            for k in self.promotion:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Promotion'] = []
        if self.promotion is not None:
            for k in self.promotion:
                result['Promotion'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.promotion = []
        if m.get('Promotion') is not None:
            for k in m.get('Promotion'):
                temp_model = GetResourcePackagePriceResponseBodyDataPromotionsPromotion()
                self.promotion.append(temp_model.from_map(k))
        return self


class GetResourcePackagePriceResponseBodyData(TeaModel):
    def __init__(
        self,
        currency: str = None,
        discount_price: float = None,
        original_price: float = None,
        promotions: GetResourcePackagePriceResponseBodyDataPromotions = None,
        trade_price: float = None,
    ):
        # The type of the currency.
        self.currency = currency
        # The discounted amount. Unit: CNY.
        self.discount_price = discount_price
        # The original price. Unit: CNY.
        self.original_price = original_price
        # The details of the discount.
        self.promotions = promotions
        # The price at which the transaction is made. Unit: CNY.
        self.trade_price = trade_price

    def validate(self):
        if self.promotions:
            self.promotions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        if self.promotions is not None:
            result['Promotions'] = self.promotions.to_map()
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        if m.get('Promotions') is not None:
            temp_model = GetResourcePackagePriceResponseBodyDataPromotions()
            self.promotions = temp_model.from_map(m['Promotions'])
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class GetResourcePackagePriceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetResourcePackagePriceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetResourcePackagePriceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetResourcePackagePriceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetResourcePackagePriceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetResourcePackagePriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSubscriptionPriceRequestModuleList(TeaModel):
    def __init__(
        self,
        config: str = None,
        module_code: str = None,
        module_status: int = None,
        tag: str = None,
    ):
        # The configurations of the Nth pricing module. Valid values of N: 1 to 50. Format: AA:aa,BB:bb. The values of AA and BB are the property IDs of the pricing module. The values of aa and bb are the property values of the pricing module.
        self.config = config
        # The identifier of the Nth pricing module.
        self.module_code = module_code
        # The status of the pricing module. This parameter is required only if the order type is Upgrade. Valid values:
        # 
        # *   1: adds one or more instances.
        # *   2: modifies the configurations of an instance. In the upgrade scenario, if the configurations of the pricing module change, you must specify this value for the parameter.
        # 
        # Default value: 1.
        self.module_status = module_status
        # The tag of the specified resource. This parameter is required only if you upgrade or modify the configurations of an Alibaba Cloud service. For example, if you want to modify the configurations of a disk, you can use a tag to identify the ID of the disk.
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.module_status is not None:
            result['ModuleStatus'] = self.module_status
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('ModuleStatus') is not None:
            self.module_status = m.get('ModuleStatus')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class GetSubscriptionPriceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        module_list: List[GetSubscriptionPriceRequestModuleList] = None,
        order_type: str = None,
        owner_id: int = None,
        product_code: str = None,
        product_type: str = None,
        quantity: int = None,
        region: str = None,
        service_period_quantity: int = None,
        service_period_unit: str = None,
        subscription_type: str = None,
    ):
        # The ID of the instance for which the price is queried. This parameter is required if you upgrade an instance. You can specify this parameter to obtain the pre-upgrade configurations of the instance.
        self.instance_id = instance_id
        # The information about the pricing module.
        self.module_list = module_list
        # The type of the order. Valid values:
        # 
        # *   NewOrder: purchases an instance of an Alibaba Cloud service.
        # *   Renewal: renews an instance of an Alibaba Cloud service.
        # *   Upgrade: upgrades an instance of an Alibaba Cloud service.
        self.order_type = order_type
        self.owner_id = owner_id
        # The code of the service. For more information about the service code, see **Codes of Alibaba Cloud Services**.
        self.product_code = product_code
        # The type of the service. Specify the parameter based on the pricing document of the specific service.
        self.product_type = product_type
        # The quantity.
        self.quantity = quantity
        # The ID of the region in which the instance resides.
        self.region = region
        # The service duration.
        self.service_period_quantity = service_period_quantity
        # The unit of the service duration. Valid values:
        # 
        # *   Year
        # *   Month
        self.service_period_unit = service_period_unit
        # The billing method. Set the value to Subscription.
        self.subscription_type = subscription_type

    def validate(self):
        if self.module_list:
            for k in self.module_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        result['ModuleList'] = []
        if self.module_list is not None:
            for k in self.module_list:
                result['ModuleList'].append(k.to_map() if k else None)
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.region is not None:
            result['Region'] = self.region
        if self.service_period_quantity is not None:
            result['ServicePeriodQuantity'] = self.service_period_quantity
        if self.service_period_unit is not None:
            result['ServicePeriodUnit'] = self.service_period_unit
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        self.module_list = []
        if m.get('ModuleList') is not None:
            for k in m.get('ModuleList'):
                temp_model = GetSubscriptionPriceRequestModuleList()
                self.module_list.append(temp_model.from_map(k))
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ServicePeriodQuantity') is not None:
            self.service_period_quantity = m.get('ServicePeriodQuantity')
        if m.get('ServicePeriodUnit') is not None:
            self.service_period_unit = m.get('ServicePeriodUnit')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class GetSubscriptionPriceResponseBodyDataModuleDetailsModuleDetail(TeaModel):
    def __init__(
        self,
        cost_after_discount: float = None,
        invoice_discount: float = None,
        module_code: str = None,
        original_cost: float = None,
        unit_price: float = None,
    ):
        # The discount price.
        self.cost_after_discount = cost_after_discount
        # The discount that was applied.
        self.invoice_discount = invoice_discount
        # The identifier of the pricing module.
        self.module_code = module_code
        # The original price of the service.
        self.original_cost = original_cost
        # The unit price.
        self.unit_price = unit_price

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost_after_discount is not None:
            result['CostAfterDiscount'] = self.cost_after_discount
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.original_cost is not None:
            result['OriginalCost'] = self.original_cost
        if self.unit_price is not None:
            result['UnitPrice'] = self.unit_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CostAfterDiscount') is not None:
            self.cost_after_discount = m.get('CostAfterDiscount')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('OriginalCost') is not None:
            self.original_cost = m.get('OriginalCost')
        if m.get('UnitPrice') is not None:
            self.unit_price = m.get('UnitPrice')
        return self


class GetSubscriptionPriceResponseBodyDataModuleDetails(TeaModel):
    def __init__(
        self,
        module_detail: List[GetSubscriptionPriceResponseBodyDataModuleDetailsModuleDetail] = None,
    ):
        self.module_detail = module_detail

    def validate(self):
        if self.module_detail:
            for k in self.module_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ModuleDetail'] = []
        if self.module_detail is not None:
            for k in self.module_detail:
                result['ModuleDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.module_detail = []
        if m.get('ModuleDetail') is not None:
            for k in m.get('ModuleDetail'):
                temp_model = GetSubscriptionPriceResponseBodyDataModuleDetailsModuleDetail()
                self.module_detail.append(temp_model.from_map(k))
        return self


class GetSubscriptionPriceResponseBodyDataPromotionDetailsPromotionDetail(TeaModel):
    def __init__(
        self,
        promotion_desc: str = None,
        promotion_id: int = None,
        promotion_name: str = None,
    ):
        # The description of the discount.
        self.promotion_desc = promotion_desc
        # The ID of the discount.
        self.promotion_id = promotion_id
        # The name of the discount.
        self.promotion_name = promotion_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.promotion_desc is not None:
            result['PromotionDesc'] = self.promotion_desc
        if self.promotion_id is not None:
            result['PromotionId'] = self.promotion_id
        if self.promotion_name is not None:
            result['PromotionName'] = self.promotion_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PromotionDesc') is not None:
            self.promotion_desc = m.get('PromotionDesc')
        if m.get('PromotionId') is not None:
            self.promotion_id = m.get('PromotionId')
        if m.get('PromotionName') is not None:
            self.promotion_name = m.get('PromotionName')
        return self


class GetSubscriptionPriceResponseBodyDataPromotionDetails(TeaModel):
    def __init__(
        self,
        promotion_detail: List[GetSubscriptionPriceResponseBodyDataPromotionDetailsPromotionDetail] = None,
    ):
        self.promotion_detail = promotion_detail

    def validate(self):
        if self.promotion_detail:
            for k in self.promotion_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PromotionDetail'] = []
        if self.promotion_detail is not None:
            for k in self.promotion_detail:
                result['PromotionDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.promotion_detail = []
        if m.get('PromotionDetail') is not None:
            for k in m.get('PromotionDetail'):
                temp_model = GetSubscriptionPriceResponseBodyDataPromotionDetailsPromotionDetail()
                self.promotion_detail.append(temp_model.from_map(k))
        return self


class GetSubscriptionPriceResponseBodyData(TeaModel):
    def __init__(
        self,
        currency: str = None,
        discount_price: float = None,
        module_details: GetSubscriptionPriceResponseBodyDataModuleDetails = None,
        original_price: float = None,
        promotion_details: GetSubscriptionPriceResponseBodyDataPromotionDetails = None,
        quantity: int = None,
        trade_price: float = None,
    ):
        # The type of currency. Valid values:
        # 
        # *   CNY: Chinese Yuan
        # *   USD: US dollar
        # *   JPY: Japanese Yen
        self.currency = currency
        # The discount that was applied.
        self.discount_price = discount_price
        # The price details of the pricing module.
        self.module_details = module_details
        # The original price of the service.
        self.original_price = original_price
        # The details of the discount.
        self.promotion_details = promotion_details
        # The quantity.
        self.quantity = quantity
        # The discount price.
        self.trade_price = trade_price

    def validate(self):
        if self.module_details:
            self.module_details.validate()
        if self.promotion_details:
            self.promotion_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.discount_price is not None:
            result['DiscountPrice'] = self.discount_price
        if self.module_details is not None:
            result['ModuleDetails'] = self.module_details.to_map()
        if self.original_price is not None:
            result['OriginalPrice'] = self.original_price
        if self.promotion_details is not None:
            result['PromotionDetails'] = self.promotion_details.to_map()
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DiscountPrice') is not None:
            self.discount_price = m.get('DiscountPrice')
        if m.get('ModuleDetails') is not None:
            temp_model = GetSubscriptionPriceResponseBodyDataModuleDetails()
            self.module_details = temp_model.from_map(m['ModuleDetails'])
        if m.get('OriginalPrice') is not None:
            self.original_price = m.get('OriginalPrice')
        if m.get('PromotionDetails') is not None:
            temp_model = GetSubscriptionPriceResponseBodyDataPromotionDetails()
            self.promotion_details = temp_model.from_map(m['PromotionDetails'])
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class GetSubscriptionPriceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: GetSubscriptionPriceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The information about the service price.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSubscriptionPriceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSubscriptionPriceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetSubscriptionPriceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSubscriptionPriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InquiryPriceRefundInstanceRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        instance_id: str = None,
        product_code: str = None,
        product_type: str = None,
    ):
        self.client_token = client_token
        self.instance_id = instance_id
        self.product_code = product_code
        self.product_type = product_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        return self


class InquiryPriceRefundInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        currency: str = None,
        host_id: str = None,
        instance_id: str = None,
        refund_amount: float = None,
    ):
        self.currency = currency
        self.host_id = host_id
        self.instance_id = instance_id
        self.refund_amount = refund_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.refund_amount is not None:
            result['RefundAmount'] = self.refund_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RefundAmount') is not None:
            self.refund_amount = m.get('RefundAmount')
        return self


class InquiryPriceRefundInstanceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: InquiryPriceRefundInstanceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        # data
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InquiryPriceRefundInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InquiryPriceRefundInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: InquiryPriceRefundInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InquiryPriceRefundInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyAccountRelationRequest(TeaModel):
    def __init__(
        self,
        child_nick: str = None,
        child_user_id: int = None,
        parent_user_id: int = None,
        permission_codes: List[str] = None,
        relation_id: int = None,
        relation_operation: str = None,
        relation_type: str = None,
        request_id: str = None,
        role_codes: List[str] = None,
    ):
        # The display name of the member. This helps clarify the scenario in which the account is used.
        self.child_nick = child_nick
        # The ID of the Alibaba Cloud account that is used as the member.
        self.child_user_id = child_user_id
        # The ID of the Alibaba Cloud account that is used as the management account.
        self.parent_user_id = parent_user_id
        # The permissions that can be modified. Valid values:
        # 
        # *   SYNCHRONIZE_FINANCE_IDENTITY: allows the credit control identity to be shared with the member.
        # *   SYNCHRONIZE_FINANCE_DISCOUNT_POLICY_TO_TARGET: allows the discount policy to be shared with the member.
        # *   FORBID_WITHDRAW_CASH: does not allow the member to withdraw the balance.
        # *   FORBID_MANAGE_INVOICE: does not allow the member to manage invoices.
        # *   CHECK_FINANCE_INFO: requests to view information about the financial relationship.
        # *   MANAGE_TARGET_INVOICE: allows the member to manage invoices.
        # *   CHECK_TARGET_CONSUMPTION: allows the member to view the bills.
        self.permission_codes = permission_codes
        # The ID of the financial relationship. Set this parameter to the value of the relationId response parameter returned by calling the QueryRelationList operation.
        self.relation_id = relation_id
        # The operation to be performed. Valid values:
        # 
        # *   ADD
        # *   DELETE
        self.relation_operation = relation_operation
        # The type of the financial relationship. Set the value to enterprise_group.
        self.relation_type = relation_type
        # The unique ID of the request. The ID is used to mark a request and troubleshoot a problem.
        self.request_id = request_id
        # The roles that can be assigned to the member. You cannot modify the roles.
        self.role_codes = role_codes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.child_nick is not None:
            result['ChildNick'] = self.child_nick
        if self.child_user_id is not None:
            result['ChildUserId'] = self.child_user_id
        if self.parent_user_id is not None:
            result['ParentUserId'] = self.parent_user_id
        if self.permission_codes is not None:
            result['PermissionCodes'] = self.permission_codes
        if self.relation_id is not None:
            result['RelationId'] = self.relation_id
        if self.relation_operation is not None:
            result['RelationOperation'] = self.relation_operation
        if self.relation_type is not None:
            result['RelationType'] = self.relation_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.role_codes is not None:
            result['RoleCodes'] = self.role_codes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChildNick') is not None:
            self.child_nick = m.get('ChildNick')
        if m.get('ChildUserId') is not None:
            self.child_user_id = m.get('ChildUserId')
        if m.get('ParentUserId') is not None:
            self.parent_user_id = m.get('ParentUserId')
        if m.get('PermissionCodes') is not None:
            self.permission_codes = m.get('PermissionCodes')
        if m.get('RelationId') is not None:
            self.relation_id = m.get('RelationId')
        if m.get('RelationOperation') is not None:
            self.relation_operation = m.get('RelationOperation')
        if m.get('RelationType') is not None:
            self.relation_type = m.get('RelationType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RoleCodes') is not None:
            self.role_codes = m.get('RoleCodes')
        return self


class ModifyAccountRelationResponseBodyData(TeaModel):
    def __init__(
        self,
        host_id: str = None,
    ):
        # HostId
        self.host_id = host_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_id is not None:
            result['HostId'] = self.host_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        return self


class ModifyAccountRelationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ModifyAccountRelationResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The unique ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ModifyAccountRelationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifyAccountRelationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ModifyAccountRelationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ModifyAccountRelationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyCostUnitRequestUnitEntityList(TeaModel):
    def __init__(
        self,
        new_unit_name: str = None,
        owner_uid: int = None,
        unit_id: int = None,
    ):
        self.new_unit_name = new_unit_name
        self.owner_uid = owner_uid
        self.unit_id = unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.new_unit_name is not None:
            result['NewUnitName'] = self.new_unit_name
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.unit_id is not None:
            result['UnitId'] = self.unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NewUnitName') is not None:
            self.new_unit_name = m.get('NewUnitName')
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('UnitId') is not None:
            self.unit_id = m.get('UnitId')
        return self


class ModifyCostUnitRequest(TeaModel):
    def __init__(
        self,
        unit_entity_list: List[ModifyCostUnitRequestUnitEntityList] = None,
    ):
        self.unit_entity_list = unit_entity_list

    def validate(self):
        if self.unit_entity_list:
            for k in self.unit_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['UnitEntityList'] = []
        if self.unit_entity_list is not None:
            for k in self.unit_entity_list:
                result['UnitEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.unit_entity_list = []
        if m.get('UnitEntityList') is not None:
            for k in m.get('UnitEntityList'):
                temp_model = ModifyCostUnitRequestUnitEntityList()
                self.unit_entity_list.append(temp_model.from_map(k))
        return self


class ModifyCostUnitResponseBodyData(TeaModel):
    def __init__(
        self,
        is_success: bool = None,
        owner_uid: int = None,
        unit_id: int = None,
    ):
        self.is_success = is_success
        self.owner_uid = owner_uid
        self.unit_id = unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_success is not None:
            result['IsSuccess'] = self.is_success
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.unit_id is not None:
            result['UnitId'] = self.unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsSuccess') is not None:
            self.is_success = m.get('IsSuccess')
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('UnitId') is not None:
            self.unit_id = m.get('UnitId')
        return self


class ModifyCostUnitResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[ModifyCostUnitResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ModifyCostUnitResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifyCostUnitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ModifyCostUnitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ModifyCostUnitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyInstanceRequestParameter(TeaModel):
    def __init__(
        self,
        code: str = None,
        value: str = None,
    ):
        self.code = code
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ModifyInstanceRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        instance_id: str = None,
        modify_type: str = None,
        owner_id: int = None,
        parameter: List[ModifyInstanceRequestParameter] = None,
        product_code: str = None,
        product_type: str = None,
        subscription_type: str = None,
    ):
        self.client_token = client_token
        self.instance_id = instance_id
        self.modify_type = modify_type
        self.owner_id = owner_id
        self.parameter = parameter
        self.product_code = product_code
        self.product_type = product_type
        self.subscription_type = subscription_type

    def validate(self):
        if self.parameter:
            for k in self.parameter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.modify_type is not None:
            result['ModifyType'] = self.modify_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        result['Parameter'] = []
        if self.parameter is not None:
            for k in self.parameter:
                result['Parameter'].append(k.to_map() if k else None)
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ModifyType') is not None:
            self.modify_type = m.get('ModifyType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        self.parameter = []
        if m.get('Parameter') is not None:
            for k in m.get('Parameter'):
                temp_model = ModifyInstanceRequestParameter()
                self.parameter.append(temp_model.from_map(k))
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class ModifyInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        host_id: str = None,
        order_id: str = None,
    ):
        self.host_id = host_id
        self.order_id = order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        return self


class ModifyInstanceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ModifyInstanceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ModifyInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifyInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ModifyInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ModifyInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAccountBalanceResponseBodyData(TeaModel):
    def __init__(
        self,
        available_amount: str = None,
        available_cash_amount: str = None,
        credit_amount: str = None,
        currency: str = None,
        mybank_credit_amount: str = None,
    ):
        # The available balance of the account.
        self.available_amount = available_amount
        # The available balance in cash.
        self.available_cash_amount = available_cash_amount
        # The credit balance of the account.
        self.credit_amount = credit_amount
        # The type of the currency. Valid values:
        # 
        # *   CNY: Chinese Yuan
        # *   USD: US dollar
        # *   JPY: Japanese Yen
        self.currency = currency
        # The credit line controlled by MYbank.
        self.mybank_credit_amount = mybank_credit_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_amount is not None:
            result['AvailableAmount'] = self.available_amount
        if self.available_cash_amount is not None:
            result['AvailableCashAmount'] = self.available_cash_amount
        if self.credit_amount is not None:
            result['CreditAmount'] = self.credit_amount
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.mybank_credit_amount is not None:
            result['MybankCreditAmount'] = self.mybank_credit_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableAmount') is not None:
            self.available_amount = m.get('AvailableAmount')
        if m.get('AvailableCashAmount') is not None:
            self.available_cash_amount = m.get('AvailableCashAmount')
        if m.get('CreditAmount') is not None:
            self.credit_amount = m.get('CreditAmount')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('MybankCreditAmount') is not None:
            self.mybank_credit_amount = m.get('MybankCreditAmount')
        return self


class QueryAccountBalanceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryAccountBalanceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryAccountBalanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryAccountBalanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryAccountBalanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryAccountBalanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAccountBillRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        billing_cycle: str = None,
        billing_date: str = None,
        granularity: str = None,
        is_group_by_product: bool = None,
        owner_id: int = None,
        page_num: int = None,
        page_size: int = None,
        product_code: str = None,
    ):
        # The ID of the member. If you specify a value for this parameter, you can query the bills of the specified member. If you leave this parameter empty, the bills of the current account are queried by default.
        self.bill_owner_id = bill_owner_id
        # The billing cycle. Format: YYYY-MM.
        self.billing_cycle = billing_cycle
        # The billing date. This parameter is required only if the Granularity parameter is set to DAILY. Format: YYYY-MM-DD.
        self.billing_date = billing_date
        # The granularity at which bills are queried. Valid values:
        # 
        # *   MONTHLY: queries bills by month. The data queried is consistent with the data that is displayed for the specified billing cycle on the Billing Details tab of the Bill Details page in User Center.
        # *   DAILY: queries bills by day. The data queried is consistent with the data that is displayed for the specified day on the Billing Details tab of the Bill Details page in User Center.
        # 
        # You must set the BillingDate parameter before you can set the Granularity parameter to DAILY.
        self.granularity = granularity
        # Specifies whether to summarize bills based on service codes. Valid values:
        # 
        # *   true: summarizes bills based on service codes.
        # *   false: does not summarize bills based on service codes.
        # 
        # Default value: false.
        self.is_group_by_product = is_group_by_product
        self.owner_id = owner_id
        # The number of the page to return. Default value: 1.
        self.page_num = page_num
        # The number of entries to return on each page. Default value: 20. Maximum value: 300.
        self.page_size = page_size
        # The code of the service.
        self.product_code = product_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.billing_date is not None:
            result['BillingDate'] = self.billing_date
        if self.granularity is not None:
            result['Granularity'] = self.granularity
        if self.is_group_by_product is not None:
            result['IsGroupByProduct'] = self.is_group_by_product
        if self.owner_id is not None:
            result['OwnerID'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('BillingDate') is not None:
            self.billing_date = m.get('BillingDate')
        if m.get('Granularity') is not None:
            self.granularity = m.get('Granularity')
        if m.get('IsGroupByProduct') is not None:
            self.is_group_by_product = m.get('IsGroupByProduct')
        if m.get('OwnerID') is not None:
            self.owner_id = m.get('OwnerID')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        return self


class QueryAccountBillResponseBodyDataItemsItem(TeaModel):
    def __init__(
        self,
        adjust_amount: float = None,
        bill_account_id: str = None,
        bill_account_name: str = None,
        billing_date: str = None,
        biz_type: str = None,
        cash_amount: float = None,
        cost_unit: str = None,
        currency: str = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        invoice_discount: float = None,
        outstanding_amount: float = None,
        owner_id: str = None,
        owner_name: str = None,
        payment_amount: float = None,
        pip_code: str = None,
        pretax_amount: float = None,
        pretax_gross_amount: float = None,
        product_code: str = None,
        product_name: str = None,
        subscription_type: str = None,
    ):
        # The amount deducted by using credit refunds.
        self.adjust_amount = adjust_amount
        # The ID of the account to which the bill belongs.
        self.bill_account_id = bill_account_id
        # The name of the account to which the bill belongs.
        self.bill_account_name = bill_account_name
        # The billing date.
        self.billing_date = billing_date
        # The business type.
        self.biz_type = biz_type
        # The amount paid in cash. The amount that was deducted by using credit refunds is not included.
        self.cash_amount = cash_amount
        # The cost center.
        self.cost_unit = cost_unit
        # The type of the currency. Valid values:
        # 
        # *   CNY
        # *   USD
        # *   JPY
        self.currency = currency
        # The amount deducted by using vouchers.
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        # The amount deducted by using coupons.
        self.deducted_by_coupons = deducted_by_coupons
        # The amount deducted by using prepaid cards.
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        # The discount amount.
        self.invoice_discount = invoice_discount
        # The unsettled amount or the amount settled with credits.
        self.outstanding_amount = outstanding_amount
        # The ID of the member.
        self.owner_id = owner_id
        # The name of the member.
        self.owner_name = owner_name
        # The amount paid in cash. The amount that was deducted by using credit refunds is included.
        self.payment_amount = payment_amount
        # The code of the service. The service code is consistent with that displayed in User Center.
        self.pip_code = pip_code
        # The pretax amount.
        self.pretax_amount = pretax_amount
        # The pretax gross amount.
        self.pretax_gross_amount = pretax_gross_amount
        # The code of the service.
        # 
        # **\
        # 
        # ****A value is returned only if the **IsGroupByProduct **parameter is set to true.
        self.product_code = product_code
        # The name of the service.
        # 
        # **\
        # 
        # ****A value is returned only if the **IsGroupByProduct **parameter is set to true.
        self.product_name = product_name
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        # 
        # **\
        # 
        # ****A value is returned only if the IsGroupByProduct parameter is set to true.
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_amount is not None:
            result['AdjustAmount'] = self.adjust_amount
        if self.bill_account_id is not None:
            result['BillAccountID'] = self.bill_account_id
        if self.bill_account_name is not None:
            result['BillAccountName'] = self.bill_account_name
        if self.billing_date is not None:
            result['BillingDate'] = self.billing_date
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.cash_amount is not None:
            result['CashAmount'] = self.cash_amount
        if self.cost_unit is not None:
            result['CostUnit'] = self.cost_unit
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.outstanding_amount is not None:
            result['OutstandingAmount'] = self.outstanding_amount
        if self.owner_id is not None:
            result['OwnerID'] = self.owner_id
        if self.owner_name is not None:
            result['OwnerName'] = self.owner_name
        if self.payment_amount is not None:
            result['PaymentAmount'] = self.payment_amount
        if self.pip_code is not None:
            result['PipCode'] = self.pip_code
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjustAmount') is not None:
            self.adjust_amount = m.get('AdjustAmount')
        if m.get('BillAccountID') is not None:
            self.bill_account_id = m.get('BillAccountID')
        if m.get('BillAccountName') is not None:
            self.bill_account_name = m.get('BillAccountName')
        if m.get('BillingDate') is not None:
            self.billing_date = m.get('BillingDate')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('CashAmount') is not None:
            self.cash_amount = m.get('CashAmount')
        if m.get('CostUnit') is not None:
            self.cost_unit = m.get('CostUnit')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('OutstandingAmount') is not None:
            self.outstanding_amount = m.get('OutstandingAmount')
        if m.get('OwnerID') is not None:
            self.owner_id = m.get('OwnerID')
        if m.get('OwnerName') is not None:
            self.owner_name = m.get('OwnerName')
        if m.get('PaymentAmount') is not None:
            self.payment_amount = m.get('PaymentAmount')
        if m.get('PipCode') is not None:
            self.pip_code = m.get('PipCode')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class QueryAccountBillResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        item: List[QueryAccountBillResponseBodyDataItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = QueryAccountBillResponseBodyDataItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class QueryAccountBillResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        billing_cycle: str = None,
        items: QueryAccountBillResponseBodyDataItems = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The ID of your Alibaba Cloud account.
        self.account_id = account_id
        # The name of the Alibaba Cloud account.
        self.account_name = account_name
        # The billing cycle. Format: YYYY-MM.
        self.billing_cycle = billing_cycle
        # The details of the bills.
        self.items = items
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('Items') is not None:
            temp_model = QueryAccountBillResponseBodyDataItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryAccountBillResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryAccountBillResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryAccountBillResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryAccountBillResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryAccountBillResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryAccountBillResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAccountTransactionDetailsRequest(TeaModel):
    def __init__(
        self,
        create_time_end: str = None,
        create_time_start: str = None,
        max_results: int = None,
        next_token: str = None,
        record_id: str = None,
        transaction_channel: str = None,
        transaction_channel_sn: str = None,
        transaction_number: str = None,
        transaction_type: str = None,
    ):
        # The end of the creation time range to query.
        self.create_time_end = create_time_end
        # The beginning of the creation time range to query.
        self.create_time_start = create_time_start
        # This parameter is invalid.
        self.max_results = max_results
        # The token that is used for paging.
        self.next_token = next_token
        # The ID of the order or bill.
        self.record_id = record_id
        # The transaction channel.
        self.transaction_channel = transaction_channel
        # The serial number of the transaction channel.
        self.transaction_channel_sn = transaction_channel_sn
        # The number of the transaction.
        self.transaction_number = transaction_number
        # The type of the transaction.
        self.transaction_type = transaction_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.record_id is not None:
            result['RecordID'] = self.record_id
        if self.transaction_channel is not None:
            result['TransactionChannel'] = self.transaction_channel
        if self.transaction_channel_sn is not None:
            result['TransactionChannelSN'] = self.transaction_channel_sn
        if self.transaction_number is not None:
            result['TransactionNumber'] = self.transaction_number
        if self.transaction_type is not None:
            result['TransactionType'] = self.transaction_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RecordID') is not None:
            self.record_id = m.get('RecordID')
        if m.get('TransactionChannel') is not None:
            self.transaction_channel = m.get('TransactionChannel')
        if m.get('TransactionChannelSN') is not None:
            self.transaction_channel_sn = m.get('TransactionChannelSN')
        if m.get('TransactionNumber') is not None:
            self.transaction_number = m.get('TransactionNumber')
        if m.get('TransactionType') is not None:
            self.transaction_type = m.get('TransactionType')
        return self


class QueryAccountTransactionDetailsResponseBodyDataAccountTransactionsListAccountTransactionsList(TeaModel):
    def __init__(
        self,
        amount: str = None,
        balance: str = None,
        billing_cycle: str = None,
        fund_type: str = None,
        record_id: str = None,
        remarks: str = None,
        transaction_account: str = None,
        transaction_channel: str = None,
        transaction_channel_sn: str = None,
        transaction_flow: str = None,
        transaction_number: str = None,
        transaction_time: str = None,
        transaction_type: str = None,
    ):
        # The amount of the transaction.
        self.amount = amount
        # The balance of the account.
        self.balance = balance
        # The billing cycle.
        self.billing_cycle = billing_cycle
        # The type of transaction payment. Valid values:
        # 
        # Cash: pay for the transaction in cash. Deposit: pay for the transaction with deposit. RegularBankCreditRefund: pay for the transaction with credit refund controlled by a bank. DirectPay: directly pay for the transaction.
        self.fund_type = fund_type
        # The ID of the order or bill.
        self.record_id = record_id
        # The remarks.
        self.remarks = remarks
        # The transaction account.
        self.transaction_account = transaction_account
        # The transaction channel.
        self.transaction_channel = transaction_channel
        # The serial number of the transaction channel.
        self.transaction_channel_sn = transaction_channel_sn
        # Indicates whether the transaction is of the income type or the expenditure type. If one of the following types is specified, results for the specific type are returned. If the type that you specified for the parameter does not belong to the following types, no result is returned. If the parameter is left empty, results for transactions of the income and expenditure types are all returned. Valid values:
        # 
        # Income and Expense.
        self.transaction_flow = transaction_flow
        # The number of the transaction.
        self.transaction_number = transaction_number
        # The time when the transaction was made.
        self.transaction_time = transaction_time
        # The type of the transaction. If one of the following transaction types is specified, results for the specified transaction type are returned. If the transaction type that you specified does not belong to the following transaction types, no result is returned. If the parameter is left empty, results for all transaction types are returned. Valid values:
        # 
        # Payment, Withdraw, Refund, Consumption, Transfer, and Adjust.
        self.transaction_type = transaction_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.balance is not None:
            result['Balance'] = self.balance
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.fund_type is not None:
            result['FundType'] = self.fund_type
        if self.record_id is not None:
            result['RecordID'] = self.record_id
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        if self.transaction_account is not None:
            result['TransactionAccount'] = self.transaction_account
        if self.transaction_channel is not None:
            result['TransactionChannel'] = self.transaction_channel
        if self.transaction_channel_sn is not None:
            result['TransactionChannelSN'] = self.transaction_channel_sn
        if self.transaction_flow is not None:
            result['TransactionFlow'] = self.transaction_flow
        if self.transaction_number is not None:
            result['TransactionNumber'] = self.transaction_number
        if self.transaction_time is not None:
            result['TransactionTime'] = self.transaction_time
        if self.transaction_type is not None:
            result['TransactionType'] = self.transaction_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('Balance') is not None:
            self.balance = m.get('Balance')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('FundType') is not None:
            self.fund_type = m.get('FundType')
        if m.get('RecordID') is not None:
            self.record_id = m.get('RecordID')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        if m.get('TransactionAccount') is not None:
            self.transaction_account = m.get('TransactionAccount')
        if m.get('TransactionChannel') is not None:
            self.transaction_channel = m.get('TransactionChannel')
        if m.get('TransactionChannelSN') is not None:
            self.transaction_channel_sn = m.get('TransactionChannelSN')
        if m.get('TransactionFlow') is not None:
            self.transaction_flow = m.get('TransactionFlow')
        if m.get('TransactionNumber') is not None:
            self.transaction_number = m.get('TransactionNumber')
        if m.get('TransactionTime') is not None:
            self.transaction_time = m.get('TransactionTime')
        if m.get('TransactionType') is not None:
            self.transaction_type = m.get('TransactionType')
        return self


class QueryAccountTransactionDetailsResponseBodyDataAccountTransactionsList(TeaModel):
    def __init__(
        self,
        account_transactions_list: List[QueryAccountTransactionDetailsResponseBodyDataAccountTransactionsListAccountTransactionsList] = None,
    ):
        self.account_transactions_list = account_transactions_list

    def validate(self):
        if self.account_transactions_list:
            for k in self.account_transactions_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccountTransactionsList'] = []
        if self.account_transactions_list is not None:
            for k in self.account_transactions_list:
                result['AccountTransactionsList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.account_transactions_list = []
        if m.get('AccountTransactionsList') is not None:
            for k in m.get('AccountTransactionsList'):
                temp_model = QueryAccountTransactionDetailsResponseBodyDataAccountTransactionsListAccountTransactionsList()
                self.account_transactions_list.append(temp_model.from_map(k))
        return self


class QueryAccountTransactionDetailsResponseBodyData(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        account_transactions_list: QueryAccountTransactionDetailsResponseBodyDataAccountTransactionsList = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        # The name of the account.
        self.account_name = account_name
        # The details of the transactions within the account.
        self.account_transactions_list = account_transactions_list
        # This parameter is invalid.
        self.max_results = max_results
        # The token that is used for paging.
        self.next_token = next_token
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.account_transactions_list:
            self.account_transactions_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_transactions_list is not None:
            result['AccountTransactionsList'] = self.account_transactions_list.to_map()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountTransactionsList') is not None:
            temp_model = QueryAccountTransactionDetailsResponseBodyDataAccountTransactionsList()
            self.account_transactions_list = temp_model.from_map(m['AccountTransactionsList'])
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryAccountTransactionDetailsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryAccountTransactionDetailsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryAccountTransactionDetailsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryAccountTransactionDetailsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryAccountTransactionDetailsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryAccountTransactionDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAccountTransactionsRequest(TeaModel):
    def __init__(
        self,
        create_time_end: str = None,
        create_time_start: str = None,
        page_num: int = None,
        page_size: int = None,
        record_id: str = None,
        transaction_channel: str = None,
        transaction_channel_sn: str = None,
        transaction_flow: str = None,
        transaction_number: str = None,
        transaction_type: str = None,
    ):
        # The end of the creation time range to query. By default, the transactions in the last month are queried. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. Example: 2018-01-01T00:00:00Z.
        self.create_time_end = create_time_end
        # The beginning of the creation time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. Example: 2018-01-01T00:00:00Z.
        self.create_time_start = create_time_start
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The ID of the order or bill.
        self.record_id = record_id
        # The transaction channel. If you specify one of the following transaction channels for this parameter, the results for the specified transaction channel are returned. If the transaction channel that you specify does not belong to the following transaction channels, no result is returned. If you leave this parameter empty, the results for all the following transaction channels are returned by default. Valid values:
        # 
        # *   AccountBalance
        # *   BankTransfer
        # *   Alipay
        # *   AntCreditPay
        # *   OfflineRemittance
        # *   RegularBankCreditRefund
        # *   CreditCard
        # *   MyBankCredit
        # *   HuaxiaBankCInstallment
        # *   ApplePay
        self.transaction_channel = transaction_channel
        # The serial number of the transaction channel.
        self.transaction_channel_sn = transaction_channel_sn
        # The type of the transaction flow. If you specify one of the following types for this parameter, the results for the specified type are returned. If the type that you specify does not belong to the following types, no result is returned. If you leave this parameter empty, the results for the following two types are returned by default. Valid values:
        # 
        # *   Income
        # *   Expense
        self.transaction_flow = transaction_flow
        # The number of the transaction.
        self.transaction_number = transaction_number
        # The type of the transaction. If you specify one of the following transaction types for this parameter, the results for the specified transaction type are returned. If the transaction type that you specify does not belong to the following types, no result is returned. If you leave this parameter empty, the results for all the following transaction types are returned by default. Valid values:
        # 
        # *   Payment
        # *   Withdraw
        # *   Refund
        # *   Consumption
        # *   Transfer
        # *   Adjust
        self.transaction_type = transaction_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.record_id is not None:
            result['RecordID'] = self.record_id
        if self.transaction_channel is not None:
            result['TransactionChannel'] = self.transaction_channel
        if self.transaction_channel_sn is not None:
            result['TransactionChannelSN'] = self.transaction_channel_sn
        if self.transaction_flow is not None:
            result['TransactionFlow'] = self.transaction_flow
        if self.transaction_number is not None:
            result['TransactionNumber'] = self.transaction_number
        if self.transaction_type is not None:
            result['TransactionType'] = self.transaction_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecordID') is not None:
            self.record_id = m.get('RecordID')
        if m.get('TransactionChannel') is not None:
            self.transaction_channel = m.get('TransactionChannel')
        if m.get('TransactionChannelSN') is not None:
            self.transaction_channel_sn = m.get('TransactionChannelSN')
        if m.get('TransactionFlow') is not None:
            self.transaction_flow = m.get('TransactionFlow')
        if m.get('TransactionNumber') is not None:
            self.transaction_number = m.get('TransactionNumber')
        if m.get('TransactionType') is not None:
            self.transaction_type = m.get('TransactionType')
        return self


class QueryAccountTransactionsResponseBodyDataAccountTransactionsListAccountTransactionsList(TeaModel):
    def __init__(
        self,
        amount: str = None,
        balance: str = None,
        billing_cycle: str = None,
        fund_type: str = None,
        record_id: str = None,
        remarks: str = None,
        transaction_account: str = None,
        transaction_channel: str = None,
        transaction_channel_sn: str = None,
        transaction_flow: str = None,
        transaction_number: str = None,
        transaction_time: str = None,
        transaction_type: str = None,
    ):
        # The amount.
        self.amount = amount
        # The balance of the account.
        self.balance = balance
        # The billing cycle. Format: YYYY-MM.
        self.billing_cycle = billing_cycle
        # The type of transaction payment. Valid values:
        # 
        # *   Cash: pay for the transaction in cash.
        # *   Deposit: pay for the transaction with deposit.
        # *   RegularBankCreditRefund: pay for the transaction with credit refund controlled by a bank.
        # *   DirectPay: directly pay for the transaction.
        self.fund_type = fund_type
        # The number of the order or bill.
        self.record_id = record_id
        # The remarks on the transaction.
        self.remarks = remarks
        # The transaction account. For example, the account is a recharge account in Alipay or a transfer account.
        self.transaction_account = transaction_account
        # The transaction channel.
        # 
        # *   AccountBalance
        # *   BankTransfer
        # *   Alipay
        # *   AntCreditPay
        # *   OfflineRemittance
        # *   RegularBankCreditRefund
        # *   CreditCard
        # *   MyBankCredit
        # *   HuaxiaBankCInstallment
        # *   ApplePay
        self.transaction_channel = transaction_channel
        # The serial number of the transaction channel.
        self.transaction_channel_sn = transaction_channel_sn
        # The type of the transaction flow.
        # 
        # *   Income
        # *   Expense
        self.transaction_flow = transaction_flow
        # The number of the transaction.
        self.transaction_number = transaction_number
        # The time when the transaction was made.
        self.transaction_time = transaction_time
        # The type of the transaction.
        # 
        # *   Payment
        # *   Withdraw
        # *   Refund
        # *   Consumption
        # *   Transfer
        # *   Adjust
        self.transaction_type = transaction_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.balance is not None:
            result['Balance'] = self.balance
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.fund_type is not None:
            result['FundType'] = self.fund_type
        if self.record_id is not None:
            result['RecordID'] = self.record_id
        if self.remarks is not None:
            result['Remarks'] = self.remarks
        if self.transaction_account is not None:
            result['TransactionAccount'] = self.transaction_account
        if self.transaction_channel is not None:
            result['TransactionChannel'] = self.transaction_channel
        if self.transaction_channel_sn is not None:
            result['TransactionChannelSN'] = self.transaction_channel_sn
        if self.transaction_flow is not None:
            result['TransactionFlow'] = self.transaction_flow
        if self.transaction_number is not None:
            result['TransactionNumber'] = self.transaction_number
        if self.transaction_time is not None:
            result['TransactionTime'] = self.transaction_time
        if self.transaction_type is not None:
            result['TransactionType'] = self.transaction_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('Balance') is not None:
            self.balance = m.get('Balance')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('FundType') is not None:
            self.fund_type = m.get('FundType')
        if m.get('RecordID') is not None:
            self.record_id = m.get('RecordID')
        if m.get('Remarks') is not None:
            self.remarks = m.get('Remarks')
        if m.get('TransactionAccount') is not None:
            self.transaction_account = m.get('TransactionAccount')
        if m.get('TransactionChannel') is not None:
            self.transaction_channel = m.get('TransactionChannel')
        if m.get('TransactionChannelSN') is not None:
            self.transaction_channel_sn = m.get('TransactionChannelSN')
        if m.get('TransactionFlow') is not None:
            self.transaction_flow = m.get('TransactionFlow')
        if m.get('TransactionNumber') is not None:
            self.transaction_number = m.get('TransactionNumber')
        if m.get('TransactionTime') is not None:
            self.transaction_time = m.get('TransactionTime')
        if m.get('TransactionType') is not None:
            self.transaction_type = m.get('TransactionType')
        return self


class QueryAccountTransactionsResponseBodyDataAccountTransactionsList(TeaModel):
    def __init__(
        self,
        account_transactions_list: List[QueryAccountTransactionsResponseBodyDataAccountTransactionsListAccountTransactionsList] = None,
    ):
        self.account_transactions_list = account_transactions_list

    def validate(self):
        if self.account_transactions_list:
            for k in self.account_transactions_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccountTransactionsList'] = []
        if self.account_transactions_list is not None:
            for k in self.account_transactions_list:
                result['AccountTransactionsList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.account_transactions_list = []
        if m.get('AccountTransactionsList') is not None:
            for k in m.get('AccountTransactionsList'):
                temp_model = QueryAccountTransactionsResponseBodyDataAccountTransactionsListAccountTransactionsList()
                self.account_transactions_list.append(temp_model.from_map(k))
        return self


class QueryAccountTransactionsResponseBodyData(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        account_transactions_list: QueryAccountTransactionsResponseBodyDataAccountTransactionsList = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The name of your Alibaba Cloud account.
        self.account_name = account_name
        # The information about transactions.
        self.account_transactions_list = account_transactions_list
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.account_transactions_list:
            self.account_transactions_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_transactions_list is not None:
            result['AccountTransactionsList'] = self.account_transactions_list.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountTransactionsList') is not None:
            temp_model = QueryAccountTransactionsResponseBodyDataAccountTransactionsList()
            self.account_transactions_list = temp_model.from_map(m['AccountTransactionsList'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryAccountTransactionsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryAccountTransactionsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryAccountTransactionsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryAccountTransactionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryAccountTransactionsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryAccountTransactionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryAvailableInstancesRequest(TeaModel):
    def __init__(
        self,
        create_time_end: str = None,
        create_time_start: str = None,
        end_time_end: str = None,
        end_time_start: str = None,
        instance_ids: str = None,
        owner_id: int = None,
        page_num: int = None,
        page_size: int = None,
        product_code: str = None,
        product_type: str = None,
        region: str = None,
        renew_status: str = None,
        subscription_type: str = None,
    ):
        # The end time when the specified instance is created. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.create_time_end = create_time_end
        # The start time when the specified instance is created. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.create_time_start = create_time_start
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC. Example: 2016-05-23T12:00:00Z.
        self.end_time_end = end_time_end
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC. Example: 2016-05-23T12:00:00Z.
        self.end_time_start = end_time_start
        # The ID of the instance. Separate multiple IDs with commas (,). You can specify a maximum of 100 IDs.
        self.instance_ids = instance_ids
        self.owner_id = owner_id
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The code of the service. You can query the service code by calling the **QueryProductList** operation or viewing **Codes of Alibaba Cloud services**.
        # 
        # >This parameter cannot be left empty if the region is specified.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type
        # The ID of the region in which the instance resides.
        self.region = region
        # The renewal status of the specified instance. Valid values:
        # 
        # *   AutoRenewal: The instance is automatically renewed.
        # *   ManualRenewal: The instance is manually renewed.
        # *   NotRenewal: The instance is not renewed.
        self.renew_status = renew_status
        # The billing method. Valid values:
        # 
        # *   Subscription: subscription
        # *   PayAsYouGo: pay-as-you-go
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.end_time_end is not None:
            result['EndTimeEnd'] = self.end_time_end
        if self.end_time_start is not None:
            result['EndTimeStart'] = self.end_time_start
        if self.instance_ids is not None:
            result['InstanceIDs'] = self.instance_ids
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region is not None:
            result['Region'] = self.region
        if self.renew_status is not None:
            result['RenewStatus'] = self.renew_status
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('EndTimeEnd') is not None:
            self.end_time_end = m.get('EndTimeEnd')
        if m.get('EndTimeStart') is not None:
            self.end_time_start = m.get('EndTimeStart')
        if m.get('InstanceIDs') is not None:
            self.instance_ids = m.get('InstanceIDs')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RenewStatus') is not None:
            self.renew_status = m.get('RenewStatus')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class QueryAvailableInstancesResponseBodyDataInstanceList(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        end_time: str = None,
        expected_release_time: str = None,
        instance_id: str = None,
        owner_id: int = None,
        product_code: str = None,
        product_type: str = None,
        region: str = None,
        release_time: str = None,
        renew_status: str = None,
        renewal_duration: int = None,
        renewal_duration_unit: str = None,
        seller: str = None,
        seller_id: int = None,
        status: str = None,
        stop_time: str = None,
        sub_status: str = None,
        subscription_type: str = None,
    ):
        # The time when the specified instance was created.
        self.create_time = create_time
        # The time when the instance was expired.
        self.end_time = end_time
        # The time when the specified instance was expected to be released.
        self.expected_release_time = expected_release_time
        # The ID of the instance.
        self.instance_id = instance_id
        # The ID of the instance owner.
        self.owner_id = owner_id
        # The code of the service.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type
        # The ID of the region in which the instance resides.
        self.region = region
        # The time when the instance was released.
        self.release_time = release_time
        # The renewal status of the specified instance. Valid values:
        # 
        # *   AutoRenewal: The instance is automatically renewed.
        # *   ManualRenewal: The instance is manually renewed.
        # *   NotRenewal: The instance is not renewed.
        self.renew_status = renew_status
        # The number of auto-renewal cycles.
        self.renewal_duration = renewal_duration
        # The unit of the auto-renewal cycle. Valid values:
        # 
        # *   M: month
        # *   Y: year
        self.renewal_duration_unit = renewal_duration_unit
        # The seller.
        self.seller = seller
        # The ID of the seller.
        self.seller_id = seller_id
        # The status of the instance.
        self.status = status
        # The time when the specified instance was suspended.
        self.stop_time = stop_time
        # The sub-status of the specified instance.
        self.sub_status = sub_status
        # The billing method. Valid values:
        # 
        # *   Subscription: subscription
        # *   PayAsYouGo: pay-as-you-go
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.expected_release_time is not None:
            result['ExpectedReleaseTime'] = self.expected_release_time
        if self.instance_id is not None:
            result['InstanceID'] = self.instance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region is not None:
            result['Region'] = self.region
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.renew_status is not None:
            result['RenewStatus'] = self.renew_status
        if self.renewal_duration is not None:
            result['RenewalDuration'] = self.renewal_duration
        if self.renewal_duration_unit is not None:
            result['RenewalDurationUnit'] = self.renewal_duration_unit
        if self.seller is not None:
            result['Seller'] = self.seller
        if self.seller_id is not None:
            result['SellerId'] = self.seller_id
        if self.status is not None:
            result['Status'] = self.status
        if self.stop_time is not None:
            result['StopTime'] = self.stop_time
        if self.sub_status is not None:
            result['SubStatus'] = self.sub_status
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExpectedReleaseTime') is not None:
            self.expected_release_time = m.get('ExpectedReleaseTime')
        if m.get('InstanceID') is not None:
            self.instance_id = m.get('InstanceID')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('RenewStatus') is not None:
            self.renew_status = m.get('RenewStatus')
        if m.get('RenewalDuration') is not None:
            self.renewal_duration = m.get('RenewalDuration')
        if m.get('RenewalDurationUnit') is not None:
            self.renewal_duration_unit = m.get('RenewalDurationUnit')
        if m.get('Seller') is not None:
            self.seller = m.get('Seller')
        if m.get('SellerId') is not None:
            self.seller_id = m.get('SellerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StopTime') is not None:
            self.stop_time = m.get('StopTime')
        if m.get('SubStatus') is not None:
            self.sub_status = m.get('SubStatus')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class QueryAvailableInstancesResponseBodyData(TeaModel):
    def __init__(
        self,
        instance_list: List[QueryAvailableInstancesResponseBodyDataInstanceList] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The instances returned.
        self.instance_list = instance_list
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.instance_list:
            for k in self.instance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceList'] = []
        if self.instance_list is not None:
            for k in self.instance_list:
                result['InstanceList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance_list = []
        if m.get('InstanceList') is not None:
            for k in m.get('InstanceList'):
                temp_model = QueryAvailableInstancesResponseBodyDataInstanceList()
                self.instance_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryAvailableInstancesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryAvailableInstancesResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryAvailableInstancesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryAvailableInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryAvailableInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryAvailableInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryBillRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        billing_cycle: str = None,
        is_display_local_currency: bool = None,
        is_hide_zero_charge: bool = None,
        owner_id: int = None,
        page_num: int = None,
        page_size: int = None,
        product_code: str = None,
        product_type: str = None,
        subscription_type: str = None,
        type: str = None,
    ):
        # The ID of the member.
        self.bill_owner_id = bill_owner_id
        # The billing cycle, in the YYYY-MM format.
        self.billing_cycle = billing_cycle
        # Specifies whether to display local currency information in bills. The parameter will be discontinued.
        self.is_display_local_currency = is_display_local_currency
        # Specifies whether to filter out a bill whose pretax gross amount is 0. By default, a bill whose pretax gross amount is 0 is not filtered out. Valid values:
        # 
        # *   true: filters out a bill whose pretax gross amount is 0.
        # *   false: does not filter out a bill whose pretax gross amount is 0.
        self.is_hide_zero_charge = is_hide_zero_charge
        self.owner_id = owner_id
        # The number of the page to return. Default value: 1.
        self.page_num = page_num
        # The number of entries to return on each page. Default value: 20. Maximum value: 300.
        self.page_size = page_size
        # The code of the service.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type
        # The billing method. Valid values:
        # 
        # *   Subscription
        # *   PayAsYouGo
        # 
        # **\
        # 
        # ****This parameter must be used together with the ProductCode parameter.
        self.subscription_type = subscription_type
        # The type of the bill. Valid values:
        # 
        # *   SubscriptionOrder
        # *   PayAsYouGoBill
        # *   Refund
        # *   Adjustment
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.is_display_local_currency is not None:
            result['IsDisplayLocalCurrency'] = self.is_display_local_currency
        if self.is_hide_zero_charge is not None:
            result['IsHideZeroCharge'] = self.is_hide_zero_charge
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('IsDisplayLocalCurrency') is not None:
            self.is_display_local_currency = m.get('IsDisplayLocalCurrency')
        if m.get('IsHideZeroCharge') is not None:
            self.is_hide_zero_charge = m.get('IsHideZeroCharge')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryBillResponseBodyDataItemsItem(TeaModel):
    def __init__(
        self,
        adjust_amount: float = None,
        after_tax_amount: float = None,
        cash_amount: float = None,
        commodity_code: str = None,
        currency: str = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        invoice_discount: float = None,
        item: str = None,
        outstanding_amount: float = None,
        owner_id: str = None,
        payment_amount: float = None,
        payment_currency: str = None,
        payment_time: str = None,
        payment_transaction_id: str = None,
        pip_code: str = None,
        pretax_amount: float = None,
        pretax_amount_local: float = None,
        pretax_gross_amount: float = None,
        product_code: str = None,
        product_detail: str = None,
        product_name: str = None,
        product_type: str = None,
        record_id: str = None,
        round_down_discount: str = None,
        status: str = None,
        sub_order_id: str = None,
        subscription_type: str = None,
        tax: float = None,
        usage_end_time: str = None,
        usage_start_time: str = None,
    ):
        # The amount deducted by using credit refunds.
        self.adjust_amount = adjust_amount
        # The amount paid after tax is deducted.
        self.after_tax_amount = after_tax_amount
        # The amount paid in cash. The amount that was deducted by using credit refunds is not included.
        self.cash_amount = cash_amount
        # The code of the commodity.
        self.commodity_code = commodity_code
        # The type of the currency.
        # 
        # *   CNY
        # *   USD
        # *   JPY
        self.currency = currency
        # The amount deducted by using vouchers.
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        # The amount deducted by using coupons.
        self.deducted_by_coupons = deducted_by_coupons
        # The amount deducted by using prepaid cards.
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        # The discount amount.
        self.invoice_discount = invoice_discount
        # The type of the bill.
        # 
        # *   SubscriptionOrder
        # *   PayAsYouGoBill
        # *   Refund
        # *   Adjustment
        self.item = item
        # The unsettled amount of the bill.
        self.outstanding_amount = outstanding_amount
        # The ID of the member. This parameter is returned in a multi-account payment scenario.
        self.owner_id = owner_id
        # The amount paid with cash.
        self.payment_amount = payment_amount
        # The currency used for payment.
        self.payment_currency = payment_currency
        # The time when the order was paid.
        self.payment_time = payment_time
        # The ID of the transaction.
        self.payment_transaction_id = payment_transaction_id
        # The code of the service.
        self.pip_code = pip_code
        # The pretax amount
        self.pretax_amount = pretax_amount
        # The pretax amount paid in local currency.
        self.pretax_amount_local = pretax_amount_local
        # The pretax gross amount.
        self.pretax_gross_amount = pretax_gross_amount
        # The code of the service.
        self.product_code = product_code
        # The details of the service.
        self.product_detail = product_detail
        # The name of the service.
        self.product_name = product_name
        # The type of the service.
        self.product_type = product_type
        # The ID of the order or bill.
        self.record_id = record_id
        # The round down discount.
        self.round_down_discount = round_down_discount
        # The payment status of the bill. Valid values:
        # 
        # *   PayFinish: The bill is paid.
        # *   PayUnclear: The bill is not cleared.
        # *   PayUnsettle: The bill is not settled.
        # *   NoSettle: The bill is free of settlement.
        self.status = status
        # The ID of the order corresponding to the bill.
        self.sub_order_id = sub_order_id
        # The billing method. Valid values:
        # 
        # *   Subscription
        # *   PayAsYouGo
        self.subscription_type = subscription_type
        # The tax.
        self.tax = tax
        # The time when the bill ends.
        self.usage_end_time = usage_end_time
        # The time when the bill starts.
        self.usage_start_time = usage_start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_amount is not None:
            result['AdjustAmount'] = self.adjust_amount
        if self.after_tax_amount is not None:
            result['AfterTaxAmount'] = self.after_tax_amount
        if self.cash_amount is not None:
            result['CashAmount'] = self.cash_amount
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.item is not None:
            result['Item'] = self.item
        if self.outstanding_amount is not None:
            result['OutstandingAmount'] = self.outstanding_amount
        if self.owner_id is not None:
            result['OwnerID'] = self.owner_id
        if self.payment_amount is not None:
            result['PaymentAmount'] = self.payment_amount
        if self.payment_currency is not None:
            result['PaymentCurrency'] = self.payment_currency
        if self.payment_time is not None:
            result['PaymentTime'] = self.payment_time
        if self.payment_transaction_id is not None:
            result['PaymentTransactionID'] = self.payment_transaction_id
        if self.pip_code is not None:
            result['PipCode'] = self.pip_code
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_amount_local is not None:
            result['PretaxAmountLocal'] = self.pretax_amount_local
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.record_id is not None:
            result['RecordID'] = self.record_id
        if self.round_down_discount is not None:
            result['RoundDownDiscount'] = self.round_down_discount
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_order_id is not None:
            result['SubOrderId'] = self.sub_order_id
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tax is not None:
            result['Tax'] = self.tax
        if self.usage_end_time is not None:
            result['UsageEndTime'] = self.usage_end_time
        if self.usage_start_time is not None:
            result['UsageStartTime'] = self.usage_start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjustAmount') is not None:
            self.adjust_amount = m.get('AdjustAmount')
        if m.get('AfterTaxAmount') is not None:
            self.after_tax_amount = m.get('AfterTaxAmount')
        if m.get('CashAmount') is not None:
            self.cash_amount = m.get('CashAmount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('OutstandingAmount') is not None:
            self.outstanding_amount = m.get('OutstandingAmount')
        if m.get('OwnerID') is not None:
            self.owner_id = m.get('OwnerID')
        if m.get('PaymentAmount') is not None:
            self.payment_amount = m.get('PaymentAmount')
        if m.get('PaymentCurrency') is not None:
            self.payment_currency = m.get('PaymentCurrency')
        if m.get('PaymentTime') is not None:
            self.payment_time = m.get('PaymentTime')
        if m.get('PaymentTransactionID') is not None:
            self.payment_transaction_id = m.get('PaymentTransactionID')
        if m.get('PipCode') is not None:
            self.pip_code = m.get('PipCode')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxAmountLocal') is not None:
            self.pretax_amount_local = m.get('PretaxAmountLocal')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RecordID') is not None:
            self.record_id = m.get('RecordID')
        if m.get('RoundDownDiscount') is not None:
            self.round_down_discount = m.get('RoundDownDiscount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubOrderId') is not None:
            self.sub_order_id = m.get('SubOrderId')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tax') is not None:
            self.tax = m.get('Tax')
        if m.get('UsageEndTime') is not None:
            self.usage_end_time = m.get('UsageEndTime')
        if m.get('UsageStartTime') is not None:
            self.usage_start_time = m.get('UsageStartTime')
        return self


class QueryBillResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        item: List[QueryBillResponseBodyDataItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = QueryBillResponseBodyDataItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class QueryBillResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        billing_cycle: str = None,
        items: QueryBillResponseBodyDataItems = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The ID of the account.
        self.account_id = account_id
        # The name of the account.
        self.account_name = account_name
        # The billing cycle, in the YYYY-MM format.
        self.billing_cycle = billing_cycle
        # The details of the bills.
        self.items = items
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('Items') is not None:
            temp_model = QueryBillResponseBodyDataItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryBillResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryBillResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The returned data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryBillResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryBillResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryBillResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryBillResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryBillOverviewRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        billing_cycle: str = None,
        product_code: str = None,
        product_type: str = None,
        subscription_type: str = None,
    ):
        # The ID of the member. If you specify a value for this parameter, you can query the bills of the specified member. If you leave this parameter empty, the bills of the current account are queried by default.
        self.bill_owner_id = bill_owner_id
        # The billing cycle, in the YYYY-MM format.
        self.billing_cycle = billing_cycle
        # The code of the service.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class QueryBillOverviewResponseBodyDataItemsItem(TeaModel):
    def __init__(
        self,
        adjust_amount: float = None,
        after_tax_amount: float = None,
        bill_account_id: str = None,
        bill_account_name: str = None,
        biz_type: str = None,
        cash_amount: float = None,
        commodity_code: str = None,
        currency: str = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        invoice_discount: float = None,
        item: str = None,
        outstanding_amount: float = None,
        owner_id: str = None,
        payment_amount: float = None,
        payment_currency: str = None,
        pip_code: str = None,
        pretax_amount: float = None,
        pretax_amount_local: float = None,
        pretax_gross_amount: float = None,
        product_code: str = None,
        product_detail: str = None,
        product_name: str = None,
        product_type: str = None,
        round_down_discount: str = None,
        subscription_type: str = None,
        tax: float = None,
    ):
        # The amount deducted by using credit refunds.
        self.adjust_amount = adjust_amount
        self.after_tax_amount = after_tax_amount
        # The ID of the account to which the bill belongs.
        self.bill_account_id = bill_account_id
        # The name of the account to which the bill belongs.
        self.bill_account_name = bill_account_name
        # The business type.
        self.biz_type = biz_type
        # The amount paid in cash. The amount that was deducted by using credit refunds is not included.
        self.cash_amount = cash_amount
        # The code of the commodity. The commodity code is the same as that displayed in User Center.
        self.commodity_code = commodity_code
        # The type of the currency. Valid values:
        # 
        # *   CNY
        # *   USD
        # *   JPY
        self.currency = currency
        # The amount deducted by using vouchers.
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        # The amount deducted by using coupons.
        self.deducted_by_coupons = deducted_by_coupons
        # The amount deducted by using prepaid cards.
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        # The discount amount.
        self.invoice_discount = invoice_discount
        # The type of the bill. Valid values:
        # 
        # *   SubscriptionOrder
        # *   PayAsYouGoBill
        # *   Refund
        # *   Adjustment
        self.item = item
        # The unsettled amount or the amount deducted by using credits. This may be an unsettled amount of a regular user or credits consumed by a credit user.
        self.outstanding_amount = outstanding_amount
        # The ID of the bill owner.
        self.owner_id = owner_id
        # The amount paid in cash. The amount that was deducted by using credit refunds is included.
        self.payment_amount = payment_amount
        self.payment_currency = payment_currency
        # The code of the service. The service code is the same as that displayed in User Center.
        self.pip_code = pip_code
        # The pretax amount.
        self.pretax_amount = pretax_amount
        self.pretax_amount_local = pretax_amount_local
        # The pretax gross amount.
        self.pretax_gross_amount = pretax_gross_amount
        # The code of the service.
        self.product_code = product_code
        # The details of the service.
        self.product_detail = product_detail
        # The name of the service.
        self.product_name = product_name
        # The type of the service.
        self.product_type = product_type
        # The round down discount.
        self.round_down_discount = round_down_discount
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        self.subscription_type = subscription_type
        self.tax = tax

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_amount is not None:
            result['AdjustAmount'] = self.adjust_amount
        if self.after_tax_amount is not None:
            result['AfterTaxAmount'] = self.after_tax_amount
        if self.bill_account_id is not None:
            result['BillAccountID'] = self.bill_account_id
        if self.bill_account_name is not None:
            result['BillAccountName'] = self.bill_account_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.cash_amount is not None:
            result['CashAmount'] = self.cash_amount
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.item is not None:
            result['Item'] = self.item
        if self.outstanding_amount is not None:
            result['OutstandingAmount'] = self.outstanding_amount
        if self.owner_id is not None:
            result['OwnerID'] = self.owner_id
        if self.payment_amount is not None:
            result['PaymentAmount'] = self.payment_amount
        if self.payment_currency is not None:
            result['PaymentCurrency'] = self.payment_currency
        if self.pip_code is not None:
            result['PipCode'] = self.pip_code
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_amount_local is not None:
            result['PretaxAmountLocal'] = self.pretax_amount_local
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.round_down_discount is not None:
            result['RoundDownDiscount'] = self.round_down_discount
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tax is not None:
            result['Tax'] = self.tax
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjustAmount') is not None:
            self.adjust_amount = m.get('AdjustAmount')
        if m.get('AfterTaxAmount') is not None:
            self.after_tax_amount = m.get('AfterTaxAmount')
        if m.get('BillAccountID') is not None:
            self.bill_account_id = m.get('BillAccountID')
        if m.get('BillAccountName') is not None:
            self.bill_account_name = m.get('BillAccountName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('CashAmount') is not None:
            self.cash_amount = m.get('CashAmount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('OutstandingAmount') is not None:
            self.outstanding_amount = m.get('OutstandingAmount')
        if m.get('OwnerID') is not None:
            self.owner_id = m.get('OwnerID')
        if m.get('PaymentAmount') is not None:
            self.payment_amount = m.get('PaymentAmount')
        if m.get('PaymentCurrency') is not None:
            self.payment_currency = m.get('PaymentCurrency')
        if m.get('PipCode') is not None:
            self.pip_code = m.get('PipCode')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxAmountLocal') is not None:
            self.pretax_amount_local = m.get('PretaxAmountLocal')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RoundDownDiscount') is not None:
            self.round_down_discount = m.get('RoundDownDiscount')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tax') is not None:
            self.tax = m.get('Tax')
        return self


class QueryBillOverviewResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        item: List[QueryBillOverviewResponseBodyDataItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = QueryBillOverviewResponseBodyDataItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class QueryBillOverviewResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        billing_cycle: str = None,
        items: QueryBillOverviewResponseBodyDataItems = None,
    ):
        # The ID of the account.
        self.account_id = account_id
        # The name of the account.
        self.account_name = account_name
        # The billing cycle, in the YYYY-MM format.
        self.billing_cycle = billing_cycle
        # The details of the bills.
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('Items') is not None:
            temp_model = QueryBillOverviewResponseBodyDataItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class QueryBillOverviewResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryBillOverviewResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryBillOverviewResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryBillOverviewResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryBillOverviewResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryBillOverviewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryBillToOSSSubscriptionResponseBodyDataItemsItem(TeaModel):
    def __init__(
        self,
        bucket_owner_id: int = None,
        bucket_path: str = None,
        row_limit_per_file: int = None,
        subscribe_bucket: str = None,
        subscribe_language: str = None,
        subscribe_time: str = None,
        subscribe_type: str = None,
    ):
        # The owner ID of the OSS bucket.
        self.bucket_owner_id = bucket_owner_id
        # The directory of the OSS bucket.
        self.bucket_path = bucket_path
        self.row_limit_per_file = row_limit_per_file
        # The ID of the OSS bucket that stores the subscribed bill.
        self.subscribe_bucket = subscribe_bucket
        # The code of the language.
        self.subscribe_language = subscribe_language
        # The time when the subscribed bill was stored in the OSS bucket. The time is displayed in the YYYY-MM-DD hh:mm:ss format.
        self.subscribe_time = subscribe_time
        # The type of the subscribed bill. Valid values:
        # 
        # *   BillingItemDetailForBillingPeriod: bill of a billable item
        # *   InstanceDetailForBillingPeriod: bill of an instance
        self.subscribe_type = subscribe_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket_owner_id is not None:
            result['BucketOwnerId'] = self.bucket_owner_id
        if self.bucket_path is not None:
            result['BucketPath'] = self.bucket_path
        if self.row_limit_per_file is not None:
            result['RowLimitPerFile'] = self.row_limit_per_file
        if self.subscribe_bucket is not None:
            result['SubscribeBucket'] = self.subscribe_bucket
        if self.subscribe_language is not None:
            result['SubscribeLanguage'] = self.subscribe_language
        if self.subscribe_time is not None:
            result['SubscribeTime'] = self.subscribe_time
        if self.subscribe_type is not None:
            result['SubscribeType'] = self.subscribe_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BucketOwnerId') is not None:
            self.bucket_owner_id = m.get('BucketOwnerId')
        if m.get('BucketPath') is not None:
            self.bucket_path = m.get('BucketPath')
        if m.get('RowLimitPerFile') is not None:
            self.row_limit_per_file = m.get('RowLimitPerFile')
        if m.get('SubscribeBucket') is not None:
            self.subscribe_bucket = m.get('SubscribeBucket')
        if m.get('SubscribeLanguage') is not None:
            self.subscribe_language = m.get('SubscribeLanguage')
        if m.get('SubscribeTime') is not None:
            self.subscribe_time = m.get('SubscribeTime')
        if m.get('SubscribeType') is not None:
            self.subscribe_type = m.get('SubscribeType')
        return self


class QueryBillToOSSSubscriptionResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        item: List[QueryBillToOSSSubscriptionResponseBodyDataItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = QueryBillToOSSSubscriptionResponseBodyDataItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class QueryBillToOSSSubscriptionResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        items: QueryBillToOSSSubscriptionResponseBodyDataItems = None,
    ):
        # The ID of the account used to perform the query.
        self.account_id = account_id
        # The name of the account used to perform the query.
        self.account_name = account_name
        # The details of the subscribed bills.
        self.items = items

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.items is not None:
            result['Items'] = self.items.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('Items') is not None:
            temp_model = QueryBillToOSSSubscriptionResponseBodyDataItems()
            self.items = temp_model.from_map(m['Items'])
        return self


class QueryBillToOSSSubscriptionResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryBillToOSSSubscriptionResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryBillToOSSSubscriptionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryBillToOSSSubscriptionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryBillToOSSSubscriptionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryBillToOSSSubscriptionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCashCouponsRequest(TeaModel):
    def __init__(
        self,
        effective_or_not: bool = None,
        expiry_time_end: str = None,
        expiry_time_start: str = None,
    ):
        # Specifies whether the voucher takes effect. Valid values:
        # 
        # *   true: The voucher takes effect.
        # *   false: The voucher does not take effect.
        self.effective_or_not = effective_or_not
        # The end time of the validity period of the voucher. Specify the parameter in the yyyy-MM-ddTHH:mm:ssZ format. Example: 2018-08-01T00:00:00Z.
        self.expiry_time_end = expiry_time_end
        # The start time of the validity period of the voucher. Specify the parameter in the yyyy-MM-ddTHH:mm:ssZ format. Example: 2018-08-01T00:00:00Z.
        self.expiry_time_start = expiry_time_start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effective_or_not is not None:
            result['EffectiveOrNot'] = self.effective_or_not
        if self.expiry_time_end is not None:
            result['ExpiryTimeEnd'] = self.expiry_time_end
        if self.expiry_time_start is not None:
            result['ExpiryTimeStart'] = self.expiry_time_start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EffectiveOrNot') is not None:
            self.effective_or_not = m.get('EffectiveOrNot')
        if m.get('ExpiryTimeEnd') is not None:
            self.expiry_time_end = m.get('ExpiryTimeEnd')
        if m.get('ExpiryTimeStart') is not None:
            self.expiry_time_start = m.get('ExpiryTimeStart')
        return self


class QueryCashCouponsResponseBodyDataCashCoupon(TeaModel):
    def __init__(
        self,
        applicable_products: str = None,
        applicable_scenarios: str = None,
        balance: str = None,
        cash_coupon_id: int = None,
        cash_coupon_no: str = None,
        effective_time: str = None,
        expiry_time: str = None,
        granted_time: str = None,
        nominal_value: str = None,
        status: str = None,
    ):
        # The service to which the voucher is applicable.
        self.applicable_products = applicable_products
        # The scenario to which the voucher is applicable.
        self.applicable_scenarios = applicable_scenarios
        # The remaining quota of the voucher.
        self.balance = balance
        # The ID of the voucher.
        self.cash_coupon_id = cash_coupon_id
        # The code of the voucher.
        self.cash_coupon_no = cash_coupon_no
        # The time when the voucher took effect.
        self.effective_time = effective_time
        # The time when the voucher expired.
        self.expiry_time = expiry_time
        # The time when the voucher was released.
        self.granted_time = granted_time
        # The denomination of the voucher.
        self.nominal_value = nominal_value
        # The state of the voucher. Valid values:
        # 
        # *   Available: The voucher is valid.
        # *   Expired: The voucher has expired.
        # *   Cancelled: The voucher is canceled.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applicable_products is not None:
            result['ApplicableProducts'] = self.applicable_products
        if self.applicable_scenarios is not None:
            result['ApplicableScenarios'] = self.applicable_scenarios
        if self.balance is not None:
            result['Balance'] = self.balance
        if self.cash_coupon_id is not None:
            result['CashCouponId'] = self.cash_coupon_id
        if self.cash_coupon_no is not None:
            result['CashCouponNo'] = self.cash_coupon_no
        if self.effective_time is not None:
            result['EffectiveTime'] = self.effective_time
        if self.expiry_time is not None:
            result['ExpiryTime'] = self.expiry_time
        if self.granted_time is not None:
            result['GrantedTime'] = self.granted_time
        if self.nominal_value is not None:
            result['NominalValue'] = self.nominal_value
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicableProducts') is not None:
            self.applicable_products = m.get('ApplicableProducts')
        if m.get('ApplicableScenarios') is not None:
            self.applicable_scenarios = m.get('ApplicableScenarios')
        if m.get('Balance') is not None:
            self.balance = m.get('Balance')
        if m.get('CashCouponId') is not None:
            self.cash_coupon_id = m.get('CashCouponId')
        if m.get('CashCouponNo') is not None:
            self.cash_coupon_no = m.get('CashCouponNo')
        if m.get('EffectiveTime') is not None:
            self.effective_time = m.get('EffectiveTime')
        if m.get('ExpiryTime') is not None:
            self.expiry_time = m.get('ExpiryTime')
        if m.get('GrantedTime') is not None:
            self.granted_time = m.get('GrantedTime')
        if m.get('NominalValue') is not None:
            self.nominal_value = m.get('NominalValue')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class QueryCashCouponsResponseBodyData(TeaModel):
    def __init__(
        self,
        cash_coupon: List[QueryCashCouponsResponseBodyDataCashCoupon] = None,
    ):
        self.cash_coupon = cash_coupon

    def validate(self):
        if self.cash_coupon:
            for k in self.cash_coupon:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CashCoupon'] = []
        if self.cash_coupon is not None:
            for k in self.cash_coupon:
                result['CashCoupon'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cash_coupon = []
        if m.get('CashCoupon') is not None:
            for k in m.get('CashCoupon'):
                temp_model = QueryCashCouponsResponseBodyDataCashCoupon()
                self.cash_coupon.append(temp_model.from_map(k))
        return self


class QueryCashCouponsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryCashCouponsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryCashCouponsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryCashCouponsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryCashCouponsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryCashCouponsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCommodityListRequest(TeaModel):
    def __init__(
        self,
        product_code: str = None,
    ):
        self.product_code = product_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        return self


class QueryCommodityListResponseBodyDataCommodityList(TeaModel):
    def __init__(
        self,
        charge_type: str = None,
        commodity_code: str = None,
        commodity_name: str = None,
    ):
        self.charge_type = charge_type
        self.commodity_code = commodity_code
        self.commodity_name = commodity_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.commodity_name is not None:
            result['CommodityName'] = self.commodity_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CommodityName') is not None:
            self.commodity_name = m.get('CommodityName')
        return self


class QueryCommodityListResponseBodyData(TeaModel):
    def __init__(
        self,
        commodity_list: List[QueryCommodityListResponseBodyDataCommodityList] = None,
    ):
        self.commodity_list = commodity_list

    def validate(self):
        if self.commodity_list:
            for k in self.commodity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CommodityList'] = []
        if self.commodity_list is not None:
            for k in self.commodity_list:
                result['CommodityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.commodity_list = []
        if m.get('CommodityList') is not None:
            for k in m.get('CommodityList'):
                temp_model = QueryCommodityListResponseBodyDataCommodityList()
                self.commodity_list.append(temp_model.from_map(k))
        return self


class QueryCommodityListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryCommodityListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryCommodityListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryCommodityListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryCommodityListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryCommodityListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCostUnitRequest(TeaModel):
    def __init__(
        self,
        owner_uid: int = None,
        page_num: int = None,
        page_size: int = None,
        parent_unit_id: int = None,
    ):
        self.owner_uid = owner_uid
        self.page_num = page_num
        self.page_size = page_size
        self.parent_unit_id = parent_unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.parent_unit_id is not None:
            result['ParentUnitId'] = self.parent_unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ParentUnitId') is not None:
            self.parent_unit_id = m.get('ParentUnitId')
        return self


class QueryCostUnitResponseBodyDataCostUnitDtoList(TeaModel):
    def __init__(
        self,
        owner_uid: int = None,
        parent_unit_id: int = None,
        unit_id: int = None,
        unit_name: str = None,
    ):
        self.owner_uid = owner_uid
        self.parent_unit_id = parent_unit_id
        self.unit_id = unit_id
        self.unit_name = unit_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.parent_unit_id is not None:
            result['ParentUnitId'] = self.parent_unit_id
        if self.unit_id is not None:
            result['UnitId'] = self.unit_id
        if self.unit_name is not None:
            result['UnitName'] = self.unit_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('ParentUnitId') is not None:
            self.parent_unit_id = m.get('ParentUnitId')
        if m.get('UnitId') is not None:
            self.unit_id = m.get('UnitId')
        if m.get('UnitName') is not None:
            self.unit_name = m.get('UnitName')
        return self


class QueryCostUnitResponseBodyData(TeaModel):
    def __init__(
        self,
        cost_unit_dto_list: List[QueryCostUnitResponseBodyDataCostUnitDtoList] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.cost_unit_dto_list = cost_unit_dto_list
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.cost_unit_dto_list:
            for k in self.cost_unit_dto_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CostUnitDtoList'] = []
        if self.cost_unit_dto_list is not None:
            for k in self.cost_unit_dto_list:
                result['CostUnitDtoList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cost_unit_dto_list = []
        if m.get('CostUnitDtoList') is not None:
            for k in m.get('CostUnitDtoList'):
                temp_model = QueryCostUnitResponseBodyDataCostUnitDtoList()
                self.cost_unit_dto_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryCostUnitResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryCostUnitResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryCostUnitResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryCostUnitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryCostUnitResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryCostUnitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCostUnitResourceRequest(TeaModel):
    def __init__(
        self,
        owner_uid: int = None,
        page_num: int = None,
        page_size: int = None,
        unit_id: int = None,
    ):
        self.owner_uid = owner_uid
        self.page_num = page_num
        self.page_size = page_size
        self.unit_id = unit_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.unit_id is not None:
            result['UnitId'] = self.unit_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('UnitId') is not None:
            self.unit_id = m.get('UnitId')
        return self


class QueryCostUnitResourceResponseBodyDataCostUnit(TeaModel):
    def __init__(
        self,
        owner_uid: int = None,
        parent_unit_id: int = None,
        unit_id: int = None,
        unit_name: str = None,
    ):
        self.owner_uid = owner_uid
        self.parent_unit_id = parent_unit_id
        self.unit_id = unit_id
        self.unit_name = unit_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.parent_unit_id is not None:
            result['ParentUnitId'] = self.parent_unit_id
        if self.unit_id is not None:
            result['UnitId'] = self.unit_id
        if self.unit_name is not None:
            result['UnitName'] = self.unit_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('ParentUnitId') is not None:
            self.parent_unit_id = m.get('ParentUnitId')
        if m.get('UnitId') is not None:
            self.unit_id = m.get('UnitId')
        if m.get('UnitName') is not None:
            self.unit_name = m.get('UnitName')
        return self


class QueryCostUnitResourceResponseBodyDataCostUnitStatisInfo(TeaModel):
    def __init__(
        self,
        resource_count: int = None,
        resource_group_count: int = None,
        sub_unit_count: int = None,
        total_resource_count: int = None,
        total_resource_group_count: int = None,
        total_user_count: int = None,
        user_count: int = None,
    ):
        self.resource_count = resource_count
        self.resource_group_count = resource_group_count
        self.sub_unit_count = sub_unit_count
        self.total_resource_count = total_resource_count
        self.total_resource_group_count = total_resource_group_count
        self.total_user_count = total_user_count
        self.user_count = user_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_count is not None:
            result['ResourceCount'] = self.resource_count
        if self.resource_group_count is not None:
            result['ResourceGroupCount'] = self.resource_group_count
        if self.sub_unit_count is not None:
            result['SubUnitCount'] = self.sub_unit_count
        if self.total_resource_count is not None:
            result['TotalResourceCount'] = self.total_resource_count
        if self.total_resource_group_count is not None:
            result['TotalResourceGroupCount'] = self.total_resource_group_count
        if self.total_user_count is not None:
            result['TotalUserCount'] = self.total_user_count
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceCount') is not None:
            self.resource_count = m.get('ResourceCount')
        if m.get('ResourceGroupCount') is not None:
            self.resource_group_count = m.get('ResourceGroupCount')
        if m.get('SubUnitCount') is not None:
            self.sub_unit_count = m.get('SubUnitCount')
        if m.get('TotalResourceCount') is not None:
            self.total_resource_count = m.get('TotalResourceCount')
        if m.get('TotalResourceGroupCount') is not None:
            self.total_resource_group_count = m.get('TotalResourceGroupCount')
        if m.get('TotalUserCount') is not None:
            self.total_user_count = m.get('TotalUserCount')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class QueryCostUnitResourceResponseBodyDataResourceInstanceDtoList(TeaModel):
    def __init__(
        self,
        apportion_code: str = None,
        apportion_name: str = None,
        commodity_code: str = None,
        commodity_name: str = None,
        related_resources: str = None,
        resource_group: str = None,
        resource_id: str = None,
        resource_nick: str = None,
        resource_status: str = None,
        resource_tag: str = None,
        resource_type: str = None,
        resource_user_id: int = None,
        resource_user_name: str = None,
    ):
        self.apportion_code = apportion_code
        self.apportion_name = apportion_name
        self.commodity_code = commodity_code
        self.commodity_name = commodity_name
        self.related_resources = related_resources
        self.resource_group = resource_group
        self.resource_id = resource_id
        self.resource_nick = resource_nick
        self.resource_status = resource_status
        self.resource_tag = resource_tag
        self.resource_type = resource_type
        self.resource_user_id = resource_user_id
        self.resource_user_name = resource_user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.apportion_code is not None:
            result['ApportionCode'] = self.apportion_code
        if self.apportion_name is not None:
            result['ApportionName'] = self.apportion_name
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.commodity_name is not None:
            result['CommodityName'] = self.commodity_name
        if self.related_resources is not None:
            result['RelatedResources'] = self.related_resources
        if self.resource_group is not None:
            result['ResourceGroup'] = self.resource_group
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_nick is not None:
            result['ResourceNick'] = self.resource_nick
        if self.resource_status is not None:
            result['ResourceStatus'] = self.resource_status
        if self.resource_tag is not None:
            result['ResourceTag'] = self.resource_tag
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.resource_user_id is not None:
            result['ResourceUserId'] = self.resource_user_id
        if self.resource_user_name is not None:
            result['ResourceUserName'] = self.resource_user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApportionCode') is not None:
            self.apportion_code = m.get('ApportionCode')
        if m.get('ApportionName') is not None:
            self.apportion_name = m.get('ApportionName')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CommodityName') is not None:
            self.commodity_name = m.get('CommodityName')
        if m.get('RelatedResources') is not None:
            self.related_resources = m.get('RelatedResources')
        if m.get('ResourceGroup') is not None:
            self.resource_group = m.get('ResourceGroup')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceNick') is not None:
            self.resource_nick = m.get('ResourceNick')
        if m.get('ResourceStatus') is not None:
            self.resource_status = m.get('ResourceStatus')
        if m.get('ResourceTag') is not None:
            self.resource_tag = m.get('ResourceTag')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('ResourceUserId') is not None:
            self.resource_user_id = m.get('ResourceUserId')
        if m.get('ResourceUserName') is not None:
            self.resource_user_name = m.get('ResourceUserName')
        return self


class QueryCostUnitResourceResponseBodyData(TeaModel):
    def __init__(
        self,
        cost_unit: QueryCostUnitResourceResponseBodyDataCostUnit = None,
        cost_unit_statis_info: QueryCostUnitResourceResponseBodyDataCostUnitStatisInfo = None,
        page_num: int = None,
        page_size: int = None,
        resource_instance_dto_list: List[QueryCostUnitResourceResponseBodyDataResourceInstanceDtoList] = None,
        total_count: int = None,
    ):
        self.cost_unit = cost_unit
        self.cost_unit_statis_info = cost_unit_statis_info
        self.page_num = page_num
        self.page_size = page_size
        self.resource_instance_dto_list = resource_instance_dto_list
        self.total_count = total_count

    def validate(self):
        if self.cost_unit:
            self.cost_unit.validate()
        if self.cost_unit_statis_info:
            self.cost_unit_statis_info.validate()
        if self.resource_instance_dto_list:
            for k in self.resource_instance_dto_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cost_unit is not None:
            result['CostUnit'] = self.cost_unit.to_map()
        if self.cost_unit_statis_info is not None:
            result['CostUnitStatisInfo'] = self.cost_unit_statis_info.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['ResourceInstanceDtoList'] = []
        if self.resource_instance_dto_list is not None:
            for k in self.resource_instance_dto_list:
                result['ResourceInstanceDtoList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CostUnit') is not None:
            temp_model = QueryCostUnitResourceResponseBodyDataCostUnit()
            self.cost_unit = temp_model.from_map(m['CostUnit'])
        if m.get('CostUnitStatisInfo') is not None:
            temp_model = QueryCostUnitResourceResponseBodyDataCostUnitStatisInfo()
            self.cost_unit_statis_info = temp_model.from_map(m['CostUnitStatisInfo'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.resource_instance_dto_list = []
        if m.get('ResourceInstanceDtoList') is not None:
            for k in m.get('ResourceInstanceDtoList'):
                temp_model = QueryCostUnitResourceResponseBodyDataResourceInstanceDtoList()
                self.resource_instance_dto_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryCostUnitResourceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryCostUnitResourceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryCostUnitResourceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryCostUnitResourceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryCostUnitResourceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryCostUnitResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryCustomerAddressListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
    ):
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class QueryCustomerAddressListResponseBodyDataCustomerInvoiceAddressListCustomerInvoiceAddress(TeaModel):
    def __init__(
        self,
        addressee: str = None,
        biz_type: str = None,
        city: str = None,
        county: str = None,
        delivery_address: str = None,
        id: int = None,
        phone: str = None,
        postal_code: str = None,
        province: str = None,
        street: str = None,
        user_id: int = None,
        user_nick: str = None,
    ):
        # The addressee.
        self.addressee = addressee
        # The business type.
        self.biz_type = biz_type
        # The city to which the invoice is mailed.
        self.city = city
        # The name of the district to which the invoice is mailed.
        self.county = county
        # The detailed address to which the invoice is mailed. This parameter is returned after fields are concatenated.
        self.delivery_address = delivery_address
        # The ID.
        self.id = id
        # The phone number of the addressee.
        self.phone = phone
        # The postcode.
        self.postal_code = postal_code
        # The province to which the invoice is mailed.
        self.province = province
        # The name of the street to which the invoice is mailed.
        self.street = street
        # The ID of the user.
        self.user_id = user_id
        # The nickname of the user.
        self.user_nick = user_nick

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addressee is not None:
            result['Addressee'] = self.addressee
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.city is not None:
            result['City'] = self.city
        if self.county is not None:
            result['County'] = self.county
        if self.delivery_address is not None:
            result['DeliveryAddress'] = self.delivery_address
        if self.id is not None:
            result['Id'] = self.id
        if self.phone is not None:
            result['Phone'] = self.phone
        if self.postal_code is not None:
            result['PostalCode'] = self.postal_code
        if self.province is not None:
            result['Province'] = self.province
        if self.street is not None:
            result['Street'] = self.street
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_nick is not None:
            result['UserNick'] = self.user_nick
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addressee') is not None:
            self.addressee = m.get('Addressee')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('County') is not None:
            self.county = m.get('County')
        if m.get('DeliveryAddress') is not None:
            self.delivery_address = m.get('DeliveryAddress')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Phone') is not None:
            self.phone = m.get('Phone')
        if m.get('PostalCode') is not None:
            self.postal_code = m.get('PostalCode')
        if m.get('Province') is not None:
            self.province = m.get('Province')
        if m.get('Street') is not None:
            self.street = m.get('Street')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserNick') is not None:
            self.user_nick = m.get('UserNick')
        return self


class QueryCustomerAddressListResponseBodyDataCustomerInvoiceAddressList(TeaModel):
    def __init__(
        self,
        customer_invoice_address: List[QueryCustomerAddressListResponseBodyDataCustomerInvoiceAddressListCustomerInvoiceAddress] = None,
    ):
        self.customer_invoice_address = customer_invoice_address

    def validate(self):
        if self.customer_invoice_address:
            for k in self.customer_invoice_address:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomerInvoiceAddress'] = []
        if self.customer_invoice_address is not None:
            for k in self.customer_invoice_address:
                result['CustomerInvoiceAddress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.customer_invoice_address = []
        if m.get('CustomerInvoiceAddress') is not None:
            for k in m.get('CustomerInvoiceAddress'):
                temp_model = QueryCustomerAddressListResponseBodyDataCustomerInvoiceAddressListCustomerInvoiceAddress()
                self.customer_invoice_address.append(temp_model.from_map(k))
        return self


class QueryCustomerAddressListResponseBodyData(TeaModel):
    def __init__(
        self,
        customer_invoice_address_list: QueryCustomerAddressListResponseBodyDataCustomerInvoiceAddressList = None,
    ):
        # The details of addresses to which invoices are mailed.
        self.customer_invoice_address_list = customer_invoice_address_list

    def validate(self):
        if self.customer_invoice_address_list:
            self.customer_invoice_address_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customer_invoice_address_list is not None:
            result['CustomerInvoiceAddressList'] = self.customer_invoice_address_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomerInvoiceAddressList') is not None:
            temp_model = QueryCustomerAddressListResponseBodyDataCustomerInvoiceAddressList()
            self.customer_invoice_address_list = temp_model.from_map(m['CustomerInvoiceAddressList'])
        return self


class QueryCustomerAddressListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryCustomerAddressListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The error message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryCustomerAddressListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryCustomerAddressListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryCustomerAddressListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryCustomerAddressListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryDPUtilizationDetailRequest(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
        deducted_instance_id: str = None,
        end_time: str = None,
        include_share: bool = None,
        instance_id: str = None,
        instance_spec: str = None,
        last_token: str = None,
        limit: int = None,
        prod_code: str = None,
        start_time: str = None,
    ):
        self.commodity_code = commodity_code
        self.deducted_instance_id = deducted_instance_id
        self.end_time = end_time
        self.include_share = include_share
        self.instance_id = instance_id
        self.instance_spec = instance_spec
        self.last_token = last_token
        self.limit = limit
        self.prod_code = prod_code
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.deducted_instance_id is not None:
            result['DeductedInstanceId'] = self.deducted_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.include_share is not None:
            result['IncludeShare'] = self.include_share
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.last_token is not None:
            result['LastToken'] = self.last_token
        if self.limit is not None:
            result['Limit'] = self.limit
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('DeductedInstanceId') is not None:
            self.deducted_instance_id = m.get('DeductedInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IncludeShare') is not None:
            self.include_share = m.get('IncludeShare')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('LastToken') is not None:
            self.last_token = m.get('LastToken')
        if m.get('Limit') is not None:
            self.limit = m.get('Limit')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QueryDPUtilizationDetailResponseBodyDataDetailListDetailList(TeaModel):
    def __init__(
        self,
        deduct_date: str = None,
        deduct_factor_total: float = None,
        deduct_hours: float = None,
        deduct_measure: float = None,
        deduct_quantity: float = None,
        deducted_commodity_code: str = None,
        deducted_instance_id: str = None,
        deducted_product_detail: str = None,
        instance_id: str = None,
        instance_spec: str = None,
        region: str = None,
        res_code: str = None,
        share_uid: int = None,
        uid: int = None,
    ):
        self.deduct_date = deduct_date
        self.deduct_factor_total = deduct_factor_total
        self.deduct_hours = deduct_hours
        self.deduct_measure = deduct_measure
        self.deduct_quantity = deduct_quantity
        self.deducted_commodity_code = deducted_commodity_code
        self.deducted_instance_id = deducted_instance_id
        self.deducted_product_detail = deducted_product_detail
        self.instance_id = instance_id
        self.instance_spec = instance_spec
        self.region = region
        self.res_code = res_code
        self.share_uid = share_uid
        self.uid = uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deduct_date is not None:
            result['DeductDate'] = self.deduct_date
        if self.deduct_factor_total is not None:
            result['DeductFactorTotal'] = self.deduct_factor_total
        if self.deduct_hours is not None:
            result['DeductHours'] = self.deduct_hours
        if self.deduct_measure is not None:
            result['DeductMeasure'] = self.deduct_measure
        if self.deduct_quantity is not None:
            result['DeductQuantity'] = self.deduct_quantity
        if self.deducted_commodity_code is not None:
            result['DeductedCommodityCode'] = self.deducted_commodity_code
        if self.deducted_instance_id is not None:
            result['DeductedInstanceId'] = self.deducted_instance_id
        if self.deducted_product_detail is not None:
            result['DeductedProductDetail'] = self.deducted_product_detail
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.region is not None:
            result['Region'] = self.region
        if self.res_code is not None:
            result['ResCode'] = self.res_code
        if self.share_uid is not None:
            result['ShareUid'] = self.share_uid
        if self.uid is not None:
            result['Uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeductDate') is not None:
            self.deduct_date = m.get('DeductDate')
        if m.get('DeductFactorTotal') is not None:
            self.deduct_factor_total = m.get('DeductFactorTotal')
        if m.get('DeductHours') is not None:
            self.deduct_hours = m.get('DeductHours')
        if m.get('DeductMeasure') is not None:
            self.deduct_measure = m.get('DeductMeasure')
        if m.get('DeductQuantity') is not None:
            self.deduct_quantity = m.get('DeductQuantity')
        if m.get('DeductedCommodityCode') is not None:
            self.deducted_commodity_code = m.get('DeductedCommodityCode')
        if m.get('DeductedInstanceId') is not None:
            self.deducted_instance_id = m.get('DeductedInstanceId')
        if m.get('DeductedProductDetail') is not None:
            self.deducted_product_detail = m.get('DeductedProductDetail')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResCode') is not None:
            self.res_code = m.get('ResCode')
        if m.get('ShareUid') is not None:
            self.share_uid = m.get('ShareUid')
        if m.get('Uid') is not None:
            self.uid = m.get('Uid')
        return self


class QueryDPUtilizationDetailResponseBodyDataDetailList(TeaModel):
    def __init__(
        self,
        detail_list: List[QueryDPUtilizationDetailResponseBodyDataDetailListDetailList] = None,
    ):
        self.detail_list = detail_list

    def validate(self):
        if self.detail_list:
            for k in self.detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DetailList'] = []
        if self.detail_list is not None:
            for k in self.detail_list:
                result['DetailList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.detail_list = []
        if m.get('DetailList') is not None:
            for k in m.get('DetailList'):
                temp_model = QueryDPUtilizationDetailResponseBodyDataDetailListDetailList()
                self.detail_list.append(temp_model.from_map(k))
        return self


class QueryDPUtilizationDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        detail_list: QueryDPUtilizationDetailResponseBodyDataDetailList = None,
        next_token: str = None,
    ):
        self.detail_list = detail_list
        self.next_token = next_token

    def validate(self):
        if self.detail_list:
            self.detail_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detail_list is not None:
            result['DetailList'] = self.detail_list.to_map()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DetailList') is not None:
            temp_model = QueryDPUtilizationDetailResponseBodyDataDetailList()
            self.detail_list = temp_model.from_map(m['DetailList'])
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        return self


class QueryDPUtilizationDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryDPUtilizationDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryDPUtilizationDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryDPUtilizationDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryDPUtilizationDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryDPUtilizationDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryEvaluateListRequest(TeaModel):
    def __init__(
        self,
        bill_cycle: str = None,
        biz_type_list: List[str] = None,
        end_amount: int = None,
        end_biz_time: str = None,
        end_search_time: str = None,
        out_biz_id: str = None,
        owner_id: int = None,
        page_num: int = None,
        page_size: int = None,
        sort_type: int = None,
        start_amount: int = None,
        start_biz_time: str = None,
        start_search_time: str = None,
        type: int = None,
    ):
        # The billing cycle.
        self.bill_cycle = bill_cycle
        # The market types in invoices.
        # 
        # >  By default, this parameter is left empty. If this parameter is left empty, all market types are queried.
        self.biz_type_list = biz_type_list
        # The maximum amount to be queried.
        self.end_amount = end_amount
        # The latest time when an order is paid Specify the time in the yyyy-mm-dd hh:mm:ss format.
        self.end_biz_time = end_biz_time
        # The end of the time range to query.
        self.end_search_time = end_search_time
        # The ID of the external order.
        self.out_biz_id = out_biz_id
        self.owner_id = owner_id
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The type of the sort. Valid values:
        # 
        # *   1: Sort invoices by ID in descending order.
        # *   2: Sort invoices by invoice type in descending order, and then sort invoices of the same type by ID in descending order.
        # *   3: Sort invoices by invoice type in ascending order, and then sort invoices of the same type by ID in descending order.
        self.sort_type = sort_type
        # The minimum amount to be queried.
        self.start_amount = start_amount
        # The earliest time when an order is paid. Specify the time in the yyyy-mm-dd hh:mm:ss format.
        self.start_biz_time = start_biz_time
        # The beginning of the time range to query.
        self.start_search_time = start_search_time
        # The type of orders to be queried. Valid values:
        # 
        # *   1: the orders in which the invoiceable amount is negative.
        # *   2: the orders in which the invoiceable amount is positive.
        # *   3: the orders in which the invoiceable amount is not 0.
        # *   4: the orders in which the amount that has been invoiced is greater than 0.
        # 
        # >  By default, this parameter is left empty. If this parameter is left empty, all orders are queried.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_cycle is not None:
            result['BillCycle'] = self.bill_cycle
        if self.biz_type_list is not None:
            result['BizTypeList'] = self.biz_type_list
        if self.end_amount is not None:
            result['EndAmount'] = self.end_amount
        if self.end_biz_time is not None:
            result['EndBizTime'] = self.end_biz_time
        if self.end_search_time is not None:
            result['EndSearchTime'] = self.end_search_time
        if self.out_biz_id is not None:
            result['OutBizId'] = self.out_biz_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sort_type is not None:
            result['SortType'] = self.sort_type
        if self.start_amount is not None:
            result['StartAmount'] = self.start_amount
        if self.start_biz_time is not None:
            result['StartBizTime'] = self.start_biz_time
        if self.start_search_time is not None:
            result['StartSearchTime'] = self.start_search_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillCycle') is not None:
            self.bill_cycle = m.get('BillCycle')
        if m.get('BizTypeList') is not None:
            self.biz_type_list = m.get('BizTypeList')
        if m.get('EndAmount') is not None:
            self.end_amount = m.get('EndAmount')
        if m.get('EndBizTime') is not None:
            self.end_biz_time = m.get('EndBizTime')
        if m.get('EndSearchTime') is not None:
            self.end_search_time = m.get('EndSearchTime')
        if m.get('OutBizId') is not None:
            self.out_biz_id = m.get('OutBizId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SortType') is not None:
            self.sort_type = m.get('SortType')
        if m.get('StartAmount') is not None:
            self.start_amount = m.get('StartAmount')
        if m.get('StartBizTime') is not None:
            self.start_biz_time = m.get('StartBizTime')
        if m.get('StartSearchTime') is not None:
            self.start_search_time = m.get('StartSearchTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryEvaluateListResponseBodyDataEvaluateListEvaluate(TeaModel):
    def __init__(
        self,
        bill_cycle: str = None,
        bill_id: int = None,
        biz_time: str = None,
        biz_type: str = None,
        can_invoice_amount: int = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        invoiced_amount: int = None,
        item_id: int = None,
        name: str = None,
        offset_accept_amount: int = None,
        offset_cost_amount: int = None,
        op_id: str = None,
        original_amount: int = None,
        out_biz_id: str = None,
        present_amount: int = None,
        status: int = None,
        type: int = None,
        user_id: int = None,
        user_nick: str = None,
    ):
        # The billing cycle.
        self.bill_cycle = bill_cycle
        # The ID of the bill.
        self.bill_id = bill_id
        # The time.
        self.biz_time = biz_time
        # The market type in the invoice. Valid values:
        # 
        # *   ALIYUN: Alibaba Cloud
        # *   MARKETPLACE: Alibaba Cloud Marketplace
        self.biz_type = biz_type
        # The invoiceable amount.
        self.can_invoice_amount = can_invoice_amount
        # The creation time.
        self.gmt_create = gmt_create
        # The modification time.
        self.gmt_modified = gmt_modified
        # The ID of the invoice.
        self.id = id
        # The invoiced amount.
        self.invoiced_amount = invoiced_amount
        # The ID of the item.
        self.item_id = item_id
        # The name of the object to be invoiced.
        self.name = name
        # If a refund is issued due to an order such as an unsubscription order or a configuration downgrade order, the refund amount is used to offset the amount of the invoice. The value is consistent with the value of the **OffsetCostAmount** parameter.
        self.offset_accept_amount = offset_accept_amount
        # The refund amount used to offset the amount of the invoice. If a refund is issued due to an order such as an unsubscription order or a configuration downgrade order, the refund amount is used to offset the amount of the invoice. The value is consistent with the value of the **OffsetAcceptAmount** parameter.
        self.offset_cost_amount = offset_cost_amount
        # The ID of the external object.
        self.op_id = op_id
        # The original amount.
        self.original_amount = original_amount
        # The ID of the external order.
        self.out_biz_id = out_biz_id
        # The balance.
        self.present_amount = present_amount
        # The status of the invoiceable amount.
        self.status = status
        # The type of orders that are queried. Valid values:
        # 
        # *   1: the orders in which the invoiceable amount is negative.
        # *   2: the orders in which the invoiceable amount is positive.
        # *   3: the orders in which the invoiceable amount is not 0.
        # *   4: the orders in which the amount that has been invoiced is greater than 0.
        # 
        # >  By default, this parameter is left empty. If this parameter is left empty, all orders are queried.
        self.type = type
        # The ID of the user.
        self.user_id = user_id
        # The nickname of the user.
        self.user_nick = user_nick

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_cycle is not None:
            result['BillCycle'] = self.bill_cycle
        if self.bill_id is not None:
            result['BillId'] = self.bill_id
        if self.biz_time is not None:
            result['BizTime'] = self.biz_time
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.can_invoice_amount is not None:
            result['CanInvoiceAmount'] = self.can_invoice_amount
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.invoiced_amount is not None:
            result['InvoicedAmount'] = self.invoiced_amount
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.name is not None:
            result['Name'] = self.name
        if self.offset_accept_amount is not None:
            result['OffsetAcceptAmount'] = self.offset_accept_amount
        if self.offset_cost_amount is not None:
            result['OffsetCostAmount'] = self.offset_cost_amount
        if self.op_id is not None:
            result['OpId'] = self.op_id
        if self.original_amount is not None:
            result['OriginalAmount'] = self.original_amount
        if self.out_biz_id is not None:
            result['OutBizId'] = self.out_biz_id
        if self.present_amount is not None:
            result['PresentAmount'] = self.present_amount
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_nick is not None:
            result['UserNick'] = self.user_nick
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillCycle') is not None:
            self.bill_cycle = m.get('BillCycle')
        if m.get('BillId') is not None:
            self.bill_id = m.get('BillId')
        if m.get('BizTime') is not None:
            self.biz_time = m.get('BizTime')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('CanInvoiceAmount') is not None:
            self.can_invoice_amount = m.get('CanInvoiceAmount')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InvoicedAmount') is not None:
            self.invoiced_amount = m.get('InvoicedAmount')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OffsetAcceptAmount') is not None:
            self.offset_accept_amount = m.get('OffsetAcceptAmount')
        if m.get('OffsetCostAmount') is not None:
            self.offset_cost_amount = m.get('OffsetCostAmount')
        if m.get('OpId') is not None:
            self.op_id = m.get('OpId')
        if m.get('OriginalAmount') is not None:
            self.original_amount = m.get('OriginalAmount')
        if m.get('OutBizId') is not None:
            self.out_biz_id = m.get('OutBizId')
        if m.get('PresentAmount') is not None:
            self.present_amount = m.get('PresentAmount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserNick') is not None:
            self.user_nick = m.get('UserNick')
        return self


class QueryEvaluateListResponseBodyDataEvaluateList(TeaModel):
    def __init__(
        self,
        evaluate: List[QueryEvaluateListResponseBodyDataEvaluateListEvaluate] = None,
    ):
        self.evaluate = evaluate

    def validate(self):
        if self.evaluate:
            for k in self.evaluate:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Evaluate'] = []
        if self.evaluate is not None:
            for k in self.evaluate:
                result['Evaluate'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.evaluate = []
        if m.get('Evaluate') is not None:
            for k in m.get('Evaluate'):
                temp_model = QueryEvaluateListResponseBodyDataEvaluateListEvaluate()
                self.evaluate.append(temp_model.from_map(k))
        return self


class QueryEvaluateListResponseBodyData(TeaModel):
    def __init__(
        self,
        evaluate_list: QueryEvaluateListResponseBodyDataEvaluateList = None,
        host_id: str = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
        total_invoice_amount: int = None,
        total_un_applied_invoice_amount: int = None,
    ):
        # The data returned.
        self.evaluate_list = evaluate_list
        # The ID of the host.
        self.host_id = host_id
        # The number of the page returned.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of returned entries.
        self.total_count = total_count
        # The invoiced amount that meets the query conditions. Unit: Cent.
        self.total_invoice_amount = total_invoice_amount
        # The invoiceable amount that meets the query conditions. Unit: Cent.
        self.total_un_applied_invoice_amount = total_un_applied_invoice_amount

    def validate(self):
        if self.evaluate_list:
            self.evaluate_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.evaluate_list is not None:
            result['EvaluateList'] = self.evaluate_list.to_map()
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.total_invoice_amount is not None:
            result['TotalInvoiceAmount'] = self.total_invoice_amount
        if self.total_un_applied_invoice_amount is not None:
            result['TotalUnAppliedInvoiceAmount'] = self.total_un_applied_invoice_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EvaluateList') is not None:
            temp_model = QueryEvaluateListResponseBodyDataEvaluateList()
            self.evaluate_list = temp_model.from_map(m['EvaluateList'])
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('TotalInvoiceAmount') is not None:
            self.total_invoice_amount = m.get('TotalInvoiceAmount')
        if m.get('TotalUnAppliedInvoiceAmount') is not None:
            self.total_un_applied_invoice_amount = m.get('TotalUnAppliedInvoiceAmount')
        return self


class QueryEvaluateListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryEvaluateListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The error message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryEvaluateListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryEvaluateListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryEvaluateListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryEvaluateListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryFinancialAccountInfoRequest(TeaModel):
    def __init__(
        self,
        user_id: int = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class QueryFinancialAccountInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        account_type: str = None,
        is_financial_account: bool = None,
        member_group_id: int = None,
        member_group_name: str = None,
        member_nick_name: str = None,
        user_name: str = None,
    ):
        # The type of the financial account. A value of MASTER indicates that the account is a management account. A value of MEMBER indicates that the account is a member.
        self.account_type = account_type
        # Indicates whether the account is a financial account. A value of true indicates that the account is a financial account. A value of false indicates that the account is not a financial account.
        self.is_financial_account = is_financial_account
        # The ID of the group to which the member belongs.
        self.member_group_id = member_group_id
        # The name of the group to which the member belongs.
        self.member_group_name = member_group_name
        # The display name of the member.
        self.member_nick_name = member_nick_name
        # The username of the account.
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.is_financial_account is not None:
            result['IsFinancialAccount'] = self.is_financial_account
        if self.member_group_id is not None:
            result['MemberGroupId'] = self.member_group_id
        if self.member_group_name is not None:
            result['MemberGroupName'] = self.member_group_name
        if self.member_nick_name is not None:
            result['MemberNickName'] = self.member_nick_name
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('IsFinancialAccount') is not None:
            self.is_financial_account = m.get('IsFinancialAccount')
        if m.get('MemberGroupId') is not None:
            self.member_group_id = m.get('MemberGroupId')
        if m.get('MemberGroupName') is not None:
            self.member_group_name = m.get('MemberGroupName')
        if m.get('MemberNickName') is not None:
            self.member_nick_name = m.get('MemberNickName')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class QueryFinancialAccountInfoResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryFinancialAccountInfoResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryFinancialAccountInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryFinancialAccountInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryFinancialAccountInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryFinancialAccountInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryInstanceBillRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        billing_cycle: str = None,
        billing_date: str = None,
        granularity: str = None,
        is_billing_item: bool = None,
        is_hide_zero_charge: bool = None,
        owner_id: int = None,
        page_num: int = None,
        page_size: int = None,
        product_code: str = None,
        product_type: str = None,
        subscription_type: str = None,
    ):
        # The ID of the member. If you specify a value for this parameter, you can query the bills of the specified member. If you leave this parameter empty, the bills of the current account are queried by default.
        self.bill_owner_id = bill_owner_id
        # The billing cycle. Format: YYYY-MM.
        self.billing_cycle = billing_cycle
        # The billing date. This parameter is required only if the **Granularity** parameter is set to DAILY. Format: YYYY-MM-DD.
        self.billing_date = billing_date
        # The granularity at which bills are queried. Valid values:
        # 
        # *   MONTHLY: queries bills by month. The data queried is consistent with the data that is displayed for the specified billing cycle on the Billing Details tab of the Bill Details page in User Center.
        # *   DAILY: queries bills by day. The data queried is consistent with the data that is displayed for the specified day on the Billing Details tab of the Bill Details page in User Center.
        # 
        # You must set the **BillingDate** parameter before you can set the Granularity parameter to DAILY.
        self.granularity = granularity
        # Specifies whether to query data by billable item. Valid values:
        # 
        # *   false: does not query data by billable item. The data queried is consistent with the data that is displayed for the specified instance on the Billing Details tab of the Bill Details page in User Center.
        # *   true: queries data by billable item. The data queried is consistent with the data that is displayed for the specified billable item on the Billing Details tab of the Bill Details page in User Center.
        # 
        # Default value: false.
        self.is_billing_item = is_billing_item
        # Specifies whether to filter out a bill whose pretax gross amount and pretax amount are 0. Default value: false.******** Valid values:
        # 
        # *   false: does not filter the bill.
        # *   true: filters the bill.
        self.is_hide_zero_charge = is_hide_zero_charge
        self.owner_id = owner_id
        # The number of the page to return. Default value: 1.
        self.page_num = page_num
        # The number of entries to return on each page. Default value: 20. Maximum value: 300.
        self.page_size = page_size
        # The code of the service.
        self.product_code = product_code
        # The type of the service. This parameter is required if the ProductCode parameter is set to the service code of Alibaba Cloud Marketplace.
        self.product_type = product_type
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        # 
        # **\
        # 
        # ****This parameter must be used together with the **ProductCode** parameter.
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.billing_date is not None:
            result['BillingDate'] = self.billing_date
        if self.granularity is not None:
            result['Granularity'] = self.granularity
        if self.is_billing_item is not None:
            result['IsBillingItem'] = self.is_billing_item
        if self.is_hide_zero_charge is not None:
            result['IsHideZeroCharge'] = self.is_hide_zero_charge
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('BillingDate') is not None:
            self.billing_date = m.get('BillingDate')
        if m.get('Granularity') is not None:
            self.granularity = m.get('Granularity')
        if m.get('IsBillingItem') is not None:
            self.is_billing_item = m.get('IsBillingItem')
        if m.get('IsHideZeroCharge') is not None:
            self.is_hide_zero_charge = m.get('IsHideZeroCharge')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class QueryInstanceBillResponseBodyDataItemsItem(TeaModel):
    def __init__(
        self,
        adjust_amount: float = None,
        billing_date: str = None,
        billing_item: str = None,
        billing_type: str = None,
        cash_amount: float = None,
        commodity_code: str = None,
        cost_unit: str = None,
        currency: str = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        deducted_by_resource_package: str = None,
        instance_config: str = None,
        instance_id: str = None,
        instance_spec: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        invoice_discount: float = None,
        item: str = None,
        list_price: str = None,
        list_price_unit: str = None,
        nick_name: str = None,
        outstanding_amount: float = None,
        owner_id: str = None,
        payment_amount: float = None,
        pip_code: str = None,
        pretax_amount: float = None,
        pretax_gross_amount: float = None,
        product_code: str = None,
        product_detail: str = None,
        product_name: str = None,
        product_type: str = None,
        region: str = None,
        resource_group: str = None,
        service_period: str = None,
        service_period_unit: str = None,
        subscription_type: str = None,
        tag: str = None,
        usage: str = None,
        usage_unit: str = None,
        zone: str = None,
    ):
        # The amount deducted by using credit refunds.
        self.adjust_amount = adjust_amount
        # The billing date. This parameter is returned only if the Granularity parameter is set to DAILY. Format: YYYY-MM-DD.
        self.billing_date = billing_date
        # The billable item. This parameter is returned only if the IsBillingItem parameter is set to true.
        self.billing_item = billing_item
        # The billing type.
        self.billing_type = billing_type
        # The amount paid in cash. The amount that was deducted by using credit refunds is not included.
        self.cash_amount = cash_amount
        # The code of the commodity. The commodity code is the same as that displayed in User Center.
        self.commodity_code = commodity_code
        # The cost center.
        self.cost_unit = cost_unit
        # The type of the currency. Valid values:
        # 
        # *   CNY
        # *   USD
        # *   JPY
        self.currency = currency
        # The amount deducted by using vouchers.
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        # The amount deducted by using coupons.
        self.deducted_by_coupons = deducted_by_coupons
        # The amount deducted by using prepaid cards.
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        # The amount deducted by using resource plans.
        self.deducted_by_resource_package = deducted_by_resource_package
        # The configurations of the instance.
        self.instance_config = instance_config
        # The ID of the instance.
        self.instance_id = instance_id
        # The instance type of the instance.
        self.instance_spec = instance_spec
        # The public IP address.
        self.internet_ip = internet_ip
        # The private IP address.
        self.intranet_ip = intranet_ip
        # The discount amount.
        self.invoice_discount = invoice_discount
        # The type of the bill.
        # 
        # *   SubscriptionOrder: subscription order
        # *   PayAsYouGoBill: pay-as-you-go bill
        # *   Refund: refund
        # *   Adjustment: reconciliation
        self.item = item
        # The unit price. This parameter is returned only if the isBillingItem parameter is set to true.
        self.list_price = list_price
        # The unit of the unit price. This parameter is returned only if the isBillingItem parameter is set to true.
        self.list_price_unit = list_price_unit
        # The name of the instance.
        self.nick_name = nick_name
        # The unsettled amount.
        self.outstanding_amount = outstanding_amount
        # The ID of the member account. This parameter is returned in a multi-account payment scenario.
        self.owner_id = owner_id
        # The amount paid in cash.
        self.payment_amount = payment_amount
        # The code of the service. The service code is the same as that displayed in User Center.
        self.pip_code = pip_code
        # The pretax amount.
        self.pretax_amount = pretax_amount
        # The pretax gross amount.
        self.pretax_gross_amount = pretax_gross_amount
        # The code of the service.
        self.product_code = product_code
        # The details of the service.
        self.product_detail = product_detail
        # The name of the service.
        self.product_name = product_name
        # The type of the service.
        self.product_type = product_type
        # The region.
        self.region = region
        # The resource group.
        self.resource_group = resource_group
        # The validity period.
        self.service_period = service_period
        # The unit of the validity period.
        self.service_period_unit = service_period_unit
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        # 
        # **\
        # 
        # ****This parameter is returned together with the ProductCode parameter.
        self.subscription_type = subscription_type
        # The tag.
        self.tag = tag
        # The usage of the billable item. This parameter is returned only if the isBillingItem parameter is set to true.
        self.usage = usage
        # The unit of usage. This parameter is returned only if the isBillingItem parameter is set to true.
        self.usage_unit = usage_unit
        # The ID of the zone.
        self.zone = zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_amount is not None:
            result['AdjustAmount'] = self.adjust_amount
        if self.billing_date is not None:
            result['BillingDate'] = self.billing_date
        if self.billing_item is not None:
            result['BillingItem'] = self.billing_item
        if self.billing_type is not None:
            result['BillingType'] = self.billing_type
        if self.cash_amount is not None:
            result['CashAmount'] = self.cash_amount
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.cost_unit is not None:
            result['CostUnit'] = self.cost_unit
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.deducted_by_resource_package is not None:
            result['DeductedByResourcePackage'] = self.deducted_by_resource_package
        if self.instance_config is not None:
            result['InstanceConfig'] = self.instance_config
        if self.instance_id is not None:
            result['InstanceID'] = self.instance_id
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.internet_ip is not None:
            result['InternetIP'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIP'] = self.intranet_ip
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.item is not None:
            result['Item'] = self.item
        if self.list_price is not None:
            result['ListPrice'] = self.list_price
        if self.list_price_unit is not None:
            result['ListPriceUnit'] = self.list_price_unit
        if self.nick_name is not None:
            result['NickName'] = self.nick_name
        if self.outstanding_amount is not None:
            result['OutstandingAmount'] = self.outstanding_amount
        if self.owner_id is not None:
            result['OwnerID'] = self.owner_id
        if self.payment_amount is not None:
            result['PaymentAmount'] = self.payment_amount
        if self.pip_code is not None:
            result['PipCode'] = self.pip_code
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_group is not None:
            result['ResourceGroup'] = self.resource_group
        if self.service_period is not None:
            result['ServicePeriod'] = self.service_period
        if self.service_period_unit is not None:
            result['ServicePeriodUnit'] = self.service_period_unit
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.usage is not None:
            result['Usage'] = self.usage
        if self.usage_unit is not None:
            result['UsageUnit'] = self.usage_unit
        if self.zone is not None:
            result['Zone'] = self.zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjustAmount') is not None:
            self.adjust_amount = m.get('AdjustAmount')
        if m.get('BillingDate') is not None:
            self.billing_date = m.get('BillingDate')
        if m.get('BillingItem') is not None:
            self.billing_item = m.get('BillingItem')
        if m.get('BillingType') is not None:
            self.billing_type = m.get('BillingType')
        if m.get('CashAmount') is not None:
            self.cash_amount = m.get('CashAmount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CostUnit') is not None:
            self.cost_unit = m.get('CostUnit')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('DeductedByResourcePackage') is not None:
            self.deducted_by_resource_package = m.get('DeductedByResourcePackage')
        if m.get('InstanceConfig') is not None:
            self.instance_config = m.get('InstanceConfig')
        if m.get('InstanceID') is not None:
            self.instance_id = m.get('InstanceID')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('InternetIP') is not None:
            self.internet_ip = m.get('InternetIP')
        if m.get('IntranetIP') is not None:
            self.intranet_ip = m.get('IntranetIP')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('ListPrice') is not None:
            self.list_price = m.get('ListPrice')
        if m.get('ListPriceUnit') is not None:
            self.list_price_unit = m.get('ListPriceUnit')
        if m.get('NickName') is not None:
            self.nick_name = m.get('NickName')
        if m.get('OutstandingAmount') is not None:
            self.outstanding_amount = m.get('OutstandingAmount')
        if m.get('OwnerID') is not None:
            self.owner_id = m.get('OwnerID')
        if m.get('PaymentAmount') is not None:
            self.payment_amount = m.get('PaymentAmount')
        if m.get('PipCode') is not None:
            self.pip_code = m.get('PipCode')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceGroup') is not None:
            self.resource_group = m.get('ResourceGroup')
        if m.get('ServicePeriod') is not None:
            self.service_period = m.get('ServicePeriod')
        if m.get('ServicePeriodUnit') is not None:
            self.service_period_unit = m.get('ServicePeriodUnit')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Usage') is not None:
            self.usage = m.get('Usage')
        if m.get('UsageUnit') is not None:
            self.usage_unit = m.get('UsageUnit')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        return self


class QueryInstanceBillResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        item: List[QueryInstanceBillResponseBodyDataItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = QueryInstanceBillResponseBodyDataItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class QueryInstanceBillResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        billing_cycle: str = None,
        items: QueryInstanceBillResponseBodyDataItems = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The ID of the account.
        self.account_id = account_id
        # The name of the account.
        self.account_name = account_name
        # The billing cycle in the YYYY-MM format.
        self.billing_cycle = billing_cycle
        # The details of the bill.
        self.items = items
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('Items') is not None:
            temp_model = QueryInstanceBillResponseBodyDataItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryInstanceBillResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryInstanceBillResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryInstanceBillResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryInstanceBillResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryInstanceBillResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryInstanceBillResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryInstanceByTagRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key.
        self.key = key
        # The tag value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QueryInstanceByTagRequest(TeaModel):
    def __init__(
        self,
        resource_id: List[str] = None,
        resource_type: str = None,
        tag: List[QueryInstanceByTagRequestTag] = None,
    ):
        # The IDs of resources.
        self.resource_id = resource_id
        # The type of the resource. Specify the savings plan instance as the type of the resource.
        self.resource_type = resource_type
        # The tags.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QueryInstanceByTagRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class QueryInstanceByTagResponseBodyTagResourceTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key.
        self.key = key
        # The tag value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QueryInstanceByTagResponseBodyTagResource(TeaModel):
    def __init__(
        self,
        resource_id: str = None,
        resource_type: str = None,
        tag: List[QueryInstanceByTagResponseBodyTagResourceTag] = None,
    ):
        # The ID of the resource.
        self.resource_id = resource_id
        # The type of the resource. The returned resource type indicates a savings plan instance.
        self.resource_type = resource_type
        # The tags.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QueryInstanceByTagResponseBodyTagResourceTag()
                self.tag.append(temp_model.from_map(k))
        return self


class QueryInstanceByTagResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        next_token: str = None,
        request_id: str = None,
        success: bool = None,
        tag_resource: List[QueryInstanceByTagResponseBodyTagResource] = None,
    ):
        # The status code returned.
        self.code = code
        # The error message returned.
        self.message = message
        # The token that determines the start point of the query. The return value is the value of the NextToken response parameter that was returned last time the QueryInstanceByTag operation was called.
        self.next_token = next_token
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success
        # The instances returned.
        self.tag_resource = tag_resource

    def validate(self):
        if self.tag_resource:
            for k in self.tag_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        result['TagResource'] = []
        if self.tag_resource is not None:
            for k in self.tag_resource:
                result['TagResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        self.tag_resource = []
        if m.get('TagResource') is not None:
            for k in m.get('TagResource'):
                temp_model = QueryInstanceByTagResponseBodyTagResource()
                self.tag_resource.append(temp_model.from_map(k))
        return self


class QueryInstanceByTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryInstanceByTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryInstanceByTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryInstanceGaapCostRequest(TeaModel):
    def __init__(
        self,
        billing_cycle: str = None,
        page_num: int = None,
        page_size: int = None,
        product_code: str = None,
        product_type: str = None,
        subscription_type: str = None,
    ):
        # The billing cycle. Format: YYYY-MM.
        self.billing_cycle = billing_cycle
        # The number of the page to return. Default value: 1.
        self.page_num = page_num
        # The number of entries to return on each page. Default value: 20. Maximum value: 100.
        self.page_size = page_size
        # The code of the service.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class QueryInstanceGaapCostResponseBodyDataModulesModule(TeaModel):
    def __init__(
        self,
        accounting_unit: str = None,
        bill_type: str = None,
        billing_cycle: str = None,
        currency: str = None,
        deducted_by_cash_coupons: str = None,
        deducted_by_coupons: str = None,
        deducted_by_prepaid_card: str = None,
        gaap_deducted_by_cash_coupons: str = None,
        gaap_deducted_by_coupons: str = None,
        gaap_deducted_by_prepaid_card: str = None,
        gaap_payment_amount: str = None,
        gaap_pretax_amount: str = None,
        gaap_pretax_amount_local: str = None,
        gaap_pretax_gross_amount: str = None,
        gaap_pricing_discount: str = None,
        instance_id: str = None,
        month_gaap_deducted_by_cash_coupons: str = None,
        month_gaap_deducted_by_coupons: str = None,
        month_gaap_deducted_by_prepaid_card: str = None,
        month_gaap_payment_amount: str = None,
        month_gaap_pretax_amount: str = None,
        month_gaap_pretax_amount_local: str = None,
        month_gaap_pretax_gross_amount: str = None,
        month_gaap_pricing_discount: str = None,
        order_id: str = None,
        order_type: str = None,
        owner_id: str = None,
        pay_time: str = None,
        payer_account: str = None,
        payment_amount: str = None,
        payment_currency: str = None,
        pretax_amount: str = None,
        pretax_amount_local: str = None,
        pretax_gross_amount: str = None,
        pricing_discount: str = None,
        product_code: str = None,
        product_type: str = None,
        region: str = None,
        resource_group: str = None,
        sub_order_id: str = None,
        subscription_type: str = None,
        tag: str = None,
        unallocated_deducted_by_cash_coupons: str = None,
        unallocated_deducted_by_coupons: str = None,
        unallocated_deducted_by_prepaid_card: str = None,
        unallocated_payment_amount: str = None,
        unallocated_pretax_amount: str = None,
        unallocated_pretax_amount_local: str = None,
        unallocated_pretax_gross_amount: str = None,
        unallocated_pricing_discount: str = None,
        usage_end_date: str = None,
        usage_start_date: str = None,
    ):
        # The accounting unit. This parameter is reserved and unavailable now.
        self.accounting_unit = accounting_unit
        # The type of the bill. Valid values:
        # 
        # *   SubscriptionOrder: subscription order
        # *   PayAsYouGoBill: pay-as-you-go bill
        # *   Refund: refund
        # *   Adjustment: reconciliation
        self.bill_type = bill_type
        # The billing cycle, in the YYYY-MM format.
        self.billing_cycle = billing_cycle
        # The type of the currency. Valid values:
        # 
        # *   CNY
        # *   USD
        # *   JPY
        self.currency = currency
        # The amount deducted by using vouchers.
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        # The amount deducted by using coupons.
        self.deducted_by_coupons = deducted_by_coupons
        # The amount deducted by using prepaid cards.
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        # The allocated amount deducted by using vouchers.
        self.gaap_deducted_by_cash_coupons = gaap_deducted_by_cash_coupons
        # The allocated amount deducted by using coupons.
        self.gaap_deducted_by_coupons = gaap_deducted_by_coupons
        # The allocated amount deducted by using prepaid cards.
        self.gaap_deducted_by_prepaid_card = gaap_deducted_by_prepaid_card
        # The allocated amount paid in cash.
        self.gaap_payment_amount = gaap_payment_amount
        # The allocated pretax amount.
        self.gaap_pretax_amount = gaap_pretax_amount
        # The allocated pretax amount paid with the local currency.
        self.gaap_pretax_amount_local = gaap_pretax_amount_local
        # The allocated pretax gross amount.
        self.gaap_pretax_gross_amount = gaap_pretax_gross_amount
        # The allocated pricing discount.
        self.gaap_pricing_discount = gaap_pricing_discount
        # The ID of the instance.
        self.instance_id = instance_id
        # The amount deducted by using vouchers and allocated to the current month.
        self.month_gaap_deducted_by_cash_coupons = month_gaap_deducted_by_cash_coupons
        # The amount deducted by using coupons and allocated to the current month.
        self.month_gaap_deducted_by_coupons = month_gaap_deducted_by_coupons
        # The amount deducted by using prepaid cards and allocated to the current month.
        self.month_gaap_deducted_by_prepaid_card = month_gaap_deducted_by_prepaid_card
        # The amount paid in cash and allocated to the current month.
        self.month_gaap_payment_amount = month_gaap_payment_amount
        # The pretax amount allocated to the current month.
        self.month_gaap_pretax_amount = month_gaap_pretax_amount
        # The pretax amount paid with the local currency and allocated to the current month (Alibaba Cloud International site).
        self.month_gaap_pretax_amount_local = month_gaap_pretax_amount_local
        # The pretax gross amount allocated to the current month.
        self.month_gaap_pretax_gross_amount = month_gaap_pretax_gross_amount
        # The pricing discount allocated to the current month.
        self.month_gaap_pricing_discount = month_gaap_pricing_discount
        # The ID of the order.
        self.order_id = order_id
        # The type of the order. Valid values:
        # 
        # *   New
        # *   Renewal
        # *   Upgrade
        # *   Degrade
        self.order_type = order_type
        # The ID of the bill owner.
        self.owner_id = owner_id
        # The time when the bill was paid.
        self.pay_time = pay_time
        # The account of the payer.
        self.payer_account = payer_account
        # The amount paid in cash.
        self.payment_amount = payment_amount
        # The type of the currency (Alibaba Cloud International site).
        self.payment_currency = payment_currency
        # The pretax amount.
        self.pretax_amount = pretax_amount
        # The allocated pretax amount paid with the local currency (Alibaba Cloud International site).
        self.pretax_amount_local = pretax_amount_local
        # The pretax gross amount.
        self.pretax_gross_amount = pretax_gross_amount
        # The pricing discount.
        self.pricing_discount = pricing_discount
        # The code of the service.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type
        # The ID of the region.
        self.region = region
        # The resource group.
        self.resource_group = resource_group
        # The ID of the sub-order.
        self.sub_order_id = sub_order_id
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        self.subscription_type = subscription_type
        # The tag.
        self.tag = tag
        # The unallocated amount deducted by using vouchers.
        self.unallocated_deducted_by_cash_coupons = unallocated_deducted_by_cash_coupons
        # The unallocated amount deducted by using coupons.
        self.unallocated_deducted_by_coupons = unallocated_deducted_by_coupons
        # The unallocated amount deducted by using prepaid cards.
        self.unallocated_deducted_by_prepaid_card = unallocated_deducted_by_prepaid_card
        # The unallocated amount paid in cash.
        self.unallocated_payment_amount = unallocated_payment_amount
        # The unallocated pretax amount.
        self.unallocated_pretax_amount = unallocated_pretax_amount
        # The unallocated pretax amount paid with the local currency.
        self.unallocated_pretax_amount_local = unallocated_pretax_amount_local
        # The unallocated pretax gross amount.
        self.unallocated_pretax_gross_amount = unallocated_pretax_gross_amount
        # The unallocated pricing discount.
        self.unallocated_pricing_discount = unallocated_pricing_discount
        # The time when the service usage ended.
        self.usage_end_date = usage_end_date
        # The time when the service usage started.
        self.usage_start_date = usage_start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accounting_unit is not None:
            result['AccountingUnit'] = self.accounting_unit
        if self.bill_type is not None:
            result['BillType'] = self.bill_type
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.gaap_deducted_by_cash_coupons is not None:
            result['GaapDeductedByCashCoupons'] = self.gaap_deducted_by_cash_coupons
        if self.gaap_deducted_by_coupons is not None:
            result['GaapDeductedByCoupons'] = self.gaap_deducted_by_coupons
        if self.gaap_deducted_by_prepaid_card is not None:
            result['GaapDeductedByPrepaidCard'] = self.gaap_deducted_by_prepaid_card
        if self.gaap_payment_amount is not None:
            result['GaapPaymentAmount'] = self.gaap_payment_amount
        if self.gaap_pretax_amount is not None:
            result['GaapPretaxAmount'] = self.gaap_pretax_amount
        if self.gaap_pretax_amount_local is not None:
            result['GaapPretaxAmountLocal'] = self.gaap_pretax_amount_local
        if self.gaap_pretax_gross_amount is not None:
            result['GaapPretaxGrossAmount'] = self.gaap_pretax_gross_amount
        if self.gaap_pricing_discount is not None:
            result['GaapPricingDiscount'] = self.gaap_pricing_discount
        if self.instance_id is not None:
            result['InstanceID'] = self.instance_id
        if self.month_gaap_deducted_by_cash_coupons is not None:
            result['MonthGaapDeductedByCashCoupons'] = self.month_gaap_deducted_by_cash_coupons
        if self.month_gaap_deducted_by_coupons is not None:
            result['MonthGaapDeductedByCoupons'] = self.month_gaap_deducted_by_coupons
        if self.month_gaap_deducted_by_prepaid_card is not None:
            result['MonthGaapDeductedByPrepaidCard'] = self.month_gaap_deducted_by_prepaid_card
        if self.month_gaap_payment_amount is not None:
            result['MonthGaapPaymentAmount'] = self.month_gaap_payment_amount
        if self.month_gaap_pretax_amount is not None:
            result['MonthGaapPretaxAmount'] = self.month_gaap_pretax_amount
        if self.month_gaap_pretax_amount_local is not None:
            result['MonthGaapPretaxAmountLocal'] = self.month_gaap_pretax_amount_local
        if self.month_gaap_pretax_gross_amount is not None:
            result['MonthGaapPretaxGrossAmount'] = self.month_gaap_pretax_gross_amount
        if self.month_gaap_pricing_discount is not None:
            result['MonthGaapPricingDiscount'] = self.month_gaap_pricing_discount
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.owner_id is not None:
            result['OwnerID'] = self.owner_id
        if self.pay_time is not None:
            result['PayTime'] = self.pay_time
        if self.payer_account is not None:
            result['PayerAccount'] = self.payer_account
        if self.payment_amount is not None:
            result['PaymentAmount'] = self.payment_amount
        if self.payment_currency is not None:
            result['PaymentCurrency'] = self.payment_currency
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_amount_local is not None:
            result['PretaxAmountLocal'] = self.pretax_amount_local
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.pricing_discount is not None:
            result['PricingDiscount'] = self.pricing_discount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region is not None:
            result['Region'] = self.region
        if self.resource_group is not None:
            result['ResourceGroup'] = self.resource_group
        if self.sub_order_id is not None:
            result['SubOrderId'] = self.sub_order_id
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.unallocated_deducted_by_cash_coupons is not None:
            result['UnallocatedDeductedByCashCoupons'] = self.unallocated_deducted_by_cash_coupons
        if self.unallocated_deducted_by_coupons is not None:
            result['UnallocatedDeductedByCoupons'] = self.unallocated_deducted_by_coupons
        if self.unallocated_deducted_by_prepaid_card is not None:
            result['UnallocatedDeductedByPrepaidCard'] = self.unallocated_deducted_by_prepaid_card
        if self.unallocated_payment_amount is not None:
            result['UnallocatedPaymentAmount'] = self.unallocated_payment_amount
        if self.unallocated_pretax_amount is not None:
            result['UnallocatedPretaxAmount'] = self.unallocated_pretax_amount
        if self.unallocated_pretax_amount_local is not None:
            result['UnallocatedPretaxAmountLocal'] = self.unallocated_pretax_amount_local
        if self.unallocated_pretax_gross_amount is not None:
            result['UnallocatedPretaxGrossAmount'] = self.unallocated_pretax_gross_amount
        if self.unallocated_pricing_discount is not None:
            result['UnallocatedPricingDiscount'] = self.unallocated_pricing_discount
        if self.usage_end_date is not None:
            result['UsageEndDate'] = self.usage_end_date
        if self.usage_start_date is not None:
            result['UsageStartDate'] = self.usage_start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountingUnit') is not None:
            self.accounting_unit = m.get('AccountingUnit')
        if m.get('BillType') is not None:
            self.bill_type = m.get('BillType')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('GaapDeductedByCashCoupons') is not None:
            self.gaap_deducted_by_cash_coupons = m.get('GaapDeductedByCashCoupons')
        if m.get('GaapDeductedByCoupons') is not None:
            self.gaap_deducted_by_coupons = m.get('GaapDeductedByCoupons')
        if m.get('GaapDeductedByPrepaidCard') is not None:
            self.gaap_deducted_by_prepaid_card = m.get('GaapDeductedByPrepaidCard')
        if m.get('GaapPaymentAmount') is not None:
            self.gaap_payment_amount = m.get('GaapPaymentAmount')
        if m.get('GaapPretaxAmount') is not None:
            self.gaap_pretax_amount = m.get('GaapPretaxAmount')
        if m.get('GaapPretaxAmountLocal') is not None:
            self.gaap_pretax_amount_local = m.get('GaapPretaxAmountLocal')
        if m.get('GaapPretaxGrossAmount') is not None:
            self.gaap_pretax_gross_amount = m.get('GaapPretaxGrossAmount')
        if m.get('GaapPricingDiscount') is not None:
            self.gaap_pricing_discount = m.get('GaapPricingDiscount')
        if m.get('InstanceID') is not None:
            self.instance_id = m.get('InstanceID')
        if m.get('MonthGaapDeductedByCashCoupons') is not None:
            self.month_gaap_deducted_by_cash_coupons = m.get('MonthGaapDeductedByCashCoupons')
        if m.get('MonthGaapDeductedByCoupons') is not None:
            self.month_gaap_deducted_by_coupons = m.get('MonthGaapDeductedByCoupons')
        if m.get('MonthGaapDeductedByPrepaidCard') is not None:
            self.month_gaap_deducted_by_prepaid_card = m.get('MonthGaapDeductedByPrepaidCard')
        if m.get('MonthGaapPaymentAmount') is not None:
            self.month_gaap_payment_amount = m.get('MonthGaapPaymentAmount')
        if m.get('MonthGaapPretaxAmount') is not None:
            self.month_gaap_pretax_amount = m.get('MonthGaapPretaxAmount')
        if m.get('MonthGaapPretaxAmountLocal') is not None:
            self.month_gaap_pretax_amount_local = m.get('MonthGaapPretaxAmountLocal')
        if m.get('MonthGaapPretaxGrossAmount') is not None:
            self.month_gaap_pretax_gross_amount = m.get('MonthGaapPretaxGrossAmount')
        if m.get('MonthGaapPricingDiscount') is not None:
            self.month_gaap_pricing_discount = m.get('MonthGaapPricingDiscount')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('OwnerID') is not None:
            self.owner_id = m.get('OwnerID')
        if m.get('PayTime') is not None:
            self.pay_time = m.get('PayTime')
        if m.get('PayerAccount') is not None:
            self.payer_account = m.get('PayerAccount')
        if m.get('PaymentAmount') is not None:
            self.payment_amount = m.get('PaymentAmount')
        if m.get('PaymentCurrency') is not None:
            self.payment_currency = m.get('PaymentCurrency')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxAmountLocal') is not None:
            self.pretax_amount_local = m.get('PretaxAmountLocal')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('PricingDiscount') is not None:
            self.pricing_discount = m.get('PricingDiscount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('ResourceGroup') is not None:
            self.resource_group = m.get('ResourceGroup')
        if m.get('SubOrderId') is not None:
            self.sub_order_id = m.get('SubOrderId')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('UnallocatedDeductedByCashCoupons') is not None:
            self.unallocated_deducted_by_cash_coupons = m.get('UnallocatedDeductedByCashCoupons')
        if m.get('UnallocatedDeductedByCoupons') is not None:
            self.unallocated_deducted_by_coupons = m.get('UnallocatedDeductedByCoupons')
        if m.get('UnallocatedDeductedByPrepaidCard') is not None:
            self.unallocated_deducted_by_prepaid_card = m.get('UnallocatedDeductedByPrepaidCard')
        if m.get('UnallocatedPaymentAmount') is not None:
            self.unallocated_payment_amount = m.get('UnallocatedPaymentAmount')
        if m.get('UnallocatedPretaxAmount') is not None:
            self.unallocated_pretax_amount = m.get('UnallocatedPretaxAmount')
        if m.get('UnallocatedPretaxAmountLocal') is not None:
            self.unallocated_pretax_amount_local = m.get('UnallocatedPretaxAmountLocal')
        if m.get('UnallocatedPretaxGrossAmount') is not None:
            self.unallocated_pretax_gross_amount = m.get('UnallocatedPretaxGrossAmount')
        if m.get('UnallocatedPricingDiscount') is not None:
            self.unallocated_pricing_discount = m.get('UnallocatedPricingDiscount')
        if m.get('UsageEndDate') is not None:
            self.usage_end_date = m.get('UsageEndDate')
        if m.get('UsageStartDate') is not None:
            self.usage_start_date = m.get('UsageStartDate')
        return self


class QueryInstanceGaapCostResponseBodyDataModules(TeaModel):
    def __init__(
        self,
        module: List[QueryInstanceGaapCostResponseBodyDataModulesModule] = None,
    ):
        self.module = module

    def validate(self):
        if self.module:
            for k in self.module:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Module'] = []
        if self.module is not None:
            for k in self.module:
                result['Module'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.module = []
        if m.get('Module') is not None:
            for k in m.get('Module'):
                temp_model = QueryInstanceGaapCostResponseBodyDataModulesModule()
                self.module.append(temp_model.from_map(k))
        return self


class QueryInstanceGaapCostResponseBodyData(TeaModel):
    def __init__(
        self,
        host_id: str = None,
        modules: QueryInstanceGaapCostResponseBodyDataModules = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The ID of the host.
        self.host_id = host_id
        # The billing information.
        self.modules = modules
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.modules:
            self.modules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.modules is not None:
            result['Modules'] = self.modules.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('Modules') is not None:
            temp_model = QueryInstanceGaapCostResponseBodyDataModules()
            self.modules = temp_model.from_map(m['Modules'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryInstanceGaapCostResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryInstanceGaapCostResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryInstanceGaapCostResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryInstanceGaapCostResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryInstanceGaapCostResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryInstanceGaapCostResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryInvoicingCustomerListRequest(TeaModel):
    def __init__(
        self,
        owner_id: int = None,
    ):
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class QueryInvoicingCustomerListResponseBodyDataCustomerInvoiceListCustomerInvoice(TeaModel):
    def __init__(
        self,
        adjust_type: int = None,
        bank: str = None,
        bank_no: str = None,
        customer_type: int = None,
        default_remark: str = None,
        end_cycle: int = None,
        gmt_create: str = None,
        id: int = None,
        invoice_title: str = None,
        issue_type: int = None,
        operating_license_address: str = None,
        operating_license_phone: str = None,
        register_no: str = None,
        start_cycle: int = None,
        status: int = None,
        taxation_license: str = None,
        taxpayer_type: int = None,
        title_change_instructions: str = None,
        type: int = None,
        user_id: int = None,
        user_nick: str = None,
    ):
        # The type of invoice that was changed to.
        self.adjust_type = adjust_type
        # The bank that issues the invoice.
        self.bank = bank
        # The bank account number.
        self.bank_no = bank_no
        # The authentication type of Alipay. Valid values:
        # 
        # *   1: individual
        # *   2: company
        self.customer_type = customer_type
        # The default note that is attached when the title is specified.
        self.default_remark = default_remark
        # The time when the payment ended.
        self.end_cycle = end_cycle
        # The time when the invoice was created. The time was in the yyyy-mm-dd hh:mm:ss format.
        self.gmt_create = gmt_create
        # The ID of the invoice.
        self.id = id
        # The company name in the invoice title.
        self.invoice_title = invoice_title
        # The type of issue.
        self.issue_type = issue_type
        # The address of the business license.
        self.operating_license_address = operating_license_address
        # The phone number of the business license.
        self.operating_license_phone = operating_license_phone
        # The tax registration number.
        self.register_no = register_no
        # The time when the payment started.
        self.start_cycle = start_cycle
        # The status of the invoice title.
        self.status = status
        # The path and file name of the scanned copy of the tax registration certificate.
        self.taxation_license = taxation_license
        # The type of the taxpayer. Valid values:
        # 
        # *   1: general taxpayer
        # *   2: special taxpayer
        self.taxpayer_type = taxpayer_type
        # The instruction document of the invoice title change.
        self.title_change_instructions = title_change_instructions
        # The type of the invoice. Valid values:
        # 
        # *   0: plain value-added tax (VAT) invoice
        # *   1: special VAT invoice
        self.type = type
        # The ID of the user.
        self.user_id = user_id
        # The nickname of the user.
        self.user_nick = user_nick

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_type is not None:
            result['AdjustType'] = self.adjust_type
        if self.bank is not None:
            result['Bank'] = self.bank
        if self.bank_no is not None:
            result['BankNo'] = self.bank_no
        if self.customer_type is not None:
            result['CustomerType'] = self.customer_type
        if self.default_remark is not None:
            result['DefaultRemark'] = self.default_remark
        if self.end_cycle is not None:
            result['EndCycle'] = self.end_cycle
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.invoice_title is not None:
            result['InvoiceTitle'] = self.invoice_title
        if self.issue_type is not None:
            result['IssueType'] = self.issue_type
        if self.operating_license_address is not None:
            result['OperatingLicenseAddress'] = self.operating_license_address
        if self.operating_license_phone is not None:
            result['OperatingLicensePhone'] = self.operating_license_phone
        if self.register_no is not None:
            result['RegisterNo'] = self.register_no
        if self.start_cycle is not None:
            result['StartCycle'] = self.start_cycle
        if self.status is not None:
            result['Status'] = self.status
        if self.taxation_license is not None:
            result['TaxationLicense'] = self.taxation_license
        if self.taxpayer_type is not None:
            result['TaxpayerType'] = self.taxpayer_type
        if self.title_change_instructions is not None:
            result['TitleChangeInstructions'] = self.title_change_instructions
        if self.type is not None:
            result['Type'] = self.type
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.user_nick is not None:
            result['UserNick'] = self.user_nick
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjustType') is not None:
            self.adjust_type = m.get('AdjustType')
        if m.get('Bank') is not None:
            self.bank = m.get('Bank')
        if m.get('BankNo') is not None:
            self.bank_no = m.get('BankNo')
        if m.get('CustomerType') is not None:
            self.customer_type = m.get('CustomerType')
        if m.get('DefaultRemark') is not None:
            self.default_remark = m.get('DefaultRemark')
        if m.get('EndCycle') is not None:
            self.end_cycle = m.get('EndCycle')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InvoiceTitle') is not None:
            self.invoice_title = m.get('InvoiceTitle')
        if m.get('IssueType') is not None:
            self.issue_type = m.get('IssueType')
        if m.get('OperatingLicenseAddress') is not None:
            self.operating_license_address = m.get('OperatingLicenseAddress')
        if m.get('OperatingLicensePhone') is not None:
            self.operating_license_phone = m.get('OperatingLicensePhone')
        if m.get('RegisterNo') is not None:
            self.register_no = m.get('RegisterNo')
        if m.get('StartCycle') is not None:
            self.start_cycle = m.get('StartCycle')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaxationLicense') is not None:
            self.taxation_license = m.get('TaxationLicense')
        if m.get('TaxpayerType') is not None:
            self.taxpayer_type = m.get('TaxpayerType')
        if m.get('TitleChangeInstructions') is not None:
            self.title_change_instructions = m.get('TitleChangeInstructions')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('UserNick') is not None:
            self.user_nick = m.get('UserNick')
        return self


class QueryInvoicingCustomerListResponseBodyDataCustomerInvoiceList(TeaModel):
    def __init__(
        self,
        customer_invoice: List[QueryInvoicingCustomerListResponseBodyDataCustomerInvoiceListCustomerInvoice] = None,
    ):
        self.customer_invoice = customer_invoice

    def validate(self):
        if self.customer_invoice:
            for k in self.customer_invoice:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomerInvoice'] = []
        if self.customer_invoice is not None:
            for k in self.customer_invoice:
                result['CustomerInvoice'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.customer_invoice = []
        if m.get('CustomerInvoice') is not None:
            for k in m.get('CustomerInvoice'):
                temp_model = QueryInvoicingCustomerListResponseBodyDataCustomerInvoiceListCustomerInvoice()
                self.customer_invoice.append(temp_model.from_map(k))
        return self


class QueryInvoicingCustomerListResponseBodyData(TeaModel):
    def __init__(
        self,
        customer_invoice_list: QueryInvoicingCustomerListResponseBodyDataCustomerInvoiceList = None,
    ):
        # The information about the invoice.
        self.customer_invoice_list = customer_invoice_list

    def validate(self):
        if self.customer_invoice_list:
            self.customer_invoice_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customer_invoice_list is not None:
            result['CustomerInvoiceList'] = self.customer_invoice_list.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomerInvoiceList') is not None:
            temp_model = QueryInvoicingCustomerListResponseBodyDataCustomerInvoiceList()
            self.customer_invoice_list = temp_model.from_map(m['CustomerInvoiceList'])
        return self


class QueryInvoicingCustomerListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryInvoicingCustomerListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The error message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryInvoicingCustomerListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryInvoicingCustomerListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryInvoicingCustomerListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryInvoicingCustomerListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryOrdersRequest(TeaModel):
    def __init__(
        self,
        create_time_end: str = None,
        create_time_start: str = None,
        order_type: str = None,
        owner_id: int = None,
        page_num: int = None,
        page_size: int = None,
        payment_status: str = None,
        product_code: str = None,
        product_type: str = None,
        subscription_type: str = None,
    ):
        self.create_time_end = create_time_end
        self.create_time_start = create_time_start
        self.order_type = order_type
        self.owner_id = owner_id
        self.page_num = page_num
        self.page_size = page_size
        self.payment_status = payment_status
        self.product_code = product_code
        self.product_type = product_type
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.payment_status is not None:
            result['PaymentStatus'] = self.payment_status
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PaymentStatus') is not None:
            self.payment_status = m.get('PaymentStatus')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class QueryOrdersResponseBodyDataOrderListOrder(TeaModel):
    def __init__(
        self,
        after_tax_amount: str = None,
        commodity_code: str = None,
        create_time: str = None,
        currency: str = None,
        order_id: str = None,
        order_type: str = None,
        payment_currency: str = None,
        payment_status: str = None,
        payment_time: str = None,
        pretax_amount: str = None,
        pretax_amount_local: str = None,
        pretax_gross_amount: str = None,
        product_code: str = None,
        product_type: str = None,
        related_order_id: str = None,
        subscription_type: str = None,
        tax: str = None,
    ):
        self.after_tax_amount = after_tax_amount
        self.commodity_code = commodity_code
        self.create_time = create_time
        self.currency = currency
        self.order_id = order_id
        self.order_type = order_type
        self.payment_currency = payment_currency
        self.payment_status = payment_status
        self.payment_time = payment_time
        self.pretax_amount = pretax_amount
        self.pretax_amount_local = pretax_amount_local
        self.pretax_gross_amount = pretax_gross_amount
        self.product_code = product_code
        self.product_type = product_type
        self.related_order_id = related_order_id
        self.subscription_type = subscription_type
        self.tax = tax

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.after_tax_amount is not None:
            result['AfterTaxAmount'] = self.after_tax_amount
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.payment_currency is not None:
            result['PaymentCurrency'] = self.payment_currency
        if self.payment_status is not None:
            result['PaymentStatus'] = self.payment_status
        if self.payment_time is not None:
            result['PaymentTime'] = self.payment_time
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_amount_local is not None:
            result['PretaxAmountLocal'] = self.pretax_amount_local
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.related_order_id is not None:
            result['RelatedOrderId'] = self.related_order_id
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tax is not None:
            result['Tax'] = self.tax
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AfterTaxAmount') is not None:
            self.after_tax_amount = m.get('AfterTaxAmount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('PaymentCurrency') is not None:
            self.payment_currency = m.get('PaymentCurrency')
        if m.get('PaymentStatus') is not None:
            self.payment_status = m.get('PaymentStatus')
        if m.get('PaymentTime') is not None:
            self.payment_time = m.get('PaymentTime')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxAmountLocal') is not None:
            self.pretax_amount_local = m.get('PretaxAmountLocal')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RelatedOrderId') is not None:
            self.related_order_id = m.get('RelatedOrderId')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tax') is not None:
            self.tax = m.get('Tax')
        return self


class QueryOrdersResponseBodyDataOrderList(TeaModel):
    def __init__(
        self,
        order: List[QueryOrdersResponseBodyDataOrderListOrder] = None,
    ):
        self.order = order

    def validate(self):
        if self.order:
            for k in self.order:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Order'] = []
        if self.order is not None:
            for k in self.order:
                result['Order'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.order = []
        if m.get('Order') is not None:
            for k in m.get('Order'):
                temp_model = QueryOrdersResponseBodyDataOrderListOrder()
                self.order.append(temp_model.from_map(k))
        return self


class QueryOrdersResponseBodyData(TeaModel):
    def __init__(
        self,
        host_name: str = None,
        order_list: QueryOrdersResponseBodyDataOrderList = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.host_name = host_name
        self.order_list = order_list
        self.page_num = page_num
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.order_list:
            self.order_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.order_list is not None:
            result['OrderList'] = self.order_list.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('OrderList') is not None:
            temp_model = QueryOrdersResponseBodyDataOrderList()
            self.order_list = temp_model.from_map(m['OrderList'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryOrdersResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryOrdersResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryOrdersResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryOrdersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryOrdersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryOrdersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryPermissionListRequest(TeaModel):
    def __init__(
        self,
        relation_id: int = None,
    ):
        # The ID of the relationship. Set this parameter to the value of the RelationId response parameter returned by calling the QueryRelationList operation.
        self.relation_id = relation_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.relation_id is not None:
            result['RelationId'] = self.relation_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RelationId') is not None:
            self.relation_id = m.get('RelationId')
        return self


class QueryPermissionListResponseBodyDataPermissionList(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        permission_code: str = None,
        permission_name: str = None,
        start_time: str = None,
    ):
        # The time when the permission expired. If no value is returned, the permission is still valid. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC. For example, 2016-05-23T12:00:00Z indicates that the permission expired at 20:00:00 on May 23, 2016 (UTC+8).
        self.end_time = end_time
        # The code of the permission.
        self.permission_code = permission_code
        # The name of the permission.
        self.permission_name = permission_name
        # The time when the permission took effect. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC. For example, 2016-05-23T12:00:00Z indicates that the permission took effect at 20:00:00 on May 23, 2016 (UTC+8).
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.permission_code is not None:
            result['PermissionCode'] = self.permission_code
        if self.permission_name is not None:
            result['PermissionName'] = self.permission_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PermissionCode') is not None:
            self.permission_code = m.get('PermissionCode')
        if m.get('PermissionName') is not None:
            self.permission_name = m.get('PermissionName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QueryPermissionListResponseBodyData(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        master_id: int = None,
        member_id: int = None,
        permission_list: List[QueryPermissionListResponseBodyDataPermissionList] = None,
        relation_type: str = None,
        setup_time: str = None,
        start_time: str = None,
        state: str = None,
    ):
        # The time when the relationship expired. If no value is returned, the relationship is still valid.
        self.end_time = end_time
        # The ID of the management account.
        self.master_id = master_id
        # The ID of the member.
        self.member_id = member_id
        # The list of permissions.
        self.permission_list = permission_list
        # The type of the relationship. Valid values: FinancialManagement and FinancialTrusteeship.
        self.relation_type = relation_type
        # The time when the relationship was established. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC. For example, 2016-05-23T12:00:00Z indicates that the relationship was established at 20:00:00 on May 23, 2016 (UTC+8).
        self.setup_time = setup_time
        # The time when the relationship took effect. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC. For example, 2016-05-23T12:00:00Z indicates that the relationship took effect at 20:00:00 on May 23, 2016 (UTC+8).
        self.start_time = start_time
        # The status of the relationship. For more information about valid values of this parameter, see the enumeration values of the RelationshipStatusEnum type in the following table.
        self.state = state

    def validate(self):
        if self.permission_list:
            for k in self.permission_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.master_id is not None:
            result['MasterId'] = self.master_id
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        result['PermissionList'] = []
        if self.permission_list is not None:
            for k in self.permission_list:
                result['PermissionList'].append(k.to_map() if k else None)
        if self.relation_type is not None:
            result['RelationType'] = self.relation_type
        if self.setup_time is not None:
            result['SetupTime'] = self.setup_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MasterId') is not None:
            self.master_id = m.get('MasterId')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        self.permission_list = []
        if m.get('PermissionList') is not None:
            for k in m.get('PermissionList'):
                temp_model = QueryPermissionListResponseBodyDataPermissionList()
                self.permission_list.append(temp_model.from_map(k))
        if m.get('RelationType') is not None:
            self.relation_type = m.get('RelationType')
        if m.get('SetupTime') is not None:
            self.setup_time = m.get('SetupTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryPermissionListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryPermissionListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryPermissionListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryPermissionListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryPermissionListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryPermissionListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryPrepaidCardsRequest(TeaModel):
    def __init__(
        self,
        effective_or_not: bool = None,
        expiry_time_end: str = None,
        expiry_time_start: str = None,
    ):
        # Specifies whether the prepaid card takes effect. Valid values:
        # 
        # *   true
        # *   false
        self.effective_or_not = effective_or_not
        # The end of the expiration time of prepaid cards to query. The value must be in the yyyy-MM-ddTHH:mm:ssZ format.
        self.expiry_time_end = expiry_time_end
        # The start of the expiration time of prepaid cards to query. The value must be in the yyyy-MM-ddTHH:mm:ssZ format.
        self.expiry_time_start = expiry_time_start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effective_or_not is not None:
            result['EffectiveOrNot'] = self.effective_or_not
        if self.expiry_time_end is not None:
            result['ExpiryTimeEnd'] = self.expiry_time_end
        if self.expiry_time_start is not None:
            result['ExpiryTimeStart'] = self.expiry_time_start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EffectiveOrNot') is not None:
            self.effective_or_not = m.get('EffectiveOrNot')
        if m.get('ExpiryTimeEnd') is not None:
            self.expiry_time_end = m.get('ExpiryTimeEnd')
        if m.get('ExpiryTimeStart') is not None:
            self.expiry_time_start = m.get('ExpiryTimeStart')
        return self


class QueryPrepaidCardsResponseBodyDataPrepaidCard(TeaModel):
    def __init__(
        self,
        applicable_products: str = None,
        applicable_scenarios: str = None,
        balance: str = None,
        effective_time: str = None,
        expiry_time: str = None,
        granted_time: str = None,
        nominal_value: str = None,
        prepaid_card_id: int = None,
        prepaid_card_no: str = None,
        status: str = None,
    ):
        # The services to which the prepaid card is applicable.
        self.applicable_products = applicable_products
        # The scenario to which the prepaid card is applicable.
        self.applicable_scenarios = applicable_scenarios
        # The balance of the prepaid card.
        self.balance = balance
        # The time when the prepaid card took effect.
        self.effective_time = effective_time
        # The time when the prepaid card expired.
        self.expiry_time = expiry_time
        # The time when the prepaid card was issued.
        self.granted_time = granted_time
        # The nominal value of the prepaid card.
        self.nominal_value = nominal_value
        # The ID of the prepaid card.
        self.prepaid_card_id = prepaid_card_id
        # The number of the prepaid card.
        self.prepaid_card_no = prepaid_card_no
        # The status of the prepaid card. Valid values:
        # 
        # *   Available: The prepaid card is valid.
        # *   Expired: The prepaid card expired.
        # *   Cancelled: The prepaid card is invalid.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applicable_products is not None:
            result['ApplicableProducts'] = self.applicable_products
        if self.applicable_scenarios is not None:
            result['ApplicableScenarios'] = self.applicable_scenarios
        if self.balance is not None:
            result['Balance'] = self.balance
        if self.effective_time is not None:
            result['EffectiveTime'] = self.effective_time
        if self.expiry_time is not None:
            result['ExpiryTime'] = self.expiry_time
        if self.granted_time is not None:
            result['GrantedTime'] = self.granted_time
        if self.nominal_value is not None:
            result['NominalValue'] = self.nominal_value
        if self.prepaid_card_id is not None:
            result['PrepaidCardId'] = self.prepaid_card_id
        if self.prepaid_card_no is not None:
            result['PrepaidCardNo'] = self.prepaid_card_no
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicableProducts') is not None:
            self.applicable_products = m.get('ApplicableProducts')
        if m.get('ApplicableScenarios') is not None:
            self.applicable_scenarios = m.get('ApplicableScenarios')
        if m.get('Balance') is not None:
            self.balance = m.get('Balance')
        if m.get('EffectiveTime') is not None:
            self.effective_time = m.get('EffectiveTime')
        if m.get('ExpiryTime') is not None:
            self.expiry_time = m.get('ExpiryTime')
        if m.get('GrantedTime') is not None:
            self.granted_time = m.get('GrantedTime')
        if m.get('NominalValue') is not None:
            self.nominal_value = m.get('NominalValue')
        if m.get('PrepaidCardId') is not None:
            self.prepaid_card_id = m.get('PrepaidCardId')
        if m.get('PrepaidCardNo') is not None:
            self.prepaid_card_no = m.get('PrepaidCardNo')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class QueryPrepaidCardsResponseBodyData(TeaModel):
    def __init__(
        self,
        prepaid_card: List[QueryPrepaidCardsResponseBodyDataPrepaidCard] = None,
    ):
        self.prepaid_card = prepaid_card

    def validate(self):
        if self.prepaid_card:
            for k in self.prepaid_card:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PrepaidCard'] = []
        if self.prepaid_card is not None:
            for k in self.prepaid_card:
                result['PrepaidCard'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.prepaid_card = []
        if m.get('PrepaidCard') is not None:
            for k in m.get('PrepaidCard'):
                temp_model = QueryPrepaidCardsResponseBodyDataPrepaidCard()
                self.prepaid_card.append(temp_model.from_map(k))
        return self


class QueryPrepaidCardsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryPrepaidCardsResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryPrepaidCardsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryPrepaidCardsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryPrepaidCardsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryPrepaidCardsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryPriceEntityListRequest(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
    ):
        self.commodity_code = commodity_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        return self


class QueryPriceEntityListResponseBodyDataPriceEntityInfoListPriceFactorList(TeaModel):
    def __init__(
        self,
        price_factor_code: str = None,
        price_factor_name: str = None,
        price_factor_value_list: List[str] = None,
    ):
        self.price_factor_code = price_factor_code
        self.price_factor_name = price_factor_name
        self.price_factor_value_list = price_factor_value_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price_factor_code is not None:
            result['PriceFactorCode'] = self.price_factor_code
        if self.price_factor_name is not None:
            result['PriceFactorName'] = self.price_factor_name
        if self.price_factor_value_list is not None:
            result['PriceFactorValueList'] = self.price_factor_value_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PriceFactorCode') is not None:
            self.price_factor_code = m.get('PriceFactorCode')
        if m.get('PriceFactorName') is not None:
            self.price_factor_name = m.get('PriceFactorName')
        if m.get('PriceFactorValueList') is not None:
            self.price_factor_value_list = m.get('PriceFactorValueList')
        return self


class QueryPriceEntityListResponseBodyDataPriceEntityInfoList(TeaModel):
    def __init__(
        self,
        price_entity_code: str = None,
        price_entity_name: str = None,
        price_factor_list: List[QueryPriceEntityListResponseBodyDataPriceEntityInfoListPriceFactorList] = None,
    ):
        self.price_entity_code = price_entity_code
        self.price_entity_name = price_entity_name
        self.price_factor_list = price_factor_list

    def validate(self):
        if self.price_factor_list:
            for k in self.price_factor_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.price_entity_code is not None:
            result['PriceEntityCode'] = self.price_entity_code
        if self.price_entity_name is not None:
            result['PriceEntityName'] = self.price_entity_name
        result['PriceFactorList'] = []
        if self.price_factor_list is not None:
            for k in self.price_factor_list:
                result['PriceFactorList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PriceEntityCode') is not None:
            self.price_entity_code = m.get('PriceEntityCode')
        if m.get('PriceEntityName') is not None:
            self.price_entity_name = m.get('PriceEntityName')
        self.price_factor_list = []
        if m.get('PriceFactorList') is not None:
            for k in m.get('PriceFactorList'):
                temp_model = QueryPriceEntityListResponseBodyDataPriceEntityInfoListPriceFactorList()
                self.price_factor_list.append(temp_model.from_map(k))
        return self


class QueryPriceEntityListResponseBodyData(TeaModel):
    def __init__(
        self,
        price_entity_info_list: List[QueryPriceEntityListResponseBodyDataPriceEntityInfoList] = None,
    ):
        self.price_entity_info_list = price_entity_info_list

    def validate(self):
        if self.price_entity_info_list:
            for k in self.price_entity_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PriceEntityInfoList'] = []
        if self.price_entity_info_list is not None:
            for k in self.price_entity_info_list:
                result['PriceEntityInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.price_entity_info_list = []
        if m.get('PriceEntityInfoList') is not None:
            for k in m.get('PriceEntityInfoList'):
                temp_model = QueryPriceEntityListResponseBodyDataPriceEntityInfoList()
                self.price_entity_info_list.append(temp_model.from_map(k))
        return self


class QueryPriceEntityListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryPriceEntityListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        # Id of the request
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryPriceEntityListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryPriceEntityListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryPriceEntityListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryPriceEntityListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryProductListRequest(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        query_total_count: bool = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.query_total_count = query_total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_total_count is not None:
            result['QueryTotalCount'] = self.query_total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryTotalCount') is not None:
            self.query_total_count = m.get('QueryTotalCount')
        return self


class QueryProductListResponseBodyDataProductListProduct(TeaModel):
    def __init__(
        self,
        product_code: str = None,
        product_name: str = None,
        product_type: str = None,
        subscription_type: str = None,
    ):
        self.product_code = product_code
        self.product_name = product_name
        self.product_type = product_type
        self.subscription_type = subscription_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        return self


class QueryProductListResponseBodyDataProductList(TeaModel):
    def __init__(
        self,
        product: List[QueryProductListResponseBodyDataProductListProduct] = None,
    ):
        self.product = product

    def validate(self):
        if self.product:
            for k in self.product:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Product'] = []
        if self.product is not None:
            for k in self.product:
                result['Product'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.product = []
        if m.get('Product') is not None:
            for k in m.get('Product'):
                temp_model = QueryProductListResponseBodyDataProductListProduct()
                self.product.append(temp_model.from_map(k))
        return self


class QueryProductListResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        product_list: QueryProductListResponseBodyDataProductList = None,
        total_count: int = None,
    ):
        self.page_num = page_num
        self.page_size = page_size
        self.product_list = product_list
        self.total_count = total_count

    def validate(self):
        if self.product_list:
            self.product_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_list is not None:
            result['ProductList'] = self.product_list.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductList') is not None:
            temp_model = QueryProductListResponseBodyDataProductList()
            self.product_list = temp_model.from_map(m['ProductList'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryProductListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryProductListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryProductListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryProductListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryProductListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryProductListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryRIUtilizationDetailRequest(TeaModel):
    def __init__(
        self,
        deducted_instance_id: str = None,
        end_time: str = None,
        instance_spec: str = None,
        page_num: int = None,
        page_size: int = None,
        ricommodity_code: str = None,
        riinstance_id: str = None,
        start_time: str = None,
    ):
        # The ID of the instance whose fees are deducted by using the RI. If this parameter is left empty, the usage details of all instances are queried.
        self.deducted_instance_id = deducted_instance_id
        # The time when the RI expires. Specify the time in the YYYY-MM-DD HH:mm:ss format.
        self.end_time = end_time
        # The instance type of the RI.
        self.instance_spec = instance_spec
        # The number of the page to return. Default value: 1.
        self.page_num = page_num
        # The number of entries to return on each page. Default value: 20. Maximum value: 300.
        self.page_size = page_size
        # The code of the service to which the RI is applied. Default value: ecsRi. Valid values:
        # 
        # *   ecsRi: ECS RI.
        # *   scu_bag: storage capacity unit (SCU).
        self.ricommodity_code = ricommodity_code
        # The ID of the RI. If this parameter is left empty, the usage details of all RIs are queried.
        self.riinstance_id = riinstance_id
        # The time when the RI was created. Specify the time in the YYYY-MM-DD HH:mm:ss format.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deducted_instance_id is not None:
            result['DeductedInstanceId'] = self.deducted_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.ricommodity_code is not None:
            result['RICommodityCode'] = self.ricommodity_code
        if self.riinstance_id is not None:
            result['RIInstanceId'] = self.riinstance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeductedInstanceId') is not None:
            self.deducted_instance_id = m.get('DeductedInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RICommodityCode') is not None:
            self.ricommodity_code = m.get('RICommodityCode')
        if m.get('RIInstanceId') is not None:
            self.riinstance_id = m.get('RIInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QueryRIUtilizationDetailResponseBodyDataDetailListDetailList(TeaModel):
    def __init__(
        self,
        deduct_date: str = None,
        deduct_factor_total: float = None,
        deduct_hours: str = None,
        deduct_quantity: float = None,
        deducted_commodity_code: str = None,
        deducted_instance_id: str = None,
        deducted_product_detail: str = None,
        instance_spec: str = None,
        riinstance_id: str = None,
    ):
        # The time when the fees are deducted by using the RI.
        self.deduct_date = deduct_date
        # The total amount of computing power of the RI or capacity of SCU in the time period.
        self.deduct_factor_total = deduct_factor_total
        # The duration that is deducted by using the RI. Unit: hours.
        # 
        # This parameter is returned only if the RICommodityCode parameter is set to ecsRi. If the RICommodityCode parameter is set to scu_bag, this parameter is not returned.
        self.deduct_hours = deduct_hours
        # The computing power or capacity of the pay-as-you-go instance whose fees are deducted by using the RI.
        self.deduct_quantity = deduct_quantity
        # The code of the service whose fees are deducted by using the RI.
        self.deducted_commodity_code = deducted_commodity_code
        # The ID of the instance whose fees are deducted by using the RI.
        self.deducted_instance_id = deducted_instance_id
        # The name of the service whose fees are deducted by using the RI.
        self.deducted_product_detail = deducted_product_detail
        # The instance type of the instance whose fees are deducted by using the RI.
        self.instance_spec = instance_spec
        # The ID of the RI.
        self.riinstance_id = riinstance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deduct_date is not None:
            result['DeductDate'] = self.deduct_date
        if self.deduct_factor_total is not None:
            result['DeductFactorTotal'] = self.deduct_factor_total
        if self.deduct_hours is not None:
            result['DeductHours'] = self.deduct_hours
        if self.deduct_quantity is not None:
            result['DeductQuantity'] = self.deduct_quantity
        if self.deducted_commodity_code is not None:
            result['DeductedCommodityCode'] = self.deducted_commodity_code
        if self.deducted_instance_id is not None:
            result['DeductedInstanceId'] = self.deducted_instance_id
        if self.deducted_product_detail is not None:
            result['DeductedProductDetail'] = self.deducted_product_detail
        if self.instance_spec is not None:
            result['InstanceSpec'] = self.instance_spec
        if self.riinstance_id is not None:
            result['RIInstanceId'] = self.riinstance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DeductDate') is not None:
            self.deduct_date = m.get('DeductDate')
        if m.get('DeductFactorTotal') is not None:
            self.deduct_factor_total = m.get('DeductFactorTotal')
        if m.get('DeductHours') is not None:
            self.deduct_hours = m.get('DeductHours')
        if m.get('DeductQuantity') is not None:
            self.deduct_quantity = m.get('DeductQuantity')
        if m.get('DeductedCommodityCode') is not None:
            self.deducted_commodity_code = m.get('DeductedCommodityCode')
        if m.get('DeductedInstanceId') is not None:
            self.deducted_instance_id = m.get('DeductedInstanceId')
        if m.get('DeductedProductDetail') is not None:
            self.deducted_product_detail = m.get('DeductedProductDetail')
        if m.get('InstanceSpec') is not None:
            self.instance_spec = m.get('InstanceSpec')
        if m.get('RIInstanceId') is not None:
            self.riinstance_id = m.get('RIInstanceId')
        return self


class QueryRIUtilizationDetailResponseBodyDataDetailList(TeaModel):
    def __init__(
        self,
        detail_list: List[QueryRIUtilizationDetailResponseBodyDataDetailListDetailList] = None,
    ):
        self.detail_list = detail_list

    def validate(self):
        if self.detail_list:
            for k in self.detail_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DetailList'] = []
        if self.detail_list is not None:
            for k in self.detail_list:
                result['DetailList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.detail_list = []
        if m.get('DetailList') is not None:
            for k in m.get('DetailList'):
                temp_model = QueryRIUtilizationDetailResponseBodyDataDetailListDetailList()
                self.detail_list.append(temp_model.from_map(k))
        return self


class QueryRIUtilizationDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        detail_list: QueryRIUtilizationDetailResponseBodyDataDetailList = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The usage details of the RI.
        self.detail_list = detail_list
        # The number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.detail_list:
            self.detail_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detail_list is not None:
            result['DetailList'] = self.detail_list.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DetailList') is not None:
            temp_model = QueryRIUtilizationDetailResponseBodyDataDetailList()
            self.detail_list = temp_model.from_map(m['DetailList'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryRIUtilizationDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryRIUtilizationDetailResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryRIUtilizationDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryRIUtilizationDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryRIUtilizationDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryRIUtilizationDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryRedeemRequest(TeaModel):
    def __init__(
        self,
        effective_or_not: bool = None,
        expiry_time_end: str = None,
        expiry_time_start: str = None,
        page_num: int = None,
        page_size: int = None,
    ):
        # Specifies whether the redemption coupon takes effect. Valid values:
        # 
        # *   true
        # *   false
        # 
        # Default value: false.
        self.effective_or_not = effective_or_not
        # The end time when the redemption coupon expires. The value must be in the yyyy-MM-ddTHH:mm:ssZ format.
        self.expiry_time_end = expiry_time_end
        # The start time when the redemption coupon expires. The value must be in the yyyy-MM-ddTHH:mm:ssZ format.
        self.expiry_time_start = expiry_time_start
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effective_or_not is not None:
            result['EffectiveOrNot'] = self.effective_or_not
        if self.expiry_time_end is not None:
            result['ExpiryTimeEnd'] = self.expiry_time_end
        if self.expiry_time_start is not None:
            result['ExpiryTimeStart'] = self.expiry_time_start
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EffectiveOrNot') is not None:
            self.effective_or_not = m.get('EffectiveOrNot')
        if m.get('ExpiryTimeEnd') is not None:
            self.expiry_time_end = m.get('ExpiryTimeEnd')
        if m.get('ExpiryTimeStart') is not None:
            self.expiry_time_start = m.get('ExpiryTimeStart')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryRedeemResponseBodyDataRedeemRedeem(TeaModel):
    def __init__(
        self,
        applicable_products: str = None,
        balance: str = None,
        effective_time: str = None,
        expiry_time: str = None,
        granted_time: str = None,
        nominal_value: str = None,
        redeem_id: str = None,
        redeem_no: str = None,
        specification: str = None,
        status: str = None,
    ):
        # The services to which the redemption coupon is applicable.
        self.applicable_products = applicable_products
        # The balance of the redemption coupon.
        self.balance = balance
        # The time when the redemption coupon took effect.
        self.effective_time = effective_time
        # The time when the redemption coupon expired.
        self.expiry_time = expiry_time
        # The time when the redemption coupon was issued.
        self.granted_time = granted_time
        # The nominal value of the redemption coupon.
        self.nominal_value = nominal_value
        # The ID of the redemption coupon.
        self.redeem_id = redeem_id
        # The number of the redemption coupon.
        self.redeem_no = redeem_no
        # The specifications of the redemption coupon.
        self.specification = specification
        # The status of the redemption coupon. Valid values:
        # 
        # *   Generated
        # *   CallBack
        # *   RefundPending
        # *   Canceled
        # *   Order_Canceled
        # *   ActivePending
        # *   ActiveSuccess
        # *   ExchangePending
        # *   ExchangeSuccess
        # *   Expired
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applicable_products is not None:
            result['ApplicableProducts'] = self.applicable_products
        if self.balance is not None:
            result['Balance'] = self.balance
        if self.effective_time is not None:
            result['EffectiveTime'] = self.effective_time
        if self.expiry_time is not None:
            result['ExpiryTime'] = self.expiry_time
        if self.granted_time is not None:
            result['GrantedTime'] = self.granted_time
        if self.nominal_value is not None:
            result['NominalValue'] = self.nominal_value
        if self.redeem_id is not None:
            result['RedeemId'] = self.redeem_id
        if self.redeem_no is not None:
            result['RedeemNo'] = self.redeem_no
        if self.specification is not None:
            result['Specification'] = self.specification
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicableProducts') is not None:
            self.applicable_products = m.get('ApplicableProducts')
        if m.get('Balance') is not None:
            self.balance = m.get('Balance')
        if m.get('EffectiveTime') is not None:
            self.effective_time = m.get('EffectiveTime')
        if m.get('ExpiryTime') is not None:
            self.expiry_time = m.get('ExpiryTime')
        if m.get('GrantedTime') is not None:
            self.granted_time = m.get('GrantedTime')
        if m.get('NominalValue') is not None:
            self.nominal_value = m.get('NominalValue')
        if m.get('RedeemId') is not None:
            self.redeem_id = m.get('RedeemId')
        if m.get('RedeemNo') is not None:
            self.redeem_no = m.get('RedeemNo')
        if m.get('Specification') is not None:
            self.specification = m.get('Specification')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class QueryRedeemResponseBodyDataRedeem(TeaModel):
    def __init__(
        self,
        redeem: List[QueryRedeemResponseBodyDataRedeemRedeem] = None,
    ):
        self.redeem = redeem

    def validate(self):
        if self.redeem:
            for k in self.redeem:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Redeem'] = []
        if self.redeem is not None:
            for k in self.redeem:
                result['Redeem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.redeem = []
        if m.get('Redeem') is not None:
            for k in m.get('Redeem'):
                temp_model = QueryRedeemResponseBodyDataRedeemRedeem()
                self.redeem.append(temp_model.from_map(k))
        return self


class QueryRedeemResponseBodyData(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        redeem: QueryRedeemResponseBodyDataRedeem = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The details of the redemption coupon.
        self.redeem = redeem
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.redeem:
            self.redeem.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.redeem is not None:
            result['Redeem'] = self.redeem.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Redeem') is not None:
            temp_model = QueryRedeemResponseBodyDataRedeem()
            self.redeem = temp_model.from_map(m['Redeem'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryRedeemResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryRedeemResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryRedeemResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryRedeemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryRedeemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryRedeemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryRelationListRequest(TeaModel):
    def __init__(
        self,
        page_num: int = None,
        page_size: int = None,
        status_list: List[str] = None,
        user_id: int = None,
    ):
        # The number of the page to return. Default value: 1.
        self.page_num = page_num
        # The number of entries to return on each page. Default value: 20.
        self.page_size = page_size
        # The states of the relationships between the management account and its members. The valid values of this parameter are the enumeration members of the RelationshipStatusEnum data type. If you do not specify this parameter, valid relationship states are queried by default.
        self.status_list = status_list
        # The ID of the Alibaba Cloud account.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class QueryRelationListResponseBodyDataFinancialRelationInfoList(TeaModel):
    def __init__(
        self,
        account_id: int = None,
        account_name: str = None,
        account_nick_name: str = None,
        account_type: str = None,
        end_time: str = None,
        relation_id: int = None,
        relation_type: str = None,
        setup_time: str = None,
        start_time: str = None,
        state: str = None,
    ):
        # The ID of the Alibaba Cloud account.
        self.account_id = account_id
        # The name of the account.
        self.account_name = account_name
        # The display name of the account.
        self.account_nick_name = account_nick_name
        # The type of the account. Valid values: MASTER and MEMBER.
        self.account_type = account_type
        # The time when the relationship became invalid. If no value is returned, the relationship is still valid.
        self.end_time = end_time
        # The ID of the relationship.
        self.relation_id = relation_id
        # The type of the relationship. Valid values: FinancialManagement and FinancialTrusteeship.
        self.relation_type = relation_type
        # The time when the relationship was established. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC. Example: 2016-05-23T12:00:00Z.
        self.setup_time = setup_time
        # The time when the relationship became valid. The time follows the ISO 8601 standard in the yyyy-MM-ddThh:mm:ssZ format. The time is displayed in UTC. Example: 2016-05-23T12:00:00Z.
        self.start_time = start_time
        # The state of the relationship. One of the enumeration members of the RelationshipStatusEnum data type is returned.
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_nick_name is not None:
            result['AccountNickName'] = self.account_nick_name
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.relation_id is not None:
            result['RelationId'] = self.relation_id
        if self.relation_type is not None:
            result['RelationType'] = self.relation_type
        if self.setup_time is not None:
            result['SetupTime'] = self.setup_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountNickName') is not None:
            self.account_nick_name = m.get('AccountNickName')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('RelationId') is not None:
            self.relation_id = m.get('RelationId')
        if m.get('RelationType') is not None:
            self.relation_type = m.get('RelationType')
        if m.get('SetupTime') is not None:
            self.setup_time = m.get('SetupTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class QueryRelationListResponseBodyData(TeaModel):
    def __init__(
        self,
        financial_relation_info_list: List[QueryRelationListResponseBodyDataFinancialRelationInfoList] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The relationships.
        self.financial_relation_info_list = financial_relation_info_list
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.financial_relation_info_list:
            for k in self.financial_relation_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FinancialRelationInfoList'] = []
        if self.financial_relation_info_list is not None:
            for k in self.financial_relation_info_list:
                result['FinancialRelationInfoList'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.financial_relation_info_list = []
        if m.get('FinancialRelationInfoList') is not None:
            for k in m.get('FinancialRelationInfoList'):
                temp_model = QueryRelationListResponseBodyDataFinancialRelationInfoList()
                self.financial_relation_info_list.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryRelationListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryRelationListResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryRelationListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryRelationListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryRelationListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryRelationListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryResellerAvailableQuotaRequest(TeaModel):
    def __init__(
        self,
        item_codes: str = None,
        owner_id: int = None,
    ):
        # You do not need to specify the parameter.
        self.item_codes = item_codes
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_codes is not None:
            result['ItemCodes'] = self.item_codes
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemCodes') is not None:
            self.item_codes = m.get('ItemCodes')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class QueryResellerAvailableQuotaResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code returned if the call failed. For more information, see the "Error codes" section of this topic.
        self.code = code
        # The remaining quota of the account.
        self.data = data
        # The error message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the call is successful. A value of true indicates that the call is successful. A value of false indicates that the call failed.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryResellerAvailableQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryResellerAvailableQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryResellerAvailableQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryResellerUserAlarmThresholdRequest(TeaModel):
    def __init__(
        self,
        alarm_type: str = None,
        owner_id: int = None,
    ):
        self.alarm_type = alarm_type
        self.owner_id = owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_type is not None:
            result['AlarmType'] = self.alarm_type
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmType') is not None:
            self.alarm_type = m.get('AlarmType')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        return self


class QueryResellerUserAlarmThresholdResponseBodyData(TeaModel):
    def __init__(
        self,
        denominator: int = None,
        numerator: int = None,
        threshold_amount: str = None,
        threshold_type: int = None,
    ):
        self.denominator = denominator
        self.numerator = numerator
        self.threshold_amount = threshold_amount
        self.threshold_type = threshold_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.denominator is not None:
            result['Denominator'] = self.denominator
        if self.numerator is not None:
            result['Numerator'] = self.numerator
        if self.threshold_amount is not None:
            result['ThresholdAmount'] = self.threshold_amount
        if self.threshold_type is not None:
            result['ThresholdType'] = self.threshold_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Denominator') is not None:
            self.denominator = m.get('Denominator')
        if m.get('Numerator') is not None:
            self.numerator = m.get('Numerator')
        if m.get('ThresholdAmount') is not None:
            self.threshold_amount = m.get('ThresholdAmount')
        if m.get('ThresholdType') is not None:
            self.threshold_type = m.get('ThresholdType')
        return self


class QueryResellerUserAlarmThresholdResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        count: int = None,
        data: List[QueryResellerUserAlarmThresholdResponseBodyData] = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.count = count
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.count is not None:
            result['Count'] = self.count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryResellerUserAlarmThresholdResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryResellerUserAlarmThresholdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryResellerUserAlarmThresholdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryResellerUserAlarmThresholdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryResourcePackageInstancesRequest(TeaModel):
    def __init__(
        self,
        expiry_time_end: str = None,
        expiry_time_start: str = None,
        include_partner: bool = None,
        owner_id: int = None,
        page_num: int = None,
        page_size: int = None,
        product_code: str = None,
    ):
        # The end of the expiration time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.expiry_time_end = expiry_time_end
        # The beginning of the expiration time range to query. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC.
        self.expiry_time_start = expiry_time_start
        # Specifies whether partners are involved.
        self.include_partner = include_partner
        self.owner_id = owner_id
        # The number of the page to return. Default value: 1.
        self.page_num = page_num
        # The number of entries to return on each page. Default value: 20. Maximum value: 100.
        self.page_size = page_size
        # The code of the service.
        self.product_code = product_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expiry_time_end is not None:
            result['ExpiryTimeEnd'] = self.expiry_time_end
        if self.expiry_time_start is not None:
            result['ExpiryTimeStart'] = self.expiry_time_start
        if self.include_partner is not None:
            result['IncludePartner'] = self.include_partner
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiryTimeEnd') is not None:
            self.expiry_time_end = m.get('ExpiryTimeEnd')
        if m.get('ExpiryTimeStart') is not None:
            self.expiry_time_start = m.get('ExpiryTimeStart')
        if m.get('IncludePartner') is not None:
            self.include_partner = m.get('IncludePartner')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        return self


class QueryResourcePackageInstancesResponseBodyDataInstancesInstanceApplicableProducts(TeaModel):
    def __init__(
        self,
        product: List[str] = None,
    ):
        self.product = product

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product is not None:
            result['Product'] = self.product
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Product') is not None:
            self.product = m.get('Product')
        return self


class QueryResourcePackageInstancesResponseBodyDataInstancesInstance(TeaModel):
    def __init__(
        self,
        applicable_products: QueryResourcePackageInstancesResponseBodyDataInstancesInstanceApplicableProducts = None,
        commodity_code: str = None,
        deduct_type: str = None,
        effective_time: str = None,
        expiry_time: str = None,
        instance_id: str = None,
        package_type: str = None,
        region: str = None,
        remaining_amount: str = None,
        remaining_amount_unit: str = None,
        remark: str = None,
        status: str = None,
        total_amount: str = None,
        total_amount_unit: str = None,
    ):
        # The services to which the resource plan is applicable.
        self.applicable_products = applicable_products
        # The commodity code.
        self.commodity_code = commodity_code
        # The deduction type. Example: Absolute.
        self.deduct_type = deduct_type
        # The time when the resource plan took effect.
        self.effective_time = effective_time
        # The time when the resource plan expired.
        self.expiry_time = expiry_time
        # The ID of the instance.
        self.instance_id = instance_id
        # The type of the resource plan.
        self.package_type = package_type
        # The ID of the region.
        self.region = region
        # The remaining quota.
        self.remaining_amount = remaining_amount
        # The unit of the remaining quota.
        self.remaining_amount_unit = remaining_amount_unit
        # The remarks on the resource plan. The remarks must be made in Chinese.
        self.remark = remark
        # The status of the resource plan. Valid values:
        # 
        # *   Available
        # *   Expired
        self.status = status
        # The total quota of the resource plan.
        self.total_amount = total_amount
        # The unit of the total quota.
        self.total_amount_unit = total_amount_unit

    def validate(self):
        if self.applicable_products:
            self.applicable_products.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.applicable_products is not None:
            result['ApplicableProducts'] = self.applicable_products.to_map()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.deduct_type is not None:
            result['DeductType'] = self.deduct_type
        if self.effective_time is not None:
            result['EffectiveTime'] = self.effective_time
        if self.expiry_time is not None:
            result['ExpiryTime'] = self.expiry_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.region is not None:
            result['Region'] = self.region
        if self.remaining_amount is not None:
            result['RemainingAmount'] = self.remaining_amount
        if self.remaining_amount_unit is not None:
            result['RemainingAmountUnit'] = self.remaining_amount_unit
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.status is not None:
            result['Status'] = self.status
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.total_amount_unit is not None:
            result['TotalAmountUnit'] = self.total_amount_unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicableProducts') is not None:
            temp_model = QueryResourcePackageInstancesResponseBodyDataInstancesInstanceApplicableProducts()
            self.applicable_products = temp_model.from_map(m['ApplicableProducts'])
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('DeductType') is not None:
            self.deduct_type = m.get('DeductType')
        if m.get('EffectiveTime') is not None:
            self.effective_time = m.get('EffectiveTime')
        if m.get('ExpiryTime') is not None:
            self.expiry_time = m.get('ExpiryTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RemainingAmount') is not None:
            self.remaining_amount = m.get('RemainingAmount')
        if m.get('RemainingAmountUnit') is not None:
            self.remaining_amount_unit = m.get('RemainingAmountUnit')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalAmount') is not None:
            self.total_amount = m.get('TotalAmount')
        if m.get('TotalAmountUnit') is not None:
            self.total_amount_unit = m.get('TotalAmountUnit')
        return self


class QueryResourcePackageInstancesResponseBodyDataInstances(TeaModel):
    def __init__(
        self,
        instance: List[QueryResourcePackageInstancesResponseBodyDataInstancesInstance] = None,
    ):
        self.instance = instance

    def validate(self):
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance = []
        if m.get('Instance') is not None:
            for k in m.get('Instance'):
                temp_model = QueryResourcePackageInstancesResponseBodyDataInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class QueryResourcePackageInstancesResponseBodyData(TeaModel):
    def __init__(
        self,
        host_id: str = None,
        instances: QueryResourcePackageInstancesResponseBodyDataInstances = None,
        page_num: str = None,
        page_size: str = None,
        total_count: str = None,
    ):
        # The ID of the host.
        self.host_id = host_id
        # The details of the instances.
        self.instances = instances
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.instances:
            self.instances.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_id is not None:
            result['HostId'] = self.host_id
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        if m.get('Instances') is not None:
            temp_model = QueryResourcePackageInstancesResponseBodyDataInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryResourcePackageInstancesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QueryResourcePackageInstancesResponseBodyData = None,
        message: str = None,
        page: int = None,
        page_size: int = None,
        request_id: str = None,
        success: bool = None,
        total: int = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The message returned.
        self.message = message
        # The page number of the returned page.
        self.page = page
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the request is successful.
        self.success = success
        # The total number of returned entries.
        self.total = total

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryResourcePackageInstancesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class QueryResourcePackageInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QueryResourcePackageInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryResourcePackageInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QuerySavingsPlansDeductLogRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        instance_id: str = None,
        instance_type: str = None,
        locale: str = None,
        page_num: int = None,
        page_size: int = None,
        start_time: str = None,
    ):
        # The end of the time range to query. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.end_time = end_time
        # The ID of the instance.
        self.instance_id = instance_id
        # The type of the instance ID based on which the data is queried. Valid values:
        # 
        # *   spn: queries data based on the ID of the savings plan instance.
        # *   product: queries data based on the ID of the cloud service instance.
        self.instance_type = instance_type
        # The language of the return data. Valid values:
        # 
        # *   ZH: Chinese
        # *   EN: English
        self.locale = locale
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The beginning of the time range to query. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.locale is not None:
            result['Locale'] = self.locale
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Locale') is not None:
            self.locale = m.get('Locale')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class QuerySavingsPlansDeductLogResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        bill_module: str = None,
        deduct_commodity: str = None,
        deduct_fee: str = None,
        deduct_instance_id: str = None,
        deduct_rate: str = None,
        discount_rate: str = None,
        end_time: str = None,
        instance_id: str = None,
        owner_id: int = None,
        savings_type: str = None,
        start_time: str = None,
        user_id: int = None,
    ):
        # The billable item for which the fee is deducted.
        self.bill_module = bill_module
        # The service for which the fee is deducted.
        self.deduct_commodity = deduct_commodity
        # The deducted amount.
        self.deduct_fee = deduct_fee
        # The ID of the instance for which the fee is deducted.
        self.deduct_instance_id = deduct_instance_id
        # The deduction rate.
        self.deduct_rate = deduct_rate
        # The discount used for the current deduction.
        self.discount_rate = discount_rate
        # The end of the billing cycle for which the fee is deducted.
        self.end_time = end_time
        # The ID of the savings plan instance.
        self.instance_id = instance_id
        self.owner_id = owner_id
        # The type of the savings plan. Valid values:
        # 
        # *   universal: general-purpose
        # *   ecs: ECS compute
        self.savings_type = savings_type
        # The beginning of the billing cycle for which the fee is deducted. The time is in the format of yyyy-MM-dd HH:mm:ss.
        self.start_time = start_time
        # The ID of the user.
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_module is not None:
            result['BillModule'] = self.bill_module
        if self.deduct_commodity is not None:
            result['DeductCommodity'] = self.deduct_commodity
        if self.deduct_fee is not None:
            result['DeductFee'] = self.deduct_fee
        if self.deduct_instance_id is not None:
            result['DeductInstanceId'] = self.deduct_instance_id
        if self.deduct_rate is not None:
            result['DeductRate'] = self.deduct_rate
        if self.discount_rate is not None:
            result['DiscountRate'] = self.discount_rate
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.savings_type is not None:
            result['SavingsType'] = self.savings_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillModule') is not None:
            self.bill_module = m.get('BillModule')
        if m.get('DeductCommodity') is not None:
            self.deduct_commodity = m.get('DeductCommodity')
        if m.get('DeductFee') is not None:
            self.deduct_fee = m.get('DeductFee')
        if m.get('DeductInstanceId') is not None:
            self.deduct_instance_id = m.get('DeductInstanceId')
        if m.get('DeductRate') is not None:
            self.deduct_rate = m.get('DeductRate')
        if m.get('DiscountRate') is not None:
            self.discount_rate = m.get('DiscountRate')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('SavingsType') is not None:
            self.savings_type = m.get('SavingsType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class QuerySavingsPlansDeductLogResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[QuerySavingsPlansDeductLogResponseBodyDataItems] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The deduction details.
        self.items = items
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = QuerySavingsPlansDeductLogResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QuerySavingsPlansDeductLogResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QuerySavingsPlansDeductLogResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code.
        self.code = code
        # The return data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QuerySavingsPlansDeductLogResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QuerySavingsPlansDeductLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QuerySavingsPlansDeductLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QuerySavingsPlansDeductLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QuerySavingsPlansDiscountRequest(TeaModel):
    def __init__(
        self,
        commodity_code: str = None,
        cycle: str = None,
        locale: str = None,
        module_code: str = None,
        page_num: int = None,
        page_size: int = None,
        pay_mode: str = None,
        region: str = None,
        spec: str = None,
        spn_type: str = None,
    ):
        self.commodity_code = commodity_code
        self.cycle = cycle
        self.locale = locale
        self.module_code = module_code
        self.page_num = page_num
        self.page_size = page_size
        self.pay_mode = pay_mode
        self.region = region
        self.spec = spec
        self.spn_type = spn_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.cycle is not None:
            result['Cycle'] = self.cycle
        if self.locale is not None:
            result['Locale'] = self.locale
        if self.module_code is not None:
            result['ModuleCode'] = self.module_code
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pay_mode is not None:
            result['PayMode'] = self.pay_mode
        if self.region is not None:
            result['Region'] = self.region
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.spn_type is not None:
            result['SpnType'] = self.spn_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('Cycle') is not None:
            self.cycle = m.get('Cycle')
        if m.get('Locale') is not None:
            self.locale = m.get('Locale')
        if m.get('ModuleCode') is not None:
            self.module_code = m.get('ModuleCode')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PayMode') is not None:
            self.pay_mode = m.get('PayMode')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('SpnType') is not None:
            self.spn_type = m.get('SpnType')
        return self


class QuerySavingsPlansDiscountResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        commodity_name: str = None,
        contract_discount_rate: str = None,
        cycle: str = None,
        discount_rate: str = None,
        module_name: str = None,
        pay_mode: str = None,
        region: str = None,
        spec: str = None,
        spn_type: str = None,
    ):
        self.commodity_name = commodity_name
        self.contract_discount_rate = contract_discount_rate
        self.cycle = cycle
        self.discount_rate = discount_rate
        self.module_name = module_name
        self.pay_mode = pay_mode
        self.region = region
        self.spec = spec
        self.spn_type = spn_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commodity_name is not None:
            result['CommodityName'] = self.commodity_name
        if self.contract_discount_rate is not None:
            result['ContractDiscountRate'] = self.contract_discount_rate
        if self.cycle is not None:
            result['Cycle'] = self.cycle
        if self.discount_rate is not None:
            result['DiscountRate'] = self.discount_rate
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        if self.pay_mode is not None:
            result['PayMode'] = self.pay_mode
        if self.region is not None:
            result['Region'] = self.region
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.spn_type is not None:
            result['SpnType'] = self.spn_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommodityName') is not None:
            self.commodity_name = m.get('CommodityName')
        if m.get('ContractDiscountRate') is not None:
            self.contract_discount_rate = m.get('ContractDiscountRate')
        if m.get('Cycle') is not None:
            self.cycle = m.get('Cycle')
        if m.get('DiscountRate') is not None:
            self.discount_rate = m.get('DiscountRate')
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        if m.get('PayMode') is not None:
            self.pay_mode = m.get('PayMode')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('SpnType') is not None:
            self.spn_type = m.get('SpnType')
        return self


class QuerySavingsPlansDiscountResponseBodyData(TeaModel):
    def __init__(
        self,
        host_id: str = None,
        items: List[QuerySavingsPlansDiscountResponseBodyDataItems] = None,
    ):
        self.host_id = host_id
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host_id is not None:
            result['HostId'] = self.host_id
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HostId') is not None:
            self.host_id = m.get('HostId')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = QuerySavingsPlansDiscountResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        return self


class QuerySavingsPlansDiscountResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QuerySavingsPlansDiscountResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        # data
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QuerySavingsPlansDiscountResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QuerySavingsPlansDiscountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QuerySavingsPlansDiscountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QuerySavingsPlansDiscountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QuerySavingsPlansInstanceRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag to query.
        self.key = key
        # The value of the tag to query.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QuerySavingsPlansInstanceRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        instance_id: str = None,
        locale: str = None,
        page_num: int = None,
        page_size: int = None,
        start_time: str = None,
        status: str = None,
        tag: List[QuerySavingsPlansInstanceRequestTag] = None,
    ):
        # The end of the time range to query. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.end_time = end_time
        # The ID of the savings plan instance.
        self.instance_id = instance_id
        # The language of the return data. Valid values:
        # 
        # *   ZH: Chinese
        # *   EN: English
        self.locale = locale
        # The number of the page to return.
        self.page_num = page_num
        # The number of entries to return on each page.
        self.page_size = page_size
        # The beginning of the time range to query. Specify the time in the format of yyyy-MM-dd HH:mm:ss.
        self.start_time = start_time
        self.status = status
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.locale is not None:
            result['Locale'] = self.locale
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Locale') is not None:
            self.locale = m.get('Locale')
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = QuerySavingsPlansInstanceRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class QuerySavingsPlansInstanceResponseBodyDataItemsTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag.
        self.key = key
        # The value of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class QuerySavingsPlansInstanceResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        allocation_status: str = None,
        currency: str = None,
        cycle: str = None,
        deduct_cycle_type: str = None,
        end_time: str = None,
        end_timestamp: int = None,
        instance_family: str = None,
        instance_id: str = None,
        last_bill_total_usage: str = None,
        last_bill_utilization: str = None,
        pay_mode: str = None,
        pool_value: str = None,
        prepay_fee: str = None,
        region: str = None,
        savings_type: str = None,
        start_time: str = None,
        start_timestamp: int = None,
        status: str = None,
        tags: List[QuerySavingsPlansInstanceResponseBodyDataItemsTags] = None,
        total_save: str = None,
        utilization: str = None,
    ):
        # The allocation status. Valid values:
        # 
        # *   unallocated
        # *   allocated
        # *   beAllocated
        self.allocation_status = allocation_status
        # The currency. Valid values: CNY and USD.
        self.currency = currency
        self.cycle = cycle
        self.deduct_cycle_type = deduct_cycle_type
        # The time when the instance expires. The time is in the format of yyyy-MM-dd HH:mm:ss.
        self.end_time = end_time
        self.end_timestamp = end_timestamp
        # The instance family information. For an instance of the Elastic Compute Service (ECS) compute type, the value indicates the ECS instance family or the ECS instance family package.
        self.instance_family = instance_family
        # The ID of the savings plan instance.
        self.instance_id = instance_id
        self.last_bill_total_usage = last_bill_total_usage
        self.last_bill_utilization = last_bill_utilization
        # The payment type. Valid values:
        # 
        # *   total: All Upfront
        # *   half: Partial Upfront
        # *   zero: No Upfront
        self.pay_mode = pay_mode
        # The commitment.
        self.pool_value = pool_value
        # The prepaid amount.
        self.prepay_fee = prepay_fee
        # The region.
        self.region = region
        # The type of the savings plan. Valid values:
        # 
        # *   universal: general-purpose
        # *   ecs: ECS compute
        self.savings_type = savings_type
        # The time when the instance takes effect. The time is in the format of yyyy-MM-dd HH:mm:ss.
        self.start_time = start_time
        self.start_timestamp = start_timestamp
        # The status of the instance. Valid values:
        # 
        # *   NORMAL: normal
        # *   LIMIT: stopped due to overdue payment
        # *   RELEASE: released
        self.status = status
        # The details about the tags.
        self.tags = tags
        # The total amount that is saved.
        self.total_save = total_save
        # The total usage.
        self.utilization = utilization

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_status is not None:
            result['AllocationStatus'] = self.allocation_status
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.cycle is not None:
            result['Cycle'] = self.cycle
        if self.deduct_cycle_type is not None:
            result['DeductCycleType'] = self.deduct_cycle_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_timestamp is not None:
            result['EndTimestamp'] = self.end_timestamp
        if self.instance_family is not None:
            result['InstanceFamily'] = self.instance_family
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.last_bill_total_usage is not None:
            result['LastBillTotalUsage'] = self.last_bill_total_usage
        if self.last_bill_utilization is not None:
            result['LastBillUtilization'] = self.last_bill_utilization
        if self.pay_mode is not None:
            result['PayMode'] = self.pay_mode
        if self.pool_value is not None:
            result['PoolValue'] = self.pool_value
        if self.prepay_fee is not None:
            result['PrepayFee'] = self.prepay_fee
        if self.region is not None:
            result['Region'] = self.region
        if self.savings_type is not None:
            result['SavingsType'] = self.savings_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.start_timestamp is not None:
            result['StartTimestamp'] = self.start_timestamp
        if self.status is not None:
            result['Status'] = self.status
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.total_save is not None:
            result['TotalSave'] = self.total_save
        if self.utilization is not None:
            result['Utilization'] = self.utilization
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllocationStatus') is not None:
            self.allocation_status = m.get('AllocationStatus')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('Cycle') is not None:
            self.cycle = m.get('Cycle')
        if m.get('DeductCycleType') is not None:
            self.deduct_cycle_type = m.get('DeductCycleType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndTimestamp') is not None:
            self.end_timestamp = m.get('EndTimestamp')
        if m.get('InstanceFamily') is not None:
            self.instance_family = m.get('InstanceFamily')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LastBillTotalUsage') is not None:
            self.last_bill_total_usage = m.get('LastBillTotalUsage')
        if m.get('LastBillUtilization') is not None:
            self.last_bill_utilization = m.get('LastBillUtilization')
        if m.get('PayMode') is not None:
            self.pay_mode = m.get('PayMode')
        if m.get('PoolValue') is not None:
            self.pool_value = m.get('PoolValue')
        if m.get('PrepayFee') is not None:
            self.prepay_fee = m.get('PrepayFee')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SavingsType') is not None:
            self.savings_type = m.get('SavingsType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StartTimestamp') is not None:
            self.start_timestamp = m.get('StartTimestamp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = QuerySavingsPlansInstanceResponseBodyDataItemsTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('TotalSave') is not None:
            self.total_save = m.get('TotalSave')
        if m.get('Utilization') is not None:
            self.utilization = m.get('Utilization')
        return self


class QuerySavingsPlansInstanceResponseBodyData(TeaModel):
    def __init__(
        self,
        items: List[QuerySavingsPlansInstanceResponseBodyDataItems] = None,
        page_num: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The details about the instances.
        self.items = items
        # The page number of the returned page.
        self.page_num = page_num
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = QuerySavingsPlansInstanceResponseBodyDataItems()
                self.items.append(temp_model.from_map(k))
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QuerySavingsPlansInstanceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QuerySavingsPlansInstanceResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The error code.
        self.code = code
        # The return data.
        self.data = data
        # The message returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the operation was successful.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QuerySavingsPlansInstanceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QuerySavingsPlansInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: QuerySavingsPlansInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QuerySavingsPlansInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QuerySettleBillRequest(TeaModel):
    def __init__(
        self,
        bill_owner_id: int = None,
        billing_cycle: str = None,
        is_display_local_currency: bool = None,
        is_hide_zero_charge: bool = None,
        max_results: int = None,
        next_token: str = None,
        owner_id: int = None,
        product_code: str = None,
        product_type: str = None,
        record_id: str = None,
        subscription_type: str = None,
        type: str = None,
    ):
        # The ID of the member. If you specify a value for this parameter, you can query the bills of the specified member. If you leave this parameter empty, the bills of the current account are queried by default.
        self.bill_owner_id = bill_owner_id
        # The billing cycle, in the YYYY-MM format.
        self.billing_cycle = billing_cycle
        # Specifies whether to display local currency information in bills.
        self.is_display_local_currency = is_display_local_currency
        # Specifies whether to filter out a bill whose pretax gross amount is 0. By default, a bill whose pretax gross amount is 0 is not filtered out.
        # 
        # *   true: filters out a bill whose pretax gross amount is 0.
        # *   false: does not filter out a bill whose pretax gross amount is 0.
        self.is_hide_zero_charge = is_hide_zero_charge
        # The maximum number of entries to return. Default value: 20. Maximum value: 300.
        self.max_results = max_results
        # The starting position of the query. If this parameter is left empty, the query starts from the beginning.
        self.next_token = next_token
        self.owner_id = owner_id
        # The code of the service.
        self.product_code = product_code
        # The type of the service.
        self.product_type = product_type
        # The ID of the bill or order.
        self.record_id = record_id
        # The billing method. Valid values:
        # 
        # *   Subscription: the subscription billing method
        # *   PayAsYouGo: the pay-as-you-go billing method
        # 
        # **\
        # 
        # ****This parameter must be used together with the ProductCode parameter.
        self.subscription_type = subscription_type
        # The type of the bill. Valid values:
        # 
        # *   SubscriptionOrder: subscription order
        # *   PayAsYouGoBill: pay-as-you-go bill
        # *   Refund: refund
        # *   Adjustment: reconciliation
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bill_owner_id is not None:
            result['BillOwnerId'] = self.bill_owner_id
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.is_display_local_currency is not None:
            result['IsDisplayLocalCurrency'] = self.is_display_local_currency
        if self.is_hide_zero_charge is not None:
            result['IsHideZeroCharge'] = self.is_hide_zero_charge
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.record_id is not None:
            result['RecordID'] = self.record_id
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BillOwnerId') is not None:
            self.bill_owner_id = m.get('BillOwnerId')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('IsDisplayLocalCurrency') is not None:
            self.is_display_local_currency = m.get('IsDisplayLocalCurrency')
        if m.get('IsHideZeroCharge') is not None:
            self.is_hide_zero_charge = m.get('IsHideZeroCharge')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RecordID') is not None:
            self.record_id = m.get('RecordID')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QuerySettleBillResponseBodyDataItemsItem(TeaModel):
    def __init__(
        self,
        adjust_amount: float = None,
        after_tax_amount: float = None,
        bill_account_id: str = None,
        bill_account_name: str = None,
        biz_type: str = None,
        cash_amount: float = None,
        commodity_code: str = None,
        currency: str = None,
        deducted_by_cash_coupons: float = None,
        deducted_by_coupons: float = None,
        deducted_by_prepaid_card: float = None,
        invoice_discount: float = None,
        item: str = None,
        outstanding_amount: float = None,
        owner_id: str = None,
        payment_amount: float = None,
        payment_currency: str = None,
        payment_time: str = None,
        payment_transaction_id: str = None,
        pip_code: str = None,
        pretax_amount: float = None,
        pretax_amount_local: float = None,
        pretax_gross_amount: float = None,
        product_code: str = None,
        product_detail: str = None,
        product_name: str = None,
        product_type: str = None,
        record_id: str = None,
        round_down_discount: str = None,
        status: str = None,
        sub_order_id: str = None,
        subscription_type: str = None,
        tax: float = None,
        usage_end_time: str = None,
        usage_start_time: str = None,
    ):
        # The amount deducted by using credit refunds.
        self.adjust_amount = adjust_amount
        # The amount paid after the tax is deducted.
        self.after_tax_amount = after_tax_amount
        # The ID of the account to which the bill belongs.
        self.bill_account_id = bill_account_id
        # The name of the account to which the bill belongs.
        self.bill_account_name = bill_account_name
        # The business type.
        self.biz_type = biz_type
        # The amount paid in cash. The amount that was deducted by using credit refunds is not included.
        self.cash_amount = cash_amount
        # The code of the commodity. The commodity code is the same as that displayed in User Center.
        self.commodity_code = commodity_code
        # The type of the currency.
        # 
        # *   CNY
        # *   USD
        # *   JPY
        self.currency = currency
        # The amount deducted by using vouchers.
        self.deducted_by_cash_coupons = deducted_by_cash_coupons
        # The amount deducted by using coupons.
        self.deducted_by_coupons = deducted_by_coupons
        # The amount deducted by using prepaid cards.
        self.deducted_by_prepaid_card = deducted_by_prepaid_card
        # The discount amount.
        self.invoice_discount = invoice_discount
        # The type of the bill. Valid values:
        # 
        # *   Subscription
        # *   OrderPayAsYouGoBill
        # *   Refund
        # *   Adjustment
        self.item = item
        # The unsettled amount.
        self.outstanding_amount = outstanding_amount
        # The ID of the member. This parameter is returned in a multi-account payment scenario.
        self.owner_id = owner_id
        # The amount paid in cash. The amount that was deducted by using credit refunds is included.
        self.payment_amount = payment_amount
        # The currency used for payment.
        self.payment_currency = payment_currency
        # The time when the bill was paid.
        self.payment_time = payment_time
        # The ID of the transaction.
        self.payment_transaction_id = payment_transaction_id
        # The code of the service. The service code is the same as that displayed in User Center.
        self.pip_code = pip_code
        # The pretax amount.
        self.pretax_amount = pretax_amount
        # The pretax amount paid in local currency.
        self.pretax_amount_local = pretax_amount_local
        # The pretax gross amount.
        self.pretax_gross_amount = pretax_gross_amount
        # The code of the service.
        self.product_code = product_code
        # The details of the service.
        self.product_detail = product_detail
        # The name of the service.
        self.product_name = product_name
        # The type of the service.
        self.product_type = product_type
        # The ID of the bill or order.
        self.record_id = record_id
        # The round down discount.
        self.round_down_discount = round_down_discount
        # The payment status of the bill. Valid values:
        # 
        # *   PayFinish: The bill is paid.
        # *   PayUnclear: The bill is not cleared.
        # *   PayUnsettle: The bill is not settled.
        # *   NoSettle: The bill is free of settlement.
        self.status = status
        # The ID of the order corresponding to the bill.
        self.sub_order_id = sub_order_id
        # The billing method. Valid values:
        # 
        # *   Subscription
        # *   PayAsYouGo
        self.subscription_type = subscription_type
        # The tax.
        self.tax = tax
        # The end time of the bill.
        self.usage_end_time = usage_end_time
        # The start time of the bill.
        self.usage_start_time = usage_start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.adjust_amount is not None:
            result['AdjustAmount'] = self.adjust_amount
        if self.after_tax_amount is not None:
            result['AfterTaxAmount'] = self.after_tax_amount
        if self.bill_account_id is not None:
            result['BillAccountID'] = self.bill_account_id
        if self.bill_account_name is not None:
            result['BillAccountName'] = self.bill_account_name
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.cash_amount is not None:
            result['CashAmount'] = self.cash_amount
        if self.commodity_code is not None:
            result['CommodityCode'] = self.commodity_code
        if self.currency is not None:
            result['Currency'] = self.currency
        if self.deducted_by_cash_coupons is not None:
            result['DeductedByCashCoupons'] = self.deducted_by_cash_coupons
        if self.deducted_by_coupons is not None:
            result['DeductedByCoupons'] = self.deducted_by_coupons
        if self.deducted_by_prepaid_card is not None:
            result['DeductedByPrepaidCard'] = self.deducted_by_prepaid_card
        if self.invoice_discount is not None:
            result['InvoiceDiscount'] = self.invoice_discount
        if self.item is not None:
            result['Item'] = self.item
        if self.outstanding_amount is not None:
            result['OutstandingAmount'] = self.outstanding_amount
        if self.owner_id is not None:
            result['OwnerID'] = self.owner_id
        if self.payment_amount is not None:
            result['PaymentAmount'] = self.payment_amount
        if self.payment_currency is not None:
            result['PaymentCurrency'] = self.payment_currency
        if self.payment_time is not None:
            result['PaymentTime'] = self.payment_time
        if self.payment_transaction_id is not None:
            result['PaymentTransactionID'] = self.payment_transaction_id
        if self.pip_code is not None:
            result['PipCode'] = self.pip_code
        if self.pretax_amount is not None:
            result['PretaxAmount'] = self.pretax_amount
        if self.pretax_amount_local is not None:
            result['PretaxAmountLocal'] = self.pretax_amount_local
        if self.pretax_gross_amount is not None:
            result['PretaxGrossAmount'] = self.pretax_gross_amount
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.product_detail is not None:
            result['ProductDetail'] = self.product_detail
        if self.product_name is not None:
            result['ProductName'] = self.product_name
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.record_id is not None:
            result['RecordID'] = self.record_id
        if self.round_down_discount is not None:
            result['RoundDownDiscount'] = self.round_down_discount
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_order_id is not None:
            result['SubOrderId'] = self.sub_order_id
        if self.subscription_type is not None:
            result['SubscriptionType'] = self.subscription_type
        if self.tax is not None:
            result['Tax'] = self.tax
        if self.usage_end_time is not None:
            result['UsageEndTime'] = self.usage_end_time
        if self.usage_start_time is not None:
            result['UsageStartTime'] = self.usage_start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AdjustAmount') is not None:
            self.adjust_amount = m.get('AdjustAmount')
        if m.get('AfterTaxAmount') is not None:
            self.after_tax_amount = m.get('AfterTaxAmount')
        if m.get('BillAccountID') is not None:
            self.bill_account_id = m.get('BillAccountID')
        if m.get('BillAccountName') is not None:
            self.bill_account_name = m.get('BillAccountName')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('CashAmount') is not None:
            self.cash_amount = m.get('CashAmount')
        if m.get('CommodityCode') is not None:
            self.commodity_code = m.get('CommodityCode')
        if m.get('Currency') is not None:
            self.currency = m.get('Currency')
        if m.get('DeductedByCashCoupons') is not None:
            self.deducted_by_cash_coupons = m.get('DeductedByCashCoupons')
        if m.get('DeductedByCoupons') is not None:
            self.deducted_by_coupons = m.get('DeductedByCoupons')
        if m.get('DeductedByPrepaidCard') is not None:
            self.deducted_by_prepaid_card = m.get('DeductedByPrepaidCard')
        if m.get('InvoiceDiscount') is not None:
            self.invoice_discount = m.get('InvoiceDiscount')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('OutstandingAmount') is not None:
            self.outstanding_amount = m.get('OutstandingAmount')
        if m.get('OwnerID') is not None:
            self.owner_id = m.get('OwnerID')
        if m.get('PaymentAmount') is not None:
            self.payment_amount = m.get('PaymentAmount')
        if m.get('PaymentCurrency') is not None:
            self.payment_currency = m.get('PaymentCurrency')
        if m.get('PaymentTime') is not None:
            self.payment_time = m.get('PaymentTime')
        if m.get('PaymentTransactionID') is not None:
            self.payment_transaction_id = m.get('PaymentTransactionID')
        if m.get('PipCode') is not None:
            self.pip_code = m.get('PipCode')
        if m.get('PretaxAmount') is not None:
            self.pretax_amount = m.get('PretaxAmount')
        if m.get('PretaxAmountLocal') is not None:
            self.pretax_amount_local = m.get('PretaxAmountLocal')
        if m.get('PretaxGrossAmount') is not None:
            self.pretax_gross_amount = m.get('PretaxGrossAmount')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ProductDetail') is not None:
            self.product_detail = m.get('ProductDetail')
        if m.get('ProductName') is not None:
            self.product_name = m.get('ProductName')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RecordID') is not None:
            self.record_id = m.get('RecordID')
        if m.get('RoundDownDiscount') is not None:
            self.round_down_discount = m.get('RoundDownDiscount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubOrderId') is not None:
            self.sub_order_id = m.get('SubOrderId')
        if m.get('SubscriptionType') is not None:
            self.subscription_type = m.get('SubscriptionType')
        if m.get('Tax') is not None:
            self.tax = m.get('Tax')
        if m.get('UsageEndTime') is not None:
            self.usage_end_time = m.get('UsageEndTime')
        if m.get('UsageStartTime') is not None:
            self.usage_start_time = m.get('UsageStartTime')
        return self


class QuerySettleBillResponseBodyDataItems(TeaModel):
    def __init__(
        self,
        item: List[QuerySettleBillResponseBodyDataItemsItem] = None,
    ):
        self.item = item

    def validate(self):
        if self.item:
            for k in self.item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Item'] = []
        if self.item is not None:
            for k in self.item:
                result['Item'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.item = []
        if m.get('Item') is not None:
            for k in m.get('Item'):
                temp_model = QuerySettleBillResponseBodyDataItemsItem()
                self.item.append(temp_model.from_map(k))
        return self


class QuerySettleBillResponseBodyData(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        account_name: str = None,
        billing_cycle: str = None,
        items: QuerySettleBillResponseBodyDataItems = None,
        max_results: int = None,
        next_token: str = None,
        total_count: int = None,
    ):
        # The ID of the account.
        self.account_id = account_id
        # The name of the account.
        self.account_name = account_name
        # The billing cycle, in the YYYY-MM format.
        self.billing_cycle = billing_cycle
        # The details of the bills.
        self.items = items
        # The maximum number of entries returned.
        self.max_results = max_results
        # The position where the query stopped. If no value is returned for this parameter, all data has been queried.
        self.next_token = next_token
        # The total number of returned entries.
        self.total_count = total_count

    def validate(self):
        if self.items:
            self.items.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountID'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.billing_cycle is not None:
            result['BillingCycle'] = self.billing_cycle
        if self.items is not None:
            result['Items'] = self.items.to_map()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountID') is not None:
            self.account_id = m.get('AccountID')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('BillingCycle') is not None:
            self.billing_cycle = m.get('BillingCycle')
        if m.get('Items') is not None:
            temp_model = QuerySettleBillResponseBodyDataItems()
            self.items = temp_model.from_map(m['Items'])
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QuerySettleBillResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: QuerySettleBillResponseBodyData = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned.
        self.code = code
        # The data returned.
        self.data = data
        # The