from sanic.errorpages import exception_response
from sanic.handlers import ErrorHandler
from sanic.exceptions import SanicException

from wf_old.workers.web.erorrs.application import ApplicationError


class StatusCodes:
    APPLICATION_CODE = 409
    REPORT_CODE = 501


class ErrorHandlerExt(ErrorHandler):
    def default(self, request, exception):
        """Convert ApplicationError to SanicException"""
        if isinstance(exception, ApplicationError):
            exception = type(exception.__class__.__name__,
                             (SanicException,),
                             {"message": exception.message if exception.message else "",
                              "status_code": StatusCodes.APPLICATION_CODE})()
        else:
            self.log(request, exception)
        fallback = ErrorHandler._get_fallback_value(self, request.app.config)
        return exception_response(
            request,
            exception,
            debug=self.debug,
            base=self.base,
            fallback=fallback,
        )
