import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * CRUDL operations for New Relic Dashboards via the NerdGraph API
 *
 * @schema CfnDashboardsProps
 */
export interface CfnDashboardsProps {
    /**
     * @schema CfnDashboardsProps#AccountID
     */
    readonly accountId?: string;
    /**
     * @schema CfnDashboardsProps#Endpoint
     */
    readonly endpoint?: string;
    /**
     * @schema CfnDashboardsProps#DashboardInput
     */
    readonly dashboardInput: string;
    /**
     * @schema CfnDashboardsProps#APIKey
     */
    readonly apiKey: string;
    /**
     * @schema CfnDashboardsProps#ListQueryFilter
     */
    readonly listQueryFilter?: string;
    /**
     * @schema CfnDashboardsProps#Variables
     */
    readonly variables?: any;
    /**
     * @schema CfnDashboardsProps#Tags
     */
    readonly tags?: any;
}
/**
 * Converts an object of type 'CfnDashboardsProps' to JSON representation.
 */
export declare function toJson_CfnDashboardsProps(obj: CfnDashboardsProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `newrelic::cloudformation::dashboards`
 *
 * @cloudformationResource newrelic::cloudformation::dashboards
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
export declare class CfnDashboards extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "newrelic::cloudformation::dashboards";
    /**
     * Resource props.
     */
    readonly props: CfnDashboardsProps;
    /**
     * Attribute `newrelic::cloudformation::dashboards.Guid`
     * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
     */
    readonly attrGuid: string;
    /**
     * Create a new `newrelic::cloudformation::dashboards`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnDashboardsProps);
}
