# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class VoicemailUserPolicy(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        VoicemailUserPolicy - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'alert_timeout_seconds': 'int',
            'minimum_recording_time_seconds': 'int',
            'maximum_recording_time_seconds': 'int',
            'unavailable_message_uri': 'str',
            'name_prompt_message_uri': 'str',
            'full_message_uri': 'str',
            'pin': 'str',
            'quota_size_bytes': 'int',
            'created_date': 'datetime',
            'modified_date': 'datetime'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'alert_timeout_seconds': 'alertTimeoutSeconds',
            'minimum_recording_time_seconds': 'minimumRecordingTimeSeconds',
            'maximum_recording_time_seconds': 'maximumRecordingTimeSeconds',
            'unavailable_message_uri': 'unavailableMessageUri',
            'name_prompt_message_uri': 'namePromptMessageUri',
            'full_message_uri': 'fullMessageUri',
            'pin': 'pin',
            'quota_size_bytes': 'quotaSizeBytes',
            'created_date': 'createdDate',
            'modified_date': 'modifiedDate'
        }

        self._enabled = False
        self._alert_timeout_seconds = None
        self._minimum_recording_time_seconds = None
        self._maximum_recording_time_seconds = None
        self._unavailable_message_uri = None
        self._name_prompt_message_uri = None
        self._full_message_uri = None
        self._pin = None
        self._quota_size_bytes = None
        self._created_date = None
        self._modified_date = None

    @property
    def enabled(self):
        """
        Gets the enabled of this VoicemailUserPolicy.


        :return: The enabled of this VoicemailUserPolicy.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this VoicemailUserPolicy.


        :param enabled: The enabled of this VoicemailUserPolicy.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def alert_timeout_seconds(self):
        """
        Gets the alert_timeout_seconds of this VoicemailUserPolicy.


        :return: The alert_timeout_seconds of this VoicemailUserPolicy.
        :rtype: int
        """
        return self._alert_timeout_seconds

    @alert_timeout_seconds.setter
    def alert_timeout_seconds(self, alert_timeout_seconds):
        """
        Sets the alert_timeout_seconds of this VoicemailUserPolicy.


        :param alert_timeout_seconds: The alert_timeout_seconds of this VoicemailUserPolicy.
        :type: int
        """
        
        self._alert_timeout_seconds = alert_timeout_seconds

    @property
    def minimum_recording_time_seconds(self):
        """
        Gets the minimum_recording_time_seconds of this VoicemailUserPolicy.


        :return: The minimum_recording_time_seconds of this VoicemailUserPolicy.
        :rtype: int
        """
        return self._minimum_recording_time_seconds

    @minimum_recording_time_seconds.setter
    def minimum_recording_time_seconds(self, minimum_recording_time_seconds):
        """
        Sets the minimum_recording_time_seconds of this VoicemailUserPolicy.


        :param minimum_recording_time_seconds: The minimum_recording_time_seconds of this VoicemailUserPolicy.
        :type: int
        """
        
        self._minimum_recording_time_seconds = minimum_recording_time_seconds

    @property
    def maximum_recording_time_seconds(self):
        """
        Gets the maximum_recording_time_seconds of this VoicemailUserPolicy.


        :return: The maximum_recording_time_seconds of this VoicemailUserPolicy.
        :rtype: int
        """
        return self._maximum_recording_time_seconds

    @maximum_recording_time_seconds.setter
    def maximum_recording_time_seconds(self, maximum_recording_time_seconds):
        """
        Sets the maximum_recording_time_seconds of this VoicemailUserPolicy.


        :param maximum_recording_time_seconds: The maximum_recording_time_seconds of this VoicemailUserPolicy.
        :type: int
        """
        
        self._maximum_recording_time_seconds = maximum_recording_time_seconds

    @property
    def unavailable_message_uri(self):
        """
        Gets the unavailable_message_uri of this VoicemailUserPolicy.


        :return: The unavailable_message_uri of this VoicemailUserPolicy.
        :rtype: str
        """
        return self._unavailable_message_uri

    @unavailable_message_uri.setter
    def unavailable_message_uri(self, unavailable_message_uri):
        """
        Sets the unavailable_message_uri of this VoicemailUserPolicy.


        :param unavailable_message_uri: The unavailable_message_uri of this VoicemailUserPolicy.
        :type: str
        """
        
        self._unavailable_message_uri = unavailable_message_uri

    @property
    def name_prompt_message_uri(self):
        """
        Gets the name_prompt_message_uri of this VoicemailUserPolicy.


        :return: The name_prompt_message_uri of this VoicemailUserPolicy.
        :rtype: str
        """
        return self._name_prompt_message_uri

    @name_prompt_message_uri.setter
    def name_prompt_message_uri(self, name_prompt_message_uri):
        """
        Sets the name_prompt_message_uri of this VoicemailUserPolicy.


        :param name_prompt_message_uri: The name_prompt_message_uri of this VoicemailUserPolicy.
        :type: str
        """
        
        self._name_prompt_message_uri = name_prompt_message_uri

    @property
    def full_message_uri(self):
        """
        Gets the full_message_uri of this VoicemailUserPolicy.


        :return: The full_message_uri of this VoicemailUserPolicy.
        :rtype: str
        """
        return self._full_message_uri

    @full_message_uri.setter
    def full_message_uri(self, full_message_uri):
        """
        Sets the full_message_uri of this VoicemailUserPolicy.


        :param full_message_uri: The full_message_uri of this VoicemailUserPolicy.
        :type: str
        """
        
        self._full_message_uri = full_message_uri

    @property
    def pin(self):
        """
        Gets the pin of this VoicemailUserPolicy.


        :return: The pin of this VoicemailUserPolicy.
        :rtype: str
        """
        return self._pin

    @pin.setter
    def pin(self, pin):
        """
        Sets the pin of this VoicemailUserPolicy.


        :param pin: The pin of this VoicemailUserPolicy.
        :type: str
        """
        
        self._pin = pin

    @property
    def quota_size_bytes(self):
        """
        Gets the quota_size_bytes of this VoicemailUserPolicy.


        :return: The quota_size_bytes of this VoicemailUserPolicy.
        :rtype: int
        """
        return self._quota_size_bytes

    @quota_size_bytes.setter
    def quota_size_bytes(self, quota_size_bytes):
        """
        Sets the quota_size_bytes of this VoicemailUserPolicy.


        :param quota_size_bytes: The quota_size_bytes of this VoicemailUserPolicy.
        :type: int
        """
        
        self._quota_size_bytes = quota_size_bytes

    @property
    def created_date(self):
        """
        Gets the created_date of this VoicemailUserPolicy.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The created_date of this VoicemailUserPolicy.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this VoicemailUserPolicy.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param created_date: The created_date of this VoicemailUserPolicy.
        :type: datetime
        """
        
        self._created_date = created_date

    @property
    def modified_date(self):
        """
        Gets the modified_date of this VoicemailUserPolicy.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The modified_date of this VoicemailUserPolicy.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date):
        """
        Sets the modified_date of this VoicemailUserPolicy.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param modified_date: The modified_date of this VoicemailUserPolicy.
        :type: datetime
        """
        
        self._modified_date = modified_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

