# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class VoicemailOrganizationPolicy(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        VoicemailOrganizationPolicy - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled': 'bool',
            'retention_time_days': 'int',
            'alert_timeout_seconds': 'int',
            'minimum_recording_time_seconds': 'int',
            'maximum_recording_time_seconds': 'int',
            'unavailable_message_uri': 'str',
            'name_prompt_message_uri': 'str',
            'full_message_uri': 'str',
            'compress_silence': 'bool',
            'pin_configuration': 'PINConfiguration',
            'quota_size_bytes': 'int',
            'created_date': 'datetime',
            'modified_date': 'datetime',
            'voicemail_extension': 'str',
            'pin_required': 'bool'
        }

        self.attribute_map = {
            'enabled': 'enabled',
            'retention_time_days': 'retentionTimeDays',
            'alert_timeout_seconds': 'alertTimeoutSeconds',
            'minimum_recording_time_seconds': 'minimumRecordingTimeSeconds',
            'maximum_recording_time_seconds': 'maximumRecordingTimeSeconds',
            'unavailable_message_uri': 'unavailableMessageUri',
            'name_prompt_message_uri': 'namePromptMessageUri',
            'full_message_uri': 'fullMessageUri',
            'compress_silence': 'compressSilence',
            'pin_configuration': 'pinConfiguration',
            'quota_size_bytes': 'quotaSizeBytes',
            'created_date': 'createdDate',
            'modified_date': 'modifiedDate',
            'voicemail_extension': 'voicemailExtension',
            'pin_required': 'pinRequired'
        }

        self._enabled = False
        self._retention_time_days = None
        self._alert_timeout_seconds = None
        self._minimum_recording_time_seconds = None
        self._maximum_recording_time_seconds = None
        self._unavailable_message_uri = None
        self._name_prompt_message_uri = None
        self._full_message_uri = None
        self._compress_silence = False
        self._pin_configuration = None
        self._quota_size_bytes = None
        self._created_date = None
        self._modified_date = None
        self._voicemail_extension = None
        self._pin_required = False

    @property
    def enabled(self):
        """
        Gets the enabled of this VoicemailOrganizationPolicy.


        :return: The enabled of this VoicemailOrganizationPolicy.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this VoicemailOrganizationPolicy.


        :param enabled: The enabled of this VoicemailOrganizationPolicy.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def retention_time_days(self):
        """
        Gets the retention_time_days of this VoicemailOrganizationPolicy.


        :return: The retention_time_days of this VoicemailOrganizationPolicy.
        :rtype: int
        """
        return self._retention_time_days

    @retention_time_days.setter
    def retention_time_days(self, retention_time_days):
        """
        Sets the retention_time_days of this VoicemailOrganizationPolicy.


        :param retention_time_days: The retention_time_days of this VoicemailOrganizationPolicy.
        :type: int
        """
        
        self._retention_time_days = retention_time_days

    @property
    def alert_timeout_seconds(self):
        """
        Gets the alert_timeout_seconds of this VoicemailOrganizationPolicy.


        :return: The alert_timeout_seconds of this VoicemailOrganizationPolicy.
        :rtype: int
        """
        return self._alert_timeout_seconds

    @alert_timeout_seconds.setter
    def alert_timeout_seconds(self, alert_timeout_seconds):
        """
        Sets the alert_timeout_seconds of this VoicemailOrganizationPolicy.


        :param alert_timeout_seconds: The alert_timeout_seconds of this VoicemailOrganizationPolicy.
        :type: int
        """
        
        self._alert_timeout_seconds = alert_timeout_seconds

    @property
    def minimum_recording_time_seconds(self):
        """
        Gets the minimum_recording_time_seconds of this VoicemailOrganizationPolicy.


        :return: The minimum_recording_time_seconds of this VoicemailOrganizationPolicy.
        :rtype: int
        """
        return self._minimum_recording_time_seconds

    @minimum_recording_time_seconds.setter
    def minimum_recording_time_seconds(self, minimum_recording_time_seconds):
        """
        Sets the minimum_recording_time_seconds of this VoicemailOrganizationPolicy.


        :param minimum_recording_time_seconds: The minimum_recording_time_seconds of this VoicemailOrganizationPolicy.
        :type: int
        """
        
        self._minimum_recording_time_seconds = minimum_recording_time_seconds

    @property
    def maximum_recording_time_seconds(self):
        """
        Gets the maximum_recording_time_seconds of this VoicemailOrganizationPolicy.


        :return: The maximum_recording_time_seconds of this VoicemailOrganizationPolicy.
        :rtype: int
        """
        return self._maximum_recording_time_seconds

    @maximum_recording_time_seconds.setter
    def maximum_recording_time_seconds(self, maximum_recording_time_seconds):
        """
        Sets the maximum_recording_time_seconds of this VoicemailOrganizationPolicy.


        :param maximum_recording_time_seconds: The maximum_recording_time_seconds of this VoicemailOrganizationPolicy.
        :type: int
        """
        
        self._maximum_recording_time_seconds = maximum_recording_time_seconds

    @property
    def unavailable_message_uri(self):
        """
        Gets the unavailable_message_uri of this VoicemailOrganizationPolicy.


        :return: The unavailable_message_uri of this VoicemailOrganizationPolicy.
        :rtype: str
        """
        return self._unavailable_message_uri

    @unavailable_message_uri.setter
    def unavailable_message_uri(self, unavailable_message_uri):
        """
        Sets the unavailable_message_uri of this VoicemailOrganizationPolicy.


        :param unavailable_message_uri: The unavailable_message_uri of this VoicemailOrganizationPolicy.
        :type: str
        """
        
        self._unavailable_message_uri = unavailable_message_uri

    @property
    def name_prompt_message_uri(self):
        """
        Gets the name_prompt_message_uri of this VoicemailOrganizationPolicy.


        :return: The name_prompt_message_uri of this VoicemailOrganizationPolicy.
        :rtype: str
        """
        return self._name_prompt_message_uri

    @name_prompt_message_uri.setter
    def name_prompt_message_uri(self, name_prompt_message_uri):
        """
        Sets the name_prompt_message_uri of this VoicemailOrganizationPolicy.


        :param name_prompt_message_uri: The name_prompt_message_uri of this VoicemailOrganizationPolicy.
        :type: str
        """
        
        self._name_prompt_message_uri = name_prompt_message_uri

    @property
    def full_message_uri(self):
        """
        Gets the full_message_uri of this VoicemailOrganizationPolicy.


        :return: The full_message_uri of this VoicemailOrganizationPolicy.
        :rtype: str
        """
        return self._full_message_uri

    @full_message_uri.setter
    def full_message_uri(self, full_message_uri):
        """
        Sets the full_message_uri of this VoicemailOrganizationPolicy.


        :param full_message_uri: The full_message_uri of this VoicemailOrganizationPolicy.
        :type: str
        """
        
        self._full_message_uri = full_message_uri

    @property
    def compress_silence(self):
        """
        Gets the compress_silence of this VoicemailOrganizationPolicy.


        :return: The compress_silence of this VoicemailOrganizationPolicy.
        :rtype: bool
        """
        return self._compress_silence

    @compress_silence.setter
    def compress_silence(self, compress_silence):
        """
        Sets the compress_silence of this VoicemailOrganizationPolicy.


        :param compress_silence: The compress_silence of this VoicemailOrganizationPolicy.
        :type: bool
        """
        
        self._compress_silence = compress_silence

    @property
    def pin_configuration(self):
        """
        Gets the pin_configuration of this VoicemailOrganizationPolicy.


        :return: The pin_configuration of this VoicemailOrganizationPolicy.
        :rtype: PINConfiguration
        """
        return self._pin_configuration

    @pin_configuration.setter
    def pin_configuration(self, pin_configuration):
        """
        Sets the pin_configuration of this VoicemailOrganizationPolicy.


        :param pin_configuration: The pin_configuration of this VoicemailOrganizationPolicy.
        :type: PINConfiguration
        """
        
        self._pin_configuration = pin_configuration

    @property
    def quota_size_bytes(self):
        """
        Gets the quota_size_bytes of this VoicemailOrganizationPolicy.


        :return: The quota_size_bytes of this VoicemailOrganizationPolicy.
        :rtype: int
        """
        return self._quota_size_bytes

    @quota_size_bytes.setter
    def quota_size_bytes(self, quota_size_bytes):
        """
        Sets the quota_size_bytes of this VoicemailOrganizationPolicy.


        :param quota_size_bytes: The quota_size_bytes of this VoicemailOrganizationPolicy.
        :type: int
        """
        
        self._quota_size_bytes = quota_size_bytes

    @property
    def created_date(self):
        """
        Gets the created_date of this VoicemailOrganizationPolicy.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The created_date of this VoicemailOrganizationPolicy.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date):
        """
        Sets the created_date of this VoicemailOrganizationPolicy.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param created_date: The created_date of this VoicemailOrganizationPolicy.
        :type: datetime
        """
        
        self._created_date = created_date

    @property
    def modified_date(self):
        """
        Gets the modified_date of this VoicemailOrganizationPolicy.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The modified_date of this VoicemailOrganizationPolicy.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date):
        """
        Sets the modified_date of this VoicemailOrganizationPolicy.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param modified_date: The modified_date of this VoicemailOrganizationPolicy.
        :type: datetime
        """
        
        self._modified_date = modified_date

    @property
    def voicemail_extension(self):
        """
        Gets the voicemail_extension of this VoicemailOrganizationPolicy.
        The extension for voicemail retrieval.  The default value is *86.

        :return: The voicemail_extension of this VoicemailOrganizationPolicy.
        :rtype: str
        """
        return self._voicemail_extension

    @voicemail_extension.setter
    def voicemail_extension(self, voicemail_extension):
        """
        Sets the voicemail_extension of this VoicemailOrganizationPolicy.
        The extension for voicemail retrieval.  The default value is *86.

        :param voicemail_extension: The voicemail_extension of this VoicemailOrganizationPolicy.
        :type: str
        """
        
        self._voicemail_extension = voicemail_extension

    @property
    def pin_required(self):
        """
        Gets the pin_required of this VoicemailOrganizationPolicy.
        If this is true, a PIN is required when accessing a user's voicemail from a phone.

        :return: The pin_required of this VoicemailOrganizationPolicy.
        :rtype: bool
        """
        return self._pin_required

    @pin_required.setter
    def pin_required(self, pin_required):
        """
        Sets the pin_required of this VoicemailOrganizationPolicy.
        If this is true, a PIN is required when accessing a user's voicemail from a phone.

        :param pin_required: The pin_required of this VoicemailOrganizationPolicy.
        :type: bool
        """
        
        self._pin_required = pin_required

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

