# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Trunk(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Trunk - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'version': 'int',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'modified_by': 'str',
            'created_by': 'str',
            'state': 'str',
            'modified_by_app': 'str',
            'created_by_app': 'str',
            'trunk_type': 'str',
            'edge': 'UriReference',
            'trunk_base': 'UriReference',
            'trunk_metabase': 'UriReference',
            'edge_group': 'UriReference',
            'enabled': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'version': 'version',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'modified_by': 'modifiedBy',
            'created_by': 'createdBy',
            'state': 'state',
            'modified_by_app': 'modifiedByApp',
            'created_by_app': 'createdByApp',
            'trunk_type': 'trunkType',
            'edge': 'edge',
            'trunk_base': 'trunkBase',
            'trunk_metabase': 'trunkMetabase',
            'edge_group': 'edgeGroup',
            'enabled': 'enabled',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._version = None
        self._date_created = None
        self._date_modified = None
        self._modified_by = None
        self._created_by = None
        self._state = None
        self._modified_by_app = None
        self._created_by_app = None
        self._trunk_type = None
        self._edge = None
        self._trunk_base = None
        self._trunk_metabase = None
        self._edge_group = None
        self._enabled = False
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Trunk.
        The globally unique identifier for the object.

        :return: The id of this Trunk.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Trunk.
        The globally unique identifier for the object.

        :param id: The id of this Trunk.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Trunk.


        :return: The name of this Trunk.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Trunk.


        :param name: The name of this Trunk.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this Trunk.


        :return: The description of this Trunk.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Trunk.


        :param description: The description of this Trunk.
        :type: str
        """
        
        self._description = description

    @property
    def version(self):
        """
        Gets the version of this Trunk.


        :return: The version of this Trunk.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this Trunk.


        :param version: The version of this Trunk.
        :type: int
        """
        
        self._version = version

    @property
    def date_created(self):
        """
        Gets the date_created of this Trunk.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_created of this Trunk.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this Trunk.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_created: The date_created of this Trunk.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this Trunk.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date_modified of this Trunk.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this Trunk.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date_modified: The date_modified of this Trunk.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def modified_by(self):
        """
        Gets the modified_by of this Trunk.


        :return: The modified_by of this Trunk.
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Sets the modified_by of this Trunk.


        :param modified_by: The modified_by of this Trunk.
        :type: str
        """
        
        self._modified_by = modified_by

    @property
    def created_by(self):
        """
        Gets the created_by of this Trunk.


        :return: The created_by of this Trunk.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this Trunk.


        :param created_by: The created_by of this Trunk.
        :type: str
        """
        
        self._created_by = created_by

    @property
    def state(self):
        """
        Gets the state of this Trunk.


        :return: The state of this Trunk.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this Trunk.


        :param state: The state of this Trunk.
        :type: str
        """
        allowed_values = ["active", "inactive", "deleted"]
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state`, must be one of {0}"
                .format(allowed_values)
            )

        self._state = state

    @property
    def modified_by_app(self):
        """
        Gets the modified_by_app of this Trunk.


        :return: The modified_by_app of this Trunk.
        :rtype: str
        """
        return self._modified_by_app

    @modified_by_app.setter
    def modified_by_app(self, modified_by_app):
        """
        Sets the modified_by_app of this Trunk.


        :param modified_by_app: The modified_by_app of this Trunk.
        :type: str
        """
        
        self._modified_by_app = modified_by_app

    @property
    def created_by_app(self):
        """
        Gets the created_by_app of this Trunk.


        :return: The created_by_app of this Trunk.
        :rtype: str
        """
        return self._created_by_app

    @created_by_app.setter
    def created_by_app(self, created_by_app):
        """
        Sets the created_by_app of this Trunk.


        :param created_by_app: The created_by_app of this Trunk.
        :type: str
        """
        
        self._created_by_app = created_by_app

    @property
    def trunk_type(self):
        """
        Gets the trunk_type of this Trunk.
        The type of this trunk.

        :return: The trunk_type of this Trunk.
        :rtype: str
        """
        return self._trunk_type

    @trunk_type.setter
    def trunk_type(self, trunk_type):
        """
        Sets the trunk_type of this Trunk.
        The type of this trunk.

        :param trunk_type: The trunk_type of this Trunk.
        :type: str
        """
        allowed_values = ["EXTERNAL", "PHONE", "EDGE"]
        if trunk_type not in allowed_values:
            raise ValueError(
                "Invalid value for `trunk_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._trunk_type = trunk_type

    @property
    def edge(self):
        """
        Gets the edge of this Trunk.
        The Edge using this trunk.

        :return: The edge of this Trunk.
        :rtype: UriReference
        """
        return self._edge

    @edge.setter
    def edge(self, edge):
        """
        Sets the edge of this Trunk.
        The Edge using this trunk.

        :param edge: The edge of this Trunk.
        :type: UriReference
        """
        
        self._edge = edge

    @property
    def trunk_base(self):
        """
        Gets the trunk_base of this Trunk.
        The trunk base configuration used on this trunk.

        :return: The trunk_base of this Trunk.
        :rtype: UriReference
        """
        return self._trunk_base

    @trunk_base.setter
    def trunk_base(self, trunk_base):
        """
        Sets the trunk_base of this Trunk.
        The trunk base configuration used on this trunk.

        :param trunk_base: The trunk_base of this Trunk.
        :type: UriReference
        """
        
        self._trunk_base = trunk_base

    @property
    def trunk_metabase(self):
        """
        Gets the trunk_metabase of this Trunk.
        The metabase used to create this trunk.

        :return: The trunk_metabase of this Trunk.
        :rtype: UriReference
        """
        return self._trunk_metabase

    @trunk_metabase.setter
    def trunk_metabase(self, trunk_metabase):
        """
        Sets the trunk_metabase of this Trunk.
        The metabase used to create this trunk.

        :param trunk_metabase: The trunk_metabase of this Trunk.
        :type: UriReference
        """
        
        self._trunk_metabase = trunk_metabase

    @property
    def edge_group(self):
        """
        Gets the edge_group of this Trunk.
        The edge group associated with this trunk.

        :return: The edge_group of this Trunk.
        :rtype: UriReference
        """
        return self._edge_group

    @edge_group.setter
    def edge_group(self, edge_group):
        """
        Sets the edge_group of this Trunk.
        The edge group associated with this trunk.

        :param edge_group: The edge_group of this Trunk.
        :type: UriReference
        """
        
        self._edge_group = edge_group

    @property
    def enabled(self):
        """
        Gets the enabled of this Trunk.
        True if this trunk is in-service.  This comes from the trunk_enabled property of the referenced trunk base.

        :return: The enabled of this Trunk.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this Trunk.
        True if this trunk is in-service.  This comes from the trunk_enabled property of the referenced trunk base.

        :param enabled: The enabled of this Trunk.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Trunk.
        The URI for this object

        :return: The self_uri of this Trunk.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Trunk.
        The URI for this object

        :param self_uri: The self_uri of this Trunk.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

