# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class RecordingEmailMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        RecordingEmailMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'html_body': 'str',
            'text_body': 'str',
            'id': 'str',
            'to': 'list[EmailAddress]',
            'cc': 'list[EmailAddress]',
            'bcc': 'list[EmailAddress]',
            'pcFrom': 'EmailAddress',
            'subject': 'str',
            'attachments': 'list[EmailAttachment]',
            'time': 'datetime'
        }

        self.attribute_map = {
            'html_body': 'htmlBody',
            'text_body': 'textBody',
            'id': 'id',
            'to': 'to',
            'cc': 'cc',
            'bcc': 'bcc',
            'pcFrom': 'from',
            'subject': 'subject',
            'attachments': 'attachments',
            'time': 'time'
        }

        self._html_body = None
        self._text_body = None
        self._id = None
        self._to = None
        self._cc = None
        self._bcc = None
        self._pcFrom = None
        self._subject = None
        self._attachments = None
        self._time = None

    @property
    def html_body(self):
        """
        Gets the html_body of this RecordingEmailMessage.


        :return: The html_body of this RecordingEmailMessage.
        :rtype: str
        """
        return self._html_body

    @html_body.setter
    def html_body(self, html_body):
        """
        Sets the html_body of this RecordingEmailMessage.


        :param html_body: The html_body of this RecordingEmailMessage.
        :type: str
        """
        
        self._html_body = html_body

    @property
    def text_body(self):
        """
        Gets the text_body of this RecordingEmailMessage.


        :return: The text_body of this RecordingEmailMessage.
        :rtype: str
        """
        return self._text_body

    @text_body.setter
    def text_body(self, text_body):
        """
        Sets the text_body of this RecordingEmailMessage.


        :param text_body: The text_body of this RecordingEmailMessage.
        :type: str
        """
        
        self._text_body = text_body

    @property
    def id(self):
        """
        Gets the id of this RecordingEmailMessage.


        :return: The id of this RecordingEmailMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RecordingEmailMessage.


        :param id: The id of this RecordingEmailMessage.
        :type: str
        """
        
        self._id = id

    @property
    def to(self):
        """
        Gets the to of this RecordingEmailMessage.


        :return: The to of this RecordingEmailMessage.
        :rtype: list[EmailAddress]
        """
        return self._to

    @to.setter
    def to(self, to):
        """
        Sets the to of this RecordingEmailMessage.


        :param to: The to of this RecordingEmailMessage.
        :type: list[EmailAddress]
        """
        
        self._to = to

    @property
    def cc(self):
        """
        Gets the cc of this RecordingEmailMessage.


        :return: The cc of this RecordingEmailMessage.
        :rtype: list[EmailAddress]
        """
        return self._cc

    @cc.setter
    def cc(self, cc):
        """
        Sets the cc of this RecordingEmailMessage.


        :param cc: The cc of this RecordingEmailMessage.
        :type: list[EmailAddress]
        """
        
        self._cc = cc

    @property
    def bcc(self):
        """
        Gets the bcc of this RecordingEmailMessage.


        :return: The bcc of this RecordingEmailMessage.
        :rtype: list[EmailAddress]
        """
        return self._bcc

    @bcc.setter
    def bcc(self, bcc):
        """
        Sets the bcc of this RecordingEmailMessage.


        :param bcc: The bcc of this RecordingEmailMessage.
        :type: list[EmailAddress]
        """
        
        self._bcc = bcc

    @property
    def pcFrom(self):
        """
        Gets the pcFrom of this RecordingEmailMessage.


        :return: The pcFrom of this RecordingEmailMessage.
        :rtype: EmailAddress
        """
        return self._pcFrom

    @pcFrom.setter
    def pcFrom(self, pcFrom):
        """
        Sets the pcFrom of this RecordingEmailMessage.


        :param pcFrom: The pcFrom of this RecordingEmailMessage.
        :type: EmailAddress
        """
        
        self._pcFrom = pcFrom

    @property
    def subject(self):
        """
        Gets the subject of this RecordingEmailMessage.


        :return: The subject of this RecordingEmailMessage.
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """
        Sets the subject of this RecordingEmailMessage.


        :param subject: The subject of this RecordingEmailMessage.
        :type: str
        """
        
        self._subject = subject

    @property
    def attachments(self):
        """
        Gets the attachments of this RecordingEmailMessage.


        :return: The attachments of this RecordingEmailMessage.
        :rtype: list[EmailAttachment]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """
        Sets the attachments of this RecordingEmailMessage.


        :param attachments: The attachments of this RecordingEmailMessage.
        :type: list[EmailAttachment]
        """
        
        self._attachments = attachments

    @property
    def time(self):
        """
        Gets the time of this RecordingEmailMessage.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The time of this RecordingEmailMessage.
        :rtype: datetime
        """
        return self._time

    @time.setter
    def time(self, time):
        """
        Sets the time of this RecordingEmailMessage.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param time: The time of this RecordingEmailMessage.
        :type: datetime
        """
        
        self._time = time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

