# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class QueueUtilizationDiagnostic(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        QueueUtilizationDiagnostic - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'queue': 'UriReference',
            'users_in_queue': 'int',
            'active_users_in_queue': 'int',
            'users_on_queue': 'int',
            'users_not_utilized': 'int',
            'users_on_queue_with_station': 'int',
            'users_on_a_campaign_call': 'int',
            'users_on_different_edge_group': 'int',
            'users_on_a_non_campaign_call': 'int'
        }

        self.attribute_map = {
            'queue': 'queue',
            'users_in_queue': 'usersInQueue',
            'active_users_in_queue': 'activeUsersInQueue',
            'users_on_queue': 'usersOnQueue',
            'users_not_utilized': 'usersNotUtilized',
            'users_on_queue_with_station': 'usersOnQueueWithStation',
            'users_on_a_campaign_call': 'usersOnACampaignCall',
            'users_on_different_edge_group': 'usersOnDifferentEdgeGroup',
            'users_on_a_non_campaign_call': 'usersOnANonCampaignCall'
        }

        self._queue = None
        self._users_in_queue = None
        self._active_users_in_queue = None
        self._users_on_queue = None
        self._users_not_utilized = None
        self._users_on_queue_with_station = None
        self._users_on_a_campaign_call = None
        self._users_on_different_edge_group = None
        self._users_on_a_non_campaign_call = None

    @property
    def queue(self):
        """
        Gets the queue of this QueueUtilizationDiagnostic.
        Identifier of the queue

        :return: The queue of this QueueUtilizationDiagnostic.
        :rtype: UriReference
        """
        return self._queue

    @queue.setter
    def queue(self, queue):
        """
        Sets the queue of this QueueUtilizationDiagnostic.
        Identifier of the queue

        :param queue: The queue of this QueueUtilizationDiagnostic.
        :type: UriReference
        """
        
        self._queue = queue

    @property
    def users_in_queue(self):
        """
        Gets the users_in_queue of this QueueUtilizationDiagnostic.
        The number of users joined to the queue

        :return: The users_in_queue of this QueueUtilizationDiagnostic.
        :rtype: int
        """
        return self._users_in_queue

    @users_in_queue.setter
    def users_in_queue(self, users_in_queue):
        """
        Sets the users_in_queue of this QueueUtilizationDiagnostic.
        The number of users joined to the queue

        :param users_in_queue: The users_in_queue of this QueueUtilizationDiagnostic.
        :type: int
        """
        
        self._users_in_queue = users_in_queue

    @property
    def active_users_in_queue(self):
        """
        Gets the active_users_in_queue of this QueueUtilizationDiagnostic.
        The number of users active on the queue

        :return: The active_users_in_queue of this QueueUtilizationDiagnostic.
        :rtype: int
        """
        return self._active_users_in_queue

    @active_users_in_queue.setter
    def active_users_in_queue(self, active_users_in_queue):
        """
        Sets the active_users_in_queue of this QueueUtilizationDiagnostic.
        The number of users active on the queue

        :param active_users_in_queue: The active_users_in_queue of this QueueUtilizationDiagnostic.
        :type: int
        """
        
        self._active_users_in_queue = active_users_in_queue

    @property
    def users_on_queue(self):
        """
        Gets the users_on_queue of this QueueUtilizationDiagnostic.
        The number of users with a status of on-queue

        :return: The users_on_queue of this QueueUtilizationDiagnostic.
        :rtype: int
        """
        return self._users_on_queue

    @users_on_queue.setter
    def users_on_queue(self, users_on_queue):
        """
        Sets the users_on_queue of this QueueUtilizationDiagnostic.
        The number of users with a status of on-queue

        :param users_on_queue: The users_on_queue of this QueueUtilizationDiagnostic.
        :type: int
        """
        
        self._users_on_queue = users_on_queue

    @property
    def users_not_utilized(self):
        """
        Gets the users_not_utilized of this QueueUtilizationDiagnostic.
        The number of users in the queue currently not engaged

        :return: The users_not_utilized of this QueueUtilizationDiagnostic.
        :rtype: int
        """
        return self._users_not_utilized

    @users_not_utilized.setter
    def users_not_utilized(self, users_not_utilized):
        """
        Sets the users_not_utilized of this QueueUtilizationDiagnostic.
        The number of users in the queue currently not engaged

        :param users_not_utilized: The users_not_utilized of this QueueUtilizationDiagnostic.
        :type: int
        """
        
        self._users_not_utilized = users_not_utilized

    @property
    def users_on_queue_with_station(self):
        """
        Gets the users_on_queue_with_station of this QueueUtilizationDiagnostic.
        The number of users in the queue with a station

        :return: The users_on_queue_with_station of this QueueUtilizationDiagnostic.
        :rtype: int
        """
        return self._users_on_queue_with_station

    @users_on_queue_with_station.setter
    def users_on_queue_with_station(self, users_on_queue_with_station):
        """
        Sets the users_on_queue_with_station of this QueueUtilizationDiagnostic.
        The number of users in the queue with a station

        :param users_on_queue_with_station: The users_on_queue_with_station of this QueueUtilizationDiagnostic.
        :type: int
        """
        
        self._users_on_queue_with_station = users_on_queue_with_station

    @property
    def users_on_a_campaign_call(self):
        """
        Gets the users_on_a_campaign_call of this QueueUtilizationDiagnostic.
        The number of users currently engaged in a campaign call

        :return: The users_on_a_campaign_call of this QueueUtilizationDiagnostic.
        :rtype: int
        """
        return self._users_on_a_campaign_call

    @users_on_a_campaign_call.setter
    def users_on_a_campaign_call(self, users_on_a_campaign_call):
        """
        Sets the users_on_a_campaign_call of this QueueUtilizationDiagnostic.
        The number of users currently engaged in a campaign call

        :param users_on_a_campaign_call: The users_on_a_campaign_call of this QueueUtilizationDiagnostic.
        :type: int
        """
        
        self._users_on_a_campaign_call = users_on_a_campaign_call

    @property
    def users_on_different_edge_group(self):
        """
        Gets the users_on_different_edge_group of this QueueUtilizationDiagnostic.
        The number of users whose station is homed to an edge different from the campaign

        :return: The users_on_different_edge_group of this QueueUtilizationDiagnostic.
        :rtype: int
        """
        return self._users_on_different_edge_group

    @users_on_different_edge_group.setter
    def users_on_different_edge_group(self, users_on_different_edge_group):
        """
        Sets the users_on_different_edge_group of this QueueUtilizationDiagnostic.
        The number of users whose station is homed to an edge different from the campaign

        :param users_on_different_edge_group: The users_on_different_edge_group of this QueueUtilizationDiagnostic.
        :type: int
        """
        
        self._users_on_different_edge_group = users_on_different_edge_group

    @property
    def users_on_a_non_campaign_call(self):
        """
        Gets the users_on_a_non_campaign_call of this QueueUtilizationDiagnostic.
        The number of users currently engaged in a communication that is not part of the campaign

        :return: The users_on_a_non_campaign_call of this QueueUtilizationDiagnostic.
        :rtype: int
        """
        return self._users_on_a_non_campaign_call

    @users_on_a_non_campaign_call.setter
    def users_on_a_non_campaign_call(self, users_on_a_non_campaign_call):
        """
        Sets the users_on_a_non_campaign_call of this QueueUtilizationDiagnostic.
        The number of users currently engaged in a communication that is not part of the campaign

        :param users_on_a_non_campaign_call: The users_on_a_non_campaign_call of this QueueUtilizationDiagnostic.
        :type: int
        """
        
        self._users_on_a_non_campaign_call = users_on_a_non_campaign_call

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

