# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class QueueMember(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        QueueMember - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'user': 'User',
            'ring_number': 'int',
            'joined': 'bool',
            'member_by': 'str',
            'routing_status': 'RoutingStatus',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'user': 'user',
            'ring_number': 'ringNumber',
            'joined': 'joined',
            'member_by': 'memberBy',
            'routing_status': 'routingStatus',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._user = None
        self._ring_number = None
        self._joined = False
        self._member_by = None
        self._routing_status = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this QueueMember.
        The globally unique identifier for the object.

        :return: The id of this QueueMember.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this QueueMember.
        The globally unique identifier for the object.

        :param id: The id of this QueueMember.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this QueueMember.


        :return: The name of this QueueMember.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this QueueMember.


        :param name: The name of this QueueMember.
        :type: str
        """
        
        self._name = name

    @property
    def user(self):
        """
        Gets the user of this QueueMember.


        :return: The user of this QueueMember.
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this QueueMember.


        :param user: The user of this QueueMember.
        :type: User
        """
        
        self._user = user

    @property
    def ring_number(self):
        """
        Gets the ring_number of this QueueMember.


        :return: The ring_number of this QueueMember.
        :rtype: int
        """
        return self._ring_number

    @ring_number.setter
    def ring_number(self, ring_number):
        """
        Sets the ring_number of this QueueMember.


        :param ring_number: The ring_number of this QueueMember.
        :type: int
        """
        
        self._ring_number = ring_number

    @property
    def joined(self):
        """
        Gets the joined of this QueueMember.


        :return: The joined of this QueueMember.
        :rtype: bool
        """
        return self._joined

    @joined.setter
    def joined(self, joined):
        """
        Sets the joined of this QueueMember.


        :param joined: The joined of this QueueMember.
        :type: bool
        """
        
        self._joined = joined

    @property
    def member_by(self):
        """
        Gets the member_by of this QueueMember.


        :return: The member_by of this QueueMember.
        :rtype: str
        """
        return self._member_by

    @member_by.setter
    def member_by(self, member_by):
        """
        Sets the member_by of this QueueMember.


        :param member_by: The member_by of this QueueMember.
        :type: str
        """
        
        self._member_by = member_by

    @property
    def routing_status(self):
        """
        Gets the routing_status of this QueueMember.


        :return: The routing_status of this QueueMember.
        :rtype: RoutingStatus
        """
        return self._routing_status

    @routing_status.setter
    def routing_status(self, routing_status):
        """
        Sets the routing_status of this QueueMember.


        :param routing_status: The routing_status of this QueueMember.
        :type: RoutingStatus
        """
        
        self._routing_status = routing_status

    @property
    def self_uri(self):
        """
        Gets the self_uri of this QueueMember.
        The URI for this object

        :return: The self_uri of this QueueMember.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this QueueMember.
        The URI for this object

        :param self_uri: The self_uri of this QueueMember.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

