# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Organization(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Organization - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'third_party_org_id': 'str',
            'third_party_org_name': 'str',
            'third_party_uri': 'str',
            'domain': 'str',
            'version': 'int',
            'state': 'str',
            'default_site_id': 'str',
            'deletable': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'third_party_org_id': 'thirdPartyOrgId',
            'third_party_org_name': 'thirdPartyOrgName',
            'third_party_uri': 'thirdPartyURI',
            'domain': 'domain',
            'version': 'version',
            'state': 'state',
            'default_site_id': 'defaultSiteId',
            'deletable': 'deletable',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._third_party_org_id = None
        self._third_party_org_name = None
        self._third_party_uri = None
        self._domain = None
        self._version = None
        self._state = None
        self._default_site_id = None
        self._deletable = False
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Organization.
        The globally unique identifier for the object.

        :return: The id of this Organization.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Organization.
        The globally unique identifier for the object.

        :param id: The id of this Organization.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Organization.


        :return: The name of this Organization.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Organization.


        :param name: The name of this Organization.
        :type: str
        """
        
        self._name = name

    @property
    def third_party_org_id(self):
        """
        Gets the third_party_org_id of this Organization.


        :return: The third_party_org_id of this Organization.
        :rtype: str
        """
        return self._third_party_org_id

    @third_party_org_id.setter
    def third_party_org_id(self, third_party_org_id):
        """
        Sets the third_party_org_id of this Organization.


        :param third_party_org_id: The third_party_org_id of this Organization.
        :type: str
        """
        
        self._third_party_org_id = third_party_org_id

    @property
    def third_party_org_name(self):
        """
        Gets the third_party_org_name of this Organization.


        :return: The third_party_org_name of this Organization.
        :rtype: str
        """
        return self._third_party_org_name

    @third_party_org_name.setter
    def third_party_org_name(self, third_party_org_name):
        """
        Sets the third_party_org_name of this Organization.


        :param third_party_org_name: The third_party_org_name of this Organization.
        :type: str
        """
        
        self._third_party_org_name = third_party_org_name

    @property
    def third_party_uri(self):
        """
        Gets the third_party_uri of this Organization.


        :return: The third_party_uri of this Organization.
        :rtype: str
        """
        return self._third_party_uri

    @third_party_uri.setter
    def third_party_uri(self, third_party_uri):
        """
        Sets the third_party_uri of this Organization.


        :param third_party_uri: The third_party_uri of this Organization.
        :type: str
        """
        
        self._third_party_uri = third_party_uri

    @property
    def domain(self):
        """
        Gets the domain of this Organization.


        :return: The domain of this Organization.
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """
        Sets the domain of this Organization.


        :param domain: The domain of this Organization.
        :type: str
        """
        
        self._domain = domain

    @property
    def version(self):
        """
        Gets the version of this Organization.
        The current version of the organization.

        :return: The version of this Organization.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this Organization.
        The current version of the organization.

        :param version: The version of this Organization.
        :type: int
        """
        
        self._version = version

    @property
    def state(self):
        """
        Gets the state of this Organization.


        :return: The state of this Organization.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this Organization.


        :param state: The state of this Organization.
        :type: str
        """
        allowed_values = ["active", "inactive", "deleted"]
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state`, must be one of {0}"
                .format(allowed_values)
            )

        self._state = state

    @property
    def default_site_id(self):
        """
        Gets the default_site_id of this Organization.


        :return: The default_site_id of this Organization.
        :rtype: str
        """
        return self._default_site_id

    @default_site_id.setter
    def default_site_id(self, default_site_id):
        """
        Sets the default_site_id of this Organization.


        :param default_site_id: The default_site_id of this Organization.
        :type: str
        """
        
        self._default_site_id = default_site_id

    @property
    def deletable(self):
        """
        Gets the deletable of this Organization.


        :return: The deletable of this Organization.
        :rtype: bool
        """
        return self._deletable

    @deletable.setter
    def deletable(self, deletable):
        """
        Sets the deletable of this Organization.


        :param deletable: The deletable of this Organization.
        :type: bool
        """
        
        self._deletable = deletable

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Organization.
        The URI for this object

        :return: The self_uri of this Organization.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Organization.
        The URI for this object

        :param self_uri: The self_uri of this Organization.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

