# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ObservationDataContainer(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ObservationDataContainer - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'group': 'dict(str, str)',
            'data': 'list[AggregateMetricData]'
        }

        self.attribute_map = {
            'group': 'group',
            'data': 'data'
        }

        self._group = None
        self._data = None

    @property
    def group(self):
        """
        Gets the group of this ObservationDataContainer.
        A mapping from dimension to value

        :return: The group of this ObservationDataContainer.
        :rtype: dict(str, str)
        """
        return self._group

    @group.setter
    def group(self, group):
        """
        Sets the group of this ObservationDataContainer.
        A mapping from dimension to value

        :param group: The group of this ObservationDataContainer.
        :type: dict(str, str)
        """
        
        self._group = group

    @property
    def data(self):
        """
        Gets the data of this ObservationDataContainer.


        :return: The data of this ObservationDataContainer.
        :rtype: list[AggregateMetricData]
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this ObservationDataContainer.


        :param data: The data of this ObservationDataContainer.
        :type: list[AggregateMetricData]
        """
        
        self._data = data

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

