# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Location(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Location - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'address': 'LocationAddress',
            'address_verified': 'bool',
            'emergency_number': 'LocationEmergencyNumber',
            'state': 'str',
            'version': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'address': 'address',
            'address_verified': 'addressVerified',
            'emergency_number': 'emergencyNumber',
            'state': 'state',
            'version': 'version',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._address = None
        self._address_verified = False
        self._emergency_number = None
        self._state = None
        self._version = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Location.
        The globally unique identifier for the object.

        :return: The id of this Location.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Location.
        The globally unique identifier for the object.

        :param id: The id of this Location.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Location.


        :return: The name of this Location.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Location.


        :param name: The name of this Location.
        :type: str
        """
        
        self._name = name

    @property
    def address(self):
        """
        Gets the address of this Location.


        :return: The address of this Location.
        :rtype: LocationAddress
        """
        return self._address

    @address.setter
    def address(self, address):
        """
        Sets the address of this Location.


        :param address: The address of this Location.
        :type: LocationAddress
        """
        
        self._address = address

    @property
    def address_verified(self):
        """
        Gets the address_verified of this Location.


        :return: The address_verified of this Location.
        :rtype: bool
        """
        return self._address_verified

    @address_verified.setter
    def address_verified(self, address_verified):
        """
        Sets the address_verified of this Location.


        :param address_verified: The address_verified of this Location.
        :type: bool
        """
        
        self._address_verified = address_verified

    @property
    def emergency_number(self):
        """
        Gets the emergency_number of this Location.


        :return: The emergency_number of this Location.
        :rtype: LocationEmergencyNumber
        """
        return self._emergency_number

    @emergency_number.setter
    def emergency_number(self, emergency_number):
        """
        Sets the emergency_number of this Location.


        :param emergency_number: The emergency_number of this Location.
        :type: LocationEmergencyNumber
        """
        
        self._emergency_number = emergency_number

    @property
    def state(self):
        """
        Gets the state of this Location.
        Current activity status of the location.

        :return: The state of this Location.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this Location.
        Current activity status of the location.

        :param state: The state of this Location.
        :type: str
        """
        allowed_values = ["active", "deleted"]
        if state not in allowed_values:
            raise ValueError(
                "Invalid value for `state`, must be one of {0}"
                .format(allowed_values)
            )

        self._state = state

    @property
    def version(self):
        """
        Gets the version of this Location.


        :return: The version of this Location.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this Location.


        :param version: The version of this Location.
        :type: int
        """
        
        self._version = version

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Location.
        The URI for this object

        :return: The self_uri of this Location.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Location.
        The URI for this object

        :param self_uri: The self_uri of this Location.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

