# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class KeywordSet(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        KeywordSet - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'queue': 'Queue',
            'queues': 'list[Queue]',
            'language': 'str',
            'agents': 'list[User]',
            'keywords': 'list[Keyword]',
            'participant_purposes': 'list[str]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'queue': 'queue',
            'queues': 'queues',
            'language': 'language',
            'agents': 'agents',
            'keywords': 'keywords',
            'participant_purposes': 'participantPurposes',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._queue = None
        self._queues = None
        self._language = None
        self._agents = None
        self._keywords = None
        self._participant_purposes = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this KeywordSet.
        The globally unique identifier for the object.

        :return: The id of this KeywordSet.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this KeywordSet.
        The globally unique identifier for the object.

        :param id: The id of this KeywordSet.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this KeywordSet.


        :return: The name of this KeywordSet.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this KeywordSet.


        :param name: The name of this KeywordSet.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this KeywordSet.


        :return: The description of this KeywordSet.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this KeywordSet.


        :param description: The description of this KeywordSet.
        :type: str
        """
        
        self._description = description

    @property
    def queue(self):
        """
        Gets the queue of this KeywordSet.


        :return: The queue of this KeywordSet.
        :rtype: Queue
        """
        return self._queue

    @queue.setter
    def queue(self, queue):
        """
        Sets the queue of this KeywordSet.


        :param queue: The queue of this KeywordSet.
        :type: Queue
        """
        
        self._queue = queue

    @property
    def queues(self):
        """
        Gets the queues of this KeywordSet.


        :return: The queues of this KeywordSet.
        :rtype: list[Queue]
        """
        return self._queues

    @queues.setter
    def queues(self, queues):
        """
        Sets the queues of this KeywordSet.


        :param queues: The queues of this KeywordSet.
        :type: list[Queue]
        """
        
        self._queues = queues

    @property
    def language(self):
        """
        Gets the language of this KeywordSet.


        :return: The language of this KeywordSet.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """
        Sets the language of this KeywordSet.


        :param language: The language of this KeywordSet.
        :type: str
        """
        
        self._language = language

    @property
    def agents(self):
        """
        Gets the agents of this KeywordSet.


        :return: The agents of this KeywordSet.
        :rtype: list[User]
        """
        return self._agents

    @agents.setter
    def agents(self, agents):
        """
        Sets the agents of this KeywordSet.


        :param agents: The agents of this KeywordSet.
        :type: list[User]
        """
        
        self._agents = agents

    @property
    def keywords(self):
        """
        Gets the keywords of this KeywordSet.


        :return: The keywords of this KeywordSet.
        :rtype: list[Keyword]
        """
        return self._keywords

    @keywords.setter
    def keywords(self, keywords):
        """
        Sets the keywords of this KeywordSet.


        :param keywords: The keywords of this KeywordSet.
        :type: list[Keyword]
        """
        
        self._keywords = keywords

    @property
    def participant_purposes(self):
        """
        Gets the participant_purposes of this KeywordSet.


        :return: The participant_purposes of this KeywordSet.
        :rtype: list[str]
        """
        return self._participant_purposes

    @participant_purposes.setter
    def participant_purposes(self, participant_purposes):
        """
        Sets the participant_purposes of this KeywordSet.


        :param participant_purposes: The participant_purposes of this KeywordSet.
        :type: list[str]
        """
        
        self._participant_purposes = participant_purposes

    @property
    def self_uri(self):
        """
        Gets the self_uri of this KeywordSet.
        The URI for this object

        :return: The self_uri of this KeywordSet.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this KeywordSet.
        The URI for this object

        :param self_uri: The self_uri of this KeywordSet.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

