# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class EdgeLine(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        EdgeLine - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'schema': 'UriReference',
            'properties': 'dict(str, object)',
            'edge': 'Edge',
            'edge_group': 'EdgeGroup',
            'line_type': 'str',
            'endpoint': 'Endpoint',
            'ip_address': 'str',
            'logical_interface_id': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'schema': 'schema',
            'properties': 'properties',
            'edge': 'edge',
            'edge_group': 'edgeGroup',
            'line_type': 'lineType',
            'endpoint': 'endpoint',
            'ip_address': 'ipAddress',
            'logical_interface_id': 'logicalInterfaceId',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._schema = None
        self._properties = None
        self._edge = None
        self._edge_group = None
        self._line_type = None
        self._endpoint = None
        self._ip_address = None
        self._logical_interface_id = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this EdgeLine.
        The globally unique identifier for the object.

        :return: The id of this EdgeLine.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this EdgeLine.
        The globally unique identifier for the object.

        :param id: The id of this EdgeLine.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this EdgeLine.


        :return: The name of this EdgeLine.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EdgeLine.


        :param name: The name of this EdgeLine.
        :type: str
        """
        
        self._name = name

    @property
    def schema(self):
        """
        Gets the schema of this EdgeLine.


        :return: The schema of this EdgeLine.
        :rtype: UriReference
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """
        Sets the schema of this EdgeLine.


        :param schema: The schema of this EdgeLine.
        :type: UriReference
        """
        
        self._schema = schema

    @property
    def properties(self):
        """
        Gets the properties of this EdgeLine.


        :return: The properties of this EdgeLine.
        :rtype: dict(str, object)
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this EdgeLine.


        :param properties: The properties of this EdgeLine.
        :type: dict(str, object)
        """
        
        self._properties = properties

    @property
    def edge(self):
        """
        Gets the edge of this EdgeLine.


        :return: The edge of this EdgeLine.
        :rtype: Edge
        """
        return self._edge

    @edge.setter
    def edge(self, edge):
        """
        Sets the edge of this EdgeLine.


        :param edge: The edge of this EdgeLine.
        :type: Edge
        """
        
        self._edge = edge

    @property
    def edge_group(self):
        """
        Gets the edge_group of this EdgeLine.


        :return: The edge_group of this EdgeLine.
        :rtype: EdgeGroup
        """
        return self._edge_group

    @edge_group.setter
    def edge_group(self, edge_group):
        """
        Sets the edge_group of this EdgeLine.


        :param edge_group: The edge_group of this EdgeLine.
        :type: EdgeGroup
        """
        
        self._edge_group = edge_group

    @property
    def line_type(self):
        """
        Gets the line_type of this EdgeLine.


        :return: The line_type of this EdgeLine.
        :rtype: str
        """
        return self._line_type

    @line_type.setter
    def line_type(self, line_type):
        """
        Sets the line_type of this EdgeLine.


        :param line_type: The line_type of this EdgeLine.
        :type: str
        """
        allowed_values = ["TIE", "NETWORK", "TRUNK", "STATION"]
        if line_type not in allowed_values:
            raise ValueError(
                "Invalid value for `line_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._line_type = line_type

    @property
    def endpoint(self):
        """
        Gets the endpoint of this EdgeLine.


        :return: The endpoint of this EdgeLine.
        :rtype: Endpoint
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """
        Sets the endpoint of this EdgeLine.


        :param endpoint: The endpoint of this EdgeLine.
        :type: Endpoint
        """
        
        self._endpoint = endpoint

    @property
    def ip_address(self):
        """
        Gets the ip_address of this EdgeLine.


        :return: The ip_address of this EdgeLine.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address):
        """
        Sets the ip_address of this EdgeLine.


        :param ip_address: The ip_address of this EdgeLine.
        :type: str
        """
        
        self._ip_address = ip_address

    @property
    def logical_interface_id(self):
        """
        Gets the logical_interface_id of this EdgeLine.


        :return: The logical_interface_id of this EdgeLine.
        :rtype: str
        """
        return self._logical_interface_id

    @logical_interface_id.setter
    def logical_interface_id(self, logical_interface_id):
        """
        Sets the logical_interface_id of this EdgeLine.


        :param logical_interface_id: The logical_interface_id of this EdgeLine.
        :type: str
        """
        
        self._logical_interface_id = logical_interface_id

    @property
    def self_uri(self):
        """
        Gets the self_uri of this EdgeLine.
        The URI for this object

        :return: The self_uri of this EdgeLine.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this EdgeLine.
        The URI for this object

        :param self_uri: The self_uri of this EdgeLine.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

