# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class Contact(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Contact - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'address': 'str',
            'display': 'str',
            'media_type': 'str',
            'type': 'str'
        }

        self.attribute_map = {
            'address': 'address',
            'display': 'display',
            'media_type': 'mediaType',
            'type': 'type'
        }

        self._address = None
        self._display = None
        self._media_type = None
        self._type = None

    @property
    def address(self):
        """
        Gets the address of this Contact.
        Email address or phone number for this contact type

        :return: The address of this Contact.
        :rtype: str
        """
        return self._address

    @address.setter
    def address(self, address):
        """
        Sets the address of this Contact.
        Email address or phone number for this contact type

        :param address: The address of this Contact.
        :type: str
        """
        
        self._address = address

    @property
    def display(self):
        """
        Gets the display of this Contact.
        Formatted version of the address property

        :return: The display of this Contact.
        :rtype: str
        """
        return self._display

    @display.setter
    def display(self, display):
        """
        Sets the display of this Contact.
        Formatted version of the address property

        :param display: The display of this Contact.
        :type: str
        """
        
        self._display = display

    @property
    def media_type(self):
        """
        Gets the media_type of this Contact.


        :return: The media_type of this Contact.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type):
        """
        Sets the media_type of this Contact.


        :param media_type: The media_type of this Contact.
        :type: str
        """
        allowed_values = ["PHONE", "EMAIL", "SMS"]
        if media_type not in allowed_values:
            raise ValueError(
                "Invalid value for `media_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._media_type = media_type

    @property
    def type(self):
        """
        Gets the type of this Contact.


        :return: The type of this Contact.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Contact.


        :param type: The type of this Contact.
        :type: str
        """
        allowed_values = ["PRIMARY", "WORK", "WORK2", "WORK3", "WORK4", "HOME", "MOBILE", "MAIN"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

