# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class ChatMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ChatMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'body': 'str',
            'id': 'str',
            'to': 'str',
            'pcFrom': 'str',
            'utc': 'str',
            'chat': 'str',
            'message': 'str',
            'type': 'str',
            'user': 'ChatMessageUser'
        }

        self.attribute_map = {
            'body': 'body',
            'id': 'id',
            'to': 'to',
            'pcFrom': 'from',
            'utc': 'utc',
            'chat': 'chat',
            'message': 'message',
            'type': 'type',
            'user': 'user'
        }

        self._body = None
        self._id = None
        self._to = None
        self._pcFrom = None
        self._utc = None
        self._chat = None
        self._message = None
        self._type = None
        self._user = None

    @property
    def body(self):
        """
        Gets the body of this ChatMessage.


        :return: The body of this ChatMessage.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this ChatMessage.


        :param body: The body of this ChatMessage.
        :type: str
        """
        
        self._body = body

    @property
    def id(self):
        """
        Gets the id of this ChatMessage.


        :return: The id of this ChatMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ChatMessage.


        :param id: The id of this ChatMessage.
        :type: str
        """
        
        self._id = id

    @property
    def to(self):
        """
        Gets the to of this ChatMessage.


        :return: The to of this ChatMessage.
        :rtype: str
        """
        return self._to

    @to.setter
    def to(self, to):
        """
        Sets the to of this ChatMessage.


        :param to: The to of this ChatMessage.
        :type: str
        """
        
        self._to = to

    @property
    def pcFrom(self):
        """
        Gets the pcFrom of this ChatMessage.


        :return: The pcFrom of this ChatMessage.
        :rtype: str
        """
        return self._pcFrom

    @pcFrom.setter
    def pcFrom(self, pcFrom):
        """
        Sets the pcFrom of this ChatMessage.


        :param pcFrom: The pcFrom of this ChatMessage.
        :type: str
        """
        
        self._pcFrom = pcFrom

    @property
    def utc(self):
        """
        Gets the utc of this ChatMessage.


        :return: The utc of this ChatMessage.
        :rtype: str
        """
        return self._utc

    @utc.setter
    def utc(self, utc):
        """
        Sets the utc of this ChatMessage.


        :param utc: The utc of this ChatMessage.
        :type: str
        """
        
        self._utc = utc

    @property
    def chat(self):
        """
        Gets the chat of this ChatMessage.


        :return: The chat of this ChatMessage.
        :rtype: str
        """
        return self._chat

    @chat.setter
    def chat(self, chat):
        """
        Sets the chat of this ChatMessage.


        :param chat: The chat of this ChatMessage.
        :type: str
        """
        
        self._chat = chat

    @property
    def message(self):
        """
        Gets the message of this ChatMessage.


        :return: The message of this ChatMessage.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this ChatMessage.


        :param message: The message of this ChatMessage.
        :type: str
        """
        
        self._message = message

    @property
    def type(self):
        """
        Gets the type of this ChatMessage.


        :return: The type of this ChatMessage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ChatMessage.


        :param type: The type of this ChatMessage.
        :type: str
        """
        
        self._type = type

    @property
    def user(self):
        """
        Gets the user of this ChatMessage.


        :return: The user of this ChatMessage.
        :rtype: ChatMessageUser
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this ChatMessage.


        :param user: The user of this ChatMessage.
        :type: ChatMessageUser
        """
        
        self._user = user

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

