# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class AnalyticsQueryPredicate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AnalyticsQueryPredicate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'dimension': 'str',
            'property_type': 'str',
            'pcProperty': 'str',
            'metric': 'str',
            'operator': 'str',
            'value': 'str',
            'range': 'NumericRange'
        }

        self.attribute_map = {
            'type': 'type',
            'dimension': 'dimension',
            'property_type': 'propertyType',
            'pcProperty': 'property',
            'metric': 'metric',
            'operator': 'operator',
            'value': 'value',
            'range': 'range'
        }

        self._type = None
        self._dimension = None
        self._property_type = None
        self._pcProperty = None
        self._metric = None
        self._operator = None
        self._value = None
        self._range = None

    @property
    def type(self):
        """
        Gets the type of this AnalyticsQueryPredicate.
        Optional type, can usually be inferred

        :return: The type of this AnalyticsQueryPredicate.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this AnalyticsQueryPredicate.
        Optional type, can usually be inferred

        :param type: The type of this AnalyticsQueryPredicate.
        :type: str
        """
        allowed_values = ["dimension", "property", "metric"]
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type`, must be one of {0}"
                .format(allowed_values)
            )

        self._type = type

    @property
    def dimension(self):
        """
        Gets the dimension of this AnalyticsQueryPredicate.
        Left hand side for dimension predicates

        :return: The dimension of this AnalyticsQueryPredicate.
        :rtype: str
        """
        return self._dimension

    @dimension.setter
    def dimension(self, dimension):
        """
        Sets the dimension of this AnalyticsQueryPredicate.
        Left hand side for dimension predicates

        :param dimension: The dimension of this AnalyticsQueryPredicate.
        :type: str
        """
        allowed_values = ["conversationId", "sessionId", "mediaType", "queueId", "userId", "participantId", "participantName", "direction", "wrapUpCode", "wrapUpNote", "interactionType", "requestedRoutingSkillId", "requestedLanguageId", "purpose", "participantType", "segmentType", "disconnectType", "errorCode", "stationId", "edgeId", "dnis", "ani", "outboundCampaignId", "outboundContactId", "outboundContactListId", "monitoredParticipantId", "sourceSessionId", "destinationSessionId", "sourceConversationId", "destinationConversationId", "remoteNameDisplayable", "sipResponseCode", "q850ResponseCode", "conference", "groupId", "roomId", "addressFrom", "addressTo", "peerId", "scriptId", "evaluationId", "evaluatorId", "contextId", "formId", "formName", "eventTime"]
        if dimension not in allowed_values:
            raise ValueError(
                "Invalid value for `dimension`, must be one of {0}"
                .format(allowed_values)
            )

        self._dimension = dimension

    @property
    def property_type(self):
        """
        Gets the property_type of this AnalyticsQueryPredicate.
        Left hand side for property predicates

        :return: The property_type of this AnalyticsQueryPredicate.
        :rtype: str
        """
        return self._property_type

    @property_type.setter
    def property_type(self, property_type):
        """
        Sets the property_type of this AnalyticsQueryPredicate.
        Left hand side for property predicates

        :param property_type: The property_type of this AnalyticsQueryPredicate.
        :type: str
        """
        allowed_values = ["bool", "integer", "real", "date", "string", "uuid"]
        if property_type not in allowed_values:
            raise ValueError(
                "Invalid value for `property_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._property_type = property_type

    @property
    def pcProperty(self):
        """
        Gets the pcProperty of this AnalyticsQueryPredicate.
        Left hand side for property predicates

        :return: The pcProperty of this AnalyticsQueryPredicate.
        :rtype: str
        """
        return self._pcProperty

    @pcProperty.setter
    def pcProperty(self, pcProperty):
        """
        Sets the pcProperty of this AnalyticsQueryPredicate.
        Left hand side for property predicates

        :param pcProperty: The pcProperty of this AnalyticsQueryPredicate.
        :type: str
        """
        
        self._pcProperty = pcProperty

    @property
    def metric(self):
        """
        Gets the metric of this AnalyticsQueryPredicate.
        Left hand side for metric predicates

        :return: The metric of this AnalyticsQueryPredicate.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric):
        """
        Sets the metric of this AnalyticsQueryPredicate.
        Left hand side for metric predicates

        :param metric: The metric of this AnalyticsQueryPredicate.
        :type: str
        """
        allowed_values = ["tSegmentDuration", "oTotalCriticalScore", "oTotalScore", "nEvaluations", "tAbandon", "tIvr", "tAnswered", "tAcd", "tTalk", "tHeld", "tTalkComplete", "tHeldComplete", "tAcw", "tHandle", "tWait", "tAgentRoutingStatus", "tOrganizationPresence", "tSystemPresence", "tUserResponseTime", "tAgentResponseTime", "nOffered", "nOverSla", "nTransferred", "nOutboundAttempted", "nOutboundConnected", "nOutboundAbandoned", "nError", "oServiceTarget", "oServiceLevel", "tActive", "tInactive", "oActiveUsers", "oMemberUsers", "oActiveQueues", "oMemberQueues", "oInteracting", "oWaiting", "oOnQueueUsers", "oOffQueueUsers"]
        if metric not in allowed_values:
            raise ValueError(
                "Invalid value for `metric`, must be one of {0}"
                .format(allowed_values)
            )

        self._metric = metric

    @property
    def operator(self):
        """
        Gets the operator of this AnalyticsQueryPredicate.
        Optional operator, default is matches

        :return: The operator of this AnalyticsQueryPredicate.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this AnalyticsQueryPredicate.
        Optional operator, default is matches

        :param operator: The operator of this AnalyticsQueryPredicate.
        :type: str
        """
        allowed_values = ["matches", "exists", "notExists"]
        if operator not in allowed_values:
            raise ValueError(
                "Invalid value for `operator`, must be one of {0}"
                .format(allowed_values)
            )

        self._operator = operator

    @property
    def value(self):
        """
        Gets the value of this AnalyticsQueryPredicate.
        Right hand side for dimension, property, or metric predicates

        :return: The value of this AnalyticsQueryPredicate.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this AnalyticsQueryPredicate.
        Right hand side for dimension, property, or metric predicates

        :param value: The value of this AnalyticsQueryPredicate.
        :type: str
        """
        
        self._value = value

    @property
    def range(self):
        """
        Gets the range of this AnalyticsQueryPredicate.
        Right hand side for property or metric predicates

        :return: The range of this AnalyticsQueryPredicate.
        :rtype: NumericRange
        """
        return self._range

    @range.setter
    def range(self, range):
        """
        Sets the range of this AnalyticsQueryPredicate.
        Right hand side for property or metric predicates

        :param range: The range of this AnalyticsQueryPredicate.
        :type: NumericRange
        """
        
        self._range = range

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

