# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class AnalyticsProperty(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AnalyticsProperty - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'property_type': 'str',
            'pcProperty': 'str',
            'value': 'str'
        }

        self.attribute_map = {
            'property_type': 'propertyType',
            'pcProperty': 'property',
            'value': 'value'
        }

        self._property_type = None
        self._pcProperty = None
        self._value = None

    @property
    def property_type(self):
        """
        Gets the property_type of this AnalyticsProperty.
        Indicates what the data type is (e.g. integer vs string) and therefore how to evaluate what would constitute a match

        :return: The property_type of this AnalyticsProperty.
        :rtype: str
        """
        return self._property_type

    @property_type.setter
    def property_type(self, property_type):
        """
        Sets the property_type of this AnalyticsProperty.
        Indicates what the data type is (e.g. integer vs string) and therefore how to evaluate what would constitute a match

        :param property_type: The property_type of this AnalyticsProperty.
        :type: str
        """
        allowed_values = ["bool", "integer", "real", "date", "string", "uuid"]
        if property_type not in allowed_values:
            raise ValueError(
                "Invalid value for `property_type`, must be one of {0}"
                .format(allowed_values)
            )

        self._property_type = property_type

    @property
    def pcProperty(self):
        """
        Gets the pcProperty of this AnalyticsProperty.
        User-defined rather than intrinsic system-observed values. These are tagged onto segments by other components within PureCloud or by API users directly.  This is the name of the user-defined property.

        :return: The pcProperty of this AnalyticsProperty.
        :rtype: str
        """
        return self._pcProperty

    @pcProperty.setter
    def pcProperty(self, pcProperty):
        """
        Sets the pcProperty of this AnalyticsProperty.
        User-defined rather than intrinsic system-observed values. These are tagged onto segments by other components within PureCloud or by API users directly.  This is the name of the user-defined property.

        :param pcProperty: The pcProperty of this AnalyticsProperty.
        :type: str
        """
        
        self._pcProperty = pcProperty

    @property
    def value(self):
        """
        Gets the value of this AnalyticsProperty.
        What property value to match against

        :return: The value of this AnalyticsProperty.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this AnalyticsProperty.
        What property value to match against

        :param value: The value of this AnalyticsProperty.
        :type: str
        """
        
        self._value = value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

