# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re


class AggregationResultEntry(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AggregationResultEntry - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'count': 'int',
            'value': 'str',
            'gte': 'float',
            'lt': 'float'
        }

        self.attribute_map = {
            'count': 'count',
            'value': 'value',
            'gte': 'gte',
            'lt': 'lt'
        }

        self._count = None
        self._value = None
        self._gte = None
        self._lt = None

    @property
    def count(self):
        """
        Gets the count of this AggregationResultEntry.


        :return: The count of this AggregationResultEntry.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this AggregationResultEntry.


        :param count: The count of this AggregationResultEntry.
        :type: int
        """
        
        self._count = count

    @property
    def value(self):
        """
        Gets the value of this AggregationResultEntry.
        For termFrequency aggregations

        :return: The value of this AggregationResultEntry.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this AggregationResultEntry.
        For termFrequency aggregations

        :param value: The value of this AggregationResultEntry.
        :type: str
        """
        
        self._value = value

    @property
    def gte(self):
        """
        Gets the gte of this AggregationResultEntry.
        For numericRange aggregations

        :return: The gte of this AggregationResultEntry.
        :rtype: float
        """
        return self._gte

    @gte.setter
    def gte(self, gte):
        """
        Sets the gte of this AggregationResultEntry.
        For numericRange aggregations

        :param gte: The gte of this AggregationResultEntry.
        :type: float
        """
        
        self._gte = gte

    @property
    def lt(self):
        """
        Gets the lt of this AggregationResultEntry.
        For numericRange aggregations

        :return: The lt of this AggregationResultEntry.
        :rtype: float
        """
        return self._lt

    @lt.setter
    def lt(self, lt):
        """
        Sets the lt of this AggregationResultEntry.
        For numericRange aggregations

        :param lt: The lt of this AggregationResultEntry.
        :type: float
        """
        
        self._lt = lt

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

