# coding: utf-8

"""
ContentManagementApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ContentManagementApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_documents_document_id(self, document_id, **kwargs):
        """
        Delete a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_documents_document_id(document_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param bool override: Override any lock on the document
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'override']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_documents_document_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_documents_document_id`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'override' in params:
            query_params['override'] = params['override']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_shares_share_id(self, share_id, **kwargs):
        """
        Deletes an existing share.
        This revokes sharing rights specified in the share record

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_shares_share_id(share_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str share_id: Share ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['share_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shares_share_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'share_id' is set
        if ('share_id' not in params) or (params['share_id'] is None):
            raise ValueError("Missing the required parameter `share_id` when calling `delete_shares_share_id`")


        resource_path = '/api/v2/contentmanagement/shares/{shareId}'.replace('{format}', 'json')
        path_params = {}
        if 'share_id' in params:
            path_params['shareId'] = params['share_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_status_status_id(self, status_id, **kwargs):
        """
        Cancel the command for this status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_status_status_id(status_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str status_id: Status ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_status_status_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'status_id' is set
        if ('status_id' not in params) or (params['status_id'] is None):
            raise ValueError("Missing the required parameter `status_id` when calling `delete_status_status_id`")


        resource_path = '/api/v2/contentmanagement/status/{statusId}'.replace('{format}', 'json')
        path_params = {}
        if 'status_id' in params:
            path_params['statusId'] = params['status_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workspaces_workspace_id(self, workspace_id, **kwargs):
        """
        Delete a workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workspaces_workspace_id(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str move_children_to_workspace_id: New location for objects in deleted workspace.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'move_children_to_workspace_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workspaces_workspace_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `delete_workspaces_workspace_id`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'move_children_to_workspace_id' in params:
            query_params['moveChildrenToWorkspaceId'] = params['move_children_to_workspace_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workspaces_workspace_id_members_member_id(self, workspace_id, member_id, **kwargs):
        """
        Delete a member from a workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workspaces_workspace_id_members_member_id(workspace_id, member_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str member_id: Member ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'member_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workspaces_workspace_id_members_member_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `delete_workspaces_workspace_id_members_member_id`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `delete_workspaces_workspace_id_members_member_id`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_workspaces_workspace_id_tagvalues_tag_id(self, workspace_id, tag_id, **kwargs):
        """
        Delete workspace tag
        Delete a tag from a workspace. Will remove this tag from all documents.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_workspaces_workspace_id_tagvalues_tag_id(workspace_id, tag_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str tag_id: Tag ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'tag_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workspaces_workspace_id_tagvalues_tag_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `delete_workspaces_workspace_id_tagvalues_tag_id`")
        # verify the required parameter 'tag_id' is set
        if ('tag_id' not in params) or (params['tag_id'] is None):
            raise ValueError("Missing the required parameter `tag_id` when calling `delete_workspaces_workspace_id_tagvalues_tag_id`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_documents(self, workspace_id, **kwargs):
        """
        Get a list of documents.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_documents(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str name: Name
        :param str expand: Expand some document fields
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: name or dateCreated
        :param str sort_order: ascending or descending
        :return: DocumentEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'name', 'expand', 'page_size', 'page_number', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_documents`")


        resource_path = '/api/v2/contentmanagement/documents'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'workspace_id' in params:
            query_params['workspaceId'] = params['workspace_id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DocumentEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_documents_document_id(self, document_id, **kwargs):
        """
        Get a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_documents_document_id(document_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param str expand: Expand some document fields
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_document_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_documents_document_id`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Document',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_documents_document_id_audits(self, document_id, **kwargs):
        """
        Get a list of audits for a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_documents_document_id_audits(document_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str transaction_filter: Transaction filter
        :param str level: level
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: DocumentAuditEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'page_size', 'page_number', 'transaction_filter', 'level', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_document_id_audits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_documents_document_id_audits`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}/audits'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'transaction_filter' in params:
            query_params['transactionFilter'] = params['transaction_filter']
        if 'level' in params:
            query_params['level'] = params['level']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DocumentAuditEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_documents_document_id_content(self, document_id, **kwargs):
        """
        Download a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_documents_document_id_content(document_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param str disposition: Request how the content will be downloaded: attached as a file or inline. Default is attachment.
        :param str content_type: The requested format for the specified document. If supported, the document will be returned in that format. Example contentType=audio/wav
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'disposition', 'content_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_documents_document_id_content" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_documents_document_id_content`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}/content'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'disposition' in params:
            query_params['disposition'] = params['disposition']
        if 'content_type' in params:
            query_params['contentType'] = params['content_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_query(self, query_phrase, **kwargs):
        """
        Query content
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_query(query_phrase, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str query_phrase: Phrase tokens are ANDed together over all searchable fields (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: name or dateCreated
        :param str sort_order: ascending or descending
        :param str expand: Expand some document fields
        :return: QueryResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_phrase', 'page_size', 'page_number', 'sort_by', 'sort_order', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'query_phrase' is set
        if ('query_phrase' not in params) or (params['query_phrase'] is None):
            raise ValueError("Missing the required parameter `query_phrase` when calling `get_query`")


        resource_path = '/api/v2/contentmanagement/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'query_phrase' in params:
            query_params['queryPhrase'] = params['query_phrase']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueryResults',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_securityprofiles(self, **kwargs):
        """
        Get a List of Security Profiles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_securityprofiles(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SecurityProfileEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_securityprofiles" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/contentmanagement/securityprofiles'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SecurityProfileEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_securityprofiles_securityprofile_id(self, security_profile_id, **kwargs):
        """
        Get a Security Profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_securityprofiles_securityprofile_id(security_profile_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str security_profile_id: Security Profile Id (required)
        :return: SecurityProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_profile_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_securityprofiles_securityprofile_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'security_profile_id' is set
        if ('security_profile_id' not in params) or (params['security_profile_id'] is None):
            raise ValueError("Missing the required parameter `security_profile_id` when calling `get_securityprofiles_securityprofile_id`")


        resource_path = '/api/v2/contentmanagement/securityprofiles/{securityProfileId}'.replace('{format}', 'json')
        path_params = {}
        if 'security_profile_id' in params:
            path_params['securityProfileId'] = params['security_profile_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SecurityProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_shared_shared_id(self, shared_id, **kwargs):
        """
        Get shared documents. Securely download a shared document.
        This method requires the download sharing URI obtained in the get document response (downloadSharingUri). Documents may be shared between users in the same workspace. Documents may also be shared between any user by creating a content management share.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_shared_shared_id(shared_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str shared_id: Shared ID (required)
        :param bool redirect: Turn on or off redirect
        :param str disposition: Request how the share content will be downloaded: attached as a file or inline. Default is attachment.
        :param str content_type: The requested format for the specified document. If supported, the document will be returned in that format. Example contentType=audio/wav
        :param str expand: Expand some document fields
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['shared_id', 'redirect', 'disposition', 'content_type', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shared_shared_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'shared_id' is set
        if ('shared_id' not in params) or (params['shared_id'] is None):
            raise ValueError("Missing the required parameter `shared_id` when calling `get_shared_shared_id`")


        resource_path = '/api/v2/contentmanagement/shared/{sharedId}'.replace('{format}', 'json')
        path_params = {}
        if 'shared_id' in params:
            path_params['sharedId'] = params['shared_id']

        query_params = {}
        if 'redirect' in params:
            query_params['redirect'] = params['redirect']
        if 'disposition' in params:
            query_params['disposition'] = params['disposition']
        if 'content_type' in params:
            query_params['contentType'] = params['content_type']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_shares(self, **kwargs):
        """
        Gets a list of shares.  You must specify at least one filter (e.g. entityId).
        Failing to specify a filter will return 400.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_shares(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str entity_id: Filters the shares returned to only the entity specified by the value of this parameter.
        :param str expand: Expand share fields
        :param int page_size: Page size
        :param int page_number: Page number
        :return: ShareEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'expand', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shares" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/contentmanagement/shares'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'entity_id' in params:
            query_params['entityId'] = params['entity_id']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShareEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_shares_share_id(self, share_id, **kwargs):
        """
        Retrieve details about an existing share.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_shares_share_id(share_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str share_id: Share ID (required)
        :param str expand: Expand share fields
        :return: Share
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['share_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shares_share_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'share_id' is set
        if ('share_id' not in params) or (params['share_id'] is None):
            raise ValueError("Missing the required parameter `share_id` when calling `get_shares_share_id`")


        resource_path = '/api/v2/contentmanagement/shares/{shareId}'.replace('{format}', 'json')
        path_params = {}
        if 'share_id' in params:
            path_params['shareId'] = params['share_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Share',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_status(self, **kwargs):
        """
        Get a list of statuses for pending operations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_status(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: CommandStatusEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/contentmanagement/status'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommandStatusEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_status_status_id(self, status_id, **kwargs):
        """
        Get a status.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_status_status_id(status_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str status_id: Status ID (required)
        :return: CommandStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status_status_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'status_id' is set
        if ('status_id' not in params) or (params['status_id'] is None):
            raise ValueError("Missing the required parameter `status_id` when calling `get_status_status_id`")


        resource_path = '/api/v2/contentmanagement/status/{statusId}'.replace('{format}', 'json')
        path_params = {}
        if 'status_id' in params:
            path_params['statusId'] = params['status_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommandStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_usage(self, **kwargs):
        """
        Get usage details.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_usage(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: Usage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_usage" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/contentmanagement/usage'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Usage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workspaces(self, **kwargs):
        """
        Get a list of workspaces.
        Specifying 'content' access will return all workspaces the user has document access to, while 'admin' access will return all group workspaces the user has administrative rights to.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workspaces(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str access: Requested access level
        :param str expand: Expand some workspace fields
        :return: WorkspaceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'access', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspaces" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/contentmanagement/workspaces'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'access' in params:
            query_params['access'] = params['access']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkspaceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workspaces_workspace_id(self, workspace_id, **kwargs):
        """
        Get a workspace.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workspaces_workspace_id(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str expand: Expand some workspace fields
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspaces_workspace_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_workspaces_workspace_id`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workspace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workspaces_workspace_id_members(self, workspace_id, **kwargs):
        """
        Get a list workspace members
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workspaces_workspace_id_members(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str expand: Expand workspace member fields
        :return: WorkspaceMemberEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'page_size', 'page_number', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspaces_workspace_id_members" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_workspaces_workspace_id_members`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/members'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkspaceMemberEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workspaces_workspace_id_members_member_id(self, workspace_id, member_id, **kwargs):
        """
        Get a workspace member
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workspaces_workspace_id_members_member_id(workspace_id, member_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str member_id: Member ID (required)
        :param str expand: Expand workspace member fields
        :return: WorkspaceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'member_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspaces_workspace_id_members_member_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_workspaces_workspace_id_members_member_id`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `get_workspaces_workspace_id_members_member_id`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkspaceMember',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workspaces_workspace_id_tagvalues(self, workspace_id, **kwargs):
        """
        Get a list of workspace tags
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workspaces_workspace_id_tagvalues(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str value: filter the list of tags returned
        :param int page_size: Page size
        :param int page_number: Page number
        :param str expand: Expand some document fields
        :return: TagValueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'value', 'page_size', 'page_number', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspaces_workspace_id_tagvalues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_workspaces_workspace_id_tagvalues`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'value' in params:
            query_params['value'] = params['value']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TagValueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_workspaces_workspace_id_tagvalues_tag_id(self, workspace_id, tag_id, **kwargs):
        """
        Get a workspace tag
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_workspaces_workspace_id_tagvalues_tag_id(workspace_id, tag_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str tag_id: Tag ID (required)
        :param str expand: Expand some document fields
        :return: TagValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'tag_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workspaces_workspace_id_tagvalues_tag_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_workspaces_workspace_id_tagvalues_tag_id`")
        # verify the required parameter 'tag_id' is set
        if ('tag_id' not in params) or (params['tag_id'] is None):
            raise ValueError("Missing the required parameter `tag_id` when calling `get_workspaces_workspace_id_tagvalues_tag_id`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TagValue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_auditquery(self, body, **kwargs):
        """
        Query audits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_auditquery(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContentQueryRequest body: Allows for a filtered query returning facet information (required)
        :return: QueryResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_auditquery" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_auditquery`")


        resource_path = '/api/v2/contentmanagement/auditquery'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueryResults',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_documents(self, body, **kwargs):
        """
        Add a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_documents(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DocumentUpload body: Document (required)
        :param str copy_source: Copy a document within a workspace or to a new workspace. Provide a document ID as the copy source.
        :param str move_source: Move a document to a new workspace. Provide a document ID as the move source.
        :param bool override: Override any lock on the source document
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'copy_source', 'move_source', 'override']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_documents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_documents`")


        resource_path = '/api/v2/contentmanagement/documents'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'copy_source' in params:
            query_params['copySource'] = params['copy_source']
        if 'move_source' in params:
            query_params['moveSource'] = params['move_source']
        if 'override' in params:
            query_params['override'] = params['override']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Document',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_documents_document_id(self, document_id, body, **kwargs):
        """
        Update a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_documents_document_id(document_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param DocumentUpdate body: Document (required)
        :param str expand: Expand some document fields
        :param bool override: Override any lock on the document
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'body', 'expand', 'override']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_documents_document_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `post_documents_document_id`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_documents_document_id`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'override' in params:
            query_params['override'] = params['override']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Document',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_documents_document_id_content(self, document_id, body, **kwargs):
        """
        Replace the contents of a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_documents_document_id_content(document_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param ReplaceRequest body: Replace Request (required)
        :param bool override: Override any lock on the document
        :return: ReplaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'body', 'override']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_documents_document_id_content" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `post_documents_document_id_content`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_documents_document_id_content`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}/content'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'override' in params:
            query_params['override'] = params['override']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ReplaceResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_query(self, body, **kwargs):
        """
        Query content
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param QueryRequest body: Allows for a filtered query returning facet information (required)
        :param str expand: Expand some document fields
        :return: QueryResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_query`")


        resource_path = '/api/v2/contentmanagement/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueryResults',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_shares(self, body, **kwargs):
        """
        Creates a new share or updates an existing share if the entity has already been shared
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_shares(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateShareRequest body: CreateShareRequest - entity id and type and a single member or list of members are required (required)
        :return: CreateShareResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_shares" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_shares`")


        resource_path = '/api/v2/contentmanagement/shares'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CreateShareResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workspaces(self, body, **kwargs):
        """
        Create a group workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workspaces(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkspaceCreate body: Workspace (required)
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workspaces" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workspaces`")


        resource_path = '/api/v2/contentmanagement/workspaces'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workspace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workspaces_workspace_id_tagvalues(self, workspace_id, body, **kwargs):
        """
        Create a workspace tag
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workspaces_workspace_id_tagvalues(workspace_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param TagValue body: tag (required)
        :return: TagValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workspaces_workspace_id_tagvalues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `post_workspaces_workspace_id_tagvalues`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workspaces_workspace_id_tagvalues`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TagValue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_workspaces_workspace_id_tagvalues_query(self, workspace_id, body, **kwargs):
        """
        Perform a prefix query on tags in the workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_workspaces_workspace_id_tagvalues_query(workspace_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param TagQueryRequest body: query (required)
        :param str expand: Expand some document fields
        :return: TagValueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_workspaces_workspace_id_tagvalues_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `post_workspaces_workspace_id_tagvalues_query`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_workspaces_workspace_id_tagvalues_query`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/query'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TagValueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_workspaces_workspace_id(self, workspace_id, body, **kwargs):
        """
        Update a workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_workspaces_workspace_id(workspace_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param Workspace body: Workspace (required)
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_workspaces_workspace_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `put_workspaces_workspace_id`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_workspaces_workspace_id`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workspace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_workspaces_workspace_id_members_member_id(self, workspace_id, member_id, body, **kwargs):
        """
        Add a member to a workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_workspaces_workspace_id_members_member_id(workspace_id, member_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str member_id: Member ID (required)
        :param WorkspaceMember body: Workspace (required)
        :return: WorkspaceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'member_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_workspaces_workspace_id_members_member_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `put_workspaces_workspace_id_members_member_id`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `put_workspaces_workspace_id_members_member_id`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_workspaces_workspace_id_members_member_id`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkspaceMember',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_workspaces_workspace_id_tagvalues_tag_id(self, workspace_id, tag_id, body, **kwargs):
        """
        Update a workspace tag. Will update all documents with the new tag value.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_workspaces_workspace_id_tagvalues_tag_id(workspace_id, tag_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str tag_id: Tag ID (required)
        :param TagValue body: Workspace (required)
        :return: TagValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'tag_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_workspaces_workspace_id_tagvalues_tag_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `put_workspaces_workspace_id_tagvalues_tag_id`")
        # verify the required parameter 'tag_id' is set
        if ('tag_id' not in params) or (params['tag_id'] is None):
            raise ValueError("Missing the required parameter `tag_id` when calling `put_workspaces_workspace_id_tagvalues_tag_id`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_workspaces_workspace_id_tagvalues_tag_id`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud Auth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TagValue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
