# Generated by Django 2.1.8 on 2019-05-04 14:18

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='FachschaftUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nickname', models.CharField(max_length=100, unique=True)),
            ],
            options={
                'verbose_name': 'StudentIn',
                'verbose_name_plural': 'StudentInnen',
                'ordering': ['nickname'],
            },
        ),
        migrations.CreateModel(
            name='Gender',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bezeichnung', models.CharField(max_length=100)),
                ('endung', models.CharField(blank=True, max_length=8)),
            ],
            options={
                'verbose_name': 'Gender/Geschlecht',
                'verbose_name_plural': 'Gender/Geschlechter',
                'ordering': ['bezeichnung'],
            },
        ),
        migrations.CreateModel(
            name='Studienabschnitt',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bezeichnung', models.CharField(max_length=100)),
                ('sortierung', models.PositiveSmallIntegerField()),
            ],
            options={
                'verbose_name': 'Studienabschnitt/Semester',
                'verbose_name_plural': 'Studienabschnitte/Semester',
                'ordering': ['sortierung'],
            },
        ),
        migrations.CreateModel(
            name='Studiengang',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('bezeichnung', models.CharField(max_length=100)),
                ('studienabschnitt', models.ManyToManyField(blank=True, related_name='studiengang', to='fsmedhro_core.Studienabschnitt')),
            ],
            options={
                'verbose_name': 'Studiengang',
                'verbose_name_plural': 'Studiengänge',
                'ordering': ['bezeichnung'],
            },
        ),
        migrations.AddField(
            model_name='fachschaftuser',
            name='gender',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='fsmedhro_core.Gender'),
        ),
        migrations.AddField(
            model_name='fachschaftuser',
            name='studienabschnitt',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='fsmedhro_core.Studienabschnitt'),
        ),
        migrations.AddField(
            model_name='fachschaftuser',
            name='studiengang',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='fsmedhro_core.Studiengang'),
        ),
        migrations.AddField(
            model_name='fachschaftuser',
            name='user',
            field=models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL),
        ),
    ]
