# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['picketapi']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.28.1,<3.0.0']

setup_kwargs = {
    'name': 'picketapi',
    'version': '0.1.1',
    'description': 'The official Python library for the Picket API (https://picketapi.com/)',
    'long_description': '# picket-python\n\nThe official Python library for the [Picket API](https://picketapi.com/)\n\n## Installation\n\n```bash \npip install -U picketapi\n```\n\n## Usage - Quick Start\n\nUse the `Picket` class to create the Picket API client. It takes a _secret API key_ as a parameter.\n\n```python\nfrom picketapi import Picket\n\npicket = new Picket("YOU_SECRET_API_KEY")\n```\n\n## Nonce\n\nA `nonce` is random value generated by the Picket API to that user must sign to prove ownership a wallet address. The `nonce` function can be used to implement your own wallet authentication flow. \n\nA nonce is unique to a project and wallet address. If a `nonce` doesn\'t exist for the project and wallet address, Picket will generate a new nonce; otherwise, Picket will return the existing nonce. A nonce is valid for two minutes before self-destructing.\n\n```python\nresp = picket.nonce(chain="solana", wallet_address="wAlLetTAdDress")\n# resp is of type NonceResponse\nprint(resp.nonce)\n```\n\n## Auth\n\n`auth` is the server-side equivalent of login. `auth` should only be used in a trusted server environment. The most common use-case for `auth` is [linking a wallet to an existing application account](https://docs.picketapi.com/picket-docs/tutorials/link-a-wallet-to-a-web-2.0-account).\n\n```python\nresp = picket.auth(chain="ethereum", wallet_address="0x1234567890", signature="abcdefghijklmnop")\n# resp is of type AuthResponse\nprint(resp.user)\nprint(resp.access_token)\n```\n\n## Authz (Authorize)\n`authz` stands for authorization. Unlike Auth, which handles both authentication and authorization, Authz only handles authorization. \nGiven an authenticated user\'s access token and authorization requirements, `authz` will issue a new access token on success (user is authorized) or, on failure, it will return a 4xx HTTP error code.\n\n```python\nresp = picket.authz(access_token="xxx.yyy.zzz", requirements={ "contractAddress": "0xContract" })\n# resp is of type AuthResponse\nprint(resp.user)\nprint(resp.access_token)\n```\n\n## Validate\n`validate` validates an access token. `validate` should be called, or manually access token validation should be done, server-side before trusting a request\'s access token. It\'s common to move access token validation and decoding logic to a shared middleware across API endpoints.\nIf the access token is valid, validate returns the decoded claims of the access token.\n\n```python\nresp, err := picket.validate(access_token="xxx.yyy.zzz", requirements={"contractAddress": "0xContract", "minTokenBalance": "100"})\n# Response is the decoded access token (AuthorizedUser)\nprint(resp)\n```\n\n## Verify Token Ownership\nIf you only want to verify token ownership server side for a given wallet, `tokenOwnership` allows you to do just that.\n\n```python\nresp = picket.token_ownership(\n\t\t\tchain="solana", \n\t\t\twallet_address="waLLETaddRess", \n\t\t\trequirements={  \n\t\t\t  "collection": "METAPLEX_COLLECTION",\n\t\t\t  "minTokenBalance": "3",\n\t\t\t}\n\t\t)\n# Response is of type TokenOwnershipResponse\nprint(resp.allowed)\nprint(resp.tokenBalances)\n```\n\n',
    'author': 'Devin Stein',
    'author_email': 'devstein@seas.upenn.edu',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/picketapi/picket-python',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
