import { Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IIntegration } from '../common';
import { IWebSocketApi } from './api';
import { IWebSocketRoute } from './route';
/**
 * (experimental) Represents an Integration for an WebSocket API.
 *
 * @experimental
 */
export interface IWebSocketIntegration extends IIntegration {
    /**
     * (experimental) The WebSocket API associated with this integration.
     *
     * @experimental
     */
    readonly webSocketApi: IWebSocketApi;
}
/**
 * (experimental) WebSocket Integration Types.
 *
 * @experimental
 */
export declare enum WebSocketIntegrationType {
    /**
     * (experimental) AWS Proxy Integration Type.
     *
     * @experimental
     */
    AWS_PROXY = "AWS_PROXY",
    /**
     * (experimental) Mock Integration Type.
     *
     * @experimental
     */
    MOCK = "MOCK"
}
/**
 * (experimental) The integration properties.
 *
 * @experimental
 */
export interface WebSocketIntegrationProps {
    /**
     * (experimental) The WebSocket API to which this integration should be bound.
     *
     * @experimental
     */
    readonly webSocketApi: IWebSocketApi;
    /**
     * (experimental) Integration type.
     *
     * @experimental
     */
    readonly integrationType: WebSocketIntegrationType;
    /**
     * (experimental) Integration URI.
     *
     * @experimental
     */
    readonly integrationUri: string;
}
/**
 * (experimental) The integration for an API route.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Integration
 */
export declare class WebSocketIntegration extends Resource implements IWebSocketIntegration {
    /**
     * (experimental) Id of the integration.
     *
     * @experimental
     */
    readonly integrationId: string;
    /**
     * (experimental) The WebSocket API associated with this integration.
     *
     * @experimental
     */
    readonly webSocketApi: IWebSocketApi;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: WebSocketIntegrationProps);
}
/**
 * (experimental) Options to the WebSocketRouteIntegration during its bind operation.
 *
 * @experimental
 */
export interface WebSocketRouteIntegrationBindOptions {
    /**
     * (experimental) The route to which this is being bound.
     *
     * @experimental
     */
    readonly route: IWebSocketRoute;
    /**
     * (experimental) The current scope in which the bind is occurring.
     *
     * If the `WebSocketRouteIntegration` being bound creates additional constructs,
     * this will be used as their parent scope.
     *
     * @experimental
     */
    readonly scope: Construct;
}
/**
 * (experimental) The interface that various route integration classes will inherit.
 *
 * @experimental
 */
export declare abstract class WebSocketRouteIntegration {
    private readonly id;
    private integration?;
    /**
     * (experimental) Initialize an integration for a route on websocket api.
     *
     * @param id id of the underlying `WebSocketIntegration` construct.
     * @experimental
     */
    constructor(id: string);
    /**
     * Internal method called when binding this integration to the route.
     * @internal
     */
    _bindToRoute(options: WebSocketRouteIntegrationBindOptions): {
        readonly integrationId: string;
    };
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    abstract bind(options: WebSocketRouteIntegrationBindOptions): WebSocketRouteIntegrationConfig;
}
/**
 * (experimental) Config returned back as a result of the bind.
 *
 * @experimental
 */
export interface WebSocketRouteIntegrationConfig {
    /**
     * (experimental) Integration type.
     *
     * @experimental
     */
    readonly type: WebSocketIntegrationType;
    /**
     * (experimental) Integration URI.
     *
     * @experimental
     */
    readonly uri: string;
}
